/*
 * @(#)calculat.C	1.58   3/17/94
 * Functions to start the computation of a primary insurance amount
 */

#ifndef lint
static char *calculatID = " @(#)calculat.C	1.58   3/17/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include <math.h>  /* definition of floor */
#include "pia.h"
#include "ardri.h"
#include "compdate.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void  qccal    ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, int curyear );
static int   round5   ( double );
static int   pebsetup ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata, Pebs *pebsdata, int num);
static double stotcal ( PIADATA *piadata, int firstyr, int i2 );
static int   qcdireqc ( WORKERDATA *workerdata, PIADATA *piadata );
static void  qcdispec ( PIADATA *piadata );
static int   qcdical  ( WORKERDATA *workerdata, PIADATA *piadata );
#else
static void  qccal();
static int   round5();
static int   pebsetup();
static double stotcal();
static int   qcdireqc();
static void  qcdispec();
static void  qcdical();
#endif

/* Function to calculate preparatory variables
 */
int calculat1(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   register i1; /* loop counter */
   int i2;  /* number of calculations to do */
   int ierr;  /* error indicator */

   if (workerdata -> jaltbi != workerdata -> ialtbi) {
   if (workerdata -> ialtbi == OTHER_ASSUM) {
      for (i1 = workerdata -> istart - 1951; i1 < workerdata -> maxyears - 14;
         i1++)
         piaparms -> cpiinc[i1] = workerdata -> cpiinc[i1];
      for (i2 = 0; i2 < 10; i2++) {
         for (i1 = 0; i1 < 8; i1++) {
            piaparms -> cachup[i2][i1] = workerdata -> cachup[i2][i1];
            } /* end for i1 */
         } /* end for i2 */
      } /* end if */
   else {
      if (workerdata -> ialtbi != FLAT && workerdata -> ialtbi != PEBS_ASSUM)
         {
         if ((ierr = benmen(piaparms, (int)workerdata -> ialtbi)) > 0)
            return(ierr);
         }
      else { /* assumptions set in program */
         for (i1 = piaparms -> istart - 1951; i1 < piaparms -> maxyears - 14;
            i1++)
            piaparms -> cpiinc[i1] = (float)0.;
         zerocch(piaparms -> cachup);
         } /* end else */
      }
   }

   if (workerdata -> jaltaw != workerdata -> ialtaw) {
   if (workerdata -> ialtaw == OTHER_ASSUM)
      for (i1 = workerdata -> istart - 1938; i1 < workerdata -> maxyears; i1++)
         piaparms -> fqinc[i1] = workerdata -> fqinc[i1];
   else {
      if (workerdata -> ialtaw != FLAT && workerdata -> ialtaw != PEBS_ASSUM)
         {
         if ((ierr = avgmen(piaparms, (int)workerdata -> ialtaw)) > 0)
            return(ierr);
         }
      else  /* assumptions set in program */
         for (i1 = piaparms -> istart - 1938; i1 < piaparms -> maxyears; i1++)
            piaparms -> fqinc[i1] = (float)0.;
      }
   avgpro(piaparms);
   qcamtc(piaparms);
   }

   if (workerdata -> jbasch != workerdata -> ibasch ||
      workerdata -> jaltaw != workerdata -> ialtaw ||
      workerdata -> ibasch == 2) {
      i2 = (workerdata -> joasdi == PEBS_CALC) ? piadata -> kbirth[2] + 70 :
         workerdata -> bendate[2];
   if (workerdata -> ibasch == 2) {
      for (i1 = piaparms -> istart - 1936; i1 < i2 - 1937; i1++) {
         piaparms -> base[i1] = workerdata -> base[i1];
         piaparms -> base77[i1] = workerdata -> base77[i1];
         }
      }
   else {
      for (i1 = piaparms -> istart - 1936; i1 < i2 - 1937; i1++) {
         piaparms -> base[i1] = 0.;
         piaparms -> base77[i1] = 0.;
         }
      }
      wgbsst(piaparms, 1937, 1936 + piaparms -> maxyears);
   }

   if (workerdata -> joasdi != PEBS_CALC)
      {
      minpro(piaparms);
      piadata -> over_max = earnpr(workerdata,piaparms);
      ernproj(workerdata, piaparms, piadata);
      }
   workerdata -> jaltbi = workerdata -> ialtbi;
   workerdata -> jaltaw = workerdata -> ialtaw;
   workerdata -> jbasch = workerdata -> ibasch;
   return(0);
}
/* Function to calculate results
 */
int calculat2(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Taxes *taxdata,  /* taxdata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
Pebs *pebsdata,  /* Pebs structure */
int curyear)  /* current year (through which qc's are known) */
{
   register i1; /* loop counter */
   int i2;  /* number of calculations to do */
   int ierr;  /* error indicator */
   int i3;  /* loop counter */

   i2 = (workerdata -> joasdi == PEBS_CALC) ? MAXPEBS : 1;
   for (i1 = 0; i1 < i2; i1++) {
      if (workerdata -> joasdi == PEBS_CALC)
         if ((ierr = pebsetup(workerdata, piaparms, piadata, lawchgdata,
            pebsdata, i1)) > 0)
            return(ierr);
      for (i3 = 0; i3 <= workerdata -> totalize; i3++)
         piadata -> stot[i3] = stotcal(piadata, workerdata -> ibegin, i3);
      taxcal(taxdata, workerdata -> maxyears, piadata -> earnst[2],
         piadata -> earnst[5], workerdata -> taxtype);
      /* calculate last year of allowable earnings */
      ernyrcal(workerdata, piadata);
      /* calculate total quarters of coverage */
      qccal(workerdata, piaparms, piadata, curyear);
      if (workerdata -> totalize) {
         piadata -> repavg = repcal(workerdata, piaparms, piadata);
         ernlimit(piadata -> earnst[3], piadata -> earnst[1], piaparms -> base,
            piaparms -> maxyears);
         }
      ncal(workerdata, piadata, piaparms, lawchgdata, 0);
      piadata -> qcreq = qcreqcal(piadata);
      /* calculate required and actual disability qc's in disability case */
      if (workerdata -> ioasdi == DISABILITY) {
         piadata -> qcdireq = qcdireqc(workerdata, piadata);
         piadata -> qctotdi = qcdical(workerdata, piadata);
         }
      if ((ierr = piacal(workerdata, piaparms, piadata, lawchgdata)) > 0)
         return(ierr);
      /* save amounts for PEBS calculation */
      if (workerdata -> joasdi == PEBS_CALC) {
         /* save quarters of coverage to date for PEBS */
         if (i1 == 0) {
            pebsdata -> qctot = workerdata -> qctottd +
               qcsum(workerdata, curyear + 1, workerdata -> istart);
            if (pebsdata -> qctot > 40)
               pebsdata -> qctot = 40;
            /* save normal retirement age */
            pebsdata -> nra[0] = piadata -> nra[0];
            pebsdata -> nra[1] = piadata -> nra[1];
            }
         pebsdata -> piapebs[i1] = round5(piadata -> hipia);
         pebsdata -> mfbpebs[i1] = round5(piadata -> himfb);
         pebsdata -> benftpbs[i1] = (i1 == 3) ?
            round5(.75 * pebsdata -> piapebs[i1]) :
            round5(piadata -> benfit[0]);
         pebsdata -> qcreq[i1] = piadata -> qcreq;
         if (i1 == 4) {
            pebsdata -> qcdireq = piadata -> qcdireq;
            pebsdata -> qcdiyr = piadata -> qcdiyr;
            }
         }
      }
   /* return iend to original value */
   if (workerdata -> joasdi == PEBS_CALC)
      setpbdata(workerdata);
   return(0);
}
/* Function to calculate total quarters of coverage
 */
static void qccal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
int curyear)  /* current year (through which qc's are known) */
{
   int i1,i2; /* loop counter */
   int qctemp;  /* temporary qc */

   if (curyear > 1950)
      piadata -> qctot50 = workerdata -> qctottd - workerdata -> qctot51td;
   else {
      piadata -> qctot50 =
         (piadata -> stot[0] < 49.9) ? 0 : (int)piadata -> stot[0] / 500 + 1;
      setqctd(workerdata, piadata -> qctot50);
      setqc51td(workerdata, 0);
      }
   for (i1 = curyear + 1; i1 < 1937 + workerdata -> maxyears; i1++)
      setqc2(workerdata, i1, 0);
   i2 = (curyear > 1950) ? curyear : 1950;
   for (i1 = i2 + 1; i1 <= workerdata -> ient[2]; i1++) {
      qctemp = (int) floor(piadata -> earnst[0][i1 - 1937] /
         ((piaparms -> qcamt[i1 - 1937] > 1.) ?
         piaparms -> qcamt[i1 - 1937] : 1.));
      if (qctemp > 4)
         qctemp = 4;
      setqc2(workerdata, i1, qctemp);
      } /* end for */
   piadata -> qctot = workerdata -> qctottd +
      qcsum(workerdata, i2 + 1, workerdata -> ient[2]);;
   piadata -> qctot51 = piadata -> qctot - piadata -> qctot50;
}
/* Function to round benefit down to $5 multiple
 */
static round5(
double benefit)  /* benefit to be rounded */
{
   return(5*(int)((benefit+.01)/5.));
}
/* Function to set information for additional PEBES cases
 */
static int pebsetup(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
Pebs *pebsdata,  /* Pebs structure */
int i1)  /* PEBES case number */
{
   int agenow; /* current age in years */
   int date1[3];  /* current date */

   date1[0] = workerdata -> monthnow;
   date1[1] = 1;
   date1[2] = workerdata -> istart;
   switch (i1)
      {
      case 0:
         piadata -> iage[0] = 70; /* set years */
         piadata -> iage[1] = 0; /* set months */
         datecal(workerdata -> ient, piadata -> kbirth, piadata -> iage);
         setbendt2(workerdata);
         setiend(workerdata, piadata -> kbirth[2] + 69);
         break;
      case 1:
         /* set month of entitlement */
         piadata -> iage[0] = piadata -> nra[0];  /* set years */
         piadata -> iage[1] = piadata -> nra[1];  /* set months */
         datecal(workerdata -> ient, piadata -> kbirth, piadata -> iage);
         setbendt2(workerdata);
         setiend(workerdata, workerdata -> bendate[2] - 1);
         break;
      case 2:
         /* retirement at earliest possible date */
         if (piadata -> nra1[0] >= workerdata -> iageplan) {
            pebsdata -> iagepln1[0] = piadata -> nra1[0];
            pebsdata -> iagepln1[1] = piadata -> nra1[1]; }
         else {
            /* retirement after normal retirement age */
            if (workerdata -> iageplan > piadata -> nra[0]) {
               pebsdata -> iagepln1[0] = piadata -> nra[0];
               pebsdata -> iagepln1[1] = piadata -> nra[1]; }
            else {
               /* retirement between early and normal ages */
               pebsdata -> iagepln1[0] = workerdata -> iageplan;
               pebsdata -> iagepln1[1] = 0; }
            }
         datecal(workerdata -> ient, piadata -> kbirth, pebsdata -> iagepln1);
         setbendt2(workerdata);
         /* check for entitlement prior to current date */
         if (compmdy(workerdata -> ient, date1) < 0) {
            setient(workerdata, date1);
            setbendt2(workerdata); }
         /* calculate age at entitlement */
         entage(piadata -> iage, piadata -> kbirth, workerdata -> ient);
         /* calculate age at benefit date */
         entage(piadata -> iage1, piadata -> kbirth, workerdata -> bendate);
         /* reset planned early retirement age */
         pebsdata -> iagepln1[0] = piadata -> iage[0];
         pebsdata -> iagepln1[1] = piadata -> iage[1];
         /* check for last year of earnings */
         pebsdata -> iagepln2 = (workerdata -> iageplan) ?
            workerdata -> iageplan : 62;
         agenow = (piadata -> kbirth[0] > workerdata -> monthnow) ?
            workerdata -> istart - piadata -> kbirth[2] - 1 :
            workerdata -> istart - piadata -> kbirth[2];
         if (pebsdata -> iagepln2 < agenow)
            pebsdata -> iagepln2 = agenow;
         /* stop earnings in early retirement year */
         if (pebsdata -> iagepln1[0] > pebsdata -> iagepln2)
            setiend(workerdata,
               piadata -> kbirth[2] + pebsdata -> iagepln2 - 1);
         /* continue earnings to year before current year */
         if (workerdata -> iend < workerdata -> istart - 1)
            setiend(workerdata, workerdata -> istart - 1);
         break;
      case 3:
         setioasdi(workerdata, SURVIVOR);
         setjsurv(workerdata, YOUNG_SURV);
         setient(workerdata, date1);
         setideath(workerdata, date1);
         setbendt2(workerdata);
         /* calculate age at entitlement */
         entage(piadata -> iage, piadata -> kbirth, workerdata -> ient);
         /* calculate age at benefit date */
         entage(piadata -> iage1, piadata -> kbirth, workerdata -> bendate);
         /* stop earnings in year of death */
         setiend(workerdata, workerdata -> istart);
         break;
      case 4:
         setioasdi(workerdata, DISABILITY);
         workerdata -> ideath[0] = workerdata -> ideath[2] = 0;
         setjsurv(workerdata, NO_SURV);
         setvaldi(workerdata, 1);
         setient(workerdata, date1);
         setionset(workerdata, date1);
         setbendt2(workerdata);
         /* stop earnings in year before disability */
         setiend(workerdata, workerdata -> istart - 1);
         break;
      default:
         break;
      }
   ernproj(workerdata, piaparms, piadata);
   elgyr(workerdata, piadata, lawchgdata);
   return(ardri(workerdata, piaparms, piadata, lawchgdata));
}
/* Function to add up pre-1951 earnings
 */
static double stotcal(
PIADATA *piadata,  /* piadata structure */
int firstyr,  /* first year of earnings */
int i2)  /* 0 for regular earnings, 1 for imputed totalized earnings */
{
   int i1;  /* loop counter */
   double rv;  /* return value */

   rv = 0;
   for (i1 = firstyr - 1937; i1 < 14; i1++)
      rv += piadata -> earnst[i2][i1];
   if (rv > 42000.)
      rv = 42000.;
   return(rv);
}
/* Function to determine number of required quarters of coverage for
   disability insured status
 */
static int qcdireqc(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   int qctmpdt[2];  /* quarter and year of attainment of age 31 */

   /* set ending quarter and year */
   piadata -> qcdidt2[0] = (workerdata -> ionset[0] + 2) / 3;
   piadata -> qcdidt2[1] = workerdata -> ionset[2];
   /* set beginning quarter and year, based on 40 quarters */
   piadata -> qcdidt1[0] = piadata -> qcdidt2[0] + 1;
   piadata -> qcdidt1[1] = piadata -> qcdidt2[1] - 10;
   if (piadata -> qcdidt1[0] > 4) {
      piadata -> qcdidt1[0] -= 4;
      piadata -> qcdidt1[1]++;
      }
   /* check for special insured status before age 31 */
   qctmpdt[0] = (piadata -> kbirth[0] + 2) / 3;
   qctmpdt[1] = piadata -> kbirth[2] + 31;
   if (piadata -> qcdidt2[1] < qctmpdt[1] ||
      (piadata -> qcdidt2[1] == qctmpdt[1] &&
      piadata -> qcdidt2[0] < qctmpdt[0]))
      qcdispec(piadata);
   /* calculate number of elapsed quarters */
   piadata -> qcdiqtr = 4 * (piadata -> qcdidt2[1] - piadata -> qcdidt1[1]) +
      piadata -> qcdidt2[0] - piadata -> qcdidt1[0] + 1;
   /* calculate number of elapsed years */
   piadata -> qcdiyr = (piadata -> qcdiqtr + 2) / 4;
   /* calculate number of qc's required */
   return(piadata -> qcdiqtr / 2);
}
/* Function to set first quarter and year of disability insured period
   for special insured status
 */
static void qcdispec(
PIADATA *piadata)  /* piadata structure */
{
   /* start with quarter after attainment of age 21 */
   piadata -> qcdidt1[0] = (piadata -> kbirth[0] + 5) / 3;
   piadata -> qcdidt1[1] = piadata -> kbirth[2] + 21;
   if (piadata -> qcdidt1[0] > 4) {
      piadata -> qcdidt1[0] -= 4;
      piadata -> qcdidt1[1]++;
      }
   /* check for fewer than 12 qc's */
   if (4 * (piadata -> qcdidt2[1] - piadata -> qcdidt1[1]) +
      piadata -> qcdidt2[0] - piadata -> qcdidt1[0] + 1 < 12) {
      /* use 12 quarters */
      piadata -> qcdidt1[0] = piadata -> qcdidt2[0] + 1;
      piadata -> qcdidt1[1] = piadata -> qcdidt2[1] - 3;
      if (piadata -> qcdidt1[0] > 4) {
         piadata -> qcdidt1[0] -= 4;
         piadata -> qcdidt1[1]++;
         }
      }
}
/* Function to calculate earned quarters of coverage in disability insured
   period
 */
static int qcdical(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   int i1;  /* loop counter */
   int rv;  /* return value */

   /* start with qc's in first year, starting with first quarter */
   rv = (workerdata -> qc[piadata -> qcdidt1[1] - 1937] <
      5 - piadata -> qcdidt1[0]) ?
      workerdata -> qc[piadata -> qcdidt1[1] - 1937] :
      5 - piadata -> qcdidt1[0];
   /* continue with full years */
   for (i1 = piadata -> qcdidt1[1] - 1936; i1 < piadata -> qcdidt2[1] - 1937;
      i1++)
      rv += workerdata -> qc[i1];
   /* end with qc's in last year, ending with last quarter */
   rv += (workerdata -> qc[piadata -> qcdidt2[1] - 1937] <
      piadata -> qcdidt2[0]) ?
      workerdata -> qc[piadata -> qcdidt2[1] - 1937] : piadata -> qcdidt2[0];
   return(rv);
}
