/*
 * @(#)coment.C	1.9   12/11/92
 * Function to write out comments for changes from present law
 */

#ifndef lint
static char *comentID = " @(#)coment.C	1.9   12/11/92 ";
#endif

#include <stdio.h>
#include "lawchg.h"
#include "coment.h"

void coment(
FILE *out,  /* output file */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int i1,i2;  /* loop counters */

   fprintf(out, "\n\n      Changes from present law:\n");
   for (i1 = 0; i1 < MAXLCH; i1++)
      {
      if (lawchgdata -> jind[i1]) {
         fprintf(out, "      %s\n", lawchgdata -> tind[i1]);
      if (i1 == 1) {
         fprintf(out, "      Bend points are %4.2f wage-indexed from ",
            lawchgdata -> pbp);
         fprintf(out, "%d to %d\n", lawchgdata -> jstart[0][1],
            lawchgdata -> jstart[1][1]);
         }
      if (i1 == 2) {
         fprintf(out, "      Bend points are CPI-indexed from %d to %d\n",
            lawchgdata -> jstart[0][2], lawchgdata -> jstart[1][2]);
         }
      if (i1 == 3) {
         fprintf(out, "      Earnings are CPI-indexed from %d to %d\n",
            lawchgdata -> jstart[0][3], lawchgdata -> jstart[1][3]);
         }
      if (i1 == 4) {
         fprintf(out, "      PIA formula is %d%% of first $%d of AIME +\n",
            (int)lawchgdata -> percpa[0] * 100., lawchgdata -> bendpalt[1]);
         fprintf(out, "        %d%% of AIME up to $%d +\n",
            (int)lawchgdata -> percpa[1] * 100., lawchgdata -> bendpalt[2]);
         fprintf(out, "        %d%% of remainder for those eligible in %d\n",
            (int)lawchgdata -> percpa[2] * 100., lawchgdata -> jstart[0][4]);
         }
      if (i1 == 5) {
         fprintf(out, "      Bend points are indexed from %d to %d by:\n",
            lawchgdata -> jstart[0][5], lawchgdata -> jstart[1][5]);
         fprintf(out, "      ");
         for (i2 = lawchgdata -> jstart[0][5] - 1937;
            i2 < lawchgdata -> jstart[1][5] - 1938; i2++)
            fprintf(out, "  %5.2f", lawchgdata -> bpinc[i2]);
         fprintf(out, "\n");
         }
      if (i1 == 6) {
         fprintf(out,
            "      %3.2f percent subtracted from wage increase factor\n",
            lawchgdata -> cp);
         fprintf(out, "      for increase in bend points from %d to %d\n",
            lawchgdata -> jstart[0][6], lawchgdata -> jstart[1][6]);
         }
      }
      }
   return;
}
