/*
 * @(#)comma.C	1.4   9/10/92
 * Various functions to convert a number to a string with commas and a
 * given number of decimal places.
 */

#ifndef lint
static char *commaID = " @(#)comma.C	1.4   9/10/92 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "comma.h"

/* Function to convert a double floating-point number to a string
 * with commas and a given number of decimal places.
 */
char *pdouble(
double temp,  /* number to be formatted */
int width,  /* minimum width of field */
int dec)  /* number of decimal places */
{
   char format[10]; /* format to print number */
   int point;       /* indicator for decimal point */
   int sign;        /* indicator for negative sign */
   static char start[40];  /* string to be returned */

   point = (dec==0) ? 0 : 1;
   sign = (temp < 0.) ? 1 : 0;
   sprintf(format,"%%%d.%dlf",dec+point,dec);
   sprintf(start,format,temp);
   pcomma(start,width,dec,point,sign);
   return(start);
}
/* Function to convert a long integer number to a string
 * with commas.
 */
char *plong(
long ltemp,  /* number to be formatted */
int width)  /* minimum width of field */
{
   int sign;        /* indicator for negative sign */
   static char start[40];  /* string to be returned */

   sign = (ltemp < 0) ? 1 : 0;
   sprintf(start,"%ld",ltemp);
   pcomma(start,width,0,0,sign);
   return(start);
}
/* Function to convert an integer number to a string
 * with commas.
 */
char *pint(
int temp,  /* number to be formatted */
int width)  /* minimum width of field */
{
   int sign;        /* indicator for negative sign */
   static char start[40];  /* string to be returned */

   sign = (temp < 0) ? 1 : 0;
   sprintf(start,"%d",temp);
   pcomma(start,width,0,0,sign);
   return(start);
}
/* Function to insert commas and blanks
 */
void pcomma(
char *start,  /* string to be returned */
int width,  /* minimum width of field */
int dec,  /* number of decimal places */
int point,  /* indicator for decimal point */
int sign)  /* indicator for negative sign */
{
   register i1, i2; /* loop counters */
   int len;         /* length of formatted number before commas */
   int ncomma;      /* number of commas or blanks to insert */

   len = strlen(start);
   if ((ncomma = (len-sign-dec-point-1)/3) > 0)
      { /* insert first comma */
      for (i1 = 0; i1 < dec+point+4; i1++)
         start[len+ncomma-i1] = start[len-i1];
      start[len+ncomma-dec-point-4] = ',';
      }
   if (ncomma > 1)
      { /* insert second and later commas */
      for (i1 = 1; i1 < ncomma; i1++) {
         for (i2 = 0; i2 < 3; i2++) /* do 3 digits */
            start[len+ncomma-4*i1-1-i2-dec-point] =
               start[len-3*i1-1-i2-dec-point];
         start[len+ncomma-4*i1-4-dec-point] = ','; }
      }
   len = strlen(start);
   if ((ncomma = width-len) > 0)
      { /* fill with blanks */
      for (i1=0; i1<=len; i1++)
         start[len+ncomma-i1] = start[len-i1];
      for (i1=0; i1<ncomma; i1++)
         start[i1] = ' ';
      }
}
