/*
 * config.C for WindowBoss
 * Function to review or change the configuration
 */

#ifndef lint
static char *configID = " config.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#include <stdlib.h>
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "winboss1.h"
#include "lawchg.h"
#include "piaparms.h"
#include "wnutils.h"
#include "setup.h"
#include "config.h"
#include "mesgcat.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int   getconf  ( WINDOW *wn, Config *config );
static int   getcsav  ( WINDOW *wn );
#else
static int   getconf();
static int   getcsav();
#endif

/* Function to review or update configuration
 */
int getconfig(
WINDOW *wn,  /* window to use */
Config *config)  /* configuration structure */
{
   int rv;  /* return value */

   if (getconf(wn, config) != ESC_CODE)
      {
      /* save results */
      if (getcsav(wn))
         {
         if ((rv = saveconf(config)) > 0) {
            wn_iemsg(catstr(rv));
            return(rv); }
         }
      }
   return(0);
}
/* Function to get configuration
 */
static int getconf(
WINDOW *wn,  /* window to use */
Config *config)  /* configuration structure */
{
   WIFORM frm;  /* form pointer */
   char answer[2][3];  /* answers as strings */
   int rv;  /* return value */

   begscrn("   Configuration    ");
   frm = wn_frmopn(8);
   if (!frm) {
      wn_iemsg(catstr(219));
      done(1); }
   sprintf(answer[0], "%1d", config -> iprntr);
   sprintf(answer[1], "%1d", config -> icolor);
   wn_gint(SET,frm,0,wn,4,3,"Direct to printer (0) or via disk (1) > ",
      COLOR_PAIR(2),' ',&(config -> iprntr),1,0,1,answer[0],
      "%type of printing%", catstr(260));
   wn_gint(SET,frm,1,wn,5,3,"          Monochrome (0) or color (1) > ",
      COLOR_PAIR(2),' ',&(config -> icolor),1,0,1,answer[1],
      "%color indicator%", catstr(262));
   wn_gtext(SET,frm,2,wn,6,3,"               Local directory > ",
      COLOR_PAIR(2),' ',40,config -> direct[0],"%local directory%",NSTR);
   wn_gtext(SET,frm,3,wn,7,3,"             Central directory > ",
      COLOR_PAIR(2),' ',40,config -> direct[1],"%central directory%",NSTR);
   wn_gtext(SET,frm,4,wn,8,3," Printer initialization string > ",
      COLOR_PAIR(2),' ',40,config -> prn_init,"%printer initialization%",NSTR);
   wn_gtext(SET,frm,5,wn,9,3," First part of printer command > ",
      COLOR_PAIR(2),' ',40,config -> command1,"%print command%",NSTR);
   wn_gtext(SET,frm,6,wn,10,3,"Second part of printer command > ",
      COLOR_PAIR(2),' ',40,config -> command2,"%print command%",NSTR);
   wattrset(wn,COLOR_PAIR(6));
   if ((rv = wn_frmget(frm)) != ESC_CODE)
      setcolor(config -> icolor);
   wn_frmcls(frm);
   delspcnf(config);
   return(rv);
}
/* Function to get answer to save-to-disk prompt
 */
static int getcsav(
WINDOW *wn)  /* window to use */
{
   static char ans[3];  /* answer */
   int value;  /* 0 = false, 1 = true */

   begscrn("    Save to disk    ");
   wattrset(wn,COLOR_PAIR(4));
   wn_dtext(XEQ,NFRM,NFLD,wn,4,3,
      "You are about to change the configuration data file for this program.");
   wn_dtext(XEQ,NFRM,NFLD,wn,5,3,
      "This means that you will permanently alter the setup options for each");
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,
      "time you run the program (until you change the configuration again).");
   wattrset(wn,COLOR_PAIR(6));
   wn_gbool(XEQ,NFRM,NFLD,wn,8,3,
      "Do you want to save the updated values to disk? (Y or N) > ",
      COLOR_PAIR(2), ' ', &value, ans, "%config Y or N%", catstr(258));
   return(value);
}
