/*  
 * %W%   %G%  
 * Macros to convert Unix curses to Window BOSS functions
 */  
  
#define refresh()  
#define stdscr               (0)  
#define LINES                (25)  
#define COLS                 (80)  
#define A_BOLD               0x08  
#define A_NORMAL             NVIDEO  
#define A_REVERSE            RVIDEO
#define wattrset(win,atrib)  wn_color(win,atrib,atrib)  
#define werase(win)          wn_clr(win)  
#define WREFRESH(win)        wn_activate(win)  
#define wmove(win,r,c)       wn_locate(win,r,c)  
#define wprintw              wn_printf  
#define waddstr(win,str)     wn_printf(win,str)  
#define touchwin(win)  
#define erase()              v_cls(A_NORMAL)  
#define attrset(atrib)  
#define beep()               bdos(2,7,0)  
#define waddch(win,ch)       wn_printf(win,"%c",ch)  
#define keypad(win,true)  
#define delwin(win)          wn_close(win)  
#define getyx(scr,y,x)       v_rcpos(0,&y,&x)  
#define PANEL                int  
#define new_panel(win)       (int *)0  
#define ERR                  NULL  
  
/* Keypad and other special characters-----------------------------------*/  
  
#define KEY_DOWN             0x5000  
#define KEY_UP               0x4800  
#define KEY_LEFT             0x4b00  
#define KEY_RIGHT            0x4d00  
#define KEY_HOME             0x4700  
#define KEY_F0               0x4400         /* F10 function key */  
#define KEY_F(n)             0x3a00+(n)     /* F1 through F9 */  
#define KEY_DC               0x5300         /* delete key */  
#define KEY_IC               0x5200         /* insert key */  
#define KEY_NPAGE            0x5100         /* page down */  
#define KEY_PPAGE            0x4900         /* page up */  
  
int wgetch( struct wcb * );  
   
typedef unsigned chtype; 
extern  chtype color[10];  /* color definitions */ 
#define init_pair(a,b,c)    color[a-1] = v_setatr(c,b,0,BOLD) 
#define COLOR_PAIR(a)       color[a-1]
