/*
 * disdeath.C for WindowBoss
 * Functions to get death or disability information
 */

#ifndef lint
static char *disdthID = " disdeath.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "winboss1.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "utils.h"
#include "wnutils.h"
#include "piain.h"
#include "compdate.h"
#include "getdate.h"
#include "mesgcat.h"

/* Function to get date of death
 */
disdeath(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i1;  /* first possible year of disability */
   int field = 0;  /* field counter */
   static char jsurvstr[10];  /* jsurv as a string */
   static char ionsetst[12];  /* ionset as a string */
   static char ideathst[12];  /* ideath as a string */
   static char jbirthst[12];  /* widow date of birth as a string */
   static char jonsetst[12];  /* widow date of onset as a string */
   static char priorst[12];  /* priorent as a string */
   static char waitst[12];  /* waitper as a string */
   WIFORM frm1, frm2 = NFRM, frm3 = NFRM;  /* form pointers */
   int jsurvt;  /* jsurv as an integer */
   int rv;  /* return value */
   int ierr;  /* error indicator */

   begscrn("Death or disability ");
   frm1 = wn_frmopn(4);
   wattrset(wn, COLOR_PAIR(6));
   if (!frm1) {
      wn_iemsg(catstr(208));
      done(1); }
   if (workerdata -> valdi == 1)
      { /* get date of disability onset */
      i1 = (1940 < workerdata -> ibirth[2]) ? workerdata -> ibirth[2] : 1940;
      wn_gmdy(SET, frm1, field, wn, 3, 18,
         "Worker's date of disability onset (mo/dy/year) > ",
         COLOR_PAIR(2), ' ', workerdata -> ionset, workerdata -> ionset + 1,
         workerdata -> ionset + 2, i1, 1936 + workerdata -> maxyears,
         ionsetst, "%disability onset%", catstr(16));
      field++;
      if (workerdata -> joasdi == OLD_AGE)
         { /* get date of prior DIB entitlement */
         wn_gmy(SET, frm1, field, wn, field+3, 18,
            "Date of prior disability entitlement (mo/year) > ",
            COLOR_PAIR(2), ' ', workerdata -> priorent,
            workerdata -> priorent + 2, i1, 1936 + workerdata -> maxyears,
            priorst, "%prior DIB entitlement%", catstr(44));
         field++;
         }
      else
         zeromdy(workerdata -> priorent);
      }
   else
      zeromdy(workerdata -> ionset);
   if (workerdata -> joasdi != SURVIVOR) {
      /* not a survivor */
      zeromdy(workerdata -> ideath);
      workerdata -> jsurv = NO_SURV; }
   else /* survivor */
      {
      i1 = (1940 < workerdata -> ibirth[2]) ? workerdata -> ibirth[2] : 1940;
      wn_gmy(SET, frm1, field, wn, field+3, 41, "Date of death (mo/year) > ",
         COLOR_PAIR(2), ' ', workerdata -> ideath, workerdata -> ideath + 2,
         i1, 1936 + workerdata -> maxyears, ideathst,
         "%date of death%", catstr(11));
      field++;
      jsurvt = (int)workerdata -> jsurv;
      sprintf(jsurvstr, "%1d", jsurvt);
      wn_gint(SET, frm1, field, wn, field+3, 3,
         "Type of survivor (1: young, 2: disabled widow, 3: aged widow) > ",
         COLOR_PAIR(2), ' ', &jsurvt, 1, 1, 3, jsurvstr, "%type of survivor%",
         catstr(13));
      } /* end else */
  form1:
   if ((rv = wn_frmget(frm1)) == ESC_CODE) {
      wn_frmcls(frm1);
      return(rv); }
   setjsurv(workerdata,jsurvt);
   if (rv == KEY_PPAGE) {
      wn_frmcls(frm1);
      return(rv); }
   if ((ierr = dthcheck(workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      goto form1; }
   if (workerdata -> valdi == 1) {
      if ((ierr = discheck(workerdata)) > 0) {
         wn_iemsg(catstr(ierr));
         goto form1; }
      if (workerdata -> joasdi == OLD_AGE)
         if ((ierr = priorchk(workerdata)) > 0) {
            wn_iemsg(catstr(ierr));
            goto form1; }
      }

   if (workerdata -> joasdi == DISABILITY)
      { /* get first month of waiting period */
      frm2 = wn_frmopn(2);
      if (!frm2) {
         wn_iemsg(catstr(209));
         done(1); }
         /* assume waiting period starts immediately after onset */
         if (workerdata -> ionset[1] == 1) {
            workerdata -> waitper[0] = workerdata -> ionset[0];
            workerdata -> waitper[2] = workerdata -> ionset[2];
            }
         else {
            workerdata -> waitper[0] = workerdata -> ionset[0] + 1;
            workerdata -> waitper[2] = workerdata -> ionset[2];
            if (workerdata -> waitper[0] > 12) {
               workerdata -> waitper[0] -= 12;
               workerdata -> waitper[2]++;
               }
            }
      wn_gmy(SET, frm2, 0, wn, 8, 25,
         "First month of waiting period (mo/year) > ",
         COLOR_PAIR(2), ' ', workerdata -> waitper, workerdata -> waitper + 2,
         workerdata -> waitper[2], 1936 + workerdata -> maxyears, waitst,
         "%waiting period%", catstr(47));
  form2:
      if ((rv = wn_frmget(frm2)) == ESC_CODE) {
         wn_frmcls(frm1);
         wn_frmcls(frm2);
         return(rv); }
      if (rv == KEY_PPAGE) {
         wn_frmcls(frm2);
         goto form1; }
      if (workerdata -> joasdi == DISABILITY)
         if ((ierr = waitchk(workerdata)) > 0) {
            wn_iemsg(catstr(ierr));
            goto form1; }
      }
   else
      zeromdy(workerdata -> waitper);

   if (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID)
      {
      frm3 = wn_frmopn(3);
      if (!frm3) {
         wn_iemsg(catstr(210));
         done(1); }
      wn_gmdy(SET, frm3, 0, wn, 10, 32,
         "Widow date of birth (mo/dy/year) > ", COLOR_PAIR(2), ' ',
         workerdata -> jbirth, workerdata -> jbirth + 1,
         workerdata -> jbirth + 2, 1800, 1936 + workerdata -> maxyears,
         jbirthst, "%widow date of birth%", catstr(146));
      if (workerdata -> jsurv == DISAB_WID)
         {
         wn_gmdy(SET, frm3, 1, wn, 11, 19,
            "Widow's date of disability onset (mo/dy/year) > ",
            COLOR_PAIR(2), ' ', workerdata -> jonset,
            workerdata -> jonset + 1, workerdata -> jonset + 2, 1940,
            1936 + workerdata -> maxyears, jonsetst,
            "%widow disab onset%", catstr(37));
         }
      else
         {
         wn_dtext(SET, frm3, 1, wn, 11, 19, stringd(58,' '));
         zeromdy(workerdata -> jonset);
         }
  form3:
      if ((rv = wn_frmget(frm3)) == ESC_CODE) {
         wn_frmcls(frm1);
         if (workerdata -> joasdi == DISABILITY)
            wn_frmcls(frm2);
         wn_frmcls(frm3);   
      return(rv); }
      if (rv == KEY_PPAGE) {
         wn_frmcls(frm3);
         if (workerdata -> joasdi == DISABILITY)
            goto form2;
         else
            goto form1;
         }
      if (workerdata -> jsurv == DISAB_WID)
         if ((ierr = widcheck(workerdata)) > 0) {
            wn_iemsg(catstr(ierr));
            goto form3; }
      }  /* end jsurv > 1 */
   else
      zeromdy(workerdata -> jbirth);

   wn_frmcls(frm1);
   if (frm2)
      wn_frmcls(frm2);
   if (frm3)
      wn_frmcls(frm3);
   return(rv);
}
