/*
 * earnin.C for WindowBoss
 * Functions to get and modify year-by-year earnings
 */

#ifndef lint
static char *earninID = " earnin.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "winboss1.h"
#include "lawchg.h"
#include "wnutils.h"
#include "piaparms.h"
#include "piadata.h"
#include "piain.h"
#include "mesgcat.h"

/* Function to review and edit earnings on screen
 */
int earnr(
WINDOW *wn,  /* window to use */
int firstyr,  /* first year to show */
int lastyr,  /* last year to show */
double *amounts,  /* array of amounts to show */
double maxearn,  /* maximum earnings allowed */
int *no_change,  /* array of indicators for not allowing changes
                0: allow changes
                non-0: allow no change */
char *wntitle,  /* window title */
char *hlpmsg)  /* help message */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][18];  /* prompt for each year of earnings */
   int rv = 0;  /* return value */
   int any_change = 0;  /* indicator for any changes allowed */

   begscrn(wntitle);
   frm = wn_frmopn(61);
   wattrset(wn, COLOR_PAIR(4));
   if (!frm) {
      wn_iemsg(catstr(220));
      done(1); }
   for (i = 0; (i < 60 && i <= lastyr-firstyr); i++)
      {
      i2 = i/20;
      i1 = i - i % 20;
      if (no_change[firstyr - 1937 + i] == 0)
         {  /* get new value */
         any_change++;
         sprintf(answer[i], "%9.2lf", amounts[firstyr-1937+i]);
         sprintf(prmpt[i], "%4d   ", firstyr+i);
         wn_gdouble(SET, frm, any_change - 1, wn, i+FF2-i1, 8+FF2+i2*(COLS/3),
            prmpt[i], COLOR_PAIR(2), '_', amounts+firstyr-1937+i, 9, 2, 0.0,
            maxearn, answer[i], hlpmsg, catstr(28));
         }
      else
         {  /* display only */
         sprintf(prmpt[i], "%4d   %9.2lf", firstyr+i,
            amounts[firstyr-1937+i]);
         wn_dtext(XEQ, NFRM, NFLD, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i]);
         }
      }
   WREFRESH(wn);
   if (any_change) {
      wattrset(wn, COLOR_PAIR(6));
      rv = wn_frmget(frm); }
   wn_frmcls(frm);
   if (!any_change)
      getret();
   return(rv);
}
/* Function to review and edit tax type on screen
 */
int taxr(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][8];  /* prompt for each year of earnings */
   int firstyr;  /* first year to show */
   int rv;  /* return value */

   begscrn("   Type of taxes    ");
   frm = wn_frmopn(61);
   if (!frm) {
      wn_iemsg(catstr(221));
      done(1); }
   firstyr = workerdata -> ibegin;
   for (i = 0; (i < 60 && i <= workerdata -> iend - firstyr); i++)
      {
      sprintf(prmpt[i], "%4d   ", firstyr+i);
      i2 = i / 20;
      i1 = i - i % 20;
      wn_ges(SET, frm, i, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i],
         COLOR_PAIR(2), '_', workerdata -> taxtype + firstyr - 1937 + i,
         answer[i], "%type of taxes%", catstr(256));
      }
   WREFRESH(wn);
   wattrset(wn, COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
   return(rv);
}
/* Function to review and edit type of earnings on screen
 */
int earntyper(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][8];  /* prompt for each year of earnings */
   int firstyr;  /* first year to show */
   int rv;  /* return value */
   int earntypet[60];  /* earntype as integer */

   begscrn("  Type of earnings  ");
   frm = wn_frmopn(61);
   if (!frm) {
      wn_iemsg(catstr(222));
      done(1); }
   firstyr = workerdata -> ibegin1;
   for (i = 0; (i < 60 && i <= workerdata -> iend1 - firstyr); i++)
      earntypet[i] = (int)workerdata -> earntype[firstyr + i - 1937];
   for (i = 0; (i < 60 && i <= workerdata -> iend1 - firstyr); i++)
      {
      sprintf(prmpt[i], "%4d   ", firstyr+i);
      i2 = i / 20;
      i1 = i - i % 20;
      wn_gmlchr(SET, frm, i, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i],
         COLOR_PAIR(2), '_', earntypet + i,
         answer[i], "%type of earnings%", catstr(257));
      }
   WREFRESH(wn);
   wattrset(wn, COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
   for (i = 0; (i < 60 && i <= workerdata -> iend1 - firstyr); i++)
      workerdata -> earntype[firstyr + i - 1937] =
         (enum earn_type)earntypet[i];
   return(rv);
}
