/*
 * @(#)getdate.C	1.26   4/8/94
 * Various functions to get dates and put them on screen
 */

#ifndef lint
static char *getdateID = " @(#)getdate.C	1.26   4/8/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#include <stdlib.h>
#endif
#include "getdate.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void put2dig ( char *, int );
#else
static void put2dig();
#endif

/* Function to interpret a string as mo/dy/year
 */
int getmdy(
char *string,  /* string to be interpreted */
int *modyyear)  /* month, day, and year */
{
   char *temp;  /* temporary pointer */
   int r;  /* return value */
   char tempstr[20];  /* temporary string */

   strncpy(tempstr,string,18);
   temp = strtok(tempstr,"/");
   r = sscanf(temp,"%d",modyyear);
   temp = strtok((char *)0,"/");
   r = sscanf(temp,"%d",modyyear+1);
   temp = strtok((char *)0,"/");
   r = sscanf(temp,"%d",modyyear+2);
   return(r);
}
/* Function to interpret a string as mo/year
 */
int getmy(
char *string,  /* string to be interpreted */
int *moyear)  /* month, day, and year */
{
   char *temp;  /* temporary pointer */
   int r;  /* return value */
   char tempstr[20];  /* temporary string */

   strncpy(tempstr,string,18);
   temp = strtok(tempstr,"/");
   r = sscanf(temp,"%d",moyear);
   temp = strtok((char *)0,"/");
   r = sscanf(temp,"%d",moyear+2);
   return(r);
}
/* Function to put month, day, and year into a string
 */
void putmdy(
char *ans,  /* character string to hold result */
int *modyyr)  /* month, day, and year */
{
   put2dig(ans, modyyr[0]);
   put2dig(ans+3, modyyr[1]);
   if (modyyr[2])
      sprintf(ans+6, "%4d", modyyr[2]);
   else
      sprintf(ans+6, "0000");
}
/* Function to put month and year into a string
 */
void putmy(
char *ans,  /* character string to hold result */
int *moyear)  /* month and year */
{
   put2dig(ans, moyear[0]);
   if (moyear[2])
      sprintf(ans+3, "%4d", moyear[2]);
   else
      sprintf(ans+3, "0000");
}
/* Function to put month or day into a string
 */
static void put2dig(
char *ans,  /* character string to hold result */
int mnth)  /* month (1-12) or day (1-31) */
{
   if (mnth < 10)
      sprintf(ans, "0%d/", mnth);
   else
      sprintf(ans, "%2d/", mnth);
}
/* Function to zero out month, day, and year
 */
void zeromdy(
int modyyr[3])  /* month, day, and year */
{
   modyyr[0] = modyyr[1] = modyyr[2] = 0;
}
