/*
 * getopt.c   7/2/91
 * Mimic function to get command line options (available in Unix 3.2)
 *
 * This function returns the next option letter in arguments that matches
 * a letter in options.  Each option is expected to be indicated by a
 * preceding optchar character.  The options string must contain the
 * option letters the command using getopt will recognize; any argument
 * to the option is expected to follow immediately after the option letter.
 * optarg is set to point to the start of the option-argument on return
 * from getopt.  getopt places in optind the arguments index of the next
 * argument to be processed.  When all options have been processed (that
 * is, up to the first non-option argument), getopt returns -1.
 */

char *optarg;
int optind = 1;  /* current argument to look at */

getopt(argcount,arguments,options)
int argcount;  /* number of arguments */
char **arguments;  /* argument strings */
char *options;  /* allowable options */
{
   char optchar = '/';
   int i;

   if (optind == -1)
      return(-1);
   for (i = optind; i < argcount; i++)
      {
      optind++;
      if (arguments[i][0] == optchar) {
         if (arguments[i][1] == options[0]) {
            optarg = arguments[i] + 2;
            return((int)arguments[i][1]);
            }
         }
      else {
         optind = -1;
         return(-1);
         }
      }
   return(-1);
}
