/*
 * @(#)lawchg.C	1.6   3/17/94
 * Various functions to handle law-change variables
 */

#ifndef lint
static char *lawchgID = " @(#)lawchg.C	1.6   3/17/94 ";
#endif

#include <stdio.h>
#include <stdlib.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "lawchg.h"

static int startyrlc;  /* earliest starting year for changes */
static int lastyrlc;  /* latest year for changes */

/* Function to initialize law-change array
 */
int initlc(
Lawchg **lawchgdatap,  /* Lawchg structure */
int startt,  /* earliest starting year for changes */
int maxyears,  /* maximum number of years projected, starting with 1951 */
char *directory)  /* directory with law-change indicators */
{

   if ((*lawchgdatap = (Lawchg *)malloc(sizeof(Lawchg))) == (Lawchg *)0)
      return(286);
   startyrlc = startt;
   lastyrlc = 1936 + maxyears;
   (*lawchgdatap) -> tind[0] = "pre-1977 law benefits";
   (*lawchgdatap) -> tind[1] =
      "bend points increasing at fraction of wage rate";
   (*lawchgdatap) -> tind[2] = "bend points increasing at CPI rate";
   (*lawchgdatap) -> tind[3] = "earnings indexed to CPI rate";
   (*lawchgdatap) -> tind[4] = "new benefit formula";
   (*lawchgdatap) -> tind[5] = "bend points increasing at specified rates";
   (*lawchgdatap) -> tind[6] =
      "bend points increasing at wage rate minus a constant";
   (*lawchgdatap) -> tind[7] = "age 65 computation point";
   (*lawchgdatap) -> tind[8] = "declining benefit formula percents";
   (*lawchgdatap) -> tind[9] = "no benefit increase in year of eligibility";
   (*lawchgdatap) -> tind[10] = "no re-indexed widow guarantee";
   (*lawchgdatap) -> tind[11] = "(Reserved for future use)";
   (*lawchgdatap) -> tind[12] = "new special minimum (years and/or amount)";
   (*lawchgdatap) -> tind[13] = "no Old-Start";
   (*lawchgdatap) -> tind[14] = "5-year DI dropout";
   (*lawchgdatap) -> tind[15] =
      "use earnings after age 62 for transitional guarantee";
   (*lawchgdatap) -> tind[16] =
      "use average of old-law and aime for transitional guar";
   (*lawchgdatap) -> tind[17] =
      "use average of type-16 and aime for transitional guar";
   (*lawchgdatap) -> tind[18] =
      "Daub notch proposal (using special weighting)";
   (*lawchgdatap) -> tind[19] =
      "original Roybal notch proposal (H.R. 1917 in 99th Congress)";
   (*lawchgdatap) -> tind[20] =
      "second Roybal notch proposal (H.R. 1917 in 100th Congress)";
   (*lawchgdatap) -> tind[21] = "original Sanford proposal (3% to retirement)";
   (*lawchgdatap) -> tind[22] = "no PIA table method";
   (*lawchgdatap) -> tind[23] = "no transitional guarantee";
   (*lawchgdatap) -> tind[24] =
      "third Roybal notch proposal (H.R. 917 in 101st Congress)";
   (*lawchgdatap) -> tind[25] =
      "second Sanford notch proposal (3.25% to age 62 and red yrs)";
   (*lawchgdatap) -> tind[26] = "no age-67 retirement age";
   (*lawchgdatap) -> tind[27] = "childcare drop-in years";
   (*lawchgdatap) -> tind[28] = "(Reserved for future use)";
   (*lawchgdatap) -> tind[29] = "(Reserved for future use)";
   /* allocate memory for law change array */
   if (((*lawchgdatap) -> bpinc = (float *)calloc((unsigned)maxyears,
      sizeof(float))) == (float *)0)
      return(286);
   if (((*lawchgdatap) -> fact = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(286);
   (*lawchgdatap) -> directory = directory;
   (*lawchgdatap) -> maxyears = maxyears;
   return(0);
}
/* Function to get indicators for change from present law
 */
lawchgf(
FILE *infile,  /* input file */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1;  /* loop counter */

   lawchgdata -> jindt = 0;
   for (i1 = 0; i1 < MAXLCH; i1++)
      {
      if (fscanf(infile, "%d", &(lawchgdata -> jind[i1])) <= 0)
         return(94);
      if (lawchgdata -> jind[i1] < 0)
         return(94);
      lawchgdata -> jindt += lawchgdata -> jind[i1];
      }
   /* read years of percentage of wage-indexed bend points */
   if (lawchgdata -> jind[1]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][1])) <= 0)
         return(94);
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[1][1])) <= 0)
         return(94);
      if (fscanf(infile, "%f", &(lawchgdata -> pbp)) <= 0)
         return(94);
      }
   /* read years of CPI-indexed bend points */
   if (lawchgdata -> jind[2]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][2])) <= 0)
         return(94);
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[1][2])) <= 0)
         return(94);
      }
   /* read years of CPI-indexed earnings */
   if (lawchgdata -> jind[3]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][3])) <= 0)
         return(94);
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[1][3])) <= 0)
         return(94);
      }
   /* read year of new benefit formula, and new formula */
   if (lawchgdata -> jind[4]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][4])) <= 0)
         return(94);
      for (i1 = 0; i1 < 3; i1++)
         if (fscanf(infile, "%f", lawchgdata -> percpa + i1) <= 0)
            return(94);
      for (i1 = 1; i1 < 3; i1++)
         if (fscanf(infile, "%d", lawchgdata -> bendpalt + i1) <= 0)
            return(94);
      }
   /* read years of specified increases in bend points, and increases */
   if (lawchgdata -> jind[5]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][5])) <= 0)
         return(94);
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[1][5])) <= 0)
         return(94);
      for (i1 = lawchgdata -> jstart[0][5] - 1951;
         i1 <= lawchgdata -> jstart[1][5] - 1951; i1++)
         if (fscanf(infile, "%f", lawchgdata -> bpinc + i1) <= 0)
            return(94);
      }
   /* read years of constant percentage decline from wage increase for
    * bend point increase, and amount of decline */
   if (lawchgdata -> jind[6]) {
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][6])) <= 0)
         return(94);
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[1][6])) <= 0)
         return(94);
      if (fscanf(infile, "%f", &(lawchgdata -> cp)) <= 0)
         return(94);
      }
   /* read first year of age-65 comp point */
   if (lawchgdata -> jind[7])
      if (fscanf(infile, "%d", &(lawchgdata -> jstart[0][7])) <= 0)
         return(94);
   return(0);
}
/* Function to check range of a jstart value
 */
int jstartchk(int jstartt)
{
   if (jstartt < startyrlc || jstartt > lastyrlc)
      return(263);
   else
      return(0);
}
/* Function to check range of a bendpoint value
 */
int bendpchk(int bendpt)
{
   if (bendpt < 0 || bendpt > 99999)
      return(266);
   else
      return(0);
}
/* Function to check range of a wage increase proportion
 */
int pbpchk(double pbpt)
{
   if (pbpt < .0 || pbpt > 1.0)
      return(264);
   else
      return(0);
}
/* Function to check range of a benefit increase percentage
 */
int percchk(double perct)
{
   if (perct < .0 || perct > 100.0)
      return(265);
   else
      return(0);
}
/* Function to check range of a bend point increase percentage
 */
int bpincchk(float bpinct)
{
   if (bpinct < .0 || bpinct > 100.0)
      return(265);
   else
      return(0);
}
/* Function to check range of a constant decline percentage
 */
int cpcheck(float cpt)
{
   if (cpt < .0 || cpt > 9.99)
      return(267);
   else
      return(0);
}
