/*
 * @(#)lawchg.h	1.29   3/17/94
 * Function declarations for lawchg.c, and variables 
 * involving changes in the law common to many modules.
 */

#ifndef __LAWCHG_H
#define __LAWCHG_H

#if defined(MSDOS) | defined(THINK_C)
#define LAWCHGDAT "LAWCHG.DAT"
#else
#define LAWCHGDAT "lawchg.dat"
#endif

#define MAXLCH 30 /* number of possible changes in law */
typedef struct {
   float  aspmin; /* alternative special minimum dollar amount */
   int    bendpalt[3];  /* alternative PIA formula bend points (used
                 if jind[4] is set) */
   float *bpinc; /* bend point increase percentages for PIA
                 formula (used if jind[5] is set) */
   float  bspmin;  /* alternative percent of old-law wage base required
                 for a year of coverage in special minimum method */
   float  cp;  /* constant percentage subtracted from bend point
                 increase (used if jind[6] is set) */
   double *fact;  /* indexing series when a mixture of wages and CPI
                 (used if jind[3] is set) */
   int    iern49;  /* starting year for 3-year limitation in notch
                 proposals */
   int    ielgy1;  /* year prior to year of eligibility, using age-65
                 computation point */
   int    jind[MAXLCH]; /* indicators for changes from present law */
   int    jindt;  /* total of jind */
   int    jspmin; /* alternative maximum number of years of coverage
                 considered in special minimum calculation (30 in PL) */
   int    jstart[2][MAXLCH]; /* first and last years of proposal to
                 change law, corresponding to JIND */
   double pbp;  /* proportion of wage increase applied to bend points */
   double percpa[3];  /* benefit formula percentages for PIA formula
                 (used if jind[4] is set) */
   char  *tind[MAXLCH];  /* titles of changes in law */
   double z4;  /* reduction factor (in multiples of 1%) for new Roybal
                 and Sanford nothc proposals */
   char  *directory;  /* directory with law-change indicators */
   int    maxyears;  /* maximum number of years allowed */
   } Lawchg;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int initlc   ( Lawchg **lawchgdatap, int startt, int maxyears,
   char *directory );
int jstartchk( int jstartt );
int bendpchk ( int bendpt );
int pbpchk   ( double pbpt );
int percchk  ( double perct );
int bpincchk ( float bpinct );
int cpcheck  ( float cpt );
#else
int initlc();
int jstartchk();
int bendpchk();
int pbpchk();
int percchk();
int bpincchk();
int cpcheck();
#endif

#endif
