/*
 * lawchgwn.C for WindowBoss
 * Functions to get changes from present law
 */

#ifndef lint
static char *lawchgID = " lawchgwn.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include "strings.h"
#else
#include "string.h"
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "setup.h"
#include "utils.h"
#include "wnutils.h"
#include "lawchgwn.h"
#include "mesgcat.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int  getlsav   ( WINDOW * );
static int  getlcparm ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp1   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp2   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp3   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp4   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp5   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp6   ( WINDOW *wn, Lawchg *lawchgdata );
static int  getlcp7   ( WINDOW *wn, Lawchg *lawchgdata );
#else
static int  getlsav();
static int  getlcparm();
static int  getlcp1();
static int  getlcp2();
static int  getlcp3();
static int  getlcp4();
static int  getlcp5();
static int  getlcp6();
static int  getlcp7();
#endif

char *msglc2 = "First year > ";
char *msglc3 = "Last year > ";
char *msglc4 = "%first year%";
char *msglc5 = "%last year%";

/* Function to get changes from present law
 */
int lawchg(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1;  /* loop counter */
   static char lawchgst[MAXLCH][10];  /* answer as a string */
   int rv;  /* return value */
   WIFORM frm1, frm2;  /* form pointers */
   FILE *iout;  /* file pointer to save results */
   char hlpmsg[MAXLCH][20];  /* help messages */
   static char hlpformat[] = "%%lawchg %d%%";  /* format for help messages */
   char *infile;  /* full pathname of file with changes in law */

      begscrn(" Changes to law - 1 ");
      frm1 = wn_frmopn(16);
   wattrset(wn,COLOR_PAIR(6));
      if (!frm1) {
         wn_iemsg(catstr(223));
         done(1); }
      for (i1 = 0; i1 < MAXLCH; i1++)
         sprintf(hlpmsg[i1],hlpformat,i1+1);
      for (i1 = 0; i1 < 15; i1++) {
         strcpy(lawchgst[i1], (lawchgdata -> jind[i1]) ? "Y" : "N");
         wn_gbool(SET, frm1, i1, wn, 3+i1, 3, lawchgdata -> tind[i1],
         COLOR_PAIR(2), ' ', lawchgdata -> jind + i1, lawchgst[i1],
         hlpmsg[i1], catstr(258));
         }
  form1:
   if ((rv = wn_frmget(frm1)) == ESC_CODE) {
      wn_frmcls(frm1);
      return(0); }
   begscrn(" Changes to law - 2 ");
   frm2 = wn_frmopn(16);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm2) {
      wn_iemsg(catstr(224));
      done(1); }
   for (i1 = 0; i1 < 15; i1++) {
      strcpy(lawchgst[i1+15], (lawchgdata -> jind[i1+15]) ? "Y" : "N");
      wn_gbool(SET, frm2, i1, wn, 3+i1, 3, lawchgdata -> tind[i1+15],
         COLOR_PAIR(2), ' ', lawchgdata -> jind + i1 + 15, lawchgst[i1+15],
         hlpmsg[i1+15], catstr(258));
      }
  form2:
   if ((rv = wn_frmget(frm2)) == ESC_CODE) {
      wn_frmcls(frm1);
      wn_frmcls(frm2);
      return(0); }
   if (rv == KEY_PPAGE)
      {
      wn_frmcls(frm2);
      goto form1;
      }
   lawchgdata -> jindt = 0;
   for (i1 = 0; i1 < MAXLCH; i1++)
      lawchgdata -> jindt += lawchgdata -> jind[i1];
   /* get parameters for any changes in law */
   if ((rv = getlcparm(wn,lawchgdata)) == ESC_CODE) {
      wn_frmcls(frm1);
      wn_frmcls(frm2);
      return(0); }
   if (rv == KEY_PPAGE)
      goto form2;
   wn_frmcls(frm1);
   wn_frmcls(frm2);
   /* save results */
   if (getlsav(wn))
      {
      concat(&infile, lawchgdata -> directory, LAWCHGDAT);
      if ((iout = fopen(infile, "w")) == (FILE *)NULL)
         return(95);
      status(catstr(293));
      for (i1 = 0; i1 < MAXLCH; i1++)
         fprintf(iout, "%3d\n", lawchgdata -> jind[i1]);
      if (lawchgdata -> jind[1]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][1]);
         fprintf(iout, "%4d\n", lawchgdata -> jstart[1][1]);
         fprintf(iout, "%4.2f\n", lawchgdata -> pbp);
         }
      if (lawchgdata -> jind[2]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][2]);
         fprintf(iout, "%4d\n", lawchgdata -> jstart[1][2]);
         }
      if (lawchgdata -> jind[3]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][3]);
         fprintf(iout, "%4d\n", lawchgdata -> jstart[1][3]);
         }
      if (lawchgdata -> jind[4]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][4]);
         for (i1 = 0; i1 < 3; i1++)
            fprintf(iout, "%4.2f\n", lawchgdata -> percpa[i1]);
         for (i1 = 1; i1 < 3; i1++)
            fprintf(iout, "%d\n", lawchgdata -> bendpalt[i1]);
         }
      if (lawchgdata -> jind[5]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][5]);
         fprintf(iout, "%4d\n", lawchgdata -> jstart[1][5]);
         for (i1 = lawchgdata -> jstart[0][5] - 1951;
            i1 <= lawchgdata -> jstart[1][5] - 1951; i1++)
            fprintf(iout, "%4.2f\n", lawchgdata -> bpinc[i1]);
         }
      if (lawchgdata -> jind[6]) {
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][6]);
         fprintf(iout, "%4d\n", lawchgdata -> jstart[1][6]);
         fprintf(iout, "%4.2f\n", lawchgdata -> cp);
         }
      if (lawchgdata -> jind[7])
         fprintf(iout, "%4d\n", lawchgdata -> jstart[0][7]);
      fclose(iout);
      clr_stat();
      }
   return(0);
}
/* Function to get yes or no to save change-in-law question
 */
static int getlsav(
WINDOW *wn)  /* window to use */
{
   static char anslwchg[3];  /* answer to law-change prompt */
   int value;  /* 0 = false, 1 = true */

   begscrn("    Save to disk    ");
   wattrset(wn,COLOR_PAIR(4));
   wn_dtext(XEQ,NFRM,NFLD,wn,3,3,
      "You are about to change the law-change data file for this program.");
   wn_dtext(XEQ,NFRM,NFLD,wn,4,3,
      "This means that you will permanently alter the law-change options for");
   wn_dtext(XEQ,NFRM,NFLD,wn,5,3,
      "each time you run the program (until you change the law-change options");
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,"again).");
   wattrset(wn,COLOR_PAIR(6));
   wn_gbool(XEQ,NFRM,NFLD,wn,8,3,
      "Do you want to save the updated values to disk? (Y or N) > ",
      COLOR_PAIR(2), ' ', &value, anslwchg, "%lawchg Y or N%", catstr(258));
   return(value);
}
/* Function to get parameters for changes in law
 */
static int getlcparm(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int rv = 0;  /* return value */

   if (lawchgdata -> jind[1]) {
      if ((rv = getlcp1(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[2]) {
      if ((rv = getlcp2(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[3]) {
      if ((rv = getlcp3(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[4]) {
      if ((rv = getlcp4(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[5]) {
      if ((rv = getlcp5(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[6]) {
      if ((rv = getlcp6(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   if (lawchgdata -> jind[7]) {
      if ((rv = getlcp7(wn,lawchgdata)) == ESC_CODE)
         return(rv);
      if (rv == KEY_PPAGE)
         return(rv);
      }
   return(rv);
}
/* Function to get parameters for jind[1]
 */
static int getlcp1(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* last year as a string */
   char jstr3[10];  /* proportion of wage increase as a string */

   begscrn("  Change in law #2  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][1]);
   sprintf(jstr2, "%4d", lawchgdata -> jstart[1][1]);
   sprintf(jstr3, "%4.2f", lawchgdata -> pbp);
   frm = wn_frmopn(4);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][1]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gint(SET, frm, 1, wn, 4, 41, msglc3, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[1][1]), 4, istart, 1936+IX, jstr2, msglc5,
      catstr(263));
   wn_gdouble(SET, frm, 2, wn, 5, 23, "Proportion of wage increase > ",
      COLOR_PAIR(2), ' ', &(lawchgdata -> pbp), 4, 2, .0, 1.0, jstr3,
      "%prop of wage inc%", catstr(264));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[2]
 */
static int getlcp2(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* last year as a string */

   begscrn("  Change in law #3  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][2]);
   sprintf(jstr2, "%4d", lawchgdata -> jstart[1][2]);
   frm = wn_frmopn(3);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][2]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gint(SET, frm, 1, wn, 4, 41, msglc3, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[1][2]), 4, istart, 1936+IX, jstr2, msglc5,
      catstr(263));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[3]
 */
static int getlcp3(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* last year as a string */

   begscrn("  Change in law #4  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][3]);
   sprintf(jstr2, "%4d", lawchgdata -> jstart[1][3]);
   frm = wn_frmopn(3);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][3]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gint(SET, frm, 1, wn, 4, 41, msglc3, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[1][3]), 4, istart, 1936+IX, jstr2, msglc5,
      catstr(263));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[4]
 */
static int getlcp4(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* first percentage as a string */
   char jstr3[10];  /* second percentage as a string */
   char jstr4[10];  /* third percentage as a string */
   char jstr5[10];  /* first bend point as a string */
   char jstr6[10];  /* second bend point as a string */

   begscrn("  Change in law #5  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][4]);
   sprintf(jstr2, "%4.2f", lawchgdata -> percpa[0]);
   sprintf(jstr3, "%4.2f", lawchgdata -> percpa[1]);
   sprintf(jstr4, "%4.2f", lawchgdata -> percpa[2]);
   sprintf(jstr5, "%4d", lawchgdata -> bendpalt[1]);
   sprintf(jstr6, "%4d", lawchgdata -> bendpalt[2]);
   frm = wn_frmopn(7);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][4]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gdouble(SET, frm, 2, wn, 4, 34, "First percentage > ",
      COLOR_PAIR(2), ' ', lawchgdata -> percpa, 5, 2, .0, 99.99, jstr2,
      "%alt percentages%", catstr(265));
   wn_gdouble(SET, frm, 2, wn, 5, 33, "Second percentage > ",
      COLOR_PAIR(2), ' ', lawchgdata -> percpa + 1, 5, 2, .0, 99.99, jstr3,
      "%alt percentages%", catstr(265));
   wn_gdouble(SET, frm, 2, wn, 6, 34, "Third percentage > ",
      COLOR_PAIR(2), ' ', lawchgdata -> percpa + 2, 5, 2, .0, 99.99, jstr4,
      "%alt percentages%", catstr(265));
   wn_gint(SET, frm, 2, wn, 7, 34, "First bend point > ",
      COLOR_PAIR(2), ' ', lawchgdata -> bendpalt + 1, 5, 0, 99999, jstr5,
      "%alt bend points%", catstr(266));
   wn_gint(SET, frm, 2, wn, 8, 33, "Second bend point > ",
      COLOR_PAIR(2), ' ', lawchgdata -> bendpalt + 2, 5, 0, 99999, jstr6,
      "%alt bend points%", catstr(266));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[5]
 */
static int getlcp5(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* first percentage as a string */
   char jstr3[10];  /* first bend point increase */

   begscrn("  Change in law #6  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][5]);
   sprintf(jstr2, "%4d", lawchgdata -> jstart[1][5]);
   sprintf(jstr3, "%4.2f",
      lawchgdata -> bpinc[lawchgdata -> jstart[0][5] - 1951]);
   frm = wn_frmopn(4);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][5]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gint(SET, frm, 0, wn, 4, 41, msglc3, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[1][5]), 4, istart, 1936+IX, jstr1, msglc5,
      catstr(263));
   wn_gfloat(SET, frm, 2, wn, 5, 31, "bend point increase > ",
      COLOR_PAIR(2), ' ',
      lawchgdata -> bpinc + lawchgdata -> jstart[0][5] - 1951, 5, 2, .0,
      99.99, jstr3, "%bend point increase%", catstr(265));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[6]
 */
static int getlcp6(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */
   char jstr2[10];  /* last year as a string */
   char jstr3[10];  /* constant percentage decline as a string */

   begscrn("  Change in law #7  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][6]);
   sprintf(jstr2, "%4d", lawchgdata -> jstart[1][6]);
   sprintf(jstr3, "%4.2f", lawchgdata -> cp);
   frm = wn_frmopn(4);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][6]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   wn_gint(SET, frm, 1, wn, 4, 41, msglc3, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[1][6]), 4, istart, 1936+IX, jstr2, msglc5,
      catstr(263));
   wn_gfloat(SET, frm, 2, wn, 5, 32, "Percentage decline > ",
      COLOR_PAIR(2), ' ', &(lawchgdata -> cp), 4, 2, .0, 9.99, jstr3,
      "%perc decline in bp%", catstr(267));
   return(wn_frmget(frm));
}
/* Function to get parameters for jind[7]
 */
static int getlcp7(
WINDOW *wn,  /* window to use */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   WIFORM frm;  /* form pointer */
   char jstr1[10];  /* first year as a string */

   begscrn("  Change in law #8  ");
   sprintf(jstr1, "%4d", lawchgdata -> jstart[0][7]);
   frm = wn_frmopn(2);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(225));
      done(1); }
   wn_gint(SET, frm, 0, wn, 3, 40, msglc2, COLOR_PAIR(2), ' ',
      &(lawchgdata -> jstart[0][7]), 4, istart, 1936+IX, jstr1, msglc4,
      catstr(263));
   return(wn_frmget(frm));
}
