/*
 * @(#)mesgcat.C	1.4  5/31/94
 * Functions to get a message catalog and provide its strings
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(M_UNIX)
#include <nl_types.h>
nl_catd catalog;  /* message catalog */
#else
char **catalog;  /* message array */
#endif
#include "mesgcat.h"
#include "utils.h"


/* Function to get a string from the catalog
 */
char *catstr(
int mesgnum)  /* message number */
{
   char defmesg[30];  /* default message */

   sprintf(defmesg, "No message number %d", mesgnum);
#if defined(M_UNIX)
   return(catgets(catalog, 1, mesgnum, defmesg));
#else
   if (catalog[mesgnum] == (char *)0)
      return(defmesg);
   if (strlen(catalog[mesgnum]))
      return(catalog[mesgnum]);
   else
      return(defmesg);
#endif
}
/* Function to initialize the catalog
 */
void initcat(
char *directory)  /* directory with message catalog */
{
   char *infile;  /* pointer to message catalog pathname */
#if !defined(M_UNIX)
   FILE *catfile;  /* pointer to file with catalog */
   char temp[80];  /* temporary input line */
   int mesgnum;  /* message number */
   int start;  /* starting point of message in temporary input line */
   int i1;  /* loop counter */
#endif

   concat(&infile, (strlen(directory) == 0) ? "." : directory, "anypia.cat");
#if defined(M_UNIX)
   catalog = catopen(infile, 0);
#else
   catalog = (char **)calloc(310, sizeof(char *));
   catfile = fopen(infile,"r");
   for (i1 = 0; i1 = 310; i1++) {
      if (getitle(temp, 80, catfile) < 1)
         break;
      sscanf(temp, "%d", &mesgnum);
      catalog[mesgnum] = (char *)calloc(strlen(temp) + 2, sizeof(char));
      if (mesgnum < 10)
         start = 2;
      else if (mesgnum < 100)
         start = 3;
      else
         start = 4;
      strcpy(catalog[mesgnum], temp + start);
      }
#endif
}
/* Function to close the catalog
 */
void exitcat( void )
{
#if defined(M_UNIX)
   catclose(catalog);
#endif
}
