/*
 * nonpen.C for WindowBoss
 * Functions to get noncovered pension info
 */

#ifndef lint
static char *nonpenID = " nonpen.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "winboss1.h"
#include "wnutils.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "piain.h"
#include "mesgcat.h"

/* Function to get noncovered pension information
 */
int nonpen(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   static char pubpenst[10];  /* pubpen as a string */
   WIFORM frm;  /* form pointer */
   int rv;  /* return value */

   begscrn(" Noncovered pension ");
   frm = wn_frmopn(2);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(226));
      done(1); }
   sprintf(pubpenst, "%8.2f", workerdata -> pubpen);
   wn_gfloat(SET,frm,0,wn,3,23,
      "Amount of monthly noncovered pension > ",COLOR_PAIR(2),' ',
      &(workerdata -> pubpen), 8, 2, 0.0, workerdata -> maxearn, pubpenst,
      "%noncovered pension%", catstr(22));
   if ((rv = wn_frmget(frm)) == ESC_CODE) {
      wn_frmcls(frm);
      return(rv); }
   wn_frmcls(frm);
   return(rv);
}
