/*
 * oldawbi.C for WindowBoss
 * Function to review or change the historical amounts
 */

#ifndef lint
static char *oldataID = " oldawbi.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "pia.h"
#include "wnutils.h"
#include "piain.h"
#include "oldawbi.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int  introold ( WINDOW *wn, PIAPARMS *piaparms );
static int  getosav  ( WINDOW * );
static int  ofq      ( WINDOW *, PIAPARMS * );
static int  obase    ( WINDOW *wn, PIAPARMS *piaparms );
static int  obasehi  ( WINDOW *wn, PIAPARMS *piaparms );
static int  obase77  ( WINDOW *, PIAPARMS * );
static int  obi      ( WINDOW *, PIAPARMS * );
static int  assupdat ( WINDOW *, PIAPARMS * );
static int  titlechk ( WINDOW *, PIAPARMS * );
#else
static int  introold();
static int  getosav();
static int  ofq();
static int  obase();
static int  obasehi();
static int  obase77();
static int  obi();
static int  assupdat();
static int  titlechk();
#endif

static struct pmenu revmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
  (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   1, 2, {
   { 1, 2, "  Enter choice (ESC to exit)", 0 },
   { 2, 2, "Review", 1 },
   { 3, 2, "Update", 2 },
   { 99, 99, "", 99 } }
   };

int selecto = 0;  /* form selection */

/* Function to review or update historical amounts
 */
oldawbi(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   int rv = 0;  /* return value */

   begscrn(" Historical Amounts ");
   selecto = wn_popup(0,3,5,35,5,COLOR_PAIR(4),COLOR_PAIR(9),
      &revmenu,TRUE);
   if (selecto < 1 || selecto > 2)
      return(0);
   /* print warning message if update chosen */
   if (selecto == 2)
      if (introold(wn, piaparms) == FALSE)
         return(0);
   if ((rv = ofq(wn, piaparms)) == ESC_CODE)
      return(rv);
   if ((rv = obase(wn,piaparms)) == ESC_CODE)
      return(rv);
   if ((rv = obasehi(wn,piaparms)) == ESC_CODE)
      return(rv);
   if ((rv = obase77(wn,piaparms)) == ESC_CODE)
      return(rv);
   if ((rv = obi(wn, piaparms)) == ESC_CODE)
      return(rv);
   if (selecto == 2) {
      begscrn("    Save to Disk    ");
      wattrset(wn, COLOR_PAIR(6));
      /* save results */
      if (getosav(wn))
         {
         piaparms -> istart++;
         rv = saveawbi(piaparms);
         piaparms -> istart--;
         if (rv > 0) {
            wn_iemsg(catstr(rv));
            return(rv); }
         rv = assupdat(wn,piaparms);
         }
      }
   clr_stat();
   return(rv);
}
/* Function to print warning and get continuation response
 */
static int introold(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   static char mesg1[] =
      "If you continue, you will need the average wage for xxxx, the wage base";
   static char mesg2[] =
      "(and old-law wage base) for xxxx, and the benefit increase for Dec xxxx.";
   char temp[5];  /* temporary string */
   int value;  /* 0 = false, 1 = true */
   static char ans[3];  /* answer */

   sprintf(temp, "%4d", piaparms -> istart - 1);
   strncpy(mesg1+52,temp,4);
   sprintf(temp, "%4d", piaparms -> istart + 1);
   strncpy(mesg2+28,temp,4);
   sprintf(temp, "%4d", piaparms -> istart);
   strncpy(mesg2+67,temp,4);
   begscrn("      Warning!      ");
   wattrset(wn, COLOR_PAIR(4));
   wn_dtext(XEQ, NFRM, NFLD, wn, 5, 3,
   "You are about to update the historical amounts necessary to compute Social");
   wn_dtext(XEQ, NFRM, NFLD, wn, 6, 3,
      "Security benefits.  This should be done once a year, around November 1,");
   wn_dtext(XEQ, NFRM, NFLD, wn, 7, 3,
      "when the new amounts are announced.");
   wn_dtext(XEQ, NFRM, NFLD, wn, 9, 3, mesg1);
   wn_dtext(XEQ, NFRM, NFLD, wn, 10, 3, mesg2);
   wn_dtext(XEQ, NFRM, NFLD, wn, 12, 3,
      "All four sets of projected average wages and benefit increases will be");
   wn_dtext(XEQ, NFRM, NFLD, wn, 13, 3,
      "automatically updated once you have updated the historical amounts.");
   wattrset(wn, COLOR_PAIR(6));
   wn_gbool(XEQ, NFRM, NFLD, wn, 15, 3,
      "Do you want to continue? (Y or N) > ", COLOR_PAIR(2), ' ',
      &value, ans, (char *)0, catstr(258));
   return(value);
}
/* Function to get answer to save-to-disk prompt
 */
static int getosav(
WINDOW *wn)  /* window to use */
{
   static char ans[3];  /* answer to prompt */
   int value;  /* 0 = false, 1 = true */

   wn_gbool(XEQ, NFRM, NFLD, wn, 5, 3,
      "Do you want to save the updated values to disk? (Y or N) > ",
      COLOR_PAIR(2), ' ', &value, ans, "%awbi Y or N%", catstr(258));
   return(value);
}
/* Function to review or update average wage series
 */
static int ofq(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   static char mesg[] = "   Average wages    ";  /* temporary string */
   int rv;  /* return value */

   setnoch(piaparms, piaparms -> istart - 1);
   if (selecto == 2)
      rv = earnr(wn, 1937, piaparms -> istart - 1, piaparms -> fq,
         piaparms -> maxearn, piaparms -> no_change, mesg,
         "%new average wage%");
   else
      rv = earnr(wn, 1937, piaparms -> istart - 2, piaparms -> fq,
         piaparms -> maxearn, piaparms -> no_change, mesg, NSTR);
   return(rv);
}
/* Function to review or update OASDI wage base series
 */
static int obase(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   static char mesg[] = "  OASDI wage bases  ";  /* temporary string */
   int rv;  /* return value */

   setnoch(piaparms, piaparms -> istart + 1);
   if (selecto == 2)
      rv = earnr(wn, 1937, piaparms -> istart + 1, piaparms -> base,
         piaparms -> maxearn, piaparms -> no_change, mesg,
         "%new OASDI wage base%");
   else
      rv = earnr(wn, 1937, piaparms -> istart, piaparms -> base,
         piaparms -> maxearn, piaparms -> no_change, mesg, NSTR);
   return(rv);
}
/* Function to review or update HI wage base series
 */
static int obasehi(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   static char mesg[] = "    HI wage bases   ";  /* temporary string */
   int rv;  /* return value */

   setnoch(piaparms, piaparms -> istart + 1);
   if (selecto == 2)
      rv = earnr(wn, 1937, piaparms -> istart + 1, piaparms -> basehi,
         piaparms -> maxearn, piaparms -> no_change, mesg,
         "%new HI wage base%");
   else
      rv = earnr(wn, 1937, piaparms -> istart, piaparms -> basehi,
         piaparms -> maxearn, piaparms -> no_change, mesg, NSTR);
   return(rv);
}
/* Function to review or update old-law wage base series
 */
static int obase77(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   static char mesg[] = " Old-law wage bases ";  /* temporary string */
   int rv;  /* return value */

   setnoch(piaparms, piaparms -> istart + 1);
   if (selecto == 2)
      rv = earnr(wn, 1937, piaparms -> istart + 1, piaparms -> base77,
         piaparms -> maxearn, piaparms -> no_change, mesg,
         "%new old-law wage base%");
   else
      rv = earnr(wn, 1937, piaparms -> istart, piaparms -> base77,
         piaparms -> maxearn, piaparms -> no_change, mesg, NSTR);
   return(rv);
}
/* Function to review or update benefit increase series
 */
static int obi(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   int rv;  /* return value */

   if (selecto == 2)
      rv = benincr(wn, piaparms -> cpiinc, 1951, piaparms -> istart, 1,
         "%new benefit increase%");
   else
      rv = benincr(wn, piaparms -> cpiinc, 1951, piaparms -> istart - 1, 0,
         NSTR);
   return(rv);
}
/* Function to update assumptions
 */
static int assupdat(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   int i3;  /* loop counter */
   char temp[5];  /* temporary string */
   int rv;  /* return value */
   char *mesg;  /* temporary title */

   mesg = (char *)calloc((unsigned)piaparms -> maxchr, sizeof(char));
   begscrn(" Update Assumptions ");
   for (i3 = 1; i3 < 5; i3++)
      {
      /* get stored assumptions */
      if ((rv = benmen(piaparms, i3)) > 0)
         return(rv);
      if ((rv = avgmen(piaparms, i3)) > 0)
         return(rv);
      /* update to next year */
      piaparms -> istart++;
      /* store benefit increases */
      status(catstr(294));
      if ((rv = savebi(piaparms, i3)) > 0) {
         piaparms -> istart--;
         return(rv);
         }
      /* store average wage increases */
      status(catstr(295));
      rv = saveaw(piaparms, i3);
      /* backdate to current year */
      piaparms -> istart--;
      if (rv > 0)
         return(rv);
      clr_stat();
      /* set new title */
      if (strlen(getavgwage(i3)) < 45) {
         strcpy(mesg, getavgwage(i3));
         strcat(mesg, ", updated Nov 1, ");
         sprintf(temp, "%d", piaparms -> istart);
         strcat(mesg, temp);
         setavgwage(i3, mesg);
         setbeninc(i3, mesg);
         }
      }
   /* check titles */
   rv = titlechk(wn,piaparms);
   /* store titles of assumptions */
   piaparms -> istart++;
   rv = savetitl(piaparms);
   piaparms -> istart--;
   return(rv);
}
/* Function to check titles
 */
static int titlechk(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   WIFORM frm;  /* form pointer */
   char mesg[4][10];  /* prompts */
   int rv;  /* return value */
   int i3;  /* loop counter */
   char *titlest[3];  /* temporary titles */

   for (i3 = 0; i3 < 3; i3++) {
      titlest[i3] = (char *)calloc((unsigned)piaparms -> maxchr,
         sizeof(char));
      strcpy(titlest[i3], getavgwage(i3 + 1));
      }
   frm = wn_frmopn(6);
   if (!frm) {
      wn_iemsg(catstr(227));
      done(1); }
   wn_dtext(SET, frm, 0, wn, 4, 3, "New titles of assumptions:");
   for (i3 = 0; i3 < 3; i3++) {
      sprintf(mesg[i3], "Set %d > ", i3+1);
      wn_gtext(SET, frm, i3+1, wn, i3+5, 3, mesg[i3], COLOR_PAIR(2), ' ',
         piaparms -> maxchr - 2, titlest[i3], "%awbi titles%", NSTR);
      }
   wattrset(wn, COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
   /* prepare titles */
   for (i3 = 0; i3 < 3; i3++) {
      wn_sdelspc(titlest[i3], 3);
      setavgwage(i3 + 1, titlest[i3]);
      setbeninc(i3 + 1, titlest[i3]);
      }
   return(rv);
}
