/*
 * @(#)oldpia.C	1.33   3/14/94
 * Various functions to compute old-law PIAs
 */

#ifndef lint
static char *oldpiaID = " @(#)oldpia.C	1.33   3/14/94 ";
#endif

#include <math.h> 
#ifdef BSD
#define fmod(x,y) (y) * ((x/y) - floor(x/y))
#endif
#include "wrkrdata.h"
#include "compdate.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "piacal.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void  pl1973  ( WORKERDATA *, PIAPARMS *, double *, double *, int );
static int   pl1971  ( WORKERDATA *, PIAPARMS *, double *, double *, int *,
                int );
static int   pl1969  ( WORKERDATA *, PIAPARMS *, double *, double *, int *,
                int );
static int   pl1967  ( WORKERDATA *, PIAPARMS *, double *, double *, int *,
                int );
static int   pl1965  ( WORKERDATA *, PIAPARMS *, double *, double *, int *,
                int );
static int   pl1958  ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   double *piasub, double *mfbsub, int *iamemax, int amesub);
static int   pl1954  ( double *, double *, int );
static int   pl1952  ( double *, double *, int );
#else
static void  pl1973();
static int   pl1971();
static int   pl1969();
static int   pl1967();
static int   pl1965();
static int   pl1958();
static int   pl1954();
static int   pl1952();
#endif

/* Function to select correct PIA table function
 */
oldpia(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   int iamemax; /* maximum AME in PIA interval */

   if (compmdy(workerdata -> bendate, piaparms -> amend52) < 0)
      return(-1);
   if (compmdy(workerdata -> bendate, piaparms -> amend54) < 0)
      return(pl1952(&piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method], (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend58) < 0)
      return(pl1954(&piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method], (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend651) < 0)
      return(pl1958(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         &iamemax, (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend672) < 0)
      return(pl1965(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         &iamemax, (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend69) < 0)
      return(pl1967(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         &iamemax, (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend70) < 0)
      return(pl1969(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         &iamemax, (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend721) < 0)
      return(pl1971(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         &iamemax, (int)piadata -> ame[(int)method]));
   if (compmdy(workerdata -> bendate, piaparms -> amend742) < 0)
      return(pl1972(workerdata, piaparms, &piadata -> piaent[(int)method],
         &piadata -> mfbent[(int)method],
         (int)piadata -> ame[(int)method]));
   return(-1);
}
/* Function to apply CPI and wage base increases to 1973 Act PIA Table
 */
cpibas(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int i22,  /* year for which PIA table is desired, minus 1950 (result
            includes benefit increases thru December of year 1950+i22) */
int freeze,  /* 1 for transitional guarantee or 1977 old-start calculation
            with 1979 or later eligibility, 0 otherwise */
enum pia_type method, /* method number */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
double amesub)  /* AME in this subroutine */
{
   int i1; /* temporary AME */
   int i2; /* temporary index */
   double mfbt; /* temporary MFB */
   int i21; /* year benefit increases are first applied minus 1950 */
   int i24 = 0; /* year that AME is first included in PIA table as of
      January, minus 1950, if AME is greater than $1100 (otherwise 0) */
   long i28; /* last AME in prior table */
   long i29; /* last AME in extended table */

   i1 = (int)(amesub + .1);
   if (i1 > 1100)
      {
      for (i2 = 25; i2 <= i22; i2++) {
         if (i1 <= (int)(piaparms -> base[i2+13]/12.)) {
            i24 = i2;
            break; }
         }
      /* find last PIA in June 1974 PIA Table */
      pl1973(workerdata,piaparms,piasub,mfbsub,1100);
      if (i24 > 25)
         { /* extend table and apply increases up to year prior to when
            * AME is first included */
         for (i2 = 25; i2 < i24; i2++)
            {
            /* extension amount depends on two successive wage bases;
             * check to see if wage bases are exact multiples of $60
             * ($22,900 in 1979 and $25,900 in 1980 are not) */
            i28 = (fmod(piaparms -> base[i2+12], 60.) > .5) ?
               ((long)piaparms -> base[i2+12]/60 + 1)*5 :
               (long)(piaparms -> base[i2+12]/12.);
            i29 = (fmod(piaparms -> base[i2+13], 60.) > .5) ?
               ((long)piaparms -> base[i2+13]/60 + 1)*5 :
               (long)(piaparms -> base[i2+13]/12.);
            *piasub += .2*(double)(i29-i28);
            *mfbsub = round(1.75*(*piasub),i2+1949);
            /* apply benefit increase */
            *piasub *= 1. + piaparms -> cpiinc[i2-1]/100.;
            *piasub = round(*piasub,i2+1950);
            *mfbsub *= 1. + piaparms -> cpiinc[i2-1]/100.;
            *mfbsub = round(*mfbsub,i2+1950);
            /* check to see that MFB is at least 150% of PIA */
            mfbt = round(1.5*(*piasub),i2+1950);
            if (*mfbsub < mfbt)
               *mfbsub = mfbt;
            /* after applying June 1978 increase, set transitional
             * guarantee or 1977 old-start (1979 or later eligibility)
             * PIA at eligibility */
            if (i2 == 28 && freeze > 0)
               piadata -> piael[(int)method][0] = *piasub;
            /* apply catch-up increase to PIA and MFB */
            *piasub = bicchp(piaparms, i2, *piasub, piadata -> icchup);
            *mfbsub = bicchp(piaparms, i2, *piasub, piadata -> icchup);
            /* check to see that MFB is at least 150% of PIA */
            mfbt = round(1.5*(*piasub),i2+1950);
            if (*mfbsub < mfbt)
               *mfbsub = mfbt;
            } /* end for */
         } /* end if i24 > 25 */
      /* apply extension in year AME is first included in table */
      *piasub += (double)((i1 - (long)piaparms -> base[i24+12]/12 + 4)/5);
      *mfbsub = round(1.75*(*piasub),i24+1950);
      /* set year benefit increases are first applied minus 1950 */
      i21 = i24;
      } /* end if i1 > 1000 */
   else
      { /* use downward-extended PIA table if transitional guarantee or
         * 1977 old-start in 1982 or later */
      if (piadata -> ielgyr[1] < 1982 || freeze == 0 || i1 > 75) {
         pl1973(workerdata,piaparms,piasub,mfbsub,i1);
         piadata -> piael[(int)method][0] = *piasub;
         piadata -> mfbel[(int)method][0] = *mfbsub;
         /* set year benefit increases are first applied minus 1950 */
         i21 = 25;
         }
      else {
         /* calculate downward-extended PIA table values as of Dec 1978 */
         *piasub = round((double)(i1)*121.8/76.,1978);
         piadata -> piael[(int)method][0] = *piasub;
         *mfbsub = round(1.5*(*piasub),1978);
         piadata -> mfbel[(int)method][0] = *mfbsub;
         /* do not apply any benefit increases to extended minimum */
         return(8);
         }
      }
#ifdef LAWCHG
   if ((double)lawchgdata -> z4 > 0.) {
      *piasub *= 1. - .01 * lawchgdata -> z4;
      *piasub = round(*piasub,i24-1);
      *mfbsub *= 1. - .01 * lawchgdata -> z4;
      *mfbsub = round(*mfbsub,i24-1);
      }
#endif
   /* apply benefit increases to PIA table */
   for (i2 = i21; i2 <= i22; i2++) {
      *piasub *= 1. + piaparms -> cpiinc[i2-1]/100.;
      *piasub = round(*piasub,i2+1950);
      *mfbsub *= 1. + piaparms -> cpiinc[i2-1]/100.;
      *mfbsub = round(*mfbsub,i2+1950);
      /* check to see that MFB is at least 150% of PIA */
      mfbt = round(1.5*(*piasub),i2+1950);
      if (*mfbsub < mfbt)
         *mfbsub = mfbt;
      /* after applying June 1978 increase, set transitional
       * guarantee or 1977 old-start (1979 or later eligibility)
       * PIA at eligibility */
      if (i2 == 28 && freeze > 0)
         piadata -> piael[(int)method][0] = *piasub;
      /* apply catch-up increase to PIA and MFB */
      *piasub = bicchp(piaparms, i2, *piasub, piadata -> icchup);
      *mfbsub = bicchp(piaparms, i2, *mfbsub, piadata -> icchup);
      /* check to see that MFB is at least 150% of PIA */
      mfbt = round(1.5*(*piasub),i2+1950);
      if (*mfbsub < mfbt)
         *mfbsub = mfbt;
      } /* end for */
   return(8);
}
/* Function to calculate PIAs under 1973 Act
 */
static void pl1973(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int amesub)  /* AME in this subroutine */
{
   double mfb73; /* temporary MFB */

   /* see if AME is in extension of table above $1000 */
   if (amesub < 1001) {
      /* if under $1000 AME, first get 1972 Act value */
      (void) pl1972(workerdata,piaparms,piasub,mfbsub,amesub);
      /* increase by 11% */
      *piasub *= 1. + piaparms -> cpiinc[23]/100.;
      *piasub = round(*piasub,1974);
      *mfbsub *= 1. + piaparms -> cpiinc[23]/100.;
      *mfbsub = round(*mfbsub,1974);
      /* MFB must be at least 1.5 times PIA */
      mfb73 = round(1.5*(*piasub),1974);
      if (*mfbsub < mfb73)
         *mfbsub = mfb73;
      }
   else {
      /* if AME over $1000, extend beyond $1000 in $5 intervals */
      *piasub = (double)((amesub+4)/5) + 249.;
      *mfbsub = round(1.75*(*piasub),1974); }
}
/* Function to calculate PIAs under 1972 Act, effective Sept 1972
 */
pl1972(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int amesub)  /* AME in this subroutine */
{
   int iamemax; /* maximum AME in PIA interval */
   double mfb72; /* temporary MFB */

   /* see if AME is in extension of table above $750 */
   if (amesub < 751) {
      /* if under $750 AME, first get 1971 Act value */
      (void) pl1971(workerdata,piaparms,piasub,mfbsub,&iamemax,amesub);
      /* increase by 20% */
      *piasub *= 1. + piaparms -> cpiinc[21]/100.;
      *piasub = round(*piasub,1972);
      *mfbsub *= 1. + piaparms -> cpiinc[21]/100.;
      *mfbsub = round(*mfbsub,1972);
      /* MFB must be at least 1.5 times PIA */
      mfb72 = round(1.5*(*piasub),1972);
      if (*mfbsub < mfb72)
         *mfbsub = mfb72;
      }
   else {
      /* if AME over $750, extent beyond $750 in $5 intervals */
      *piasub = (double)((amesub+4)/5) + 204.5;
      /* MFB is 175% of PIA in extension */
      *mfbsub = round(1.75*(*piasub),1972);
      }
   /* check to see if temporary 7% increase applies (Mar-May 1974) */
   if (compmdy(workerdata -> bendate, piaparms -> amend741) >= 0 &&
      compmdy(workerdata -> bendate, piaparms -> amend742) < 0) {
      *piasub *= 1.07;
      *piasub = round(*piasub,1974);
      *mfbsub *= 1.07;
      *mfbsub = round(*mfbsub,1974);
      }
   return(7);
}
/* Function to calculate PIAs under 1971 Act
 */
static int pl1971(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int *iamemax,  /* maximum AME in PIA interval */
int amesub)  /* AME in this subroutine */
{
   double mfb71; /* temporary MFB */

   if (amesub < 652) {
      /* if under $652, first get 1969 Act value */
      (void) pl1969(workerdata,piaparms,piasub,mfbsub,iamemax,amesub);
      /* increase by 10% */
      *piasub *= 1. + piaparms -> cpiinc[20]/100.;
      *piasub = round(*piasub,1971); }
   else {
      /* extend beyond $651, using 20% extension starting at $657 */
      if (amesub > 656)
         *piasub = (double)((amesub+4)/5) + 145.4;
      /* from $652 to $656, use ad hoc values smoothing to 20% extension */
      if (amesub < 657 && amesub > 652)
         *piasub = 276.6;
      if (amesub == 652)
         *piasub = 275.8;
      }
   /* calculate MFB */
   if (amesub < 628) {
      /* for AME up to $436, MFB is 88% of AME */
      if (amesub < 437)
         *mfbsub = .88*(double)(*iamemax);
      /* for AME from $437 to $627, MFB increases at 44% of AME */
      if (amesub > 436)
         *mfbsub = 383.68 + .44*(double)(*iamemax-436);
      *mfbsub = round(*mfbsub,1971);
      mfb71 = round(1.5*(*piasub),1971);
      if (amesub < 240 || *mfbsub < mfb71)
         *mfbsub = mfb71;
      }
   else
      *mfbsub = round(1.75*(*piasub),1971);
   return(6);
}
/* Function to calculate PIAs under 1969 Act
 */
static int pl1969(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int *iamemax,  /* maximum AME in PIA interval */
int amesub)  /* AME in this subroutine */
{
   /* there is no extension of table, so get 1967 Act value */
   (void) pl1967(workerdata,piaparms,piasub,mfbsub,iamemax,amesub);
   /* increase by 15% */
   *piasub *= 1. + piaparms -> cpiinc[19]/100.;
   *piasub = round(*piasub,1970);
   /* minimum PIA of $64 */
   if (*piasub < 64.)
      *piasub = 64.;
   /* MFB does not change from 1967 Act for AME over $239 */
   if ((double)amesub < 239.5)
      /* below $240, MFB is 1.5 times PIA */
      *mfbsub = round(1.5*(*piasub),1970);
   return(5);
}
/* Function to calculate PIAs under 1967 Act
 */
static int pl1967(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int *iamemax,  /* maximum AME in PIA interval */
int amesub)  /* AME in this subroutine */
{
   double pia67; /* test PIA in MFB calculation */

   /* test to see if AME is in extension of table above $550 (treat
    * $551 to $553 as being in table before extension, since correct
    * value results) */
   if ((*iamemax = amesub) < 554) {
      /* if under $554, first get 1965 Act value */
      (void) pl1965(workerdata,piaparms,piasub,mfbsub,iamemax,amesub);
      /* increase by 13% */
      *piasub *= 1. + piaparms -> cpiinc[17]/100.;
      *piasub = round(*piasub,1968);
      /* minimum PIA of $55 */
      if (*piasub < 55.)
         *piasub = 55.;
      }
   else {
      /* extend table beyond $553 at 28.43% */
      *piasub = floor(189.598 + .2843*(amesub-550) +.5);
      do {
         /* find the highest AME giving that same PIA */
         pia67 = floor(189.598 + .2843*(double)(++(*iamemax)-550) + .5);
         } while (fabs(pia67 - *piasub) < .1);
      (*iamemax)--;
      }
   /* find MFB for AME up to $370 */
   if (amesub < 371) {
      /* for AME from $179 to $370, MFB is same as in 1965 Act */
      if (amesub < 179)
         *mfbsub = round(1.5*(*piasub),1968);
      return(4); }
   /* for AME above $436, MFB is $348.80 plus 40% of AME above $436 */
   if (amesub > 436) {
      *mfbsub = 348.8 + .4*(double)(*iamemax - 436);
      /* MFB is maximum of $434.40 */
      if (*mfbsub > 434.4)
         *mfbsub = 434.4; }
   else
      /* for AME from $371 to $436, MFB is 80% of AME */
      *mfbsub = .8*(double)(*iamemax);
   return(4);
}
/* Function to calculate PIAs under 1965 Act
 */
static int pl1965(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int *iamemax,  /* maximum AME in PIA interval */
int amesub)  /* AME in this subroutine */
{
   /* start with 1958 Act, even for values above the original maximum
    * AMW of $400 in the 1958 Act */
   (void) pl1958(workerdata,piaparms,piasub,mfbsub,iamemax,amesub);
   /* for AME up to $94, increase PIA by $4 */
   if (amesub < 95) {
      *piasub += 4.;
      /* minimum PIA of $44 */
      if (*piasub < 44.)
         *piasub = 44.;
      /* MFB of 150% of PIA */
      *mfbsub = 1.5*(*piasub);
      return(3); }
   /* for AME from $95 to $403, increase PIA by 7% (include $401 to $403
    * as if from 1958 Act) */
   if (amesub < 404) {
      *piasub *= 1. + piaparms -> cpiinc[14]/100.;
      *piasub = round(*piasub,1965); }
   /* for AME above $403, increase PIA by $9 to match increase at $403
    * (7% of $127.00 is $8.89), rounded to a dollar */
   else
      *piasub += 9.;
   /* find MFB for AME up to $314 */
   if (amesub < 315) {
      /* for AME from $142 to $314, MFB is same as in 1958 Act */
      if (amesub < 142)
         *mfbsub = round(1.5*(*piasub),1965);
      return(3); }
   /* for AME above $370, MFB is $296 plus 40% of AME above $370 */
   if (amesub > 370) {
      *mfbsub = 296. + .4*(double)(*iamemax - 370);
      /* MFB is maximum of $368.00 */
      if (*mfbsub > 368.)
         *mfbsub = 368.; }
   else
      /* for AME from $315 to $370, MFB is 80% of AME */
      *mfbsub = .8*(double)(*iamemax);
   return(3);
}
/* Function to calculate PIAs under 1958 Act
 */
static int pl1958(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int *iamemax,  /* maximum AME in this PIA interval */
int amesub)  /* AME in this subroutine */
{
   double pia58; /* test PIA in MFB calculation */
   double round58; /* temporary value */

   if (amesub <= 84)
      /* Up to $84, 1958 Act increased PIAs by $3, rounded up to even
         dollar */
      *piasub = 3.49 + .55*(double)amesub;
   else {
      /* Over $84, 1958 Act increased PIAs by 7% (.5885 equals 1.07 times
         the .55 in 1954 Act */
      round58 = (amesub > 110) ? 110. : (double)amesub;
      *piasub = .5885*round58;
      round58 = (amesub > 110) ? (double)(amesub-110) : 0.;
      *piasub += .214*round58; }
   /* round to whole dollar */
   *piasub = floor(*piasub+.5);
   /* minimum PIA of $33 */
   if (*piasub < 33.)
      *piasub = 33.;
   /* PIA for AME of $553 was made ad hoc in 1967 Act */
   if (amesub == 553)
      *piasub = 159.;
   /* minimum PIA increased as of August 1961 to $40 */
   if (compmdy(workerdata -> bendate, piaparms -> amend61) >= 0 &&
      *piasub < 40.)
      *piasub = 40.;
   /* calculate maximum family benefit */
   if ((*iamemax = amesub) > 127)
      {
      do {
         /* find the highest AME giving that same PIA */
         pia58 = floor(41.195 + .214*(double)(++(*iamemax))+.5);
      } while (fabs(pia58 - *piasub) < .1);
      if (*iamemax != 553)
         (*iamemax)--;
      *mfbsub = .8*(double)(*iamemax);
      if (*mfbsub > 254.)
         *mfbsub = 254.;
      }
   else
      /* for AME up to $127, MFB is 150% of PIA, but at least a $20
       * increase */
      *mfbsub = (1.5*(*piasub) > (*piasub) + 20.) ? 1.5*(*piasub) :
         (*piasub) + 20.;
   return(2);
}
/* Function to calculate PIAs under 1954 Act
 */
static int pl1954(
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int amesub)  /* AME in this subroutine */
{
   int i1; /* test AMW */

   /* PIA is 55% of first $110 of AMW plus 20% of excess */
   i1 = (amesub > 110) ? 110 : amesub;
   *piasub = .55*(double)i1;
   i1 = (amesub > 110) ? amesub - 110 : 0;
   *piasub += .2*(double)i1;
   *piasub = round(*piasub,1954);
   /* minimum PIA of $30 */
   if (*piasub < 30.)
      *piasub = 30.;
   *mfbsub = (.8*(double)amesub > 50.) ?
      .8*(double)amesub : 50.;
   if (*mfbsub < 1.5*(*piasub))
      *mfbsub = 1.5*(*piasub);
   if (*mfbsub > 200.)
      *mfbsub = 200.;
   return(1);
}
/* Function to calculate PIAs under 1952 Act
 */
static int pl1952(
double *piasub,  /* PIA in this subroutine */
double *mfbsub,  /* MFB in this subroutine */
int amesub)  /* AME in this subroutine */
{
   int i1; /* test AMW */

   /* PIA is 55% of first $100 of AMW plus 15% of excess */
   i1 = (amesub > 100) ? 100 : amesub;
   *piasub = .55*(double)i1;
   i1 = (amesub > 100) ? amesub - 100 : 0;
   *piasub += .15*(double)i1;
   *piasub = round(*piasub,1952);
   /* minimum PIA of $25 */
   if (*piasub < 25.)
      *piasub = 25.;
   *mfbsub = (.8*(double)amesub > 45.) ?
      .8*(double)amesub : 45.;
   if (*mfbsub > 168.75)
      *mfbsub = 168.75;
   return(0);
}
