/*
 * @(#)one_page.C	1.43   3/10/94
 * Function to write out one-page summary of results
 */

#ifndef lint
static char *one_pgID = " @(#)one_page.C	1.43   3/10/94 ";
#endif

#include <stdio.h>
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "comma.h"
#include "utils.h"
#include "taxes.h"
#include "piaout.h"
#include "prtutils.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void pr_earn  ( FILE *out, PIADATA *piadata, int firstyr,
   int lastyr, int tier );
#else
static void pr_earn();
#endif

/* Function to print 1-page summary
 */
void one_page(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   char asterisk;  /* asterisk or blank */
   int firstyr;  /* index of first year to print out */
   register i1;  /* loop counter */
   int lastyr;  /* index of last year to print out */

   switch (workerdata -> ioasdi)
   {
   case OLD_AGE:
      fprintf(out, "%sR E T I R E M E N T   E S T I M A T E",
         stringd(25,' '));
      break;
   case SURVIVOR:
      fprintf(out, "%sS U R V I V O R   E S T I M A T E", stringd(27,' '));
      break;
   case DISABILITY:
      fprintf(out, "%sD I S A B I L I T Y   E S T I M A T E",
         stringd(25,' '));
      break;
   case PEBS_CALC:
      return;
   }
   fprintf(out, "\n\n\n%s%s\n", stringd(54,' '), piadata -> dateln);
   prtnmssn(out,workerdata,15);
   fprintf(out, "%sDate of birth:  %s\n", stringd(15,' '),
      date(workerdata -> ibirth));
   if (workerdata -> ioasdi == SURVIVOR)
      fprintf(out, "%sDate of death:  %s %d\n", stringd(15,' '),
         month(workerdata -> ideath[0] - 1), workerdata -> ideath[2]);
   if (workerdata -> ioasdi == DISABILITY)
      fprintf(out, "%sDate of onset:  %s\n", stringd(15,' '),
         date(workerdata -> ionset));
   fprintf(out, "\n\n%sR E G U L A R   E A R N I N G S\n\n\n",
      stringd(28,' '));
   if (piadata -> stot[0] > 0.0) {
      fprintf(out, "     50 %10s\n", pdouble(piadata -> stot[0], 10, 2));
      firstyr = 14; }
   else
      firstyr = (workerdata -> ibegin > 1950) ?
         5*((workerdata -> ibegin - 1951)/5) + 14 : 14;
   lastyr = 5*((workerdata -> iend - 1951)/5) + 18;
   pr_earn(out, piadata, firstyr, lastyr, 0);
   if (piadata -> iapp[(int)PIA_TABLE] || piadata -> iapp[(int)TRANS_GUAR]) {
      fprintf(out, "\n     Dividend:  ");
      if (piadata -> iapp[(int)PIA_TABLE])
         fprintf(out, "%10s", pdouble(piadata -> ftearn[(int)PIA_TABLE],10,2));
      else
         fprintf(out, "%10s", pdouble(piadata -> ftearn[(int)TRANS_GUAR],10,2));
      fprintf(out, "%sDivisor months: %d\n", stringd(34,' '),
         12 * piadata -> n);
      }
   fprintf(out, "\n\n%sI N D E X E D   E A R N I N G S\n\n\n",
      stringd(28,' '));
   pr_earn(out, piadata, firstyr, lastyr, 1);
   fprintf(out, "\n     Dividend:  %13s%sDivisor months: %d\n",
      pdouble(piadata -> ftearn[(int)WAGE_IND],10,2), stringd(30,' '),
         12 * piadata -> n);
   fprintf(out, "\n     Eff.%s", stringd(25,' '));
   if (piadata -> arf >= 1.0)
      fprintf(out, "Increment");
   else
      fprintf(out, "Reduction");
   fprintf(out, "%sFamily\n", stringd(14,' '));
   fprintf(out, "     date      AIME      PIA       factor      MBA");
   fprintf(out, "      maximum\n");
   fprintf(out, "     -----    ------    ------    ---------   ------");
   fprintf(out, "    -------\n");
   fprintf(out, "     %2d/", workerdata -> bendate[0]);
   firstyr = workerdata -> bendate[2] - 100*(workerdata -> bendate[2]/100);
   if (firstyr > 9)
      fprintf(out, "%2d", firstyr);
   else
      fprintf(out, "0%d", firstyr);
   fprintf(out, "   %6d   %8.2lf     %7.5lf  %8.2lf",
      (int)(piadata -> ame[(int)WAGE_IND]+.1),
      piadata -> piaent[(int)WAGE_IND],
      piadata -> arf, piadata -> benfit[0]);
   asterisk = (piadata -> iappn == (int)WAGE_IND) ? ' ' : '*';
   fprintf(out, "%c  %8.2lf%c\n\n", asterisk,
      piadata -> mfbent[piadata -> iappn], asterisk);
   /* print footnotes */
   if (asterisk == '*')
      fprintf(out, "      *Based on %s\n", piadata -> title[piadata -> iappn]);
   for (i1 = 0; i1 < MAXCAL; i1++)
      {
      if ((i1 != (int)WAGE_IND) && piadata -> iapp[i1]) {
         fprintf(out, "       %s PIA: %7.2lf\n", piadata -> title[i1],
            piadata -> piaent[i1]);
         if (i1 == (int)SPEC_MIN)
            fprintf(out, "       Years of coverage = %d\n",
               piadata -> ispmnt[0]);
         }
      }
   /* print windfall message */
   if (piadata -> iwind)
      {
      if (piadata -> iwind < 0)
         fprintf(out, "       WEP considered, but not applied\n");
      else
         fprintf(out, "       WEP applied\n");
      }
   /* print uninsured message */
   nonins(out, workerdata, piadata, 5);
   /* print disability insured message */
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,8);
   FORMFEED;
}
/* Function to print out table of earnings
 */
static void pr_earn(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
int firstyr,  /* index of first year to print out */
int lastyr,  /* index of last year to print out */
int tier)  /* tier of table to print (0 for actual earnings, 1 for
            * indexed earnings) */
{
   register i1,i2;  /* loop counters */
   int i3;  /* temporary index */
   int lines;  /* number of lines in table */
   int year;  /* year (2 digits) */

   lines = (lastyr-firstyr+1)/5;
   for (i1 = firstyr; i1 < firstyr+lines; i1++) {
      fprintf(out, "   ");
      for (i2 = 0; i2 < 5; i2++) {
         i3 = i1 + i2*lines;
         year = i3 + 37;
         if (year > 99)
            year -= 100;
         if (year > 9)
            fprintf(out, "  %d", year);
         else
            fprintf(out, "  0%d", year);
         if (tier == 0)
            fprintf(out, " %10s", pdouble(piadata -> earnst[2][i3], 10, 2));
         else
            fprintf(out, " %10s",
               pdouble(piadata -> vearn[(int)WAGE_IND][i3-14], 10, 2));
         }
      fprintf(out, "\n");
      }
}
