/*
 * @(#)pebspage.C	1.57   5/10/94
 * Function to print out the Personalized Earnings and Benefit Estimate
 * Statement
 */

#ifndef lint
static char *pebspgID = " @(#)pebspage.C	1.57   5/10/94 ";
#endif

#include <stdio.h>
#include <math.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "taxes.h"
#include "prtutils.h"
#include "utils.h"
#include "comma.h"
#include "setup.h"
#include "pebspage.h"
#include "piaout.h"
#include "compdate.h"

/* Function to print first PEBES page
 */
void pebspg1(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
Pebs *pebsdata,  /* pebsdata structure */
FOINFO *foinfo)  /* field office info structure */
{
   register i1;  /* loop counter */

   fprintf(out, "\n\n\n\n");
   for (i1 = 0; i1 < 4; i1++)
      if (strlen(foinfo -> foaddr[i1]))
         fprintf(out, "%s%s\n", stringd(41,' '), foinfo -> foaddr[i1]);
   fprintf(out, "%s%s\n\n", stringd(41,' '), pebsdata -> dateln2);
   fprintf(out, "        %s\n", workerdata -> nhname);
   for (i1 = 0; i1 < 3; i1++)
      if (strlen(workerdata -> nhaddr[i1]))
         fprintf(out, "        %s\n", workerdata -> nhaddr[i1]);
   fprintf(out, "\n");
   fprintf(out, "        Dear %s:\n\n", workerdata -> nhname);
   fprintf(out, "        This is the earnings and benefit estimate ");
   fprintf(out, "statement that you\n");
   fprintf(out, "        recently requested.  It lists your Social ");
   fprintf(out, "Security earnings history\n");
   fprintf(out, "        and gives you an estimate of the benefits for ");
   fprintf(out, "which you and your\n");
   fprintf(out, "        family might qualify now and in the future.\n\n");
   fprintf(out, "        Remember that this statement is not a decision ");
   fprintf(out, "on a claim for\n");
   fprintf(out, "        Social Security benefits.  You do not qualify ");
   fprintf(out, "for any of these\n");
   fprintf(out, "        benefits unless you apply for them, have all ");
   fprintf(out, "the Social Security\n");
   fprintf(out, "        credits you need, and meet all other ");
   fprintf(out, "requirements.  The benefit\n");
   fprintf(out, "        estimates we show on this statement may change.");
   fprintf(out, "  We will determine\n");
   fprintf(out, "        the exact amount of your Social Security ");
   fprintf(out, "benefits, if any, when you\n");
   fprintf(out, "        apply.\n\n");
   fprintf(out, "        If any of the information you submitted is ");
   fprintf(out, "wrong, the benefits we\n");
   fprintf(out, "        estimated in this statement may also be wrong.");
   fprintf(out, "  We based your\n");
   fprintf(out, "        benefit estimates in part on any future ");
   fprintf(out, "earnings you told us about.\n");
   fprintf(out, "        How accurately you predicted your earnings will ");
   fprintf(out, "affect the accuracy\n");
   fprintf(out, "        of your benefit estimates.\n\n");
   fprintf(out, "        Many Americans think of Social Security as only ");
   fprintf(out, "a retirement\n");
   fprintf(out, "        program.  However, it is much more than that.  ");
   fprintf(out, "Social Security also\n");
   fprintf(out, "        protects you and your family if you become ");
   fprintf(out, "severely disabled or\n");
   fprintf(out, "        die.  But, keep in mind that Social Security ");
   fprintf(out, "was never intended to\n");
   fprintf(out, "        do it all.  We encourage you to build a complete ");
   fprintf(out, "financial package\n");
   fprintf(out, "        by supplementing your Social Security with ");
   fprintf(out, "private pensions,\n");
   fprintf(out, "        savings, other insurance, and investments.\n\n");
   fprintf(out, "        We hope that this statement gives you a better ");
   fprintf(out, "picture of what\n");
   fprintf(out, "        Social Security has to offer and helps you plan ");
   fprintf(out, "for your financial\n");
   fprintf(out, "        future.\n\n\n\n\n");
   fprintf(out, "%s%s\n", stringd(41,' '), foinfo -> foname);
   fprintf(out, "%s%s\n\n", stringd(41,' '), foinfo -> fotitle);
   fprintf(out, "        Attachment\n");
   FORMFEED;
}
/* Function to print second PEBES page
 */
void pebspg2(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Pebs *pebsdata)  /* pebsdata structure */
{
   register i1;  /* loop counter */

   fprintf(out, "      FACTS ABOUT YOUR SOCIAL SECURITY%20s%s\n\n",
      " ", pebsdata -> dateln2);
   fprintf(out, "      %s\n", stringd(68,'='));
   fprintf(out, "      THE FACTS YOU GAVE US\n\n");
   fprintf(out, "      Your Name %s %s\n",
      stringd(57 - (int)strlen(workerdata -> nhname), '.'),
      workerdata -> nhname);
   fprintf(out, "      Your Social Security Number %s %-s\n",
      stringd(28, '.'), workerdata -> ssn);
   fprintf(out, "      Your Date of Birth %s",
      stringd(48 - (int)strlen(date(workerdata -> ibirth)), '.'));
   fprintf(out, " %s\n", date(workerdata -> ibirth));
   /* print two years of lag earnings */
   for (i1 = 1; i1 >= 0; i1--) {
      fprintf(out, "      %d Earnings ", workerdata -> istart - i1);
      if (workerdata -> earnpebs[workerdata -> istart - 1937 - i1] < .01)
         fprintf(out, "%s NONE\n", stringd(49, '.'));
      else if (workerdata -> earnpebs[workerdata -> istart - 1937 - i1] >=
         piaparms -> base[workerdata -> istart - 1937 - i1])
         fprintf(out, "%s OVER $%s\n", stringd(41, '.'),
            pdouble(piaparms -> base[workerdata -> istart - 1937 - i1], 6, 0));
      else
         fprintf(out, "%s $%s\n", stringd(46, '.'),
            pdouble(workerdata -> earnpebs[workerdata -> istart - 1937 - i1],
            6, 0));
      }
   /* print future earnings */
   fprintf(out, "      Your Estimated Future Yearly Earnings ");
   if (workerdata -> earnpebs[workerdata -> istart - 1936] < .01)
      fprintf(out, "%s NONE\n", stringd(25, '.'));
   else if (workerdata -> earnpebs[workerdata -> istart - 1936] >=
      piaparms -> base[workerdata -> istart - 1936])
      fprintf(out, "%s OVER $%s\n", stringd(17, '.'),
         pdouble(piaparms -> base[workerdata -> istart - 1936], 6, 0));
   else
      fprintf(out, "%s $%s\n", stringd(22, '.'),
         pdouble(workerdata -> earnpebs[workerdata -> istart - 1936], 6, 0));
   fprintf(out, "      The Age You Plan to Retire ");
   if (workerdata -> iageplan)
      fprintf(out, "%s %d\n", stringd(38, '.'), pebsdata -> iagepln2);
   else
      fprintf(out, "%s NOT PROVIDED\n", stringd(28, '.'));
   fprintf(out, "      Your Monthly Noncovered Pension ");
   if (workerdata -> pubpen < (float).01)
      fprintf(out, "%s NONE\n", stringd(31,'.'));
   else
      fprintf(out, "%s $%s\n", stringd(28, '.'),
         pdouble((double)workerdata -> pubpen,6,0));
   if (workerdata -> totalize)
      fprintf(out,"      Benefits Estimated Using Totalization Provision\n");
   fprintf(out, "      Processing month %s %s %d\n\n",
      stringd(45- (int)strlen(month(workerdata -> monthnow - 1)), '.'),
      month(workerdata -> monthnow - 1), workerdata -> istart);
   fprintf(out,
      "      We used the facts you gave us and the information in our\n");
   fprintf(out,
      "      records under your Social Security number to prepare this\n");
   fprintf(out, "      statement for you.\n\n");
   fprintf(out,
      "      When we estimated your benefits, we included any %d and\n",
      workerdata -> istart - 1);
   fprintf(out,
      "      %d earnings and any future estimated earnings you told\n",
      workerdata -> istart);
   fprintf(out,
      "      us about.  If you did not estimate your future earnings,\n");
   fprintf(out, "      we did not project any future earnings for you.\n\n");
   fprintf(out, "      %s\n", stringd(68,'='));
   fprintf(out, "      YOUR SOCIAL SECURITY CREDITS\n\n");
   fprintf(out, "      To qualify for Social Security benefits and ");
   fprintf(out, "Medicare, you need\n");
   fprintf(out, "      credit for a certain amount of work covered by ");
   fprintf(out, "Social Security.\n");
   fprintf(out,
      "      The number of credits you need will vary with the type of\n");
   fprintf(out,
      "      benefit.  Under current law, you do not need more than\n");
   fprintf(out,
      "      40 credits to qualify for any benefit or for Medicare.\n\n");
   fprintf(out, "      Our review of your earnings, including any ");
   fprintf(out, "%d and ", workerdata -> istart - 1);
   fprintf(out, "%d\n", workerdata -> istart);
   fprintf(out,
      "      earnings you told us about, shows that you now have at least\n");
   fprintf(out, "      %d Social Security credits.\n", pebsdata -> qctot);
   fprintf(out, "\n      %s\n", stringd(68,'='));
   fprintf(out, "      YOUR SOCIAL SECURITY EARNINGS\n\n");
   fprintf(out,
      "      The chart on the next page shows the earnings on your\n");
   fprintf(out, "");
   fprintf(out,
      "      Social Security record.  It also estimates the amount of\n");
   fprintf(out,
      "      Social Security taxes you paid each year to finance benefits\n");
   fprintf(out,
      "      under Social Security and Medicare.  If you have government\n");
   fprintf(out,
      "      earnings that help you qualify for Medicare, those earnings\n");
   fprintf(out, "      also are included on the chart under the heading\n");
   fprintf(out, "      \"Medicare--Your Taxed Earnings.\"\n\n");
   fprintf(out,
      "      We show earnings only up to the maximum yearly amount\n");
   fprintf(out,
      "      taxable for Social Security.  These maximum amounts are\n");
   fprintf(out,
      "      shown on the chart.  The chart may not include some or all\n");
   fprintf(out,
      "      of your earnings from last year because they may not have\n");
   fprintf(out, "      been added to your record yet.\n");
   FORMFEED;
}
/* Function to print third PEBES page
 */
void pebspg3(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Taxes *taxdata)  /* taxdata structure */
{
   register i1;  /* loop counter */

   fprintf(out, "      %s\n", stringd(70,'='));
   fprintf(out, "      YOUR EARNINGS RECORD\n\n");
   fprintf(out, "                           SOCIAL SECURITY         ");
   fprintf(out, "         MEDICARE\n");
   fprintf(out, "                -----------------------------------");
   fprintf(out, "  -----------------------\n");
   fprintf(out, "                   Maximum        Your    Estimated");
   fprintf(out, "        Your    Estimated\n");
   fprintf(out, "                    Yearly       Taxed    Taxes You");
   fprintf(out, "       Taxed    Taxes You\n");
   fprintf(out, "      YEARS       Earnings    Earnings         Paid");
   fprintf(out, "   Earnings1         Paid\n");
   fprintf(out, "      %s\n", stringd(70,'-'));
   fprintf(out, "      1937-50       $%s",
      pdouble(piaparms -> base[13], 5, 0));
   fprintf(out, "     $%s", pdouble(floor(piadata -> stot[0]), 6, 0));
   fprintf(out, "       $%s\n",
      pdouble((double)taxdata -> taxtot[2][0], 5, 0));
   for (i1 = 14; i1 < workerdata -> istart - 1936; i1++) {
      fprintf(out, "      %d %s", 1937+i1,
         pdouble(piaparms -> base[i1], 15, 0));
      if (1937+i1 < workerdata -> istart - 1) {
         fprintf(out, " %s", pdouble(piadata -> earnst[2][i1], 11, 0));
         fprintf(out, " %s", pdouble((double)taxdata -> taxes[2][i1], 12, 0));
         /* print HI earnings and taxes */
         if (1937+i1 > 1965) {
            if (1937+i1 == 1966) {
               fprintf(out, "     $%s",
                  pdouble(piadata -> earnst[5][i1], 6, 0));
               fprintf(out, "       $%s",
                  pdouble((double)taxdata -> taxes[3][i1], 5, 0));
               }
            else {
               fprintf(out, " %s", pdouble(piadata -> earnst[5][i1], 11, 0));
               fprintf(out, " %s",
                  pdouble((double)taxdata -> taxes[3][i1], 12, 0));
               }
            }
         }
      else
         if (1937 + i1 == workerdata -> istart - 1)
            fprintf(out, "            Not Yet Recorded");
      fprintf(out, "\n");
      }
   fprintf(out, "      %s\n", stringd(70,'-'));
   fprintf(out,
      "      1Earnings were taxed for Medicare beginning in 1966.  From 1983 on,\n");
   fprintf(out,
      "       these earnings include Medicare-Qualified Government Earnings (see\n");
   fprintf(out,
      "       last page).  In 1991, the maximum yearly earnings taxed for Medicare\n");
   fprintf(out,
      "       were $125,000.  For 1992, the amount was $130,200.  For 1993, the\n");
   fprintf(out, "       amount is $135,000.\n");
   FORMFEED;
}
/* Function to print fourth PEBES page
 */
void pebspg4(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
Pebs *pebsdata)  /* pebsdata structure */
{
   fprintf(out, "      %s\n", stringd(68,'='));
   fprintf(out, "      ESTIMATED BENEFITS\n");
   fprintf(out, "      %s\n", stringd(68,'='));
   fprintf(out, "      RETIREMENT\n\n");
   fprintf(out,
      "      You must have %d Social Security credits to qualify for\n",
      pebsdata -> qcreq[0]);
   fprintf(out,
      "      retirement benefits and also for Medicare at age 65.\n");
   fprintf(out,
      "      Assuming that you meet all the requirements, here are\n");
   fprintf(out,
      "      estimates of your retirement benefits based on your past\n");
   fprintf(out,
      "      and any projected earnings.  The estimates are in today's\n");
   fprintf(out, "      dollars");
   if (workerdata -> ialtaw == PEBS_ASSUM) {
      fprintf(out,
         ", but adjusted to account for average wage growth in the\n");
      fprintf(out, "      national economy.\n\n");
      }
   else
      fprintf(out, ".\n\n");
   /* early retirement benefit */
   if (compym(pebsdata -> iagepln1, pebsdata -> nra) < 0) {
      /* stop working before social security retirement */
      if (pebsdata -> iagepln2 < pebsdata -> iagepln1[0])
         {
         fprintf(out, "      If you retire at %d", pebsdata -> iagepln2);
         fprintf(out, ", your reduced monthly amount at %d", pebsdata -> iagepln1[0]);
         if (pebsdata -> iagepln1[1]) {
            fprintf(out, " and %d month", pebsdata -> iagepln1[1]);
            if (pebsdata -> iagepln1[1] != 1)
               fprintf(out, "s");
            }
         fprintf(out, "\n      in today's dollars will be about %s",
            stringd(28,'.'));
         }
      else
         {
         fprintf(out,
            "      If you retire at %d", pebsdata -> iagepln1[0]);
         fprintf(out, ", your reduced monthly amount in today's\n");
         fprintf(out, "      dollars will be about %s",
            stringd(39,'.'));
         }
      fprintf(out, " $%s\n\n", pint(pebsdata -> benftpbs[2],5));
      }
   fprintf(out,
      "      The earliest age at which you can get an unreduced benefit is\n");
   fprintf(out, "      %d ", pebsdata -> nra[0]);
   if (pebsdata -> nra[1])
      fprintf(out, "and %d months.", pebsdata -> nra[1]);
   else
      fprintf(out, "years of age.");
   fprintf(out, "  We call this your full retirement age.\n");
   fprintf(out,
      "      If you wait until that age to get benefits, your monthly\n");
   fprintf(out, "      benefit in today's dollars will be about %s $%s\n\n",
      stringd(20, '.'), pint(pebsdata -> benftpbs[1], 5));
   fprintf(out, "      If you ");
   if (workerdata -> earnpebs[workerdata -> istart - 1936] > .0) {
      fprintf(out, "continue to work and wait until you are 70 to get\n");
      fprintf(out,
         "      benefits, your monthly amount in today's dollars will be\n");
      fprintf(out, "      about %s", stringd(55, '.'));
      }
   else {
      fprintf(out, "wait until you are 70 to get benefits, your\n");
      fprintf(out,
         "      monthly amount in today's dollars will be about .............");
      }
   fprintf(out, " $%s\n", pint(pebsdata -> benftpbs[0],5));
   fprintf(out, "      %s\n", stringd(68, '-'));
   fprintf(out, "      SURVIVORS\n\n");
   fprintf(out, "      If you have a family, you must have ");
   fprintf(out, "%d Social Security\n", pebsdata -> qcreq[3]);
   fprintf(out,
      "      credits for certain family members to get benefits if you\n");
   fprintf(out,
      "      were to die this year.  Some of your survivors may also\n");
   fprintf(out,
      "      qualify if you earn 6 credits in the 3 years before your death.\n");
   fprintf(out,
      "      The number of credits a person needs to qualify for survivors\n");
   fprintf(out,
      "      benefits increases each year until age 62, up to a maximum of\n");
   fprintf(out, "      40 credits.\n\n");
   fprintf(out,
      "      Here is an estimate of the benefits your family could get\n");
   fprintf(out,
      "      if you had enough credits to be insured, they qualified for\n");
   fprintf(out, "      benefits, and you died this year:\n\n");
   fprintf(out,
      "      Your child could get a monthly amount of about ..............");
   fprintf(out, " $%s\n\n", pint(pebsdata -> benftpbs[3],5));
   fprintf(out,
      "      If your child and your surviving spouse who is caring\n");
   fprintf(out,
      "      for your child both qualify, they could each get a\n");
   fprintf(out, "      monthly amount of about %s $%s\n\n",
      stringd(37, '.'), pint(pebsdata -> benftpbs[3], 5));
   fprintf(out,
      "      When your surviving spouse reaches full retirement age,\n");
   fprintf(out,
      "      he or she could get a monthly amount of about %s $%s\n\n",
      stringd(15, '.'), pint(pebsdata -> piapebs[3], 5));
   fprintf(out,
      "      If more family members qualify for benefits (other\n");
   fprintf(out,
      "      children, for example), the total amount that we could\n");
   fprintf(out, "      pay your family each month is about %s $%s\n\n",
      stringd(25, '.'), pint(pebsdata -> mfbpebs[3], 5));
   fprintf(out,
      "      We also may be able to pay your surviving spouse or\n");
   fprintf(out, "      children a one-time death benefit of %s $%s\n",
      stringd(24, '.'), pint(255, 5));
   FORMFEED;
}
/* Function to print fifth PEBES page
 */
void pebspg5(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Pebs *pebsdata)  /* pebsdata structure */
{
   fprintf(out, "      %s\n", stringd(68, '-'));
   fprintf(out, "      DISABILITY\n\n");
   fprintf(out, "      Right now, you must have %d ", pebsdata -> qcreq[4]);
   fprintf(out, "Social Security credits to\n");
   fprintf(out, "      qualify for disability benefits.  And, ");
   fprintf(out, "%d of these credits\n", pebsdata -> qcdireq);
   fprintf(out,
      "      had to be earned in the %d year period immediately before\n",
      pebsdata -> qcdiyr);
   fprintf(out,
      "      you became disabled.  If you are blind or got disability\n");
   fprintf(out,
      "      benefits in the past, you may need fewer credits.\n");
   fprintf(out,
      "      The number of credits a person needs to qualify for\n");
   fprintf(out,
      "      disability benefits increases each year until age 62, up\n");
   fprintf(out,
      "      to a maximum of 40 credits.\n\n");
   fprintf(out,
      "      If you were disabled, had enough credits, and met the\n");
   fprintf(out,
      "      other requirements for disability benefits, here is an\n");
   fprintf(out,
      "      estimate of the benefits you could get right now:\n\n");
   fprintf(out, "      Your monthly benefit would be about %s $%s\n\n",
      stringd(25,'.'), pint(pebsdata -> piapebs[4],5));
   fprintf(out,
      "      You and your family members who qualify could get up to\n");
   fprintf(out, "      a monthly total of about %s $%s\n\n",
      stringd(36,'.'), pint(pebsdata -> mfbpebs[4],5));
   fprintf(out,
      "      These estimates may be reduced if you get workers'\n");
   fprintf(out, "      compensation or public disability benefits.\n");
   fprintf(out, "      %s\n", stringd(68, '='));
   fprintf(out, "      ESTIMATED RETIREMENT BENEFITS\n\n");
   bottom3(out, "retirement", workerdata -> ialtaw);
   fprintf(out, "      %s\n", stringd(68, '='));
   fprintf(out, "      YOUR SOCIAL SECURITY TAXES\n\n");
   fprintf(out,
      "      Currently, you and your employer each pay Social Security\n");
   fprintf(out, "      taxes of 6.2 percent on your first $%s ",
      pdouble(piaparms -> base[workerdata -> istart - 1937], 5, 0));
   fprintf(out, "of covered wages.\n");
   fprintf(out,
      "      You each also pay Medicare taxes of 1.45 percent on all\n");
   fprintf(out, "      covered wages.  If you are self-employed,\n");
   fprintf(out,
      "      your Social Security tax is 12.4 percent and your Medicare\n");
   fprintf(out, "      tax is 2.9 percent.\n\n");
   fprintf(out,
      "      The earnings chart shows how much tax you paid to finance\n");
   fprintf(out,
      "      Social Security benefits and how much you paid to finance\n");
   fprintf(out,
      "      Medicare hospital insurance.  If you had earnings from \n");
   fprintf(out,
      "      employment and self-employment in the same year, we show\n");
   fprintf(out,
      "      estimated taxes as if all your earnings were from employment.\n");
   fprintf(out,
      "      If you had Social Security covered earnings and Medicare-\n");
   fprintf(out,
      "      qualified government earnings in the same year, we show the\n");
   fprintf(out, "      combined Medicare taxes you paid.\n");
   FORMFEED;
}
