/*
 * @(#)pebspage.h	1.19   6/27/94
 * Variables common to all files
 */

#ifndef __PEBSPAGE_H
#define __PEBSPAGE_H

#define MAXPEBS 5  /* number of calculations for PEBS */

typedef struct {
   int    benftpbs[MAXPEBS];  /* benefit actually payable in PEBS
                 calculation */
   int    iagepln1[2];  /* planned early retirement age (years and
                 months), after adjusting for current age */
   int    iagepln2;  /* planned retirement age (adjusted to 62 if none
                 entered), or current age, if greater */
   int    mfbpebs[MAXPEBS];  /* MFB for PEBS calculation */
   int    nra[2];  /* worker's normal retirement age (years and
                 months) */
   int    piapebs[MAXPEBS];  /* PIA for PEBS calculation */
   int    qcreq[MAXPEBS];  /* quarters of coverage required for fully
                 insured status for PEBS calculation */
   int    qctot;  /* quarters of coverage earned through current year */
   int    qcdireq;  /* quarters of coverage required for disability insured
                 status for PEBS calculation */
   int    qcdiyr;  /* number of years over which quarters of coverage must be
                 earned for disability insured status for PEBS calculation */
   char   dateln2[20];  /* date for output */
   } Pebs;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
void  pebspg1  ( FILE *out, WORKERDATA *workerdata, Pebs *pebsdata,
   FOINFO *foinfo );
void  pebspg2  ( FILE *out, WORKERDATA *workerdata, PIAPARMS *piaparms,
   Pebs *pebsdata );
void  pebspg3  ( FILE *out, WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Taxes *taxdata );
void  pebspg4  ( FILE *out, WORKERDATA *workerdata, Pebs *pebsdata );
void  pebspg5  ( FILE *out, WORKERDATA *workerdata, PIAPARMS *piaparms,
   Pebs *pebsdata );
#else
void  pebspg1();
void  pebspg2();
void  pebspg3();
void  pebspg4();
void  pebspg5();
#endif

#endif  // __PEBSPAGE_H
