/*
 * @(#)piacal.C	1.136   4/1/94
 * Function to calculate a PIA
 */

#ifndef lint
static char *piacalID = " @(#)piacal.C	1.136   4/1/94 ";
#endif

#include <stdio.h>
#include <math.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#if defined(MSDOS) | defined(M_UNIX)
#include <stdlib.h>
#else
extern char *calloc();
extern char *malloc();
extern void free();
#define fmod(x,y) (y) * ((x/y) - floor(x/y))
#endif
#if defined(M_UNIX)
#include <malloc.h>
#endif
#include "pia.h"
#include "compdate.h"

typedef struct {
   int index;
   double earn;
} EARNINGS;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int    c_oldst   ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_spmin   ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_piatab  ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_trnsgr  ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_wgind   ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_reindw  ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata );
static void   c_frozmin ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata );
static void   order     ( PIADATA *piadata, int first, int last,
   int number, enum pia_type method );
static int    compar    ( const void *, const void * );
static double cpi77     ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, enum pia_type method, double *pia77, int mcchup );
static double mfbcal    ( PIADATA *piadata, enum pia_type method );
static void   rwgadj    ( PIADATA *piadata, int melgyr, int istart,
   enum pia_type method );
static int    methoscal ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata );
static void   impute    ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata );
static int    increment ( WORKERDATA *workerdata, PIADATA *piadata );
static int    getpibtb  ( PIAPARMS *piaparms, char *filename, int size );
static int    wep_app   ( WORKERDATA *workerdata, PIADATA *piadata );
static void   icchupc   ( PIADATA *piadata, int istart );
static int    spmntcal  ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, enum pia_type piatype );
static double spmincal  ( PIADATA *piadata, PIAPARMS *piaparms,
   Lawchg *lawchgdata, int date1[3] );
static double dimax    ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, int method, double amedimax );
static void   prorate   ( PIAPARMS *piaparms, PIADATA *piadata,
   enum pia_type piatype );
static double decnvtpia ( PIAPARMS *, int, int, double, int );
static double unround   ( double, int );
static double unbicchp  ( PIAPARMS *, int, double, int );
static float  mfboldcal ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata, Lawchg *lawchgdata, enum pia_type method,
   int belowmin );
static double decnvtame ( PIADATA *piadata, double piasub );
#else
static int    c_oldst();
static void   c_spmin();
static void   c_piatab();
static void   c_trnsgr();
static void   c_wgind();
static void   c_reindw();
static void   c_frozmin();
static void   order();
static int    compar();
static double cpi77();
static double mfbcal();
static void   rwgadj();
static int    methoscal();
static void   impute();
static int    increment();
static int    getpibtb();
static int    wep_app();
static int    icchupc();
static int    spmntcal();
static double spmincal();
static double dimax();
static void   prorate();
static double decnvtpia();
static double unround();
static double unbicchp();
static float  mfboldcal();
static double decnvtame();
#endif

int iern50;  /* initial year of earnings, minus 1950 */

/* Function to calculate PIA and MFB
 */
int piacal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1,i2; /* loop counters */
   int itrans;  /* transitional guarantee period */
   int age62[3];  /* month, day, and year of age 62 */
   int ierr;  /* error indicator */

   piadata -> pib = piadata -> pibinc = 0.;
   piadata -> iwind = piadata -> methos = 0;
   piadata -> ispmnt[0] = piadata -> ispmnt[1] = 0;
   piadata -> nold = piadata -> arfapp = 0;
   for (i1 = 0; i1 < 3; i1++)
      piadata -> bendpia[i1] = piadata -> percp[i1] = 0.;
   for (i1 = 0; i1 < 4; i1++)
      piadata -> bendmfb[i1] = 0.;
   for (i1 = 0; i1 < workerdata -> maxyears; i1++) {
      for (i2 = 0; i2 < MAXCAL; i2++) {
         piadata -> vearn[i2][i1] = 0.;
         piadata -> iorder[i2][i1] = 0; }
      }
   age62[0] = piadata -> kbirth[0];
   age62[1] = piadata -> kbirth[1];
   age62[2] = piadata -> kbirth[2] + 62;
   iern50 = (workerdata -> ibegin > 1950) ? workerdata -> ibegin - 1950 : 1;
   for (i1 = 0; i1 < MAXCAL; i1++) {
      piadata -> iapp[i1] = piadata -> icap[i1] = 0;
      for (i2 = 0; i2 < MAXIYCPI; i2++)
         piadata -> iycpi[i1][i2] = 0;
      piadata -> piaent[i1] = piadata -> ame[i1] = piadata -> mfbent[i1] =
         piadata -> cap[i1] = 0.;
      for (i2 = 0; i2 < 50; i2++)
         piadata -> piael[i1][i2] = piadata -> mfbel[i1][i2] = 0.;
      }
   piadata -> iycpi[(int)PIA_TABLE][2] = (workerdata -> ient[0] >=
      piaparms -> monben[workerdata -> ient[2] - 1951]) ?
      workerdata -> ient[2] : workerdata -> ient[2] - 1;
   piadata -> iycpi[(int)PIA_TABLE][3] = (workerdata -> bendate[0] >=
      piaparms -> monben[workerdata -> bendate[2] - 1951]) ?
      workerdata -> bendate[2] : workerdata -> bendate[2] - 1;
   piadata -> iycpi[(int)PIA_TABLE][0] = 1975;
   icchupc(piadata, workerdata -> istart);
   percpset(piaparms,piadata -> percp);
   /* old-start PIA */
   if (piadata -> qctot50 > 0 &&
      (piadata -> kbirth[2] < 1929 || piadata -> qctot51 < 6))
      {
      piadata -> iapp[(int)OLD_START] = 1;
      if ((ierr = c_oldst(workerdata, piaparms, piadata, lawchgdata)) > 0)
         return(ierr);
      }

   /* special-minimum PIA */
   if (compmdy(workerdata -> bendate, piaparms -> amend722) >= 0 &&
      workerdata -> totalize == 0)
      {
      piadata -> iapp[(int)SPEC_MIN] = 1;
      c_spmin(workerdata, piaparms, piadata, lawchgdata);
      }

#ifdef LAWCHG
   if (piadata -> ielgyr[1] > 1978 && lawchgdata -> jind[0] > 0)
      {  /* old-law */
      piadata -> iapp[(int)PIA_TABLE] = 1;
      c_piatab(workerdata, piaparms, piadata, lawchgdata);
      }
   if (lawchgdata -> jind[16] > 0)
      itrans = 5 * lawchgdata -> jind[16];
   if (lawchgdata -> jind[18] == 1)
      itrans = 5;
   if (lawchgdata -> jind[20] > 0)
      itrans = 5 * lawchgdata -> jind[20];
   if (lawchgdata -> jind[21] > 0)
      itrans = 13;
   if (lawchgdata -> jind[24] > 0)
      itrans = 5 * lawchgdata -> jind[24];
   if (lawchgdata -> jind[25] > 0)
      itrans = 10;
   if ((lawchgdata -> jind[16] > 0 || lawchgdata -> jind[18] > 0 ||
      lawchgdata -> jind[20] > 0 || lawchgdata -> jind[21] > 0 ||
      lawchgdata -> jind[24] > 0 || lawchgdata -> jind[25] > 0) &&
      piadata -> ielgyr[1] > 1978 && piadata -> ielgyr[0] < 1979 + itrans &&
      workerdata -> ioasdi != DISABILITY)
      c_piatab(workerdata, piaparms, piadata, lawchgdata);
   if (lawchgdata -> jind[19] > 0 && piadata -> ielgyr[1] > 1978 &&
      workerdata -> ioasdi != DISABILITY)
      c_piatab(workerdata, piaparms, piadata, lawchgdata);
#endif

   if (piadata -> ielgyr[1] < 1979 &&
      compmdy(workerdata -> bendate, piaparms -> amend52) >= 0 &&
      (workerdata -> ioasdi != SURVIVOR ||
      compmdy(workerdata -> ideath, piaparms -> amend52) >= 0) )
      { /* PIA Table */
      piadata -> iapp[(int)PIA_TABLE] = 1;
      c_piatab(workerdata, piaparms, piadata, lawchgdata);
      }

   itrans = 5;
#ifdef LAWCHG
   if (lawchgdata -> jind[15] == 2 || lawchgdata -> jind[16] == 2 ||
      lawchgdata -> jind[17] == 2)
      itrans = 10;
#endif
   if (piadata -> ielgyr[1] > 1978 && piadata -> ielgyr[0] < 1979+itrans &&
      workerdata -> ioasdi != DISABILITY
      && (workerdata -> ioasdi != SURVIVOR ||
      compmdy(workerdata -> ideath, age62) >= 0) &&
      workerdata -> totalize == 0)
      /* transitional guarantee */
      {
      piadata -> iapp[(int)TRANS_GUAR] = 1;
      c_trnsgr(workerdata, piaparms, piadata, lawchgdata);
      }

#ifdef LAWCHG
   if (piadata -> ielgyr[1] > 1978 && workerdata -> iend > 1950 &&
      lawchgdata -> jind[0] == 0)
#else
   if (piadata -> ielgyr[1] > 1978 && workerdata -> iend > 1950)
#endif
      /* wage-indexed PIA */
      {
      piadata -> iapp[(int)WAGE_IND] = 1;
      c_wgind(workerdata,piaparms,piadata,lawchgdata);
      }

   if (piadata -> ielgyr[1] > 1978 && workerdata -> iend > 1950 &&
      workerdata -> ioasdi == SURVIVOR &&
      (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID)
      && compmdy(workerdata -> ideath, age62) < 0
      && (piadata -> kelgyr > 1984 || workerdata -> ideath[2] >= 1985) &&
      workerdata -> totalize == 0)
      /* re-indexed widow guarantee */
      {
      piadata -> iapp[(int)REIND_WID] = 1;
      c_reindw(workerdata,piaparms,piadata,lawchgdata);
      }

   if (piadata -> ielgyr[1] > 1978 && piadata -> ielgyr[1] < 1982 &&
      workerdata -> totalize == 0)
      /* frozen minimum */
      {
      piadata -> iapp[(int)FROZ_MIN] = 1;
      c_frozmin(workerdata, piaparms, piadata);
      }

#ifdef LAWCHG
   /* reset transitional guarantee, if necessary */
   if (lawchgdata -> jind[16] + lawchgdata -> jind[17] +
      lawchgdata -> jind[18] + lawchgdata -> jind[25] > 0)
      trguarlc(workerdata, piadata, lawchgdata, itrans);
#endif

   piadata -> suppia = piadata -> himfb = piadata -> hipia = 0.;
   piadata -> iapps = piadata -> iappn = -1;
   for (i1 = 0; i1 < MAXCAL; i1++) { /* set highest PIA */
      if (piadata -> hipia < piadata -> piaent[i1]) {
         piadata -> hipia = piadata -> piaent[i1];
         piadata -> iappn = i1; }
      }
   if (piadata -> iappn > -1)
      piadata -> iapp[piadata -> iappn] = 2;
   /* find support PIA */
   if (piadata -> arf > 1.0 && piadata -> iappn == (int)SPEC_MIN) {
      for (i1 = 0; i1 < MAXCAL; i1++) {
         if (piadata -> suppia < piadata -> piaent[i1] && i1 != (int)SPEC_MIN) {
            piadata -> suppia = piadata -> piaent[i1];
            piadata -> iapps = i1; }
         }
      piadata -> iapp[piadata -> iapps] = 3;
      }
   /* apply DI maximum */
   if (workerdata -> ioasdi == DISABILITY && piadata -> ielgyr[1] > 1978 &&
      compmdy(workerdata -> ient, piaparms -> amend80) >= 0)
      for (i1 = 0; i1 < MAXCAL; i1++)
         if (piadata -> iapp[i1])
            piadata -> mfbent[i1] = dimax(workerdata, piaparms, piadata, i1,
               piadata -> ame[(int)WAGE_IND]);
   if (piadata -> iappn > -1)
      piadata -> himfb = piadata -> mfbent[piadata -> iappn];
   /* calculate benefit payable */
   /* check for special minimum with delayed retirement credit */
   if (piadata -> iapps >= 0) {
      piadata -> benfit[0] = round(piadata -> arf * piadata -> suppia,
         piadata -> iycpi[(int)PIA_TABLE][3]);
      if (piadata -> benfit[0] > piadata -> piaent[(int)SPEC_MIN])
         piadata -> arfapp = 2;
      else {
         piadata -> benfit[0] = piadata -> piaent[(int)SPEC_MIN];
         piadata -> arfapp = 1; }
      }
   else
      piadata -> benfit[0] =
         (compmdy(workerdata -> ient, piaparms -> amend50) < 0 ?
         piadata -> hipia : round(piadata -> arf * piadata -> hipia,
            piadata -> iycpi[(int)PIA_TABLE][2]));
   /* round to lower dollar if June 1982 or later */
   piadata -> benfit[1] =
      (compmdy(workerdata -> bendate, piaparms -> amend82) >= 0) ?
      floor(piadata -> benfit[0]) : piadata -> benfit[0];
   return(0);
}
/* Function to compute old-start PIA
 */
static int c_oldst(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1, i2; /* loop counters */
   static int iame58[] = /* 1958 PIB-PIA Conversion Table AME's */
      { 76,78,80,81,83,85,87,89,90,92,94,96,97,99,101,
        102,104,106,107,109,113,118,122,127,132,136,141,
        146,150,155,160,164,169,174,178,183,188,193,197,
        202,207,211,216,221,225,230,235,239,244,249,250 };
   static float pib58[] = /* 1958 PIB-PIA Conversion Table PIB's */
      { 16.2,16.84,17.6,18.4,19.24,20.,20.64,21.28,21.88,22.28,22.68,
        23.08,23.44,23.76,24.2,24.6,25.,25.48,25.92,26.4,26.94,27.46,
        28.,28.68,29.25,29.68,30.36,30.92,31.36,32.,32.6,33.2,33.88,
        34.50,35.,35.80,36.40,37.08,37.6,38.2,39.12,39.68,40.33,
        41.12,41.76,42.44,43.20,43.76,44.44,44.58,45.60 };
   double test; /*temporary value */
   int ierr;  /* error indicator */

#ifdef LAWCHG
   if (lawchgdata -> jind[13] > 0 &&
      workerdata -> ient[2] >= lawchgdata -> jstart[0][13])
      return(0);
#endif
   /* find old-start n */
   ncal(workerdata, piadata, piaparms, lawchgdata, 1);
   piadata -> methos = methoscal(workerdata, piaparms, piadata);
#ifdef LAWCHG
   lawchgdata -> iern49 = i49cal1(piadata, lawchgdata);
#endif
   impute(workerdata, piaparms, piadata);
   /* fill out remainder of wearn */
   i2 = piadata -> iernyr - 1936;
   /* if 1977 old-start using Dec 1979 frozen PIA table, do not use
    * earnings in year of eligibility or later */
   if (piadata -> methos == 6 && piadata -> iernyr >= piadata -> ielgyr[1])
      i2 = piadata -> ielgyr[1] - 1937;
   for (i1 = 14; i1 < i2; i1++)
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1-1937 ||
         i1 > piadata -> frzyr2-1937)
         piadata -> vearn[(int)OLD_START][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1];
   /* order the earnings and compute average monthly earnings */
   order(piadata, 1, i2, piadata -> nold, OLD_START);
   /* save old-start AME */
   piadata -> iameos = (int)piadata -> ame[(int)OLD_START];
   /* calculate old-start AME */
   piadata -> paime[0][(int)OLD_START] =
      (piadata -> iameos < piaparms -> ibenos[1]) ?
      (float) piadata -> iameos : (float) piaparms -> ibenos[1];
   piadata -> paime[1][(int)OLD_START] =
      (piadata -> iameos > piaparms -> ibenos[2]) ?
      (float) (piaparms -> ibenos[2] - piaparms -> ibenos[1]) :
      (float) (piadata -> iameos - piaparms -> ibenos[1]);
   if (piadata -> paime[1][(int)OLD_START] < 0.)
      piadata -> paime[1][(int)OLD_START] = 0.;
   for (i1 = 0; i1 < 2; i1++) /* find PIB before incrementing */
      piadata -> pib +=
         piaparms -> percos[i1] * piadata -> paime[i1][(int)OLD_START];
   /* calculate increment years */
   piadata -> incyrs = increment(workerdata, piadata);
   /* increase PIB 1% for each increment year */
   piadata -> pibinc = piadata -> pib * (1. + .01*(float)piadata -> incyrs);
   /* if this is 1939 Amendments, then PIB is PIA, with $10 minimum */
   if (piadata -> methos == 0) {
      piadata -> piaent[(int)OLD_START] = (piadata -> pibinc < 10.) ?
         10. : piadata -> pibinc;
      /* MFB is 80% of old-start AMW */
      piadata -> mfbent[(int)OLD_START] = .8*(double)piadata -> iameos;
      /* limit MFB to $85 */
      if (piadata -> mfbent[(int)OLD_START] > 85.)
         piadata -> mfbent[(int)OLD_START] = 85.;
      /* limit MFB to twice PIA */
      if (piadata -> mfbent[(int)OLD_START] >
         2. * piadata -> piaent[(int)OLD_START])
         piadata -> mfbent[(int)OLD_START] =
            2. * piadata -> piaent[(int)OLD_START];
      /* MFB is at least $20 */
      if (piadata -> mfbent[(int)OLD_START] < 20.)
         piadata -> mfbent[(int)OLD_START] = 20.;
      return(0);
      }
   i1 = 0;
   /* use 1950 conversion table */
   if (piadata -> methos == 1) {
      if ((ierr = getpibtb(piaparms, "os50pib.dat", 486)) > 0)
         return(ierr);
      while (piadata -> pibinc > piaparms -> pibtable[i1] && i1 < 485)
         i1++;
      /* PIAs in conversion table start at $20 and increase at $.10 per
       * interval */
      piadata -> piaent[(int)OLD_START] = piadata -> piael[(int)OLD_START][0] =
         20.00 + (double)i1/10.;
      if (compmdy(workerdata -> bendate, piaparms -> amend52) < 0)
         {
         if ((ierr = getpibtb(piaparms, "os50mfb.dat", 486)) > 0)
            return(ierr);
         piadata -> mfbent[(int)OLD_START] =
            piadata -> mfbel[(int)OLD_START][0] =
            piaparms -> pibtable[i1];
         }
      else
         {
         /* increase is greater of $5 or 12.5% */
         test = piadata -> piaent[(int)OLD_START] *
            (1. + piaparms -> cpiinc[1]/100.);
         piadata -> piaent[(int)OLD_START] =
            (test > piadata -> piaent[(int)OLD_START] + 5.0) ?
            test : piadata -> piaent[(int)OLD_START] + 5.0;
         piadata -> piaent[(int)OLD_START] =
            round(piadata -> piaent[(int)OLD_START], 1952);
         if (compmdy(workerdata -> bendate, piaparms -> amend54) < 0)
            {
            if ((ierr = getpibtb(piaparms, "os52mfb.dat", 486)) > 0)
               return(ierr);
            piadata -> mfbent[(int)OLD_START] =
               piadata -> mfbel[(int)OLD_START][0] = piaparms -> pibtable[i1];
            }
         else
            {
            if (i1 < 329)
               piadata -> piaent[(int)OLD_START] += 5.0;
            else
               {
               if ((ierr = getpibtb(piaparms, "os54pia.dat", 157)) > 0)
                  return(ierr);
               piadata -> piaent[(int)OLD_START] =
                  piaparms -> pibtable[i1 - 329];
               if ((ierr = getpibtb(piaparms, "os54mfb.dat", 486)) > 0)
                  return(ierr);
               piadata -> mfbent[(int)OLD_START] =
                  piadata -> mfbel[(int)OLD_START][0] =
                  piaparms -> pibtable[i1];
               }
            }
         }
      return(0);
      }
   /* find PIB in 1958 PIB-PIA conversion table */
   while (piadata -> pibinc > pib58[i1] && i1 < 50)
      i1++;
   piadata -> ame[(int)OLD_START] = (double)iame58[i1];
   if (piadata -> methos == 6) {
      /* if eligible in 1982 or later, extend down below minimum */
      if ((i1 == 0) && (piadata -> ielgyr[1] > 1981))
         piadata -> ame[(int)OLD_START] =
            floor(piadata -> pibinc * 76. / 16.20 + .999);
      /* find corresponding PIA in Dec 1978 PIA Table */
#ifdef LAWCHG
      lawchgdata -> z4 = 0.;
#endif
      piadata -> itabel[(int)OLD_START] = cpibas(workerdata, piaparms, piadata,
         lawchgdata, 28, 1, OLD_START, &piadata -> piaent[(int)OLD_START],
         &piadata -> mfbent[(int)OLD_START], piadata -> ame[(int)OLD_START]);
      piadata -> piael[(int)OLD_START][0] = piadata -> piaent[(int)OLD_START];
      /* apply windfall elimination provision */
      if (wep_app(workerdata, piadata))
         {
         piadata -> piaw[(int)OLD_START] =
            piadata -> piael[(int)OLD_START][0];
         test = round (.5 * workerdata -> pubpen, piadata -> ielgyr[1]-1);
         piadata -> piael[(int)OLD_START][0] =
            (.5 * piadata -> piael[(int)OLD_START][0] < test) ?
            round (.5 * piadata -> piael[(int)OLD_START][0],
            piadata -> ielgyr[1]-1) :
            piadata -> piael[(int)OLD_START][0] - test;
         piadata -> piaent[(int)OLD_START] = piadata -> piael[(int)OLD_START][0];
         }
      /* apply CPI increases to PIA */
      for (i2 = 0; i2 < 2; i2++)
         piadata -> iycpi[(int)OLD_START][i2] = piadata -> ielgyr[1];
      piadata -> piaent[(int)OLD_START] = cpi77(workerdata, piaparms, piadata,
         OLD_START, piadata -> piael[(int)OLD_START], piadata -> icchup);
      mfbset(piaparms, piadata -> ielgyr[1], piadata -> bendmfb,
         piadata -> percm);
      /* apply totalization */
      if (workerdata -> totalize)
         prorate(piaparms, piadata, OLD_START);
      /* find AIME MFB from wage-indexed formula */
      piadata -> mfbel[(int)OLD_START][0] = mfbcal(piadata, OLD_START);
      /* apply CPI increases to MFB */
      piadata -> mfbent[(int)OLD_START] = cpi77(workerdata, piaparms, piadata,
         OLD_START, piadata -> mfbel[(int)OLD_START], piadata -> icchup);
      }
   else {
      if (compmdy(workerdata -> bendate, piaparms -> amend742) < 0)
         piadata -> itabel[(int)OLD_START] = oldpia(workerdata, piaparms,
            piadata, OLD_START);
      else {
         for (i2 = 0; i2 < MAXIYCPI; i2++)
            piadata -> iycpi[(int)OLD_START][i2] =
               piadata -> iycpi[(int)PIA_TABLE][i2];
#ifdef LAWCHG
         lawchgdata -> z4 = z4set(workerdata, piadata, lawchgdata);
#endif
         piadata -> itabel[(int)OLD_START] = cpibas(workerdata, piaparms,
            piadata, lawchgdata, piadata -> iycpi[(int)OLD_START][3] - 1950,
            0, OLD_START, &piadata -> piaent[(int)OLD_START],
            &piadata -> mfbent[(int)OLD_START], piadata -> ame[(int)OLD_START]);
         }
      }
   return(0);
}
/* Function to compute special minimum PIA
 */
static void c_spmin(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1; /* loop counter */
   double mfbt; /* test MFB */
   int number = 0;  /* number of benefit increases applied */

   /* find years of coverage */
   piadata -> ispmnt[0] = spmntcal(workerdata, piaparms, piadata, SPEC_MIN);
   piadata -> spmin = spmincal(piadata, piaparms, lawchgdata,
      workerdata -> bendate);
   /* limit usable years of coverage to those in excess of 10, up to 20
    * usable years */
   piadata -> iyrspm = (piadata -> ispmnt[0] > 10) ?
      piadata -> ispmnt[0] - 10 : 0;
   if (piadata -> iyrspm > 20)
      piadata -> iyrspm = 20;
#ifdef LAWCHG
   /* change maximum years, if applicable */
   if (lawchgdata -> jind[12] >= 2 &&
      piadata -> ielgyr[1] >= lawchgdata -> jstart[0][12])
      {
      piadata -> iyrspm = (piadata -> ispmnt[0] > 10) ?
         piadata -> ispmnt[0] - 10 : 0;
      if (piadata -> iyrspm > lawchgdata -> jspmin - 10)
         piadata -> iyrspm = lawchgdata -> jspmin - 10;
      }
#endif
   /* PIA equals dollar amount times years of coverage */
   piadata -> piael[(int)SPEC_MIN][0] = (double) piadata -> iyrspm *
      piadata -> spmin;
   /* find MFB by first checking if 1979 or later */
   if (compmdy(workerdata -> bendate, piaparms -> amend77) >= 0)
      { /* find January 1979 MFB */
      piadata -> mfbel[(int)SPEC_MIN][0] =
         round(1.5 * piadata -> piael[(int)SPEC_MIN][0], 1978);
      /* benefit increases start in 1979 */
      piadata -> iycpi[(int)SPEC_MIN][0] = 1979;
      piadata -> iycpi[(int)SPEC_MIN][1] = piadata -> ielgyr[1];
      for (i1 = 2; i1 < MAXIYCPI; i1++)
         piadata -> iycpi[(int)SPEC_MIN][i1] =
            piadata -> iycpi[(int)PIA_TABLE][i1];
      /* apply benefit increases if June 1979 or later */
      for (i1 = 28; i1 < piadata -> iycpi[(int)SPEC_MIN][3] - 1950; i1++)
         {
         piadata -> piael[(int)SPEC_MIN][number+1] =
            round(piadata -> piael[(int)SPEC_MIN][number] *
            (1. + piaparms -> cpiinc[i1]/100.), i1+1951);
         piadata -> mfbel[(int)SPEC_MIN][number+1] =
            round(piadata -> mfbel[(int)SPEC_MIN][number] *
            (1. + piaparms -> cpiinc[i1]/100.), i1+1951);
         /* check to see that MFB is at least 150% of PIA */
         mfbt = round(1.5 * piadata -> piael[(int)SPEC_MIN][number+1],
            i1+1951);
         if (piadata -> mfbel[(int)SPEC_MIN][number+1] < mfbt)
            piadata -> mfbel[(int)SPEC_MIN][number+1] = mfbt;
         /* apply catch-up benefit increases */
         piadata -> piael[(int)SPEC_MIN][number+1] =
            bicchp(piaparms, i1+1, piadata -> piael[(int)SPEC_MIN][number+1],
               0);
         piadata -> mfbel[(int)SPEC_MIN][number+1] =
            bicchp(piaparms, i1+1, piadata -> mfbel[(int)SPEC_MIN][number+1],
               0);
         /* check to see that MFB is at least 150% of PIA */
         mfbt = round(1.5 * piadata -> piael[(int)SPEC_MIN][number+1], i1+1951);
         if (piadata -> mfbel[(int)SPEC_MIN][number+1] < mfbt)
            piadata -> mfbel[(int)SPEC_MIN][number+1] = mfbt;
         number++;
         }
      piadata -> mfbent[(int)SPEC_MIN] =
         piadata -> mfbel[(int)SPEC_MIN][number];
      piadata -> piaent[(int)SPEC_MIN] =
         piadata -> piael[(int)SPEC_MIN][number];
      }
   else
      { /* find old-law MFB from PIA table for pre-1977 special minimum */
      /* years of benefit increases is same as for PIA table */
      for (i1 = 0; i1 < MAXIYCPI; i1++)
         piadata -> iycpi[(int)SPEC_MIN][i1] =
            piadata -> iycpi[(int)PIA_TABLE][i1];
      piadata -> piaent[(int)SPEC_MIN] = piadata -> piael[(int)SPEC_MIN][0];
      piadata -> ame[(int)SPEC_MIN] = mfboldcal(workerdata, piaparms, piadata,
         lawchgdata, SPEC_MIN, 0);
      }
}
/* Function to compute a PIA from table
 */
static void c_piatab(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1; /* loop counter */

#ifdef LAWCHG
   lawchgdata -> iern49 = i49cal2(piadata, lawchgdata);
#endif
   for (i1 = iern50 - 1; i1 < piadata -> iernyr - 1950; i1++)
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1-1951 ||
         i1 > piadata -> frzyr2-1951)
         piadata -> vearn[(int)PIA_TABLE][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1+14];
   order(piadata, iern50, piadata -> iernyr - 1950, piadata -> n, PIA_TABLE);
   if (compmdy(workerdata -> bendate, piaparms -> amend742) < 0)
      piadata -> itabel[(int)PIA_TABLE] = oldpia(workerdata, piaparms,
         piadata, PIA_TABLE);
   else
      {
#ifdef LAWCHG
      lawchgdata -> z4 = z4set(workerdata, piadata, lawchgdata);
#endif
      piadata -> itabel[(int)PIA_TABLE] = cpibas(workerdata, piaparms, piadata,
         lawchgdata, piadata -> iycpi[(int)PIA_TABLE][3] - 1950, 0,
         PIA_TABLE, &piadata -> piaent[(int)PIA_TABLE],
         &piadata -> mfbent[(int)PIA_TABLE], piadata -> ame[(int)PIA_TABLE]);
      }
   if (workerdata -> totalize) {
      piadata -> piael[(int)PIA_TABLE][0] = piadata -> piaent[(int)PIA_TABLE];
      prorate(piaparms, piadata, PIA_TABLE);
      piadata -> piaent[(int)PIA_TABLE] = piadata -> piael[(int)PIA_TABLE][0];
      (void)mfboldcal(workerdata, piaparms, piadata, lawchgdata, PIA_TABLE, 1);
      }
}
/* Function to compute a transitional guarantee PIA
 */
static void c_trnsgr(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1;  /* loop counter */

   /* set earnings to be used up to year prior to eligibility */
   for (i1 = iern50 - 1; i1 < piadata -> ielgyr[1] - 1951; i1++)
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1-1951 ||
         i1 > piadata -> frzyr2-1951)
         piadata -> vearn[(int)TRANS_GUAR][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1+14];
   /* order the earnings and compute average monthly earnings */
   order (piadata, iern50, piadata -> ielgyr[1] - 1951, piadata -> n,
      TRANS_GUAR);
   /* calculate Dec 1978 PIA */
#ifdef LAWCHG
   lawchgdata -> z4 = 0.;
#endif
   piadata -> itabel[(int)TRANS_GUAR] = cpibas(workerdata, piaparms, piadata,
      lawchgdata, 28, 1, TRANS_GUAR, &piadata -> piaent[(int)TRANS_GUAR],
      &piadata -> mfbent[(int)TRANS_GUAR], piadata -> ame[(int)TRANS_GUAR]);
   mfbset(piaparms,piadata -> ielgyr[1],piadata -> bendmfb,piadata -> percm);
   /* find AIME MFB from wage-indexed formula */
   piadata -> mfbel[(int)TRANS_GUAR][0] = mfbcal (piadata, TRANS_GUAR);
   /* apply cpi increases to PIA and MFB */
   for (i1 = 0; i1 < 2; i1++)
      piadata -> iycpi[(int)TRANS_GUAR][i1] = piadata -> ielgyr[1];
   piadata -> piaent[(int)TRANS_GUAR] = cpi77(workerdata, piaparms, piadata,
      TRANS_GUAR, piadata -> piael[(int)TRANS_GUAR], piadata -> icchup);
   piadata -> mfbent[(int)TRANS_GUAR] = cpi77(workerdata, piaparms, piadata,
      TRANS_GUAR, piadata -> mfbel[(int)TRANS_GUAR], piadata -> icchup);
}
/* Function to compute wage-indexed PIA
 */
static void c_wgind(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1; /* loop counter */
   double test; /*temporary value */

   piadata -> itabel[(int)WAGE_IND] = 9;
#ifdef LAWCHG
   if (lawchgdata -> jind[3])
      factcal(piaparms,lawchgdata);
#endif
   for (i1 = iern50-1; i1 < piadata -> ielgyr[1]-1952; i1++) {
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1-1951 ||
         i1 > piadata -> frzyr2-1951) {
#ifdef LAWCHG
         if (lawchgdata -> jind[3]) {
            piadata -> uearn[i1] =
               lawchgdata -> fact[piadata -> ielgyr[1]-1953] *
               piadata -> earnst[workerdata -> totalize + 2][i1+14];
            piadata -> vearn[(int)WAGE_IND][i1] = piadata -> uearn[i1] /
               lawchgdata -> fact[i1];
            }
         else {
#endif
            piadata -> uearn[i1] = piaparms -> fq[piadata -> ielgyr[1]-1939] *
               piadata -> earnst[workerdata -> totalize + 2][i1+14];
            piadata -> vearn[(int)WAGE_IND][i1] = piadata -> uearn[i1] /
               (piaparms -> fq[i1+14]);
#ifdef LAWCHG
            }
#endif
         piadata -> vearn[(int)WAGE_IND][i1] =
            floor(piadata -> vearn[(int)WAGE_IND][i1]*100.+.5)/100.;
         }
      else
         piadata -> uearn[i1] = 0.;
      }
   for (i1 = piadata -> ielgyr[1] - 1952; i1 < piadata -> iernyr - 1950; i1++)
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1-1951 ||
         i1 > piadata -> frzyr2-1951)
         piadata -> vearn[(int)WAGE_IND][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1+14];
   order(piadata, iern50, piadata -> iernyr - 1950, piadata -> n, WAGE_IND);
   /* project applicable bend points from 1979 bend points */
   bendpiac(piaparms,piadata -> ielgyr[1],piadata -> bendpia);
#ifdef LAWCHG
   /* reproject bend points if necessary */
   if (lawchgdata -> jind[1] + lawchgdata -> jind[2] + lawchgdata -> jind[4]
      + lawchgdata -> jind[5] + lawchgdata -> jind[6] > 0)
      bpcal(piaparms,lawchgdata,piadata -> ielgyr[1],piadata -> bendpia);
#endif
   /* find portion of AIME in each AIME interval */
   piadata -> paime[0][(int)WAGE_IND] =
      (piadata -> ame[(int)WAGE_IND] < piadata -> bendpia[1]) ?
      piadata -> ame[(int)WAGE_IND] : piadata -> bendpia[1];
   piadata -> paime[1][(int)WAGE_IND] =
      (piadata -> ame[(int)WAGE_IND] < piadata -> bendpia[2]) ?
      piadata -> ame[(int)WAGE_IND] - piadata -> bendpia[1] :
      piadata -> bendpia[2] - piadata -> bendpia[1];
   if (piadata -> paime[1][(int)WAGE_IND] < 0.)
      piadata -> paime[1][(int)WAGE_IND] = 0.;
   piadata -> paime[2][(int)WAGE_IND] =
      (piadata -> ame[(int)WAGE_IND] > piadata -> bendpia[2]) ?
      piadata -> ame[(int)WAGE_IND] - piadata -> bendpia[2] : 0.;
#ifdef LAWCHG
   /* reset formula percents if necessary */
   if (lawchgdata -> jind[4] + lawchgdata -> jind[8] > 0)
      percal(lawchgdata,piadata -> ielgyr[1],piadata -> percp);
#endif
   for (i1 = 0; i1 < 3; i1++) /* find AIME PIA */
      piadata -> piael[(int)WAGE_IND][0] +=
         piadata -> percp[i1] * piadata -> paime[i1][(int)WAGE_IND];
   piadata -> piael[(int)WAGE_IND][0] =
      round(piadata -> piael[(int)WAGE_IND][0], piadata -> ielgyr[1]-1);
   /* apply windfall elimination provision */
   if (wep_app(workerdata, piadata))
      {
      /* find years of coverage for wep */
      piadata -> ispmnt[1] = spmntcal(workerdata, piaparms, piadata, WAGE_IND);
      if (piadata -> ispmnt[1] >= 30)
         piadata -> iwind = -1;
      else
         {
         piadata -> piaw[(int)WAGE_IND] =
            piadata -> piael[(int)WAGE_IND][0];
         piadata -> iwind = 1;
         piadata -> piael[(int)WAGE_IND][0] -= 
            round (.5 * workerdata -> pubpen, piadata -> ielgyr[1]-1);
         percpset(piaparms,piadata -> percw);
         piadata -> percw[0] = percw0set(piaparms, piadata -> ielgyr[1],
            workerdata -> bendate, piadata -> ispmnt[1]);
         test = 0.;
         for (i1 = 0; i1 < 3; i1++)
            test += piadata -> percw[i1] * piadata -> paime[i1][(int)WAGE_IND];
         test = round(test,piadata -> ielgyr[1]-1);
         /* check for one-half pension guarantee */
         if (test > piadata -> piael[(int)WAGE_IND][0]) {
            piadata -> iwind = 2;
            piadata -> piael[(int)WAGE_IND][0] = test; }
         }
      }
   /* apply benefit increases to PIA */
   for (i1 = 0; i1 < 2; i1++)
      piadata -> iycpi[(int)WAGE_IND][i1] = piadata -> ielgyr[1];
   piadata -> piaent[(int)WAGE_IND] = cpi77(workerdata, piaparms, piadata,
      WAGE_IND, piadata -> piael[(int)WAGE_IND], piadata -> icchup);
   mfbset(piaparms,piadata -> ielgyr[1],piadata -> bendmfb,piadata -> percm);
   /* apply totalization */
   if (workerdata -> totalize)
      prorate(piaparms, piadata, WAGE_IND);
   /* calculate the AIME MFB */
   piadata -> mfbel[(int)WAGE_IND][0] = mfbcal(piadata, WAGE_IND);
   piadata -> mfbent[(int)WAGE_IND] = cpi77(workerdata, piaparms, piadata,
      WAGE_IND, piadata -> mfbel[(int)WAGE_IND], piadata -> icchup);
   if (piadata -> ielgyr[1] > workerdata -> istart &&
      workerdata -> ialtaw == PEBS_ASSUM)
      rwgadj(piadata, piadata -> ielgyr[1], workerdata -> istart, WAGE_IND);
}
/* Function to compute re-indexed widow guarantee
 */
static void c_reindw(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1; /* loop counter */

   piadata -> jelgyr = (piadata -> ielgyr[0] > piadata -> kelgyr) ?
      piadata -> ielgyr[0] : piadata -> kelgyr;
   i1 = piadata -> kbirth[2] + 62;
   if (piadata -> jelgyr > i1)
      piadata -> jelgyr = i1;
   percpset(piaparms,piadata -> jpercp);
   for (i1 = iern50-1; i1 < piadata -> jelgyr-1952; i1++) {
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1 - 1951 ||
         i1 > piadata -> frzyr2 - 1951) {
         piadata -> xearn[i1] = piaparms -> fq[piadata -> jelgyr-1939] *
            piadata -> earnst[workerdata -> totalize + 2][i1+14];
         piadata -> vearn[(int)REIND_WID][i1] = piadata -> xearn[i1] /
            (piaparms -> fq[i1+14]);
         piadata -> vearn[(int)REIND_WID][i1] =
            floor(piadata -> vearn[(int)REIND_WID][i1]*100.+.5)/100.;
         }
      else
         piadata -> xearn[i1] = 0.;
      }
   for (i1 = piadata -> jelgyr - 1952; i1 < piadata -> iernyr - 1950; i1++)
      if (workerdata -> valdi == 0 || i1 < piadata -> frzyr1 - 1951 ||
         i1 > piadata -> frzyr2 - 1951)
         piadata -> vearn[(int)REIND_WID][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1+14];
   order(piadata, iern50, piadata -> iernyr - 1950, piadata -> n, REIND_WID);
   /* project applicable bend points from 1979 bend points */
   bendpiac(piaparms,piadata -> jelgyr,piadata -> jbendpia);
#ifdef LAWCHG
   /* reproject bend points if necessary */
   if (lawchgdata -> jind[1] + lawchgdata -> jind[2] + lawchgdata -> jind[4]
      + lawchgdata -> jind[5] + lawchgdata -> jind[6] > 0)
      bpcal(piaparms,lawchgdata,piadata -> jelgyr,piadata -> jbendpia);
#endif
   /* find portion of AIME in each AIME interval */
   piadata -> paime[0][(int)REIND_WID] =
      (piadata -> ame[(int)REIND_WID] < piadata -> jbendpia[1]) ?
      piadata -> ame[(int)REIND_WID] : piadata -> jbendpia[1];
   piadata -> paime[1][(int)REIND_WID] =
      (piadata -> ame[(int)REIND_WID] < piadata -> jbendpia[2]) ?
      piadata -> ame[(int)REIND_WID] - piadata -> jbendpia[1] :
      piadata -> jbendpia[2] - piadata -> jbendpia[1];
   if (piadata -> paime[1][(int)REIND_WID] < 0.)
      piadata -> paime[1][(int)REIND_WID] = 0.;
   piadata -> paime[2][(int)REIND_WID] =
      (piadata -> ame[(int)REIND_WID] > piadata -> jbendpia[2]) ?
      piadata -> ame[(int)REIND_WID] - piadata -> jbendpia[2] : 0.;
#ifdef LAWCHG
   /* reset formula percents if necessary */
   if (lawchgdata -> jind[4] + lawchgdata -> jind[8] > 0)
      percal(lawchgdata,piadata -> jelgyr,piadata -> jpercp);
#endif
   for (i1=0; i1<3; i1++) /* find AIME PIA */
      piadata -> piael[(int)REIND_WID][0] +=
         piadata -> jpercp[i1] * piadata -> paime[i1][(int)REIND_WID];
   piadata -> piaent[(int)REIND_WID] = piadata -> piael[(int)REIND_WID][0] =
      round(piadata -> piael[(int)REIND_WID][0], piadata -> jelgyr-1);
   for (i1 = 0; i1 < 2; i1++)
      piadata -> iycpi[(int)REIND_WID][i1] = piadata -> jelgyr;
   piadata -> piaent[(int)REIND_WID] = cpi77(workerdata, piaparms, piadata,
      REIND_WID, piadata -> piael[(int)REIND_WID], piadata -> jcchup);
   if (piadata -> jelgyr > workerdata -> istart &&
      workerdata -> ialtaw == PEBS_ASSUM)
      rwgadj(piadata, piadata -> jelgyr, workerdata -> istart, REIND_WID);
   /* set the AIME MFB equal to wage-indexed amount */
   piadata -> mfbent[(int)REIND_WID] = piadata -> mfbent[(int)WAGE_IND];
}
/* Function to calculate frozen minimum
 */
static void c_frozmin(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   piadata -> piael[(int)FROZ_MIN][0] = 122.;
   piadata -> mfbel[(int)FROZ_MIN][0] = 183.;
   piadata -> iycpi[(int)FROZ_MIN][0] =
      (workerdata -> ient[2] < piadata -> kbirth[2] + 65) ?
      workerdata -> ient[2] : piadata -> kbirth[2] + 65;
   piadata -> iycpi[(int)FROZ_MIN][1] = piadata -> iycpi[(int)FROZ_MIN][0];
   /* apply cpi increases beginning with earlier of year of entitlement
    * or year of age 65 */
   piadata -> piaent[(int)FROZ_MIN] = cpi77(workerdata, piaparms, piadata,
      FROZ_MIN, piadata -> piael[(int)FROZ_MIN], piadata -> icchup);
   piadata -> mfbent[(int)FROZ_MIN] = cpi77(workerdata, piaparms, piadata,
      FROZ_MIN, piadata -> mfbel[(int)FROZ_MIN], piadata -> icchup);
}
/* Function to order earnings and compute AME or AIME 
 */
static void order(
PIADATA *piadata,  /* piadata structure */
int first,  /* first year of earnings */
int last,  /* last year of earnings */
int number,  /* number of years to be selected */
enum pia_type method) /* method number */
{
   register i1,i2; /* loop counters */
   double tearn = 0.; /* sum of high n years of earnings */
   EARNINGS wearn[129];  /* earnings used to compute AME or AIME */

   for (i1 = 0; i1 < last - first + 1; i1++) { /* initialize arrays */
      wearn[i1].index = first + i1 - 1;
      wearn[i1].earn = piadata -> vearn[(int)method][first+i1-1]; }
   qsort((char *)wearn,last-first+1,sizeof(EARNINGS),compar);
   i2 = (last-first+1 > number) ? last-first+1-number : 0;
   for (i1 = i2; i1 < last-first+1; i1++) {
      piadata -> iorder[(int)method][wearn[i1].index] = 1;
      tearn += wearn[i1].earn; }
   piadata -> ftearn[(int)method] = tearn;
   piadata -> ame[(int)method] = floor(tearn/(((double) number)*12.));
}
/* Function to compare two earnings structures
 */
static int compar(
const void *earn1,  /* first earnings structure */
const void *earn2)  /* second earnings structure */
{
   if (((EARNINGS *)earn1) -> earn < ((EARNINGS *)earn2) -> earn)
      return(-1);
   if (((EARNINGS *)earn1) -> earn > ((EARNINGS *)earn2) -> earn)
      return(1);
   return(0);
}
/* Function to apply CPI increases to 1977 Amendments PIA or MFB
 */
static double cpi77(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type method,  /* method number */
double *pia77,  /* PIA or MFB to be increased */
int mcchup)  /* index of year of eligibility for catch-up benefit
   increases */
{
   int i1;  /* temporary index */
   int number;  /* number of benefit increases applied */

   number = piadata -> iycpi[(int)method][1] -
      piadata -> iycpi[(int)method][0];
   piadata -> iycpi[(int)method][3] = (workerdata -> bendate[0] <
      piaparms -> monben[workerdata -> bendate[2] - 1951]) ?
      workerdata -> bendate[2] - 1 : workerdata -> bendate[2];
   piadata -> iycpi[(int)method][2] = (workerdata -> ient[0] <
      piaparms -> monben[workerdata -> ient[2] - 1951]) ?
      workerdata -> ient[2] - 1 : workerdata -> ient[2];
   /* if year of benefit equals year of eligibility, and benefit
    * date is prior to benefit increase month, there are no CPI 
    * increases applied */
   /* do not apply any increases prior to 1979 */
   if (piadata -> iycpi[(int)method][1] < 1979)
      return(pia77[number]);
   for (i1 = piadata -> iycpi[(int)method][1] - 1951;
      i1 < piadata -> iycpi[(int)method][3] - 1950; i1++)
      { /* apply increases */
      pia77[number+1] =
         round(pia77[number]*(1. + piaparms -> cpiinc[i1]/100.), 1951 + i1);
      pia77[number+1] = bicchp(piaparms, i1, pia77[number+1], mcchup);
      number++; }
   return(pia77[number]);
}
/* Function to calculate an MFB at eligibility under the 1977 law
 */
static double mfbcal(
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   register i2;  /* loop counter */
   double temp = 0.;  /* MFB at eligibility */

   /* calculate portion of PIA in each interval */
   piadata -> ppiael[0][(int)method] =
      (piadata -> piael[(int)method][0] < piadata -> bendmfb[1]) ?
      piadata -> piael[(int)method][0] : piadata -> bendmfb[1];
   piadata -> ppiael[1][(int)method] =
      (piadata -> piael[(int)method][0] < piadata -> bendmfb[2]) ?
      piadata -> piael[(int)method][0] - piadata -> bendmfb[1] :
      piadata -> bendmfb[2] - piadata -> bendmfb[1];
   if (piadata -> ppiael[1][(int)method] < 0.)
      piadata -> ppiael[1][(int)method] = 0.;
   piadata -> ppiael[2][(int)method] =
      (piadata -> piael[(int)method][0] < piadata -> bendmfb[3]) ?
      piadata -> piael[(int)method][0] - piadata -> bendmfb[2] :
      piadata -> bendmfb[3] - piadata -> bendmfb[2];
   if (piadata -> ppiael[2][(int)method] < 0.)
      piadata -> ppiael[2][(int)method] = 0.;
   piadata -> ppiael[3][(int)method] =
      (piadata -> piael[(int)method][0] > piadata -> bendmfb[3]) ?
      piadata -> piael[(int)method][0] - piadata -> bendmfb[3] : 0.;
   /*  multiply percent by PIA portion and add */
   for (i2 = 0; i2 < 4; i2++)
      temp += piadata -> percm[i2] * piadata -> ppiael[i2][(int)method];
   return (round(temp, piadata -> ielgyr[1]-1));
}
/* Function to apply real-wage-gain adjustment
 */
static void rwgadj(
PIADATA *piadata,  /* piadata structure */
int melgyr,  /* year of eligibility */
int istart,  /* current year */
enum pia_type method)  /* method number */
{
   piadata -> piarwg[(int)method] = piadata -> piaent[(int)method];
   piadata -> piaent[(int)method] =
      round(piadata -> piaent[(int)method] * (1.+.01*(melgyr-istart)),
      istart-1);
   if (method == WAGE_IND) {
      piadata -> mfbrwg[(int)method] = piadata -> mfbent[(int)method];
      piadata -> mfbent[(int)method] =
         round(piadata -> mfbent[(int)method] * (1.+.01*(melgyr-istart)),
         istart-1); }
   return;
}
/* Function to apply DI maximum provision
 */
static double dimax(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
int method,  /* method number */
double amedimax)  /* ame for DI maximum calculation */
{
   int number;  /* number of benefit increases applied to eligibility */

   number = piadata -> iycpi[(int)method][1] -
      piadata -> iycpi[(int)method][0];
   piadata -> mfbel[method][number] =
      round(.85 * amedimax, piadata -> ielgyr[1] - 1);
   if (piadata -> mfbel[method][number] >
      1.5 * piadata -> piael[method][number])
      { /* cap is 150% of PIA */
      piadata -> cap[method] = 1.5;
      piadata -> icap[method] = 1;
      piadata -> mfbel[method][number] =
         round(1.5 * piadata -> piael[method][number],
         piadata -> ielgyr[1] - 1);
      }
   else {
      if (piadata -> mfbel[method][number] <
         piadata -> piael[method][number])
         { /* MFB is at floor of 100% of PIA */
         piadata -> cap[method] = 1.0;
         piadata -> icap[method] = 3;
         piadata -> mfbel[method][number] = piadata -> piael[method][number];
         }
      else
         { /* cap is 85% of AIME */
         piadata -> cap[method] = .85;
         piadata -> icap[method] = 2;
         }
      }
   return(cpi77(workerdata, piaparms, piadata, (enum pia_type)method,
      piadata -> mfbel[method], piadata -> icchup));
}
/* Function to determine correct old-start method
 */
static int methoscal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   /* if entitled prior to September 1950, use 1939 amendments */
   if (compmdy(workerdata -> ient, piaparms -> amend50) < 0)
      return(0);
   /* if entitled from September 1950 to December 1958, use 1950 
    * conversion table */
   if (compmdy(workerdata -> ient, piaparms -> amend58) < 0)
      return(1);
   /* if entitled from January 1959 to December 1965, use 1958 conversion
    * table */
   if (compmdy(workerdata -> ient, piaparms -> amend653) < 0)
      return(2);
   /* if entitled after 1965, but eligible prior to 1966, use 1958
    * conversion table or 1990 amendments */
   if (piadata -> ielgyr[1] < 1966)
      return((compmdy(workerdata -> ient, piaparms -> amend90) < 0) ? 2 : 7);
   /* otherwise, if entitled in 1966-67, use 1965 old-start */
   if (compmdy(workerdata -> ient, piaparms -> amend671) < 0)
      return(3);
   /* if entitled after 1967, but died prior to 1968, use 1965
    * old-start or 1990 amendments */
   if (piadata -> ielgyr[1] < 1968 && workerdata -> ioasdi == SURVIVOR)
      return((compmdy(workerdata -> ient, piaparms -> amend90) < 0) ? 3 : 7);
   /* separate into old-law and new-law */
   if (piadata -> kbirth[2] < 1916 || piadata -> ielgyr[1] < 1978)
      {
      /* if born before 1916, use 1967 old-start or 1990 amendments */
      if (piadata -> kbirth[2] < 1916)
         return((compmdy(workerdata -> ient, piaparms -> amend90) < 0) ? 4 : 7);
      /* if born in 1916 or later, use 1965 old-start or 1990 amendments */
      else
         return((compmdy(workerdata -> ient, piaparms -> amend90) < 0) ? 3 : 7);
      }
   else
      {
      /* if eligible in 1978, use old-start method 5 */
      if (piadata -> ielgyr[1] == 1978)
         return(5);
      else
         return(6);
      }
}
/* Function to impute yearly earnings prior to 1951
 */
static void impute(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   register i1; /* loop counter */
   int i2,i3;  /* first and last years of imputed earnings */

   if (piadata -> methos < 4) {
      /* methods 1-4 use actual yearly earnings */
      for (i1 = 0; i1 < 14; i1++)
         piadata -> vearn[(int)OLD_START][i1] =
            piadata -> earnst[workerdata -> totalize + 2][i1];
      }
   else
      {
      /* zero out earnings prior to 1951 */
      for (i1 = 0; i1 < 14; i1++)
         piadata -> vearn[(int)OLD_START][i1] = 0.;
      if (piadata -> methos == 4) {
         /* 1967 old-start allocates over 9 years, up to $3000 per year */
         piadata -> idivos = 9;
         i2 = 5;
         i3 = 13;
         }
      else {
         /* 1977 old-start allocates over variable number of years */
         i2 = (1930 > piadata -> kbirth[2]) ? piadata -> kbirth[2] - 1916 : 13;
         if (i2 < 0)
            i2 = 0;
         i3 = 13;
         if (workerdata -> ioasdi == SURVIVOR && 1951 > workerdata -> ideath[2])
            i3 = workerdata -> ideath[2] - 1938;
         if (workerdata -> valdi && piadata -> frzyr1 < 1951)
            i3 = piadata -> frzyr1 - 1938;
         if (i3 < 0)
            i3 = 0;
         if (i2 > i3)
            i2 = i3;
         piadata -> idivos = i3 - i2 + 1;
         }
      if (piadata -> stot[workerdata -> totalize] >
         piaparms -> base[0] * (double)piadata -> idivos) {
         /* if over $3000 allocated per year, allocate $3000 per year
          * up to 14 years */
         piadata -> idivos = (piadata -> stot[workerdata -> totalize] > 14. *
            piaparms -> base[0]) ? 14 :
            (int)floor((piadata -> stot[workerdata -> totalize] + .001) /
            piaparms -> base[0]);
         if (piadata -> idivos > i3 + 1)
            piadata -> idivos = i3 + 1;
         i2 = (piadata -> idivos > i3) ? 0 : i3 - piadata -> idivos;
         for (i1 = i2+1; i1 < i3+1; i1++)
            piadata -> vearn[(int)OLD_START][i1] = piaparms -> base[0];
         /* if any earnings remain, put in next prior year */
         piadata -> vearn[(int)OLD_START][i2] =
            piadata -> stot[workerdata -> totalize] -
            floor(piadata -> stot[workerdata -> totalize] /
            piaparms -> base[0]) * piaparms -> base[0];
         }
      else
         /* if less than $3000 per year, fill out earnings array */
         for (i1 = i2; i1 < i3+1; i1++)
            piadata -> vearn[(int)OLD_START][i1] =
               piadata -> stot[workerdata -> totalize] / (double)piadata -> idivos;
      }
}
/* Function to calculate number of increment years for old-start
 */
static increment(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   register i1; /* loop counter */
   int temp; /* number of increment years */

   switch (piadata -> methos)
   {
   case 0:
   case 1:
   case 2:
   case 3:
      /* under 1939 amendments, 1950 old-start, or 1965 old-start, one
       * increment year for each year of at least $200 of earnings */
      temp = 0;
      for (i1 = 0; i1 < 14; i1++)
         if (piadata -> earnst[workerdata -> totalize][i1] >= 200.)
            temp++;
      break;
   case 4:
      /* under 1967 old-start, 14 increment years */
      temp = 14;
      break;
   case 5:
   case 6:
   case 7:
      /* under 1977 old-start, one increment year for each $1650 of
       * cumulative earnings, with minimum 4 and maximum 14 */
      temp = ((int)piadata -> stot[workerdata -> totalize] / 1650 < 4) ?
         4 : (int)piadata -> stot[workerdata -> totalize] / 1650;
      if (temp > 14)
         temp = 14;
      break;
   }
   return(temp);
}
/* Function to fill out PIB conversion table
 */
static int getpibtb(
PIAPARMS *piaparms,  /* piaparms structure */
char *filename,  /* name of file with conversion table */
int size)  /* number of entries in conversion table */
{
   float *fp;  /* temporary pointer to float */
   register i1;  /* loop counter */
   FILE *in;  /* file handle for conversion table */
   char *infile;  /* full pathname of file with conversion table */

   concat(&infile, piaparms -> directory, filename);
   /* open file with conversion table */
   if ((in = fopen(infile, "r")) == (FILE *)NULL)
      return(229);
   for (i1 = 0, fp = piaparms -> pibtable; i1 < size; i1++, fp++) {
      if (fscanf(in, "%f", fp) <= 0) {
         fclose(in);
         return(230);
         }
      }
   fclose(in);
   return(0);
}
/* Function to determine if windfall elimination provision applies
 */
static int wep_app(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   if ((double)workerdata -> pubpen > 0. && piadata -> ielgyr[1] > 1985 &&
      workerdata -> ioasdi != SURVIVOR)
      return(1);
   else
      return(0);
}
/* Function to calculate catch-up index
 */
static void icchupc(
PIADATA *piadata,  /* piadata structure */
int istart)  /* current year */
{
   piadata -> icchup = (piadata -> ielgyr[1] >= istart) ?
      piadata -> ielgyr[1] - istart : 0;
   if (piadata -> icchup > 9)
      piadata -> icchup = 9;
}
/* Function to calculate number of QC's required for insured status
 */
int qcreqcal(
PIADATA *piadata)  /* piadata structure */
{
   return((piadata -> nelap < 6) ? 6 : piadata -> nelap);
}
/* Function to calculate number of years of coverage for special minimum
 * or windfall elimination provision
 */
static int spmntcal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type piatype)  /* special minimum or wage-indexed (wep) */
{
   int totyears;  /* total years of coverage */
   double factor;  /* percentage of old-law base required for year of
      coverage */
   int i1,i2,i3;  /* loop counters */

   /* find years of coverage before 1951; credit 1 year of coverage for
    * each $900 of pre-1951 earnings */
   totyears = (int) floor(piadata -> stot[workerdata -> totalize] / 900.);
   /* limit pre-1951 years of coverage to 14 */
   if (totyears > 14)
      totyears = 14;
   if (piatype == SPEC_MIN)
      piadata -> iorder[(int)SPEC_MIN][13] = totyears;
   /* count years after 1950 */
   i2 = (workerdata -> ibegin > 1950) ? workerdata -> ibegin - 1937 : 14;
   i3 = (workerdata -> iend < piadata -> iernyr) ? workerdata -> iend - 1937 :
      piadata -> iernyr - 1937;
   for (i1 = i2; i1 <= i3; i1++) {
      /* set applicable percent of wage base */
      if (piatype == SPEC_MIN) {
         factor = (i1 > 1990 - 1937) ?
            piaparms -> spmnper[1] : piaparms -> spmnper[0];
         piaparms -> pspmin[i1-14] = (float)factor;
         }
      else
         factor = piaparms -> spmnper[0];
      /* use actual, not theoretical, earnings */
      if (piadata -> earnst[0][i1] >= factor*(piaparms -> base77[i1])) {
         if (piatype == SPEC_MIN)
            piadata -> iorder[(int)SPEC_MIN][i1] = 1;
         totyears++;
         }
      }
   return(totyears);
}
/* Function to set amount per year of coverage in special minimum
 */
static double spmincal(
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int date1[3])  /* month, day, and year of amount */
{
#ifdef LAWCHG
   /* change dollar amount, if applicable */
   if ((lawchgdata -> jind[12] == 1 || lawchgdata -> jind[12] == 3) &&
      piadata -> ielgyr[1] >= lawchgdata -> jstart[0][12])
      return(lawchgdata -> aspmin);
#endif
   /* set amount per year depending on date of entitlement */
   /* from Jan 1973 to Feb 1974, was $8.50 per year of coverage */
   if (compmdy(date1, piaparms -> amend722) >= 0 &&
      compmdy(date1, piaparms -> amend741) < 0)
      return(8.50);
   /* from March 1974 to Dec 1978, was $9.00 per year of coverage */
   if (compmdy(date1, piaparms -> amend77) < 0)
      return(9.00);
   /* for January 1979 and later, use $11.50 per year of coverage */
   return(11.50);
}
/* Function to calculate pro rata totalization benefit
 */
static void prorate(
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type piatype)  /* type of pia */
{
   piadata -> piaeltot[(int)piatype] = piadata -> piael[(int)piatype][0];
   piadata -> piatot[(int)piatype] = piadata -> piaent[(int)piatype];
   piadata -> piaent[(int)piatype] =
      round(piadata -> qctot * piadata -> piaent[(int)piatype] /
         (double)(4 * piadata -> n),
      piadata -> iycpi[(int)PIA_TABLE][3]);
   piadata -> piael[(int)piatype][0] =
      decnvtpia(piaparms, piadata -> ielgyr[1],
      piadata -> iycpi[(int)piatype][3] - piadata -> iycpi[(int)piatype][0] + 1,
      piadata -> piaent[(int)piatype], piadata -> icchup);
   if (piadata -> ielgyr[1] > 1978) {
      piadata -> ametot[(int)piatype] = piadata -> ame[(int)piatype];
      piadata -> ame[(int)piatype] =
         decnvtame(piadata, piadata -> piael[(int)piatype][0]);
      }
}
/* Function to deconvert pia back to year of eligibility
 */
static double decnvtpia(
PIAPARMS *piaparms,  /* piaparms structure */
int melgyr,  /* year of eligibility */
int number,  /* number of years for which benefit increases are 
   applied */
double pia77,  /* PIA or MFB to be increased */
int mcchup)  /* index of year of eligibility for catch-up benefit
   increases */
{
   int i1,i3; /* temporary indices */

   /* return if there are no CPI increases applied */
   if (number <= 0)
      return(pia77);
   /* do not handle year of eligibility prior to 1979 */
   if (melgyr < 1979)
      return(pia77);
   i1 = melgyr - 1951; /* first year of benefit increase */
   /* divide out increases, starting with last one */
   for (i3 = i1+number-1; i3 > i1-1; i3--) {
      pia77 = unround(pia77/(1. + (piaparms -> cpiinc[i3])/100.), i3+1951);
      pia77 = unbicchp(piaparms,i3,pia77,mcchup);
      }
   return(pia77);
}
/* Function to divide out catch-up benefit increases
 */
static double unbicchp(
PIAPARMS *piaparms,  /* piaparms structure */
int i1,  /* year, minus 1950, of catch-up benefit increase */
double bcatch,  /* amount to be increased */
int i2)  /* index of year of eligibility */
{
   if (i1 < piaparms -> istart - 1948 || i1 > piaparms -> istart - 1941)
      return(bcatch);
   if (piaparms -> cachup[i2][i1 - piaparms -> istart + 1948] < .05)
      return(bcatch);
   return(unround(bcatch /
      (piaparms -> cachup[i2][i1 - piaparms -> istart + 1948] / 100. + 1.),
      i1 + 1950));
}
/* Function to return a PIA or MFB unrounded to the appropriate
 * multiple of $.10.
 */
static double unround(
double crude,  /* unrounded PIA or MFB */
int l)  /* year of benefit increase, or year prior to year of wage-
   indexed formula */
{
   double q; /* fraction of $.01 above which PIA is rounded to next
      higher dime, for June 1981 and earlier benefit increases, and
      1982 and earlier wage-indexed formula AIME PIA's. */
   double x100; /* number of cents that PIA is less than a multiple of
      a dime */

   /* round up to higher dime for June 1982 and later increases */
   if (l > 1981)
      return(floor(10.*crude+.999)/10.);
   /* for rounding-down to dime, use half-cent rule for 1972 and earlier
      increases; for 1973-81 benefit increases, round down to dime in
      any case not already an exact multiple of $.10. */
   q = (l >= 1973) ? 9.99 : 9.501;
   if ((x100 = 10. - fmod((double)crude*100.,10.)) > q)
   /* if within tolerance of q, do not round down */
      return(crude + x100/100.);
   /* otherwise round down to dime */
   else
      return(crude + x100/100. - .10);
}
/* Function to find AME from PIA in PIA table
 */
static float mfboldcal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
enum pia_type method,  /* type of pia */
int belowmin)  /* 0 to not adjust for PIA below minimum, 1 to adjust */
{
   double piasm; /* test PIA */
   int rv;  /* return value */

   /* start with lowest applicable AME */
   rv = 75;
   do {
      rv++;
      /* test to see which PIA table to use */
      if (compmdy(workerdata -> bendate, piaparms -> amend742) < 0)
         (void) pl1972(workerdata, piaparms, &piasm,
            &piadata -> mfbent[(int)method], rv);
      else {
         /* apply benefit increases if June 1975 or later */
#ifdef LAWCHG
         lawchgdata -> z4 = 0.;
#endif
         piadata -> itabel[(int)method] = cpibas(workerdata, piaparms, piadata,
            lawchgdata, piadata -> iycpi[(int)method][3] - 1950,
            0, method, &piasm, &piadata -> mfbent[(int)method], (double)rv);
         }
      } while (piadata -> piaent[(int)method] > piasm && rv < 1000);
   if (belowmin && rv == 76)
      piadata -> mfbent[(int)method] =
         round(1.5 * piadata -> piaent[(int)method],
         piadata -> iycpi[(int)PIA_TABLE][3]);
   return((float)rv);
}
/* Function to deconvert AIME from raw PIA
 */
static double decnvtame(
PIADATA *piadata,  /* piadata structure */
double piasub)  /* pia at eligibility in this subroutine */
{
   double rv;  /* return value */

   if (piasub < piadata -> percp[0] * piadata -> bendpia[1])
      rv = piasub / piadata -> percp[0];
   else {
      if (piasub < ((piadata -> percp[0] - piadata -> percp[1]) *
         piadata -> bendpia[1] +
         piadata -> percp[1] * piadata -> bendpia[2]))
         rv = (piasub - (piadata -> percp[0] - piadata -> percp[1]) *
            piadata -> bendpia[1]) / piadata -> percp[1];
      else
         rv = (piasub - (piadata -> percp[0] - piadata -> percp[1]) *
            piadata -> bendpia[1] -
            (piadata -> percp[1] - piadata -> percp[2]) *
            piadata -> bendpia[2]) / piadata -> percp[2];
      }
   if (piadata -> ielgyr[1] > 1982)
      return(ceil(rv));
   else
      return(floor(rv));
}
