/*
 * @(#)piacallc.C	1.28   5/10/94
 * Function to calculate a PIA
 */

#ifndef lint
static char *piacallcID = " @(#)piacallc.C	1.28   5/10/94 ";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "pia.h"
#include "compdate.h"

/* Function to determine reduction factor for Roybal or Sanford proposal
 */
float z4set(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   double rv;  /* return value */

   rv = 0.;
   if (lawchgdata -> jind[20] > 0)
      rv = 3.*(double)(piadata -> ielgyr[1] - 1977);
   if (lawchgdata -> jind[21] > 1 && workerdata -> ioasdi != DISABILITY &&
      piadata -> kbirth[2] > 1916 && piadata -> kbirth[2] < 1930) {
      rv = 5. + 2.*(double)(piadata -> ielgyr[0] - 1978);
      rv += ((workerdata -> ient[2] > piadata -> ielgyr[0]) ?
         (double)(workerdata -> ient[2] - piadata -> ielgyr[0]) : 3.);
      }
   if (lawchgdata -> jind[24] > 0)
      rv = 3.25*(double)(piadata -> ielgyr[1] - 1977);
   if (rv < 0.)
      rv = 0.;
   return((float)rv);
}
/* Function to set 3-year limitation starting year for old starts
 */
int i49cal1(
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   /* use 1979 for HR 1917 from 99th Congress */
   if (lawchgdata -> jind[19] > 0 && piadata -> methos == 6)
      return(41);
   /* use age 62 to start 3-year limitation for Daub */
   if (lawchgdata -> jind[18] > 0 && piadata -> methos == 5 &&
      piadata -> ielgyr[0] > 1978)
      return(piadata -> ielgyr[0]-1937);
   /* otherwise use last year of earnings */
   return(piadata -> iernyr - 1937);
}
/* Function to set 3-year limitation starting year for new starts
 */
int i49cal2(
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   /* use 1979 for HR 1917 from 99th Congress */
   if (lawchgdata -> jind[19] > 0)
      return(27);
   /* use age 62 to start 3-year limitation for Daub */
   if (lawchgdata -> jind[18] > 0)
      return(piadata -> ielgyr[0]-1937);
   /* otherwise use last year of earnings */
   return(piadata -> iernyr - 1937);
}
/* Function to reset transitional guarantee
 */
void trguarlc(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int itrans)  /* transitional guarantee period */
{
   int i1;  /* rounding index */
   static double facm18[5] = { .4, .65, .7, .75, .9 };
      /* special weighting factor for ad hoc blend weights */
   double facm;  /* weighting factor */

   /* set rounding index */
   i1 = (workerdata -> ient[0] >= (int)JUNE) ?
      workerdata -> ient[2] : workerdata -> ient[2] - 1;
   if (piadata -> piaent[(int)TRANS_GUAR] > 0. && lawchgdata -> jind[16] > 0) {
      facm = (double)(1979+itrans-piadata -> ielgyr[1])/(double)(itrans+1);
      piadata -> piaent[(int)TRANS_GUAR] = piadata -> piaent[(int)WAGE_IND] +
         facm * (piadata -> piaent[(int)PIA_TABLE] -
         piadata -> piaent[(int)WAGE_IND]);
      piadata -> mfbent[(int)TRANS_GUAR] = piadata -> mfbent[(int)WAGE_IND] +
         facm * (piadata -> mfbent[(int)PIA_TABLE] -
         piadata -> mfbent[(int)WAGE_IND]);
      piadata -> piaent[(int)PIA_TABLE] =
         piadata -> mfbent[(int)PIA_TABLE] = 0.;
      }
   if (piadata -> piaent[(int)TRANS_GUAR] > 0. && lawchgdata -> jind[17] > 0) {
      facm = (double)(1979+itrans-piadata -> ielgyr[1])/(double)(itrans+1);
      piadata -> piaent[(int)TRANS_GUAR] = piadata -> piaent[(int)WAGE_IND] +
         facm * (piadata -> piaent[(int)TRANS_GUAR] -
         piadata -> piaent[(int)WAGE_IND]);
      piadata -> mfbent[(int)TRANS_GUAR] = piadata -> mfbent[(int)WAGE_IND] +
         facm * (piadata -> mfbent[(int)TRANS_GUAR] -
         piadata -> mfbent[(int)WAGE_IND]);
      }
   if (piadata -> piaent[(int)TRANS_GUAR] > 0. && lawchgdata -> jind[18] > 0) {
      facm = facm18[piadata -> ielgyr[1]-1978];
      piadata -> piaent[(int)PIA_TABLE] -=
         (piadata -> piaent[(int)PIA_TABLE] > piadata -> piaent[(int)WAGE_IND] ?
         facm * (piadata -> piaent[(int)PIA_TABLE] -
         piadata -> piaent[(int)WAGE_IND]) : 0.);
      piadata -> mfbent[(int)PIA_TABLE] -=
         (piadata -> mfbent[(int)PIA_TABLE] > piadata -> mfbent[(int)WAGE_IND] ?
         facm * (piadata -> mfbent[(int)PIA_TABLE] -
         piadata -> mfbent[(int)WAGE_IND]) : 0.);
      if (piadata -> piaent[(int)PIA_TABLE] >
         piadata -> piaent[(int)TRANS_GUAR])
         piadata -> piaent[(int)TRANS_GUAR] =
            piadata -> piaent[(int)PIA_TABLE];
      if (piadata -> mfbent[(int)PIA_TABLE] >
         piadata -> mfbent[(int)TRANS_GUAR])
         piadata -> mfbent[(int)TRANS_GUAR] =
            piadata -> mfbent[(int)PIA_TABLE];
      piadata -> piaent[(int)PIA_TABLE] =
         piadata -> mfbent[(int)PIA_TABLE] = 0.;
      }
   if (lawchgdata -> jind[25] > 0 && workerdata -> ioasdi != DISABILITY &&
      piadata -> kbirth[2] > 1916 && piadata -> kbirth[2] < 1927) {
      facm = .68 - .04*(workerdata -> ient[2] - piadata -> ielgyr[0] > 3 ? 3 :
         workerdata -> ient[2] - piadata -> ielgyr[0]) +
         .04 * (piadata -> ielgyr[0] - 1978);
      if (facm > 1.)
         facm = 1.;
      if (facm < 0.)
         facm = 0.;
      if (piadata -> piaent[(int)WAGE_IND] >
         piadata -> piaent[(int)TRANS_GUAR])
         piadata -> piaent[(int)TRANS_GUAR] =
            piadata -> piaent[(int)WAGE_IND];
      if (piadata -> piaent[(int)SPEC_MIN] >
         piadata -> piaent[(int)TRANS_GUAR])
         piadata -> piaent[(int)TRANS_GUAR] =
            piadata -> piaent[(int)SPEC_MIN];
      if (piadata -> piaent[(int)REIND_WID] >
         piadata -> piaent[(int)TRANS_GUAR])
         piadata -> piaent[(int)TRANS_GUAR] =
            piadata -> piaent[(int)REIND_WID];
      if (piadata -> mfbent[(int)WAGE_IND] >
         piadata -> mfbent[(int)TRANS_GUAR])
         piadata -> mfbent[(int)TRANS_GUAR] =
            piadata -> mfbent[(int)WAGE_IND];
      if (piadata -> mfbent[(int)SPEC_MIN] >
         piadata -> mfbent[(int)TRANS_GUAR])
         piadata -> mfbent[(int)TRANS_GUAR] =
            piadata -> mfbent[(int)SPEC_MIN];
      if (piadata -> mfbent[(int)REIND_WID] >
         piadata -> mfbent[(int)TRANS_GUAR])
         piadata -> mfbent[(int)TRANS_GUAR] =
            piadata -> mfbent[(int)REIND_WID];
      piadata -> piaent[(int)TRANS_GUAR] = piadata -> piaent[(int)PIA_TABLE] -
         (piadata -> piaent[(int)PIA_TABLE] > piadata -> piaent[(int)TRANS_GUAR] ? 
         facm * (piadata -> piaent[(int)PIA_TABLE] -
         piadata -> piaent[(int)TRANS_GUAR]) : 0.);
      piadata -> mfbent[(int)TRANS_GUAR] = piadata -> mfbent[(int)PIA_TABLE] -
         (piadata -> mfbent[(int)PIA_TABLE] > piadata -> mfbent[(int)TRANS_GUAR] ? 
         facm * (piadata -> mfbent[(int)PIA_TABLE] -
         piadata -> mfbent[(int)TRANS_GUAR]) : 0.);
      piadata -> piaent[(int)PIA_TABLE] =
         piadata -> mfbent[(int)PIA_TABLE] = 0.;
      }
   piadata -> piaent[(int)TRANS_GUAR] =
      round(piadata -> piaent[(int)TRANS_GUAR],i1);
   piadata -> mfbent[(int)TRANS_GUAR] =
      round(piadata -> mfbent[(int)TRANS_GUAR],i1);
}
/* Function to project bend points for changes in law
 */
void bpcal(
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int melgyr,  /* year of eligibility */
double *mbendpia)  /* benefit formula bend points */
{
   int i,i2,i3;  /* loop counters */
   double factor;  /* factor used in various places */

   if (lawchgdata -> jind[1] > 0 && melgyr >= lawchgdata -> jstart[0][1])
      {
      i2 = (melgyr > lawchgdata -> jstart[1][1]) ?
         lawchgdata -> jstart[1][1] : melgyr;
      i3 = lawchgdata -> jstart[0][1];
      /* get last bend points under present law */
      bendpiac(piaparms,i3-1,mbendpia);
      /* project by percent of average wage increase */
      for (i = i3-1939; i <= i2-1939; i++) {
         factor = 1. + lawchgdata -> pbp * (double)piaparms -> fqinc[i] / 100.;
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      /* if beyond ending year, continue projecting at wage rate */
      if (melgyr > lawchgdata -> jstart[1][1]) {
         factor = piaparms -> fq[melgyr-1939] / piaparms -> fq[i2-1939];
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      }
   if (lawchgdata -> jind[2] > 0 && melgyr >= lawchgdata -> jstart[0][2])
      {
      i2 = (melgyr > lawchgdata -> jstart[1][2]) ?
         lawchgdata -> jstart[1][2] : melgyr;
      i3 = lawchgdata -> jstart[0][2];
      /* get last bend points under present law */
      bendpiac(piaparms,i3-1,mbendpia);
      /* project by cpi increase */
      for (i = i3-1953; i <= i2-1953; i++) {
         factor = 1. + piaparms -> cpiinc[i] / 100.;
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      /* if beyond ending year, continue projecting at wage rate */
      if (melgyr > lawchgdata -> jstart[1][2]) {
         factor = piaparms -> fq[melgyr-1939] / piaparms -> fq[i2-1939];
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      }
   if (lawchgdata -> jind[4] > 0 && melgyr >= lawchgdata -> jstart[0][4])
      {
      i3 = lawchgdata -> jstart[0][4] - 1939;
      /* project off of alternate bend points */
      factor = piaparms -> fq[melgyr-1939] / piaparms -> fq[i3];
      mbendpia[1] = floor(lawchgdata -> bendpalt[1] * factor + .5);
      mbendpia[2] = floor(lawchgdata -> bendpalt[2] * factor + .5);
      }
   if (lawchgdata -> jind[5] > 0 && melgyr >= lawchgdata -> jstart[0][5])
      {
      i2 = (melgyr > lawchgdata -> jstart[1][5]) ?
         lawchgdata -> jstart[1][5] : melgyr;
      i3 = lawchgdata -> jstart[0][5];
      /* get last bend points under present law */
      bendpiac(piaparms,i3-1,mbendpia);
      /* project by ad hoc bend point increases */
      for (i = i3-1951; i <= i2-1951; i++) {
         factor = 1. + lawchgdata -> bpinc[i] / 100.;
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      /* if beyond ending year, continue projecting at wage rate */
      if (melgyr > lawchgdata -> jstart[1][5]) {
         factor = piaparms -> fq[melgyr-1939] / piaparms -> fq[i2-1939];
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      }
   if (lawchgdata -> jind[6] > 0 && melgyr >= lawchgdata -> jstart[0][6])
      {
      i2 = (melgyr > lawchgdata -> jstart[1][1]) ?
         lawchgdata -> jstart[1][6] : melgyr;
      i3 = lawchgdata -> jstart[0][6];
      /* get last bend points under present law */
      bendpiac(piaparms,i3-1,mbendpia);
      /* project by average wage increase minus a percentage */
      for (i = i3-1939; i <= i2-1939; i++) {
         factor = 1. + ((double)piaparms -> fqinc[i] - lawchgdata -> cp)/100.;
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      /* if beyond ending year, continue projecting at wage rate */
      if (melgyr > lawchgdata -> jstart[1][6]) {
         factor = piaparms -> fq[melgyr-1939] / piaparms -> fq[i2-1939];
         mbendpia[1] = floor(mbendpia[1]*factor+.5);
         mbendpia[2] = floor(mbendpia[2]*factor+.5);
         }
      }
}
/* Function to reset benefit formula percents for changes in law
 */
void percal(
Lawchg *lawchgdata,  /* Lawchg structure */
int melgyr,  /* year of eligibility */
double *mpercp)  /* benefit formula percents */
{
   int i,i1;  /* loop counters */

   if (lawchgdata -> jind[4] > 0 && melgyr >= lawchgdata -> jstart[0][4])
      {
      mpercp[0] = lawchgdata -> percpa[0];
      mpercp[1] = lawchgdata -> percpa[1];
      mpercp[2] = lawchgdata -> percpa[2];
      }
   if (lawchgdata -> jind[8] > 0 && melgyr >= lawchgdata -> jstart[0][8])
      {
      i1 = (melgyr > lawchgdata -> jstart[1][8]) ?
         lawchgdata -> jstart[1][8] - lawchgdata -> jstart[0][8] + 1 :
         melgyr - lawchgdata -> jstart[0][8] + 1;
      for (i = 0; i < 3; i++)
         mpercp[i] = mpercp[i]*pow(1. - lawchgdata -> cp / 100., (double)i1);
      }
}
/* Function to calculate indexing series when a mixture of wages and CPI
 */
void factcal(
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int i,i1;  /* loop counters */

   i1 = lawchgdata -> jstart[0][3] - 1950 - 1 - 2;
   for (i = 0; i < i1; i++)
      lawchgdata -> fact[i] = piaparms -> fq[i+14];
   for (i = i1; i < piaparms -> maxyears - 14; i++)
      lawchgdata -> fact[i] = (lawchgdata -> jstart[1][3] - 1950 < i + 3) ?
         lawchgdata -> fact[i-1] *
         ((double)piaparms -> fqinc[i+14] / 100. + 1.) :
         lawchgdata -> fact[i-1] * (piaparms -> cpiinc[i] / 100. + 1.);
}
