/*
 * @(#)piadata.C	1.2   3/17/94
 * Various functions to set up data to calculate and print out a PIA
 */

#ifndef lint
static char *piadataID = " @(#)piadata.C	1.2   3/17/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include <stdlib.h>
#include "piadata.h"

/* Function to initialize arrays used in piacal
 */
int initcal(
PIADATA **piadatap,  /* piadata structure */
int maxyears,  /* maximum number of years projected, starting with 1937 */
int maxchr)  /* maximum string length allowed */
{
   int i;  /* loop counter */

   if ((*piadatap  = (PIADATA *)malloc(sizeof(PIADATA))) == (PIADATA *)0)
      return(283);
   /* allocate memory for earnings */
   for (i = 0; i < 6; i++) {
      if (((*piadatap) -> earnst[i] = (double *)calloc((unsigned)maxyears,
         sizeof(double))) == (double *)0)
         return(283);
      }
   /* allocate memory for indicator for earnings used */
   for (i = 0; i < MAXCAL; i++) {
      if (((*piadatap) -> iorder[i] = (int *)calloc((unsigned)maxyears,
         sizeof(int))) == (int *)0)
         return(283);
      }
   /* allocate memory for earnings multiplied by average earnings */
   if (((*piadatap) -> uearn = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(283);
   /* allocate memory for unordered earnings */
   for (i = 0; i < MAXCAL; i++) {
      if (((*piadatap) -> vearn[i] = (double *)calloc((unsigned)maxyears,
         sizeof(double))) == (double *)0)
         return(283);
      }
   /* allocate memory for time series of PIAs */
   for (i = 0; i < MAXCAL; i++) {
      if (((*piadatap) -> piael[i] = (double *)calloc((unsigned)maxyears,
         sizeof(double))) == (double *)0)
         return(283);
      }
   /* allocate memory for time series of MFBs */
   for (i = 0; i < MAXCAL; i++) {
      if (((*piadatap) -> mfbel[i] = (double *)calloc((unsigned)maxyears,
         sizeof(double))) == (double *)0)
         return(283);
      }
   /* allocate memory for earnings multiplied by average earnings */
   if (((*piadatap) -> xearn = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(283);
   /* allocate memory for annual relative earnings position */
   if (((*piadatap) -> rep = (float *)calloc((unsigned)maxyears,
      sizeof(float))) == (float *)0)
      return(283);
   if (((*piadatap) -> prn_init = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0)
      return(283);
   /* set titles for type of calculation */
   (*piadatap) -> title[OLD_START] = "Old-Start Calculation";
   (*piadatap) -> title[PIA_TABLE] = "New-Start Calculation (pre-1977 Act)";
   (*piadatap) -> title[WAGE_IND] = "Wage-Indexed Formula (1977 Act)";
   (*piadatap) -> title[TRANS_GUAR] = "Transitional Guarantee (1977 Act)";
   (*piadatap) -> title[SPEC_MIN] = "Special Minimum";
   (*piadatap) -> title[REIND_WID] = "Re-indexed Widow (1983 Act)";
   (*piadatap) -> title[FROZ_MIN] = "Frozen Minimum (1977 Act)";
   return(0);
}
/* Function to parse the printer initialization string
 */
void setprn_init(
PIADATA *piadata,  /* piadata structure */
char *prn_init)  /* ascii string to parse */
{
   char *ptr;  /* temporary pointer to string form of number */
   int number;  /* number interpreted from printer initialization string */
   int i = 0;  /* character counter */

   piadata -> prn_init[0] = '\0';
   if ((ptr = strtok(prn_init, "\\")) == (char *)0)
      return;
   (void)sscanf(ptr, "%d", &number);
   piadata -> prn_init[i++] = (char)number;
   while ((ptr = strtok((char *)0, "\\")) != (char *)0) {
      (void)sscanf(ptr, "%d", &number);
      piadata -> prn_init[i++] = (char)number;
      }
   piadata -> prn_init[i] = '\0';
}
