/*
 * @(#)piadata.h	1.5   3/17/94
 * Function declarations and macros for piadata.c
 */

#ifndef __PIADATA_H
#define __PIADATA_H

#define MAXCAL 7 /* number of PIA calculation types */
#define MAXIYCPI 4  /* number of start and end years of CPI increases */

enum pia_type { OLD_START, PIA_TABLE, WAGE_IND, TRANS_GUAR, SPEC_MIN,
                 REIND_WID, FROZ_MIN };

typedef struct {
   double ame[MAXCAL];  /* average (indexed) monthly earnings */
   double ametot[MAXCAL];  /* average (indexed) monthly earnings before
                 application of totalization provision, if applicable */
   double arf; /* reduction or increment factor */
   int    arfapp;  /* 1 if highest PIA is special minimum, delayed
                 retirement credits are involved, and benefit equals
                 special minimum PIA, 2 if highest PIA is special minimum,
                 delayed retirement credits are involved, and benefit
                 equals support PIA increased by increment factor, 0
                 otherwise */
   double bendmfb[4];  /* bend points for MFB formula */
   double bendpia[3];  /* bend points for PIA formula */
   double benfit[2];  /* benefit actually payable
                 i=0 is before dollar rounding
                 i=1 is after dollar rounding */
   double cap[MAXCAL];  /* percentage cap for MFB (for DI cases) */
   char   *command1;  /* first part of command to send output to printer */
   char   *command2;  /* second part of command to send output to printer */
   char   dateln[26];  /* date and time for output */
   double *earnst[6];  /* worker earnings, 1937 to 1936+IX, used in
                 calculation:
                 0 = actual OASDI,
                 1 = attributed for totalization,
                 2 = actual OASDI limited to OASDI wage base,
                 3 = attributed for totalization limited to OASDI wage base,
                 4 = actual HI,
                 5 = actual HI limited to HI wage base */
   int    frzyr1;  /* first year wholly within disability freeze */
   int    frzyr2;  /* last year wholly within disability freeze */
   double ftearn[MAXCAL]; /* sum of high n years of earnings */
   double himfb;  /* highest applicable MFB */
   double hipia;  /* highest applicable PIA */
   int    iage[2];  /* age at entitlement of worker (years and months) */
   int    iage1[2];  /* age at benefit date of worker (years and months) */
   int    iameos;  /* old-start AME */
   int    iapp[MAXCAL]; /* 0 if method not applicable, 1 if
                 applicable, 2 if highest PIA, 3 if support PIA */
   int    iappn;  /* applicable PIA method number (see title) */
   int    iapps;  /* support PIA method number (see title) */
   int    icap[MAXCAL];  /* disability MFB cap indicator (0 for no cap,
                 1 for 1.5*PIA, 2 for .85*AIME, 3 for 1.0*PIA) */
   int    icchup; /* index of year of eligibility for catch-up
                 benefit increases */
   int    idivos;  /* divisor for old-start pre-1951 earnings */
   int    ielgyr[2]; /* worker's year of eligibility
                 i=0 is year of worker's attainment of age 62, for old-age
                   and disability, or year of worker's death, for survivor.
                 i=1 is year of eligibility after
                   considering prior disability onset. */
   int    iernyr; /* year prior to year of retirement or disability, or
                 exact year of death (last year of earnings considered) */
   int    incyrs;  /* number of old-start increment years */
   int    *iorder[MAXCAL]; /* 1 if earnings are among highest
                 n, 0 otherwise */
   int    *iprntr;  /* printer method (0 for direct write to printer,
                 1 for mass storage file) */
   int    ispmnt[2];  /* total number of years of coverage (0 for special
                 minimum, 1 for windfall elimination provision) */
   int    itabel[MAXCAL];  /* number of applicable PIA table for each
                 method */
   int    iwind;  /* windfall indicator in wage-indexed method (-1 
                 if windfall applicable, but have 30 years of coverage,
                 0 for windfall not applicable (no noncovered pension,
                 or eligible before 1986), 1 for one-half noncovered
                 pension, 2 for reduced first percentage) */
   int    iycpi[MAXCAL][MAXIYCPI]; /* years of benefit increases applied
                 j = 0 is first year,
                     1 is first year starting with year of eligibility,
                     2 is last year ending with year of entitlement,
                     3 is last year ending with year of benefit */
   int    iyrspm;  /* number of years of coverage in special minimum
                 in excess of 10, up to 30 */
   int    jage[2];  /* age of widow (years and months) */
   double jbendpia[3];  /* bend points for PIA formula under re-indexed
                 widow guarantee method (0 if not applicable) */
   int    jcchup;  /* index of year of eligibility for catch-up
                 benefit increases in re-indexed widow guarantee */
   int    jelgyr;  /* year of eligibility in re-indexed widow guarantee */
   double jpercp[3];  /* re-indexed widow PIA formula percentages */
   int    kbirth[3]; /* month, day, and year of day before birth of worker */
   int    kelgyr;  /* widow's year of eligibility */
   int    lbirth[3]; /* month, day, and year of day before birth of widow */
   int    mardri;  /* number of months of early or delayed retirement */
   int    methos; /* old-start PIA calculation method:  0 for 1939
                 Amendments, 1 for 1950 old-start, 2 for 1950 old-start
                 with 1958 conversion table, 3 for 1965 old-start, 4
                 for 1967 old-start, 5 for 1977 old-start with Jan 1978
                 old-law PIA table, 6 for 1977 old-start with Dec 1978
                 frozen PIA table, 7 for 1990 old-start */
   double mfbent[MAXCAL]; /* MFB at entitlement */
   double *mfbel[MAXCAL]; /* MFB at eligibility (i = 0) and
                 succeeding MFB's */
   double mfbrwg[MAXCAL]; /* MFB at entitlement before real-wage-
                 gain adjustment */
   int    n;  /* number of computation years */
   int    ndrop;  /* number of dropout years */
   int    ndropold;  /* number of dropout years for old-start method */
   int    nelap;  /* number of elapsed years */
   int    nelapold;  /* number of elapsed years for old-start method */
   int    nold;  /* number of computation years for old-start method */
   int    nra[2];  /* worker's normal retirement age (years and
                 months) */
   int    nradate[3];  /* date of attainment of normal retirement age
                 (month, day, and year, where day is 0) */
   int    nra1[2];  /* earliest possible retirement age (years and
                 months */
   int    nra2[2];  /* widow's normal retirement age (years and
                 months) */
   int    nra3[2];  /* widow's earliest possible retirement age (years
                 and months) */
   int    over_max;  /* 0 if no earnings over MAXEARN, 1 if some earnings
                 over MAXEARN */
   double paime[3][MAXCAL]; /* portion of AIME in each interval of
                 PIA formula, for methods 2 and 5; portion of AME in each
                 interval of PIB formula, for method 0 */
   double percm[4];  /* wage-indexed MFB formula percentages */
   double percp[3];  /* wage-indexed PIA formula percentages */
   double percw[3];  /* windfall PIA formula percentages */
   double *piael[MAXCAL]; /* PIA at eligibility (i = 0) and
                 succeeding PIA's */
   double piaeltot[MAXCAL];  /* PIA at eligibility before application of
                 totalization provision, if applicable (0 otherwise) */
   double piaent[MAXCAL]; /* PIA at entitlement for each method */
   double piarwg[MAXCAL]; /* PIA at entitlement before real-wage-
                 gain adjustment */
   double piatot[MAXCAL]; /* PIA before application of totalization
                 provision, if applicable (0 otherwise) */
   double piaw[MAXCAL]; /* PIA at eligibility before application of
                 windfall provision, if applicable (0 otherwise) */
   double pib;  /* old-start PIB before incrementing */
   double pibinc;  /* old-start PIB after incrementing */
   double ppiael[4][MAXCAL]; /* portion of AIME PIA in each 
                 interval of MFB formula */
   char  *prn_init;  /* printer initialization string, interpreted */
   int    qcdidt1[2];  /* beginning quarter and year of period of required
                 quarters of coverage for disability insured status */
   int    qcdidt2[2];  /* ending quarter and year of period of required
                 quarters of coverage for disability insured status */
   int    qcdiqtr;  /* number of quarters over which quarters of coverage
                 must be earned for disability insured status */
   int    qcdireq;  /* number of quarters of coverage required for
                 disability insured status */
   int    qcdiyr;  /* number of years over which quarters of coverage
                 must be earned for disability insured status */
   int    qcreq;  /* number of quarters of coverage required for
                 fully-insured status */
   int    qctot;  /* total number of quarters of coverage earned */
   int    qctot50;  /* number of quarters of coverage earned from 1937
                 to 1950 */
   int    qctot51;  /* number of quarters of coverage earned after 1950 */
   int    qctotdi;  /* number of quarters of coverage earned for
                 disability insured status */
   float  *rep;  /* annual relative earnings position, 1937 to
                 1936+IX */
   double repavg;  /* average relative earnings position */
   double spmin;  /* special minimum dollar amount per year of
                 coverage */
   double stot[2];  /* total earnings prior to 1951
                 0 = actual, 1 = attributed for totalization */
   double suppia;  /* support PIA when highest PIA is special minimum
                 and delayed retirement credits are involved */
   char   *title[MAXCAL];  /* titles for type of calculation */
   double *uearn; /* earnings multiplied by fq of base year in
                 wage-indexed method */
   double *vearn[MAXCAL]; /* unordered earnings as in wearn */
   double *xearn; /* earnings multiplied by FQ of base year in
                 widow guarantee method */
   }  PIADATA;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int  initcal ( PIADATA **piadatap, int maxyears, int maxchr );
void setprn_init ( PIADATA *piadata, char *prn_init );
#else
int  initcal();
void setprn_init();
#endif

#endif
