/*
 * piain.C for WindowBoss
 * Function to prepare the data for a PIA calculation
 */

#ifndef lint
static char *piainID = " piain.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <dos.h>
#include <conio.h>
#endif
#endif
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "pia.h"
#include "wnutils.h"
#include "ardri.h"
#include "compdate.h"
#include "piain.h"
#include "getdate.h"

#define ALL_FORMS          0
#define WAGE_EARNER_FORM   1
#define PEBES_FORM         2
#define NON_PEBES_FORM     3
#define QC_FORM            4
#define DIS_DEATH_FORM     5
#define NONCOV_PEN_FORM    6
#define ASSUMP_FORM        7
#define BENINC_FORM        8
#define CATCHUP_FORM       9
#define WAGEINC_FORM       10
#define PL_BASES_FORM      11
#define OL_BASES_FORM      12
#define EARNTYPE_FORM      13
#define EARNINGS_FORM      14
#define EARNHI_FORM        15
#define TAXES_FORM         16
#define NAMESSN_FORM       17

static struct pmenu viewmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   0, NAMESSN_FORM, {
   { FF,   FF3, " All",                   ALL_FORMS        },
   { FF3,  FF3, " Wage-earner data",      WAGE_EARNER_FORM },
   { FF4,  FF3, " PEBES data",            PEBES_FORM       },
   { FF5,  FF3, " Non-PEBES data",        NON_PEBES_FORM   },
   { FF6,  FF3, " Quarters of coverage",  QC_FORM          },
   { FF7,  FF3, " Disability/death data", DIS_DEATH_FORM   },
   { FF8,  FF3, " Noncovered pension",    NONCOV_PEN_FORM  },
   { FF9,  FF3, " Assumptions",           ASSUMP_FORM      },
   { FF10, FF3, " Benefit increases",     BENINC_FORM      },
   { FF11, FF3, " Catch-up increases",    CATCHUP_FORM     },
   { FF12, FF3, " Wage increases",        WAGEINC_FORM     },
   { FF13, FF3, " Present-law bases",     PL_BASES_FORM    },
   { FF14, FF3, " Old-law bases",         OL_BASES_FORM    },
   { FF15, FF3, " Type of earnings",      EARNTYPE_FORM    },
   { FF16, FF3, " OASDI earnings",        EARNINGS_FORM    },
   { FF17, FF3, " HI earnings",           EARNHI_FORM      },
   { FF18, FF3, " Type of taxes",         TAXES_FORM       },
   { FF19, FF3, " Name and SSN",          NAMESSN_FORM     },
   { 99,   99,  "",                       99               } }
   };

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void viewast ( WORKERDATA *workerdata, PIADATA *piadata );
#else
static void viewast();
#endif

/* Function to enter, review, or modify PIA data
 */
int datain(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int i2,i3;  /* loop counters */
   int rv;  /* return value */
   int choice = 0;  /* choice on starting form */
   int *zero_array = (int *)0;  /* array of zeroes to allow changes in
      earnr call */
   int ierr;  /* error indicator */

   if (zero_array == (int *)0) {
      if ((zero_array = (int *)calloc((unsigned)workerdata -> maxyears,
         sizeof(int))) == (int *)0)
         return(211);
      }
   viewast(workerdata, piadata);
  menu:
   choice = wn_popup(0,1,10,23+2*FF,NAMESSN_FORM+1+2*FF,COLOR_PAIR(4),
      COLOR_PAIR(9),&viewmenu,TRUE);
   /* handle error return */
   if (choice == 99)
      return(0);
   if (choice == 0) {
      i2 = 1;
      i3 = NAMESSN_FORM; }
   else
      i2 = i3 = choice;
   for (choice = i2; choice <= i3; choice++)
   {
   if (viewmenu.scrn[choice].t[0] == '*') {
      if (i2 == i3) {
         wn_iemsg(catstr(212));
         goto menu;
         }
      else
         continue;
      }
   switch (choice)
      {
      case WAGE_EARNER_FORM:
         if ((rv = worker1(wn,workerdata)) == ESC_CODE)
            return(rv);
         break;
      case PEBES_FORM:
        form1:
         if ((rv = worker2a(wn,workerdata)) == ESC_CODE)
            return(rv);
         setbirth(workerdata -> ibirth, piadata -> kbirth);
         /* ielgyr[1] is not yet calculated for PEBES case; use kbirth[2]+62
          * since there is no prior disability in PEBES case */
         nracal(workerdata, lawchgdata, piadata -> nra,
            piadata -> kbirth[2] + 62);
         datecal(piadata -> nradate, piadata -> kbirth, piadata -> nra);
         if ((ierr = agecheck(workerdata, piadata -> nradate)) > 0) {
            wn_iemsg(catstr(ierr));
            goto form1; }
         /* calculate early retirement age */
         nra1cal(workerdata, piaparms, piadata);
         zeroearn(workerdata);
         break;
      case NON_PEBES_FORM:
        form2:
         if ((rv = worker2b(wn,workerdata)) == ESC_CODE)
            return(rv);
         setbirth(workerdata -> ibirth, piadata -> kbirth);
         /* ielgyr[1] is not yet calculated for PEBES case; use kbirth[2]+62
          * since there is no prior disability in PEBES case */
         nracal(workerdata, lawchgdata, piadata -> nra,
            piadata -> kbirth[2] + 62);
         datecal(piadata -> nradate, piadata -> kbirth, piadata -> nra);
         /* calculate early retirement age */
         if (workerdata -> ioasdi == OLD_AGE) /* only for old-age */
            nra1cal(workerdata, piaparms, piadata);
         /* calculate age at entitlement */
         entage(piadata -> iage, piadata -> kbirth, workerdata -> ient);
         /* calculate age at benefit date */
         entage(piadata -> iage1, piadata -> kbirth, workerdata -> bendate);
         setiagepl(workerdata, 0);
         if (workerdata -> ioasdi != SURVIVOR ||
            workerdata -> jsurv != NO_SURV) {
            elgyr(workerdata, piadata, lawchgdata);
            if ((ierr = ardri(workerdata, piaparms, piadata, lawchgdata)) > 0) {
               wn_iemsg(catstr(ierr));
               goto form2;
               }
            }
         if (workerdata -> ioasdi == DISABILITY)
            /* print disability-insured message */
            wn_ihmsg(catstr(289));
         zeroearn(workerdata);
         if (workerdata -> valdi == 0 && workerdata -> ioasdi != SURVIVOR) {
            zeromdy(workerdata -> ideath);
            workerdata -> jsurv = NO_SURV;
            zeromdy(workerdata -> ionset);
            }
         break;
      case QC_FORM:
         if (qcbyyear(workerdata)) {
            if ((rv = getqc2(wn,workerdata)) == ESC_CODE)
               return(rv);
            }
         else {
            if ((rv = getqc1(wn,workerdata)) == ESC_CODE)
               return(rv);
            }
         break;
      case DIS_DEATH_FORM:
        form5:
         if ((rv = disdeath(wn, workerdata)) == ESC_CODE)
            return(rv);
         if (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv ==
            AGED_WID)
            {
            setbirth(workerdata -> jbirth, piadata -> lbirth);
            entage(piadata -> jage, piadata -> lbirth, workerdata -> ient);
            }
         else
            zeromdy(piadata -> lbirth);
         elgyr(workerdata, piadata, lawchgdata);
         if ((ierr = ardri(workerdata, piaparms, piadata, lawchgdata)) > 0) {
            wn_iemsg(catstr(ierr));
            goto form5; }
         break;
      case NONCOV_PEN_FORM:
         if ((rv = nonpen(wn,workerdata)) == ESC_CODE)
            return(rv);
         break;
      case ASSUMP_FORM:
         if ((rv = assumpr(wn, workerdata)) == ESC_CODE)
            return(rv);
         if (workerdata -> anscch != 'Y')
            /* zero out catch-up benefit increases */
            zerocch(workerdata -> cachup);
         break;
      case BENINC_FORM:
         if ((rv = benincr(wn, workerdata -> cpiinc, workerdata -> istart,
            workerdata -> bendate[2], 2,
            "%benefit increases%")) == ESC_CODE)
            return(rv);
         break;
      case CATCHUP_FORM:
         if ((rv = benred(wn, workerdata)) == ESC_CODE)
            return(rv);
         break;
      case WAGEINC_FORM:
         if ((rv = avgred(wn, workerdata -> fqinc, workerdata -> istart - 1,
            workerdata -> bendate[2], 2, "%avg wage increases%"))
            == ESC_CODE)
            return(rv);
         break;
      case PL_BASES_FORM:
         if ((rv = earnr(wn, workerdata -> istart + 1,
            workerdata -> bendate[2], workerdata -> base, workerdata -> maxearn,
            zero_array, "     Wage bases     ", "%wage bases%")) == ESC_CODE)
            return(rv);
         break;
      case OL_BASES_FORM:
         if ((rv = earnr(wn, workerdata -> istart + 1,
            workerdata -> bendate[2], workerdata -> base77,
            workerdata -> maxearn, zero_array,
            " Old-law wage bases ", "%old-law wage bases%")) == ESC_CODE)
            return(rv);
         break;
      case EARNTYPE_FORM:
         if ((rv = earntyper(wn, workerdata)) == ESC_CODE)
            return(rv);
         break;
      case EARNINGS_FORM:
         minpro(piaparms);
         piadata -> over_max = earnpr(workerdata, piaparms);
         if ((rv = earnr(wn, workerdata -> ibegin1, workerdata -> iend1,
            workerdata -> earnpebs, workerdata -> maxearn,
            (int *)workerdata -> earntype, "   OASDI earnings   ",
            "%oasdi earnings%")) == ESC_CODE)
            return(rv);
         break;
      case EARNHI_FORM:
         if ((rv = earnr(wn, workerdata -> ibegin, workerdata -> iend,
            workerdata -> earnhi, workerdata -> maxearn, zero_array,
            "    HI earnings     ", "%hi earnings%")) == ESC_CODE)
            return(rv);
         break;
      case TAXES_FORM:
         if ((rv = taxr(wn, workerdata)) == ESC_CODE)
            return(rv);
         break;
      case NAMESSN_FORM:
         if ((rv = namessn(wn,workerdata)) == ESC_CODE)
            return(rv);
         break;
      }  /* end switch */
   if (i2 != i3)
      viewast(workerdata, piadata);
   }  /* end for */
   return(0);
}
/* Function to set asterisks for assumptions
 */
static void viewast(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   if (workerdata -> joasdi == PEBS_CALC) {
      viewmenu.scrn[PEBES_FORM].t[0] = ' ';
      viewmenu.scrn[NON_PEBES_FORM].t[0] = '*'; }
   else {    
      viewmenu.scrn[PEBES_FORM].t[0] = '*';
      viewmenu.scrn[NON_PEBES_FORM].t[0] = ' '; }
   if (piadata -> kbirth[2] + 62 > 1985 && workerdata -> joasdi != SURVIVOR)
      viewmenu.scrn[NONCOV_PEN_FORM].t[0] = ' ';
   else {
      viewmenu.scrn[NONCOV_PEN_FORM].t[0] = '*';
      setpubpen(workerdata, (float)0.);
      }
   if (lastqcyr(workerdata) >= workerdata -> ibegin)
      viewmenu.scrn[QC_FORM].t[0] = ' ';
   else {
      viewmenu.scrn[QC_FORM].t[0] = '*';
      workerdata -> qctottd = workerdata -> qctot51td = 0;
      }
   if (workerdata -> valdi == 0 && workerdata -> ioasdi != SURVIVOR)
      viewmenu.scrn[DIS_DEATH_FORM].t[0] = '*';
   else
      viewmenu.scrn[DIS_DEATH_FORM].t[0] = ' ';
   /* set PEBS assumptions */
   if (workerdata -> joasdi == PEBS_CALC) {
      /* only initialize assumptions if out of range */
      if (pebsasmchk(workerdata))
         workerdata -> ialtbi = workerdata -> ialtaw = PEBS_ASSUM;
      setibasch(workerdata, 1);
      }
   else
      {
      if (need_bi(workerdata) == 0)
         workerdata -> ialtbi = FLAT;
      if (need_aw(workerdata) == 0)
         workerdata -> ialtaw = FLAT;
      }
   if (need_bi(workerdata) || need_aw(workerdata))
      viewmenu.scrn[ASSUMP_FORM].t[0] = ' ';
   else
      viewmenu.scrn[ASSUMP_FORM].t[0] = '*';
   if (workerdata -> ialtbi == OTHER_ASSUM)
      viewmenu.scrn[BENINC_FORM].t[0] = ' ';
   else
      viewmenu.scrn[BENINC_FORM].t[0] = '*';
   if (workerdata -> anscch == 'Y')
      viewmenu.scrn[CATCHUP_FORM].t[0] = ' ';
   else
      viewmenu.scrn[CATCHUP_FORM].t[0] = '*';
   if (workerdata -> ialtaw == OTHER_ASSUM)
      viewmenu.scrn[WAGEINC_FORM].t[0] = ' ';
   else
      viewmenu.scrn[WAGEINC_FORM].t[0] = '*';
   if (workerdata -> ibasch == 2) {
      viewmenu.scrn[PL_BASES_FORM].t[0] = ' ';
      viewmenu.scrn[OL_BASES_FORM].t[0] = ' ';
      }
   else {
      viewmenu.scrn[PL_BASES_FORM].t[0] = '*';
      viewmenu.scrn[OL_BASES_FORM].t[0] = '*';
      }
#if !defined(EXPANDED_PEBES)
   if (workerdata -> joasdi == PEBS_CALC)
      viewmenu.scrn[EARNTYPE_FORM].t[0] = '*';
   else
#endif
      viewmenu.scrn[EARNTYPE_FORM].t[0] = ' ';
   if (workerdata -> mqge)
      viewmenu.scrn[EARNHI_FORM].t[0] = ' ';
   else
      viewmenu.scrn[EARNHI_FORM].t[0] = '*';
}
/* Function to display current directory's files ending in ".pia"
 */
int dispdir(
WINDOW *wn,  /* window to use */
char *directory,  /* directory with files */
int limit)  /* trigger to limit output (0 for none, 1 for 13-line limit) */
{
   char cases[MAXFILES][NAMELEN]; /* array of stored cases */
   int count; /* number of cases */
   register i1 = 0; /* case counter */
#if DLC > 0
   struct FIND *p; /* file name ending in ".pia", Datalight */
#endif
#ifdef _MSC_VER
   struct _find_t p; /* file name ending in ".pia", Microsoft */
#endif
   char *infile;  /* pathname of cases */
   int i;  /* character counter */

   begscrn("Cases Stored on Disk");
   wattrset(wn, COLOR_PAIR(4));
   concat(&infile, directory, "*.pia");
#if DLC > 0
   p = findfirst(infile,0x00);
   while (p && (i1 < 60))
      {
      strcpy(cases[i1++],p->name);
      p = findnext();
      }
#endif
#ifdef _MSC_VER
   _dos_findfirst(infile,_A_NORMAL,&p);
   strcpy(cases[i1++],p.name);
   while ((_dos_findnext(&p) == 0) && (i1 < 60))
      strcpy(cases[i1++],p.name);
#endif
   if ((count = i1) > 0) {
      qsort(cases, count, NAMELEN, stricmp);
      for (i1 = 0; i1 < count; i1++) {
         if (limit  &&  i1/NUMCOLS >= 13)
            break;
         /* cut off extension on filename */
         for (i=0 ; cases[i1][i]  &&  cases[i1][i] != '.' ; ++i)
            ;
         cases[i1][i] = '\0';
         wn_dtext(XEQ, NFRM, NFLD, wn, 3 + i1 / NUMCOLS,
            3 + COLWIDTH * (i1 - NUMCOLS * (i1 / NUMCOLS)), cases[i1]);
         }
      }
   else
      wn_dtext(XEQ, NFRM, NFLD, wn, 5, 3, "No cases found");
   WREFRESH(wn);
   return(0);
}
