/*
 * @(#)piaout.C	1.99   6/28/94
 * Functions to write out results
 */

#ifndef lint
static char *piaoutID = " @(#)piaout.C	1.99   6/28/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "taxes.h"
#include "prtutils.h"
#include "comma.h"
#include "utils.h"
#include "compdate.h"
#include "piaout.h"
#include "setup.h"
#include "mesgcat.h"

static int ifile = 0;  /* output file counter */
static int maxifile = 99;  /* maximum output file counter */

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int   pr_taxes  ( FILE *out, WORKERDATA *workerdata, PIADATA *piadata,
   Taxes *taxdata );
static void  compyr    ( FILE *out, WORKERDATA *workerdata, PIADATA *piadata,
   int n1, int n2, int n3 );
static void  biout     ( FILE *out, PIAPARMS *piaparms, PIADATA *piadata,
   enum pia_type method, int melgyr, int type, int piamfb );
static void  piamfb1   ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  piamfb2   ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  mfbout    ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  pgtitle   ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  prrwg     ( FILE *out, PIADATA *piadata, int melgyr, int istart,
   enum pia_type method );
static void  tabhead1  ( FILE *out, double avgbsyr );
static void  tabhead2  ( FILE *out );
static void  baseyrout ( FILE *out, int year );
static void  piaentout ( FILE *out, double piaentt );
static void  rawpiaout ( FILE *out, double rawpia );
static void  totpiaout ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  dimfbout  ( FILE *out, float capt, double amepia, double mfbt );
static void  ostabout  ( FILE *out, PIADATA *piadata );
static void  bpmfbout  ( FILE *out, PIADATA *piadata );
static void  bppiaout  ( FILE *out, double *bppia );
static void  ameout    ( FILE *out, double ftearnt, int nx, char *amet );
static void  aimeout   ( FILE *out, PIADATA *piadata, enum pia_type method );
static void  pubpenout ( FILE *out, WORKERDATA *workerdata, PIADATA *piadata,
   enum pia_type method );
static void  piaelout  ( FILE *out, PIADATA *piadata, double percpt[3], 
   enum pia_type method );
#else
static int   pr_taxes();
static void  compyr();
static void  biout();
static void  piamfb1();
static void  piamfb2();
static void  mfbout();
static void  pgtitle();
static void  prrwg();
static void  tabhead1();
static void  tabhead2();
static void  baseyrout();
static void  piaentout();
static void  rawpiaout();
static void  totpiaout();
static void  dimfbout();
static void  ostabout();
static void  bpmfbout();
static void  bppiaout();
static void  ameout();
static void  aimeout();
static void  pubpenout();
static void  piaelout();
#endif

/* Function to print detailed results
 */
piaout(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata,  /* Lawchg structure */
Taxes *taxdata,  /* taxdata structure */
int isum,  /* type of printout (1-4) */
int curyear)  /* current year (through which qc's are known) */
{
   FILE *out;  /* output file */
   int ptwopage = 0;  /* indicator for two-page summary printed */
   int idet = 0;  /* indicator for file open */
   int ierr;  /* error indicator */
   char outfile[13];  /* name of output file */

   if (isum == 1)
      { /* print one-page summary */
      if ((out = openfile(piadata, outfile)) == (FILE *)NULL)
         return(78);
      one_page(out,workerdata,piadata);
      } /* end one-page summary */

   if (isum == 2 || (isum == 3 && ptwopage == 0))
      { /* print two-page summary */
      if ((out = openfile(piadata, outfile)) == (FILE *)NULL)
         return(78);
      two_pg1(out,workerdata,piadata,lawchgdata);
      two_pg2(out, workerdata, piaparms, piadata, curyear);
      ptwopage = idet = 1;
      }

   if (isum == 3)
      { /* print detailed output */
      /* open output file if not still open from summary pages */
      if (idet == 0) {
         if ((out = openfile(piadata, outfile)) == (FILE *)NULL)
            return(78);
         idet = 1;
         } /* open output file */
      if (piadata -> iapp[(int)OLD_START])
         { /* print out old-start calculation */
         if (pr_oldst(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)PIA_TABLE])
         { /* print out PIA Table calculation */
         if (pr_piatb(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)WAGE_IND])
         { /* print out wage-indexed calculation */
         if (pr_wgind(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)TRANS_GUAR])
         { /* print out trans guarantee calculation */
         if (pr_trnsgr(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)SPEC_MIN])
         { /* print out special-minimum calculation */
         if (pr_spmin(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)REIND_WID])
         { /* print out re-indexed widow calculation */
         if (pr_reind(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (piadata -> iapp[(int)FROZ_MIN])
         { /* print out frozen minimum calculation */
         if (pr_frozmin(out,workerdata,piadata,piaparms))
            return(1);
         }
      if (pr_taxes(out, workerdata, piadata, taxdata))
         { /* print out taxes paid */
         return(1);
         }
      }
   if (piadata -> iprntr)
      fclose(out);
   else
      fprintf(out,"\n");
   idet = 0;
   if (piadata -> iprntr) {
      if ((ierr = printout(piadata, outfile)) > 0) {
         return(ierr);
         }
      }
   return(0);
}
/* Function to open an output file
 */
FILE *openfile(
PIADATA *piadata,  /* piadata structure */
char *outfile)  /* name of output file */
{
   FILE *outtemp;  /* output file handle */

   if (piadata -> iprntr) {
      ifile++;
      if (ifile > maxifile)
         ifile = 1;
      sprintf(outfile,"outfile.%d",ifile);
      if ((outtemp = fopen(outfile,"w")) != (FILE *)NULL)
         fprintf(outtemp, "%s", piadata -> prn_init);
      return(outtemp);
      }
   else
#ifdef MSDOS
      fprintf(stdprn, "%s", piadata -> prn_init);
      return(stdprn);
#else
      return((FILE *)NULL);
#endif
}
/* Function to print out old-start calculation
 */
pr_oldst(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1; /* loop counter */
   static char *iyros[8] = { "1939", "1950", "1950", "1965", "1967",
                             "1977", "1977", "1990" };
                   /* years of old-start Social Security Acts */
   static char *ios77[8] = { "", "1950 Conversion Table",
      "1958 Conversion Table", "", "", "Pre-1977 Act PIA Table",
      "December 1978 PIA Table", "Pre-1977 Act PIA Table" };

   pgtitle(out, piadata, OLD_START);
   fprintf(out,"%31sImputed      High n\n"," ");
   fprintf(out,"      Year      Earnings      Earnings      Years\n\n");
   for (i1 = 1937; i1 <= piadata -> iernyr; i1++) {
      fprintf(out, "      %4d  ", i1);
      fprintf(out, "%s", (workerdata -> ibegin != 1950 || i1 != 1950) ?
         pdouble(piadata -> earnst[workerdata -> totalize + 2][i1-1937],12,2) :
         pdouble(piadata -> stot[workerdata -> totalize], 12, 2));
      fprintf(out, "  %s",
         pdouble((double)piadata -> vearn[(int)OLD_START][i1-1937], 12, 2));
      if (piadata -> iorder[(int)OLD_START][i1-1937] > 0)
         fprintf(out, "  %s",
            pdouble((double)piadata -> vearn[(int)OLD_START][i1-1937], 12, 2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   pgtitle(out, piadata, OLD_START);
   compyr(out, workerdata, piadata, piadata -> nelapold, piadata -> ndropold,
      piadata -> nold);
   ameout(out, piadata -> ftearn[(int)OLD_START], piadata -> nold,
      pint(piadata -> iameos, 1));
   fprintf(out, "      Applicable method: %s Act\n", iyros[piadata -> methos]);
   if (strlen(ios77[piadata -> methos]))
      fprintf(out, "        %s\n", ios77[piadata -> methos]);
   fprintf(out, "\n      PIB before applying increment years = \n");
   fprintf(out, "%9s%4.2f * %s +\n", " ", piaparms -> percos[0],
      pdouble(piadata -> paime[0][(int)OLD_START],0,0));
   fprintf(out, "%9s%4.2f * %s = ", " ", piaparms -> percos[1],
      pdouble(piadata -> paime[1][(int)OLD_START],0,0));
   fprintf(out, "%s\n\n", pdouble((double)piadata -> pib, 4, 2));
   fprintf(out, "      Increment years = %d\n", piadata -> incyrs);
   fprintf(out, "\n      PIB after applying increment years = %s\n\n",
      pdouble((double)piadata -> pibinc, 4, 2));
   switch (piadata -> methos)
   {
   case 1:
      fprintf(out, "      1950 PIA = %s\n\n",
         pdouble(piadata -> piael[(int)OLD_START][0], 4, 2));
      fprintf(out, "      1950 MFB = %s\n\n",
         pdouble(piadata -> mfbel[(int)OLD_START][0], 4, 2));
      break;
   case 2:
   case 3:
   case 4:
   case 5:
   case 6:
   case 7:
      fprintf(out, "      New-start AME = ");
      fprintf(out, "%s\n\n", pdouble(piadata -> ame[(int)OLD_START],1,0));
      switch (piadata -> methos)
      {
      case 5:
      case 7:
         ostabout(out, piadata);
         if (piadata -> iycpi[(int)OLD_START][2] >=
            piadata -> iycpi[(int)OLD_START][0])
            biout(out, piaparms, piadata, OLD_START, piadata -> icchup, 0, 0);
         if (piadata -> iycpi[(int)OLD_START][3] >
            piadata -> iycpi[(int)OLD_START][2])
            biout(out, piaparms, piadata, OLD_START, piadata -> icchup, 2, 3);
         break;
      case 6:
         fprintf(out, "      PIA at eligibility = ");
         if (piadata -> iwind == 0 && workerdata -> totalize == 0)
            fprintf(out, "%s\n\n",
               pdouble(piadata -> piael[(int)OLD_START][0], 4, 2));
         else {
            if (piadata -> iwind != 0)
               fprintf(out, "%s\n\n",
                  pdouble(piadata -> piaw[(int)OLD_START],4,2));
            else
               fprintf(out, "%s\n\n",
                  pdouble(piadata -> piaeltot[(int)OLD_START], 4, 2));
            }
         if (piadata -> iwind != 0)
            pubpenout(out, workerdata, piadata, OLD_START);
         if (workerdata -> totalize) {
            totpiaout(out, piadata, OLD_START);
            rawpiaout(out, piadata -> piael[(int)OLD_START][0]);
            }
         bpmfbout(out, piadata);
         mfbout(out, piadata, OLD_START);
         if (piadata -> iycpi[(int)OLD_START][2] >=
            piadata -> iycpi[(int)OLD_START][1])
            biout(out, piaparms, piadata, OLD_START, piadata -> icchup, 1, 3);
         if (piadata -> iycpi[(int)OLD_START][3] >
            piadata -> iycpi[(int)OLD_START][2]) {
            piamfb1(out, piadata, OLD_START);
            biout(out, piaparms, piadata, OLD_START, piadata -> icchup, 2, 3);
            }
         break;
      default:
         break;
      }
      break;
   default:
      break;
   }
   piamfb2(out, piadata, OLD_START);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print out PIA Table calculation
 */
pr_piatb(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1,i2; /* loop counters */

   pgtitle(out, piadata, PIA_TABLE);
   tabhead2(out);
   i2 = (workerdata -> ibegin < 1951) ? 1951 : workerdata -> ibegin;
   for (i1 = i2; i1 <= piadata -> iernyr; i1++) {
      fprintf(out, "      %4d  %s", i1,
         pdouble(piadata -> earnst[workerdata -> totalize + 2][i1-1937], 12, 2));
      if (piadata -> iorder[(int)PIA_TABLE][i1-1951] > 0)
         fprintf(out, "  %s",
            pdouble((double)piadata -> vearn[(int)PIA_TABLE][i1-1951], 12, 2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   pgtitle(out, piadata, PIA_TABLE);
   compyr(out, workerdata, piadata, piadata -> nelap, piadata -> ndrop,
      piadata -> n);
   ameout(out, piadata -> ftearn[(int)PIA_TABLE], piadata -> n,
      pdouble(piadata -> ame[(int)PIA_TABLE], 1, 0));
   ostabout(out, piadata);
   if (piadata -> iycpi[(int)PIA_TABLE][2] >=
      piadata -> iycpi[(int)PIA_TABLE][0])
      biout(out, piaparms, piadata, PIA_TABLE, piadata -> icchup, 0, 0);
   if (piadata -> iycpi[(int)PIA_TABLE][3] >
      piadata -> iycpi[(int)PIA_TABLE][2]) {
      piamfb1(out, piadata, PIA_TABLE);
      biout(out, piaparms, piadata, PIA_TABLE, piadata -> icchup, 2, 3);
      }
   if (workerdata -> totalize)
      totpiaout(out, piadata, PIA_TABLE);
   piamfb2(out, piadata, PIA_TABLE);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print out wage-indexed calculation
 */
pr_wgind(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1,i2; /* loop counters */

   pgtitle(out, piadata, WAGE_IND);
   tabhead1(out, piaparms -> fq[piadata -> ielgyr[1] - 1939]);
   i2 = (workerdata -> ibegin < 1951) ? 1951 : workerdata -> ibegin;
   for (i1 = i2; i1 <= piadata -> iernyr; i1++) {
      fprintf(out, "      %4d  %s", i1,
         pdouble(piadata -> earnst[workerdata -> totalize + 2][i1-1937],12,2));
      if (i1 < piadata -> ielgyr[1] - 1)
         fprintf(out, " %s", pdouble(piadata -> uearn[i1-1951],18,2));
      else
         fprintf(out, "%19s", " ");
      fprintf(out, "  %s",
         pdouble((double)piadata -> vearn[(int)WAGE_IND][i1-1951], 12, 2));
      if (piadata -> iorder[(int)WAGE_IND][i1-1951] > 0)
         fprintf(out, "  %s",
            pdouble((double)piadata -> vearn[(int)WAGE_IND][i1-1951], 12, 2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   pgtitle(out, piadata, WAGE_IND);
   baseyrout(out, piadata -> ielgyr[1] - 2);
   compyr(out, workerdata, piadata, piadata -> nelap, piadata -> ndrop,
      piadata -> n);
   if (workerdata -> totalize) {
      fprintf(out, "      Theoretical AIME = %s",
         pdouble(piadata -> ftearn[(int)WAGE_IND], 4, 2));
      fprintf(out, "/(%d*12) = %s\n\n", piadata -> n,
         pdouble(piadata -> ametot[(int)WAGE_IND], 1, 0));
      }
   else
      aimeout(out, piadata, WAGE_IND);
   bppiaout(out, piadata -> bendpia);
   bpmfbout(out, piadata);
   piaelout(out, piadata, piadata -> percp, WAGE_IND);
   if (piadata -> iwind <= 0 && workerdata -> totalize == 0)
      fprintf(out, "%s\n\n",
         pdouble(piadata -> piael[(int)WAGE_IND][0],4,2));
   else {
      if (piadata -> iwind > 0)
         fprintf(out, "%s\n\n",
            pdouble(piadata -> piaw[(int)WAGE_IND],4,2));
      else
         fprintf(out, "%s\n\n",
            pdouble(piadata -> piaeltot[(int)WAGE_IND],4,2));
      }
   if (piadata -> iwind != 0)
      pubpenout(out, workerdata, piadata, WAGE_IND);
   if (workerdata -> totalize) {
      if (piadata -> iycpi[(int)WAGE_IND][2] >=
         piadata -> iycpi[(int)WAGE_IND][1])
         biout(out, piaparms, piadata, WAGE_IND, piadata -> icchup, 1, 1);
      if (piadata -> iycpi[(int)WAGE_IND][3] >
         piadata -> iycpi[(int)WAGE_IND][2])
         biout(out, piaparms, piadata, WAGE_IND, piadata -> icchup, 2, 1);
      totpiaout(out, piadata, WAGE_IND);
      rawpiaout(out, piadata -> piael[(int)WAGE_IND][0]);
      fprintf(out, "      Pro Rata AIME = ");
      fprintf(out, "%s\n\n", pdouble(piadata -> ame[(int)WAGE_IND], 2, 0));
      }
   mfbout(out, piadata, WAGE_IND);
   i1 = (workerdata -> totalize) ? 2 : 3;
   if (piadata -> iycpi[(int)WAGE_IND][2] >=
      piadata -> iycpi[(int)WAGE_IND][1])
      biout(out, piaparms, piadata, WAGE_IND, piadata -> icchup, 1, i1);
   if (piadata -> iycpi[(int)WAGE_IND][3] >
      piadata -> iycpi[(int)WAGE_IND][2]) {
      piamfb1(out, piadata, WAGE_IND);
      biout(out, piaparms, piadata, WAGE_IND, piadata -> icchup, 2, i1);
      }
   if (piadata -> ielgyr[1] > workerdata -> istart &&
      workerdata -> ialtaw == PEBS_ASSUM)
      prrwg(out, piadata, piadata -> ielgyr[1], workerdata -> istart,
         WAGE_IND);
   piamfb2(out, piadata, WAGE_IND);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print transitional guarantee 
 */
pr_trnsgr(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1,i2; /* loop counters */

   pgtitle(out, piadata, TRANS_GUAR);
   tabhead2(out);
   i2 = (workerdata -> ibegin < 1951) ? 1951 : workerdata -> ibegin;
   for (i1 = i2; i1 <= piadata -> iernyr; i1++) {
      fprintf(out, "      %4d  %s", i1,
         pdouble(piadata -> earnst[workerdata -> totalize + 2][i1-1937],12,2));
      if (piadata -> iorder[(int)TRANS_GUAR][i1-1951] > 0)
         fprintf(out, "  %s",
            pdouble(piadata -> vearn[(int)TRANS_GUAR][i1-1951], 12, 2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   pgtitle(out, piadata, TRANS_GUAR);
   compyr(out, workerdata, piadata, piadata -> nelap, piadata -> ndrop,
      piadata -> n);
   ameout(out, piadata -> ftearn[(int)TRANS_GUAR], piadata -> n,
      pdouble(piadata -> ame[(int)TRANS_GUAR], 1, 0));
   fprintf(out, "      Dec 1978 PIA = %s\n\n",
      pdouble(piadata -> piael[(int)TRANS_GUAR][0], 4, 2));
   bpmfbout(out, piadata);
   mfbout(out, piadata, TRANS_GUAR);
   if (piadata -> iycpi[(int)TRANS_GUAR][2] >=
      piadata -> iycpi[(int)TRANS_GUAR][1])
      biout(out, piaparms, piadata, TRANS_GUAR, piadata -> icchup, 1, 3);
   if (piadata -> iycpi[(int)TRANS_GUAR][3] >
      piadata -> iycpi[(int)TRANS_GUAR][2]) {
      piamfb1(out, piadata, TRANS_GUAR);
      biout(out, piaparms, piadata, TRANS_GUAR, piadata -> icchup, 2, 3);
      }
   piamfb2(out, piadata, TRANS_GUAR);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print special-minimum calculation
 */
pr_spmin(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1,i2,i3; /* loop counters */

   pgtitle(out, piadata, SPEC_MIN);
   fprintf(out,"%27spercent of\n"," ");
   fprintf(out,"%29sold-law\n"," ");
   fprintf(out,"%30sbase      required   years of\n"," ");
   fprintf(out,
      "      year      earnings    required    earnings   coverage\n\n");
   if (workerdata -> ibegin < 1951) {
      fprintf(out,"      1937-50 %s",
         pdouble(piadata -> stot[workerdata -> totalize], 10, 2));
      fprintf(out, "%32d\n", piadata -> iorder[(int)SPEC_MIN][13]); }
   i2 = (workerdata -> ibegin < 1951) ? 14 : workerdata -> ibegin - 1937;
   i3 = (workerdata -> iend < piadata -> iernyr) ? workerdata -> iend - 1936 :
      piadata -> iernyr - 1936;
   for (i1 = i2; i1 < i3; i1++)
      {
      fprintf(out, "      %4d", 1937+i1);
      fprintf(out, "  %s",
         pdouble(piadata -> earnst[2][i1],12,2));
      fprintf(out, "%10.2f", piaparms -> pspmin[i1-14]);
      fprintf(out, "  %s",
         pdouble(piaparms -> base77[i1] * piaparms -> pspmin[i1-14], 12, 2));
      fprintf(out, "%8d\n", piadata -> iorder[(int)SPEC_MIN][i1]);
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   pgtitle(out, piadata, SPEC_MIN);
   fprintf(out, "      Years of coverage = %d\n\n", piadata -> ispmnt[0]);
   fprintf(out,"      Years of coverage over 10 (maximum 20) = %d\n\n",
      piadata -> iyrspm);
   fprintf(out, "      Amount per year = %3.2f\n\n", piadata -> spmin);
   if (compmdy(workerdata -> bendate, piaparms -> amend77) >= 0)
      {
      fprintf(out,"      January 1979 PIA = %d * %3.2f = %3.2f\n\n",
         piadata -> iyrspm, piadata -> spmin,
         piadata -> piael[(int)SPEC_MIN][0]);
      if (piadata -> iycpi[(int)SPEC_MIN][3] >=
         piadata -> iycpi[(int)SPEC_MIN][0])
         {
         fprintf(out,"      MFB in January 1979 = %3.2f\n\n",
            piadata -> mfbel[(int)SPEC_MIN][0]);
         if (piadata -> iycpi[(int)SPEC_MIN][2] >=
            piadata -> iycpi[(int)SPEC_MIN][1])
            biout(out, piaparms, piadata, SPEC_MIN, piadata -> icchup, 0, 3);
         if (piadata -> iycpi[(int)SPEC_MIN][3] >
            piadata -> iycpi[(int)SPEC_MIN][2]) {
            piamfb1(out, piadata, SPEC_MIN);
            biout(out, piaparms, piadata, SPEC_MIN, piadata -> icchup, 2, 3);
            }
         }
      piamfb2(out, piadata, SPEC_MIN);
      }
   else
      {
      fprintf(out, "      PIA = %d * %4.2f = %4.2f\n\n", piadata -> iyrspm,
         piadata -> spmin, piadata -> piaent[(int)SPEC_MIN]);
      fprintf(out, "      MFB = %4.2f\n", piadata -> mfbent[(int)SPEC_MIN]);
      }
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print out re-indexed widow calculation
 */
pr_reind(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1,i2; /* loop counters */
   int cols = 6;  /* left-hand margin */

   pgtitle(out, piadata, REIND_WID);
   tabhead1(out, piaparms -> fq[piadata -> jelgyr - 1939]);
   i2 = (workerdata -> ibegin < 1951) ? 1951 : workerdata -> ibegin;
   for (i1 = i2; i1 <= piadata -> iernyr; i1++) {
      fprintf(out, "      %4d  %s", i1,
         pdouble(piadata -> earnst[workerdata -> totalize + 2][i1-1937],12,2));
      if (i1 <= piadata -> jelgyr-2)
         fprintf(out, " %s", pdouble(piadata -> xearn[i1-1951],18,2));
      else
         fprintf(out, "%19s", " ");
      fprintf(out, "  %s",
         pdouble(piadata -> vearn[(int)REIND_WID][i1-1951], 12, 2));
      if (piadata -> iorder[(int)REIND_WID][i1-1951] > 0)
         fprintf(out, "  %s",
            pdouble(piadata -> vearn[(int)REIND_WID][i1-1951], 12, 2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, cols);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out, cols);
   fprintf(out,"\n");
   prtnmssn(out,workerdata, cols);
   FORMFEED;
   pgtitle(out, piadata, REIND_WID);
   fprintf(out, "%s%s%s\n\n", stringd(cols, ' '), catstr(249),
      date(workerdata -> jbirth));
   if (workerdata -> jsurv == DISAB_WID)
      fprintf(out, "%s%s%s\n\n", stringd(cols, ' '), catstr(268),
         date(workerdata -> jonset));
   baseyrout(out, piadata -> jelgyr - 2);
   compyr(out, workerdata, piadata, piadata -> nelap, piadata -> ndrop,
      piadata -> n);
   aimeout(out, piadata, REIND_WID);
   bppiaout(out, piadata -> jbendpia);
   piaelout(out, piadata, piadata -> jpercp, REIND_WID);
   fprintf(out, "%s\n\n",
      pdouble(piadata -> piael[(int)REIND_WID][0], 4, 2));
   if (piadata -> iycpi[(int)REIND_WID][2] >=
      piadata -> iycpi[(int)REIND_WID][1])
      biout(out, piaparms, piadata, REIND_WID, piadata -> jcchup, 1, 3);
   if (piadata -> iycpi[(int)REIND_WID][3] >
      piadata -> iycpi[(int)REIND_WID][2])
      biout(out, piaparms, piadata, REIND_WID, piadata -> jcchup, 2, 3);
   if (piadata -> jelgyr > workerdata -> istart &&
      workerdata -> ialtaw == PEBS_ASSUM)
      prrwg(out, piadata, piadata -> jelgyr, workerdata -> istart, REIND_WID);
   piaentout(out, piadata -> piaent[(int)REIND_WID]);
   fprintf(out, "\n      MFB at entitlement = ");
   fprintf(out, "(same as for wage-indexed)\n");
   /* print noninsured message */
   nonins(out, workerdata, piadata, cols);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out, cols);
   fprintf(out,"\n");
   prtnmssn(out, workerdata, cols);
   FORMFEED;
   return(0);
}
/* Function to print frozen minimum calculation
 */
pr_frozmin(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   pgtitle(out, piadata, FROZ_MIN);
   fprintf(out, "      PIA at eligibility = ");
   fprintf(out, "%s\n\n", pdouble(piadata -> piael[(int)FROZ_MIN][0], 4, 2));
   fprintf(out,"      MFB at eligibility = %s\n\n",
      pdouble(piadata -> mfbel[(int)FROZ_MIN][0], 4, 2));
   if (piadata -> iycpi[(int)FROZ_MIN][2] >=
      piadata -> iycpi[(int)FROZ_MIN][1])
      biout(out, piaparms, piadata, FROZ_MIN, piadata -> icchup, 1, 3);
   if (piadata -> iycpi[(int)FROZ_MIN][3] >
      piadata -> iycpi[(int)FROZ_MIN][2]) {
      piamfb1(out, piadata, FROZ_MIN);
      biout(out, piaparms, piadata, FROZ_MIN, piadata -> icchup, 2, 3);
      }
      piamfb2(out, piadata, FROZ_MIN);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (workerdata -> ioasdi == DISABILITY)
      disinsout(out,6);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print out taxes paid
 */
static int pr_taxes(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /*piadata structure */
Taxes *taxdata)  /* taxdata structure */
{
   register i1,i2; /* loop counters */

   fprintf(out, "%25sTaxes paid%15s%s\n\n\n", " ", " ", piadata -> dateln);
   fprintf(out,"      year      Earnings      OASI        DI        OASDI");
   fprintf(out,"       HI       OASDHI\n\n");
   for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++) {
      fprintf(out, "      %4d  %s", i1,
         pdouble(piadata -> earnst[2][i1-1937], 12, 2));
      for (i2 = 0; i2 < 5; i2++)
         fprintf(out, " %s",
            pdouble((double)taxdata -> taxes[i2][i1-1937],10,2));
      fprintf(out,"\n");
      } /* end for */
   fprintf(out,"\n      Total             ");
   for (i2 = 0; i2 < 5; i2++)
      fprintf(out, " %s", pdouble(taxdata -> taxtot[i2][1],10,2));
   fprintf(out,"\n\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
   return(0);
}
/* Function to print out number of computation years
 */
static void compyr(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
int n1,  /* elapsed years */
int n2,  /* dropout years */
int n3)  /* computation years */
{
   if (workerdata -> valdi == 1) {
      if (piadata -> frzyr2 >= piadata -> frzyr1)
         fprintf(out,
            "      Years wholly within disability freeze = %d to %d\n\n",
            piadata -> frzyr1, piadata -> frzyr2);
      else
         fprintf(out, "      No years wholly within disability freeze\n\n");
      }
   fprintf(out, "      Number of elapsed years = %d\n\n", n1);
   fprintf(out, "      Number of dropout years = %d\n\n", n2);
   fprintf(out, "      Number of computation years = %d - %d = %d\n\n",
      n1 , n2, n3);
}
/* Function to write out benefit increases
 */
static void biout(
FILE *out,  /* output file */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type method,  /* method number */
int melgyr,  /* index of catch-up year */
int type,  /* type of writeout (0 to go from first year to entitlement,
   1 to go from eligibility to entitlement, 2 to go from entitlement to
   benefit date) */
int piamfb)  /* indicator for PIA and MFB printout (0 to not print out PIA
   or MFB, 1 for PIA, 2 for MFB, 3 for PIA and MFB) */
{
   register i1; /* loop counter */
   int i2,i3;  /* temporary variables */

   i2 = (type == 0) ? 2 : type + 1;
   fprintf(out, "      CPI increases applied:\n");
   i3 = (type == 2) ? piadata -> iycpi[(int)method][type] + 1 :
      piadata -> iycpi[(int)method][type];
   for (i1 = i3; i1 <= piadata -> iycpi[(int)method][i2]; i1++) {
      if (cchpexist(piaparms, i1, melgyr))
         fprintf(out, "%9s%4.1f %% for %d %d, catch-up\n", " ",
            piaparms -> cachup[melgyr][i1 - piaparms -> cstart],
            piaparms -> monben[i1 - 1951], i1);
      fprintf(out, "%9s%4.1f %% for %d %d", " ",
         piaparms -> cpiinc[i1 - 1951], piaparms -> monben[i1 - 1951], i1);
      if (piamfb != 0) {
         fprintf(out, ":");
         if (piamfb % 2 == 1)
            fprintf(out, " %9.2f", piadata ->
               piael[(int)method][i1 - piadata -> iycpi[(int)method][0] + 1]);
         if (piamfb > 1)
            fprintf(out, " %9.2f", piadata ->
               mfbel[(int)method][i1 - piadata -> iycpi[(int)method][0] + 1]);
         }
      fprintf(out, "\n");
      }
   fprintf(out, "\n");
}
/* Function to write out PIA and MFB at entitlement
 */
static void piamfb1(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   int numyears;  /* number of years of benefit increases to entitlement */

   numyears = piadata -> iycpi[(int)method][2] -
      piadata -> iycpi[(int)method][0] + 1;
   piaentout(out, piadata -> piael[(int)method][numyears]);
   fprintf(out, "\n      MFB at entitlement = ");
   if (piadata -> icap[(int)method] == 1 || piadata -> icap[(int)method] == 3)
      /* cap is 1.0 or 1.5 times PIA */
      dimfbout(out, piadata -> cap[(int)method],
         piadata -> piael[(int)method][numyears],
         piadata -> mfbel[(int)method][numyears]);
   else
      fprintf(out, "%s\n\n",
         pdouble(piadata -> mfbel[(int)method][numyears],4,2));
}
/* Function to write out PIA and MFB at benefit date
 */
static void piamfb2(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   fprintf(out, "      PIA at benefit date = %s\n",
      pdouble(piadata -> piaent[(int)method], 4, 2));
   fprintf(out, "\n      MFB at benefit date = ");
   if (piadata -> icap[(int)method] == 1 || piadata -> icap[(int)method] == 3)
      /* cap is 1.0 or 1.5 times PIA */
      dimfbout(out, piadata -> cap[(int)method],
         piadata -> piaent[(int)method], piadata -> mfbent[(int)method]);
   else
      fprintf(out, "%s\n\n", pdouble(piadata -> mfbent[(int)method], 4, 2));
}
/* Function to write out MFB calculation 
 */
static void mfbout(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   register i2;  /* loop counter */

   if (piadata -> icap[(int)method] == 1 || piadata -> icap[(int)method] == 3)
      /* cap is 1.0 or 1.5 times PIA */
      return;
   fprintf(out, "      MFB at eligibility =\n");
   if (piadata -> icap[(int)method] == 2)
      /* cap is 85% of AIME */
      dimfbout(out, piadata -> cap[(int)method],
         piadata -> ame[(int)WAGE_IND], piadata -> mfbel[(int)method][0]);
   else
      { /* usual formula */
      for (i2 = 0; i2 < 3; i2++)
         fprintf(out, "%9s%4.2f * %s +\n", " ", piadata -> percm[i2],
            pdouble(piadata -> ppiael[i2][(int)method],4,2));
      fprintf(out, "%9s%4.2f * %s = ", " ", piadata -> percm[3],
         pdouble(piadata -> ppiael[3][(int)method],4,2));
      fprintf(out, "%s\n\n", pdouble(piadata -> mfbel[(int)method][0], 4, 2));
      }
}
/* Function to print title at top of page
 */
static void pgtitle(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   fprintf(out, "%10s%-40s%s\n\n\n", " ", piadata -> title[(int)method],
      piadata -> dateln);
}
/* Function to write out real-wage-gain adjustment
 */
static void prrwg(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
int melgyr,  /* year of eligibility */
int istart,  /* current year */
enum pia_type method)  /* method number */
{
   fprintf(out, "      Real-wage-gain adjustment for PEBES calculation:\n");
   fprintf(out, "%9sFactor = %4.2f\n", " ",
      1.+.01*(float)(melgyr-istart));
   fprintf(out, "%9sPIA before adjustment = %s\n", " ",
      pdouble(piadata -> piarwg[(int)method],4,2));
   if (method == WAGE_IND)
      fprintf(out, "%9sMFB before adjustment = %s\n", " ",
         pdouble(piadata -> mfbrwg[(int)method],4,2));
   fprintf(out, "\n");
}
/* Function to print table heading for wage-indexed earnings
 */
static void tabhead1(
FILE *out,  /* output file */
double avgbsyr)  /* average wage in base year */
{
   fprintf(out, "%33searnings        indexed       high n\n"," ");
   fprintf(out, "      year      earnings      * ");
   fprintf(out, "%s      earnings       years\n\n", pdouble(avgbsyr, 11, 2));
}
/* Function to print table heading for non-indexed earnings
 */
static void tabhead2(
FILE *out)  /* output file */
{
   fprintf(out, "%30sHigh n\n      Year      Earnings       Years\n\n"," ");
}
/* Function to print base year
 */
static void baseyrout(
FILE *out,  /* output file */
int year)  /* base year */
{
   fprintf(out, "      Base year for indexing = %d\n\n", year);
}
/* Function to print PIA at entitlement
 */
static void piaentout(
FILE *out,  /* output file */
double piaentt)  /* pia at entitlement */
{
    fprintf(out, "      PIA at entitlement = %s\n", pdouble(piaentt, 4, 2));
}
/* Function to print raw pro rata PIA
 */
static void rawpiaout(
FILE *out,  /* output file */
double rawpia)  /* raw pro rata pia */
{
    fprintf(out, "      Raw Pro Rata PIA = %s\n\n", pdouble(rawpia, 4, 2));
}
/* Function to print title at top of page
 */
static void totpiaout(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   fprintf(out, "      Theoretical PIA = %s\n\n",
      pdouble(piadata -> piatot[(int)method], 4, 2));
   fprintf(out, "      Pro Rata PIA = (%d/%d) * %s = ", 3 * piadata -> qctot,
      12 * piadata -> n, pdouble(piadata -> piatot[(int)method], 4, 2));
   fprintf(out, "%s\n\n", pdouble(piadata -> piaent[(int)method], 4, 2));
}
/* Function to print MFB cap on DI cases
 */
static void dimfbout(
FILE *out,  /* output file */
float capt,  /* percentage cap for DI MFB */
double amepia,  /* ame or pia */
double mfbt)  /* DI MFB */
{
   fprintf(out, "\n%9s%4.2f * %s\n", " ", capt, pdouble(amepia, 1, 0));
   fprintf(out, "%9s(MFB cap on DI cases) = %s\n\n", " ",
      pdouble(mfbt, 4, 2));
}
/* Function to print out applicable old start pia table
 */
static void ostabout(
FILE *out,  /* output file */
PIADATA *piadata)  /* piadata structure */
{
   static char *table[10] = { "1952", "1954", "1958", "1965", "1967", "1969",
                              "1971", "1972", "1973", "1977" };
                            /* years of Social Security Acts */

   fprintf(out, "      Applicable table: %s Act\n\n",
      table[piadata -> itabel[(int)OLD_START]]);
}
/* Function to print MFB formula bend points
 */
static void bpmfbout(
FILE *out,  /* output file */
PIADATA *piadata)  /* piadata structure */
{
   fprintf(out, "      MFB formula bend points = %s, ",
      pdouble((double)piadata -> bendmfb[1],1,0));
   fprintf(out, "%s, and ", pdouble((double)piadata -> bendmfb[2],1,0));
   fprintf(out, "%s\n\n", pdouble((double)piadata -> bendmfb[3],1,0));
}
/* Function to print PIA formula bend points
 */
static void bppiaout(
FILE *out,  /* output file */
double *bppia)  /* pia formula bend points */
{
   fprintf(out, "      PIA formula bend points = %s",
      pdouble(bppia[1], 1, 0));
   fprintf(out, " and %s\n\n", pdouble(bppia[2], 1, 0));
}
/* Function to print out AME calculation
 */
static void ameout(
FILE *out,  /* output file */
double ftearnt,  /* total earnings */
int nx,  /* number of comp years */
char *amet)  /* ame or aime as a string */
{
   fprintf(out, "      AME = %s", pdouble(ftearnt,4,2));
   fprintf(out, "/(%d*12) = %s\n\n", nx, amet);
}
/* Function to print out AIME calculation
 */
static void aimeout(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   fprintf(out, "      AIME = %s",
      pdouble(piadata -> ftearn[(int)method], 4, 2));
   fprintf(out, "/(%d*12) = %s\n\n", piadata -> n,
      pdouble(piadata -> ame[(int)method], 1, 0));
}
/* Function to print out windfall calculation
 */
static void pubpenout(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
enum pia_type method)  /* method number */
{
   int i;  /* loop counter */

   nonpenout(out, workerdata, 6);
   if (method == WAGE_IND) {
      fprintf(out,"\n      %d years of coverage for windfall provision\n",
         piadata -> ispmnt[1]);
      if (piadata -> iwind < 0) {
         fprintf(out,"\n      Special minimum savings clause applies\n\n");
         return;
         }
      }
   fprintf(out, "\n      PIA after windfall =\n");
   if (method == OLD_START) {
      fprintf(out, "         %s - .5*",
         pdouble(piadata -> piaw[(int)OLD_START],4,2));
      fprintf(out, "%s\n",
         (piadata -> piaw[(int)OLD_START] < (double)workerdata -> pubpen) ?
         pdouble(piadata -> piaw[(int)OLD_START],4,2) :
         pdouble((double)workerdata -> pubpen,4,2));
      fprintf(out,"         = %s\n\n",
         pdouble(piadata -> piael[(int)OLD_START][0], 4, 2));
      }
   else {
      if (piadata -> iwind > 1)
         {
         for (i = 0; i < 2; i++)
            fprintf(out, "%9s%4.2f * %s +\n", " ", piadata -> percw[i],
               pdouble(piadata -> paime[i][(int)WAGE_IND], 2, 0));
         fprintf(out, "%9s%4.2f * %s = "," ",piadata -> percw[2],
            pdouble(piadata -> paime[2][(int)WAGE_IND], 2, 0));
         fprintf(out, "%s\n\n",
            pdouble(piadata -> piael[(int)WAGE_IND][0], 4, 2));
         }
      else
         {
         fprintf(out, "         %s - .5*",
            pdouble(piadata -> piaw[(int)WAGE_IND],4,2));
         fprintf(out, "%s\n",
            pdouble((double)workerdata -> pubpen,4,2));
         fprintf(out,"         = %s\n\n",
            pdouble(piadata -> piael[(int)WAGE_IND][0], 4, 2));
         }
      }
}
/* Function to print out wage-indexed pia at eligibility calculation
 */
static void piaelout(
FILE *out,  /* output file */
PIADATA *piadata,  /* piadata structure */
double percpt[3],  /* pia formula percentages */
enum pia_type method)  /* method number */
{
   int i;  /* loop counter */

   fprintf(out, "      PIA at eligibility = \n");
   for (i = 0; i < 2; i++)
      fprintf(out, "%9s%4.2f * %s +\n", " ", percpt[i],
         pdouble(piadata -> paime[i][(int)method], 0, 0));
   fprintf(out, "%9s%4.2f * %s = ", " ", percpt[2],
      pdouble(piadata -> paime[2][(int)method], 0, 0));
}
