/*
 * piaoutwn.C for WindowBoss
 * Functions that use windows to write out results
 */

#ifndef lint
static char *piaoutwnID = " piaoutwn.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "pia.h"
#include "wnutils.h"
#include "prtutils.h"
#include "piaoutwn.h"
#include "comma.h"
#include "compdate.h"

static struct pmenu outmenu = {
   (WINDOW *)0, FALSE, 0,
   1, 3, {
   { 1, 2, "  Enter desired printed output (ESC to exit)", 0 },
   { 2, 2, "One-page summary (includes indexed earnings)", 1 },
   { 3, 2, "Two-page summary", 2 },
   { 4, 2, "Details of all calculations", 3 },
   { 99, 99, "", 99 } }
   };

/* Function to print printout form
 */
piaoutwn(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata,  /* Lawchg structure */
Taxes *taxdata)  /* taxdata structure */
{
   static int isum; /* type of printout (1-4) */
   int ierr;  /* error indicator */

start: /* get type of output */
   begscrn(" Print Out Results  ");
   isum = wn_popup(0,3,5,55,6,COLOR_PAIR(4),COLOR_PAIR(9),
      &outmenu,TRUE);
   if (isum < 1 || isum > 3)
      return(0);
   if (isum == 1)
      status(catstr(296));
   if (isum == 2)
      status(catstr(297));
   if (isum == 3)
      status(catstr(298));
   if ((ierr = piaout(workerdata, piadata, piaparms, lawchgdata, taxdata,
      isum, 1977)) > 0)
      wn_iemsg(catstr(ierr));
   clr_stat();
   goto start;
}
/* Function to get response for printout
 */
int getprt(
WINDOW *wn)  /* window to use */
{
   static char ansprt[3];  /* answer to printout prompt as string */
   int value;  /* 0 = false, 1 = true */

   wn_gbool(XEQ,NFRM,NFLD,wn,18,3,
      "Do you want printed output of results? (Y or N) > ",COLOR_PAIR(2),
      ' ', &value, ansprt, "%printout Y or N%", catstr(258));
   return(value);
}
/* Function to print warning about paper position
 */
void getprntr(
WINDOW *wn,  /* window to use */
chtype i2)  /* color for information */
{
   begscrn("  Prepare Printer   ");
   wattrset(wn,i2);
   wn_dtext(XEQ,NFRM,NFLD,wn,5,3,
      "Printer should be on and paper should be positioned");
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,
      "1/2 inch below top of form.");
   WREFRESH(wn);
}
/* Function to print out PEBES form
 */
int pebspage(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Pebs *pebsdata,  /* pebsdata structure */
Taxes *taxdata,  /* taxdata structure */
FOINFO *foinfo)  /* field office info structure */
{
   FILE *out;  /* output file */
   int ierr;  /* error indicator */
   char outfile[13];  /* name of output file */

   if ((out = openfile(piadata, outfile)) == (FILE *)NULL)
      return(78);
   status(catstr(299));
   pebspg1(out,workerdata,pebsdata,foinfo);
   status(catstr(300));
   pebspg2(out,workerdata,piaparms,pebsdata);
   status(catstr(301));
   pebspg3(out, workerdata, piaparms, piadata, taxdata);
   status(catstr(302));
   pebspg4(out,workerdata,pebsdata);
   status(catstr(303));
   pebspg5(out,workerdata,piaparms,pebsdata);
   if (piadata -> iprntr)
      fclose(out);
   else
      fprintf(out,"\n");
   if (piadata -> iprntr) {
      status(catstr(304));
      if ((ierr = printout(piadata, outfile)) > 0)
         return(ierr);
      }
   clr_stat();
   return(0);
}
/* Function to print summary of PEBS results on screen
 */
void pebscrn(
WINDOW *wn,  /* window to use */
Pebs *pebsdata)  /* pebsdata structure */
{
   char *form1 = "Retirement benefit at %d %s $%s";
   char *form2 = "Retirement benefit at %d and %2d months %s $%s";
   char mesg[MAXSTR];  /* temporary string */

   /* early retirement benefit */
   if (compym(pebsdata -> iagepln1, pebsdata -> nra) < 0) {
      sprintf(mesg, form2, pebsdata -> iagepln1[0], pebsdata -> iagepln1[1],
         stringd(22,'.'), pint(pebsdata -> benftpbs[2],5));
      wn_dtext(XEQ,NFRM,NFLD,wn,5,3,mesg); }
   sprintf(mesg, form2, pebsdata -> nra[0], pebsdata -> nra[1],
      stringd(22,'.'), pint(pebsdata -> benftpbs[1],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,mesg);
   sprintf(mesg, form1, 70, stringd(36,'.'),
      pint(pebsdata -> benftpbs[0],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,7,3,mesg);
   sprintf(mesg,"Surviving child and/or spouse caring for child %s $%s",
      stringd(14,'.'), pint(pebsdata -> benftpbs[3],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,8,3,mesg);
   sprintf(mesg, "Surviving spouse at full retirement age %s $%s",
      stringd(21,'.'), pint(pebsdata -> piapebs[3],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,9,3,mesg);
   sprintf(mesg, "Maximum surviving family benefit %s $%s",
      stringd(28,'.'), pint(pebsdata -> mfbpebs[3],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,10,3,mesg);
   sprintf(mesg,"One-time death benefit %s $%s", stringd(38,'.'),
      pint(255,5));
   wn_dtext(XEQ,NFRM,NFLD,wn,11,3,mesg);
   sprintf(mesg,"Disability benefit %s $%s", stringd(42,'.'),
      pint(pebsdata -> piapebs[4],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,12,3,mesg);
   sprintf(mesg,"Maximum disability family benefit %s $%s",
      stringd(27,'.'), pint(pebsdata -> mfbpebs[4],5));
   wn_dtext(XEQ,NFRM,NFLD,wn,13,3,mesg);
}
/* Function to print summary of results on screen
 */
void sumscrn(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   char mesg[80];  /* temporary string */
   int cols = 3;  /* left-hand margin */

   if (workerdata -> totalize)
      {
      if (piadata -> qctot < 6)
         wn_iemsg(catstr(190));
      if (piadata -> qctot >= piadata -> qcreq)
         wn_iemsg(catstr(191));
      }
   else
      if (piadata -> qctot < piadata -> qcreq)  /* print noninsured message */
         wn_iemsg(catstr(192));
   if (piadata -> iernyr < workerdata -> iend)  /* print unused earnings message */
      wn_iemsg(catstr(193));
   if (piadata -> over_max)  /* print truncated earnings message */
      wn_iemsg(catstr(194));
   mesg[0] = '\0';
   switch (piadata -> iappn)
      {
      case OLD_START:
      case PIA_TABLE:
      case TRANS_GUAR:
         strcpy(mesg,stringd(cols,' '));
         strncat(mesg, catstr(269), 60);
         strncat(mesg, pdouble(piadata -> ame[piadata -> iappn],8,0), 8);
         break;
      case WAGE_IND:
      case REIND_WID:
         strcpy(mesg,stringd(cols,' '));
         strncat(mesg, catstr(270), 60);
         strncat(mesg, pdouble(piadata -> ame[piadata -> iappn],8,0), 8);
         break;
      case SPEC_MIN:
         strcpy(mesg,stringd(cols,' '));
         strncat(mesg, catstr(271), 60);
         strncat(mesg, pint(piadata -> ispmnt[0], 8), 8);
         break;
      case FROZ_MIN:
         break;
      default:
         wn_iemsg(catstr(245));
         return;
      }
   if (mesg != (char *)0)
      wn_dtext(XEQ,NFRM,NFLD,wn,5,3,mesg);
   strcpy(mesg,stringd(cols,' '));
   strncat(mesg, catstr(272), 60);
   strncat(mesg, pdouble(piadata -> hipia,8,2), 8);
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,mesg);
   /* print support PIA, if applicable */
   if (piadata -> arfapp > 0) {
      strcpy(mesg,stringd(cols,' '));
      strncat(mesg, catstr(280), 60);
      strncat(mesg, pdouble(piadata -> suppia,8,2), 8);
      wn_dtext(XEQ,NFRM,NFLD,wn,7,3,mesg); }
   if (piadata -> arf >= 1.0)
      {
      strcpy(mesg,stringd(cols,' '));
      strncat(mesg, catstr(273), 60);
      strncat(mesg, pint(piadata -> mardri, 8), 8);
      wn_dtext(XEQ,NFRM,NFLD,wn,8,3,mesg);
      strcpy(mesg,stringd(cols,' '));
      strncat(mesg, catstr(274), 60);
      strncat(mesg, pdouble(piadata -> arf, 8, 3), 8);
      wn_dtext(XEQ,NFRM,NFLD,wn,9,3,mesg);
      }
   else
      {
      strcpy(mesg,stringd(cols,' '));
      strncat(mesg, catstr(275), 60);
      strncat(mesg, pint(piadata -> mardri, 8), 8);
      wn_dtext(XEQ,NFRM,NFLD,wn,8,3,mesg);
      if (workerdata -> ioasdi == SURVIVOR &&
         workerdata -> jsurv == YOUNG_SURV) {
         strcpy(mesg,stringd(cols,' '));
         strncat(mesg, catstr(276), 60);
         strncat(mesg, pdouble(piadata -> arf, 8, 3), 8); }
      else {
         strcpy(mesg,stringd(cols,' '));
         strncat(mesg, catstr(277), 60);
         strncat(mesg, pdouble(piadata -> arf, 8, 3), 8); }
      wn_dtext(XEQ,NFRM,NFLD,wn,9,3,mesg);
      }
   strcpy(mesg,stringd(cols,' '));
   strncat(mesg, catstr(278), 60);
   strncat(mesg, pdouble(piadata -> benfit[0],8,2), 8);
   wn_dtext(XEQ,NFRM,NFLD,wn,10,3,mesg);
   strcpy(mesg,stringd(cols,' '));
   strncat(mesg, catstr(281), 60);
   strncat(mesg, pdouble(piadata -> benfit[1],8,2), 8);
   wn_dtext(XEQ,NFRM,NFLD,wn,11,3,mesg);
   if (piadata -> arfapp > 0) {
      strcpy(mesg,stringd(cols,' '));
      strncat(mesg, catstr(245 + piadata -> arfapp), 60);
      wn_dtext(XEQ,NFRM,NFLD,wn,12,3,mesg); }
   strcpy(mesg,stringd(cols,' '));
   strncat(mesg, catstr(279), 60);
   strncat(mesg, pdouble(piadata -> himfb,8,2), 8);
   wn_dtext(XEQ,NFRM,NFLD,wn,13,3,mesg);
}
