/*
 * @(#)piaparms.C	1.9   3/17/94
 * Functions to handle PIA parameters
 */

#ifndef lint
static char *piaparmsID = " @(#)piaparms.C	1.9   3/17/94 ";
#endif

#include <stdio.h>
#include <math.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#if defined(MSDOS) | defined(THINK_C) | defined(M_UNIX)
#include <stdlib.h>
#else
extern char *calloc();
extern char *malloc();
extern void free();
#define fmod(x,y) (y) * ((x/y) - floor(x/y))
#endif
#if defined(M_UNIX)
#include <malloc.h>
#endif
#include "compdate.h"
#include "piaparms.h"

/* Function to initialize arrays used in piaparms
 */
int initparms(
PIAPARMS **piaparmsp,  /* piaparms structure */
int maxyears,  /* maximum number of years projected, starting with 1937 */
double maxearn,  /* maximum wage base allowed */
int maxchr,  /* maximum string length allowed */
char *directory)  /* directory with conversion table file */
{
   /* allocate memory for structure */
   if ((*piaparmsp = (PIAPARMS *)malloc(sizeof(PIAPARMS))) == (PIAPARMS *)0)
      return(285);
   /* allocate memory for benefit increases */
   if (((*piaparmsp) -> cpiinc = (float *)calloc((unsigned)(maxyears-14),
      sizeof(float))) == (float *)0)
      return(285);
   /* allocate memory for benefit increase months */
   if (((*piaparmsp) -> monben = (int *)calloc((unsigned)(maxyears-14),
      sizeof(int))) == (int *)0)
      return(285);
   /* allocate memory for indicator for no change */
   if (((*piaparmsp) -> no_change = (int *)calloc((unsigned)maxyears,
      sizeof(int))) == (int *)0)
      return(285);
   /* allocate memory for wage base */
   if (((*piaparmsp) -> base = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(285);
   /* allocate memory for old-law wage base */
   if (((*piaparmsp) -> base77 = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(285);
   /* allocate memory for HI wage bases */
   if (((*piaparmsp) -> basehi = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(285);
   /* allocate memory for average earnings */
   if (((*piaparmsp) -> fq = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(285);
   /* allocate memory for low wage */
   if (((*piaparmsp) -> wagmin = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(285);
   /* allocate memory for wage increases */
   if (((*piaparmsp) -> fqinc = (float *)calloc((unsigned)maxyears,
      sizeof(float))) == (float *)0)
      return(285);
   /* allocate memory for amount required for quarter of coverage */
   if (((*piaparmsp) -> qcamt = (float *)calloc((unsigned)maxyears,
      sizeof(float))) == (float *)0)
      return(285);
   /* allocate memory for special minimum percentage */
   if (((*piaparmsp) -> pspmin = (float *)calloc((unsigned)(maxyears-14),
      sizeof(float))) == (float *)0)
      return(285);
   if (((*piaparmsp) -> pibtable = (float *)calloc((unsigned)486,
      sizeof(float))) == (float *)0)
      return(285);
   (*piaparmsp) -> directory = directory;
   (*piaparmsp) -> maxyears = maxyears;
   (*piaparmsp) -> maxearn = maxearn;
   (*piaparmsp) -> maxchr = maxchr;
   return(0);
}
/* Function to set values for piaparms
 */
void setparms(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int i1;  /* loop counter */

   piaparms -> percp[0] = .90;
   piaparms -> percp[1] = .32;
   piaparms -> percp[2] = .15;
   /* special minimum wage base percentages */
   piaparms -> spmnper[0] = .25;
   piaparms -> spmnper[1] = .15;
   /* old-start PIB formula */
   piaparms -> ibenos[0] = 0;
   piaparms -> ibenos[1] = 50;
   piaparms -> ibenos[2] = 250;
   piaparms -> percos[0] = .40;
   piaparms -> percos[1] = .10;
   /* date of 1950 amendments */
   piaparms -> amend50[0] = 9;
   piaparms -> amend50[1] = 0;
   piaparms -> amend50[2] = 1950;
   /* date of 1952 amendments */
   piaparms -> amend52[0] = 9;
   piaparms -> amend52[1] = 0;
   piaparms -> amend52[2] = 1952;
   piaparms -> monben[1] = 9;
   /* date of 1954 amendments */
   piaparms -> amend54[0] = 9;
   piaparms -> amend54[1] = 0;
   piaparms -> amend54[2] = 1954;
   piaparms -> monben[3] = 9;
   /* date of 1956 amendments */
   piaparms -> amend56[0] = 11;
   piaparms -> amend56[1] = 0;
   piaparms -> amend56[2] = 1956;
   piaparms -> monben[5] = 11;
   /* date of 1958 amendments */
   piaparms -> amend58[0] = 1;
   piaparms -> amend58[1] = 0;
   piaparms -> amend58[2] = 1959;
   piaparms -> monben[8] = 1;
   /* date of 1961 amendments */
   piaparms -> amend61[0] = 8;
   piaparms -> amend61[1] = 0;
   piaparms -> amend61[2] = 1961;
   piaparms -> monben[10] = 8;
   /* date of 1965 amendments for benefit increase */
   piaparms -> amend651[0] = 1;
   piaparms -> amend651[1] = 0;
   piaparms -> amend651[2] = 1965;
   piaparms -> monben[14] = 1;
   /* date of 1965 amendments for change to age 60 */
   piaparms -> amend652[0] = 9;
   piaparms -> amend652[1] = 0;
   piaparms -> amend652[2] = 1965;
   /* date of 1965 amendments for old start */
   piaparms -> amend653[0] = 1;
   piaparms -> amend653[1] = 0;
   piaparms -> amend653[2] = 1966;
   /* date of 1967 amendments for old start */
   piaparms -> amend671[0] = 1;
   piaparms -> amend671[1] = 0;
   piaparms -> amend671[2] = 1968;
   /* date of 1967 amendments for benefit increase */
   piaparms -> amend672[0] = 2;
   piaparms -> amend672[1] = 0;
   piaparms -> amend672[2] = 1968;
   piaparms -> monben[16] = 2;
   /* date of 1969 amendments */
   piaparms -> amend69[0] = 1;
   piaparms -> amend69[1] = 0;
   piaparms -> amend69[2] = 1970;
   piaparms -> monben[18] = 1;
   /* date of 1970 amendments */
   piaparms -> amend70[0] = 1;
   piaparms -> amend70[1] = 0;
   piaparms -> amend70[2] = 1971;
   piaparms -> monben[19] = 1;
   /* date of 1972 amendments for benefit increase */
   piaparms -> amend721[0] = 9;
   piaparms -> amend721[1] = 0;
   piaparms -> amend721[2] = 1972;
   piaparms -> monben[21] = 9;
   /* date of 1972 amendments for special minimum */
   piaparms -> amend722[0] = 1;
   piaparms -> amend722[1] = 0;
   piaparms -> amend722[2] = 1973;
   /* date of 1974 amendments for partial increase */
   piaparms -> amend741[0] = 3;
   piaparms -> amend741[1] = 0;
   piaparms -> amend741[2] = 1974;
   /* date of 1974 amendments for full increase */
   piaparms -> amend742[0] = 6;
   piaparms -> amend742[1] = 0;
   piaparms -> amend742[2] = 1974;
   /* date of 1977 amendments */
   piaparms -> amend77[0] = 1;
   piaparms -> amend77[1] = 0;
   piaparms -> amend77[2] = 1979;
   /* date of 1980 amendments */
   piaparms -> amend80[0] = 7;
   piaparms -> amend80[1] = 0;
   piaparms -> amend80[2] = 1980;
   /* date of birth for 1981 amendments, for age 62 and 1 month */
   piaparms -> amend81[0] = 8;
   piaparms -> amend81[1] = 31;
   piaparms -> amend81[2] = 1919;
   /* date of 1981 amendments, for dollar-down rounding */
   piaparms -> amend82[0] = 6;
   piaparms -> amend82[1] = 0;
   piaparms -> amend82[2] = 1982;
   /* date of 1983 amendments */
   piaparms -> amend83[0] = 1;
   piaparms -> amend83[1] = 0;
   piaparms -> amend83[2] = 1984;
   /* date of 1988 amendments */
   piaparms -> amend88[0] = 1;
   piaparms -> amend88[1] = 0;
   piaparms -> amend88[2] = 1989;
   /* date of 1990 amendments */
   piaparms -> amend90[0] = 6;
   piaparms -> amend90[1] = 0;
   piaparms -> amend90[2] = 1992;
   for (i1 = 23; i1 < 32; i1++)
      piaparms -> monben[i1] = 6;
   for (i1 = 32; i1 < piaparms -> maxyears - 14; i1++)
      piaparms -> monben[i1] = 12;
}
/* Function to project wage-indexed bend points
 */
void bendpiac(
PIAPARMS *piaparms,  /* piaparms structure */
int melgyr,  /* year of eligibility */
double *bendpts)  /* array of bend points */
{
   double temp;  /* temporary ratio */

   temp = (piaparms -> fq[melgyr-1939])/(piaparms -> fq[40]);
   bendpts[1] = floor(180.*temp+.5);
   bendpts[2] = floor(1085.*temp+.5);
}
/* Function to set MFB formula percentages and bend points
 */
void mfbset(
PIAPARMS *piaparms,  /* piaparms structure */
int melgyr,  /* year of elgibility */
double *bendpts,  /* array of bend points */
double *percm)  /* array of percentages */
{
   double temp;  /* average wage ratio */

   /* set MFB formula percentages */
   percm[0] = 1.50;
   percm[1] = 2.72;
   percm[2] = 1.34;
   percm[3] = 1.75;
   /* set MFB formula bend points */
   temp = (piaparms -> fq[melgyr-1939])/(piaparms -> fq[40]);
   bendpts[1] = floor(230.*temp + .5);
   bendpts[2] = floor(332.*temp + .5);
   bendpts[3] = floor(433.*temp + .5);
}
/* Function to apply catch-up benefit increases
 */
double bicchp(
PIAPARMS *piaparms,  /* piaparms structure */
int year,  /* year, minus 1950, of catch-up benefit increase */
double bcatch,  /* amount to be increased */
int mcchup)  /* index of year of eligibility for catch-up benefit
   increases */
{
   if (cchpexist(piaparms, year, mcchup))
      return(round(bcatch *
         (piaparms -> cachup[mcchup][year - piaparms -> cstart]/100. + 1.),
         year+1950));
   else
      return(bcatch);
}
/* Function to check for existence of catch-up benefit increase
 */
int cchpexist(
PIAPARMS *piaparms,  /* piaparms structure */
int year,  /* year, minus 1950, of catch-up benefit increase */
int mcchup)  /* index of year of eligibility for catch-up benefit
   increases */
{
   if (year < piaparms -> cstart || year > piaparms -> cstart + 7)
      return(0);
   if (piaparms -> cachup[mcchup][year - piaparms -> cstart] < .05)
      return(0);
   return(1);
}
/* Function to return a PIA or MFB rounded to the appropriate
 * multiple of $.10.
 */
double round(
double crude,  /* unrounded PIA or MFB */
int l)  /* year of benefit increase, or year prior to year of wage-
   indexed formula */
{
   double q; /* fraction of $.01 above which PIA is rounded to next
      higher dime, for June 1981 and earlier benefit increases, and
      1982 and earlier wage-indexed formula AIME PIA's. */
   double x100; /* number of cents that PIA exceeds a multiple of a dime */

   /* round down to lower dime for June 1982 and later increases */
   if (l > 1981)
      return(floor(10.*crude+.001)/10.);
   /* for rounding-up to dime, use half-cent rule for 1972 and earlier
      increases; for 1973-81 benefit increases, round up to dime in
      any case not already an exact multiple of $.10. */
   q = (l >= 1973) ? .01 : .499;
   if ((x100 = fmod((double)crude*100.,10.)) < q)
   /* if within tolerance of q, do not round up */
      return(crude - x100/100.);
   /* otherwise round up to dime */
   else
      return(crude + .10 - x100/100.);
}
/* Function to set PIA formula percentages
 */
void percpset(
PIAPARMS *piaparms,  /* piaparms structure */
double *percp)  /* PIA formula percentages */
{
   int i1;  /* loop counter */

   for (i1 = 0; i1 < 3; i1++)
      percp[i1] = piaparms -> percp[i1];
}
/* Function to set first PIA formula percentage for windfall elimination
 * provision
 */
double percw0set(
PIAPARMS *piaparms,  /* piaparms structure */
int melgyr,  /* year of eligibility */
int *bendate,  /* date of benefit */
int spmntot)  /* years of coverage */
{
   double rv;  /* return value */
   double test;  /* test amount for year of coverage guarantee */

   if (melgyr < 1985)
      return(0.);
   if (spmntot > 29)
      return(0.);
   rv = (melgyr > 1989) ? .40 :
      piaparms -> percp[0] - .1 * (double)(melgyr - 1985);
   /* check for years of coverage guarantee (changes beginning with
    * benefits paid in 1989) */
   test = (compmdy(bendate, piaparms -> amend88) >= 0) ? .05 : .10;
   if (piaparms -> percp[0] - test * (double)(30 - spmntot) > rv)
      rv = piaparms -> percp[0] - test * (double)(30 - spmntot);
   return(rv);
}
/* Function to set indicators for no change allowed
 */
void setnoch(
PIAPARMS *piaparms,  /* piaparms structure */
int firstyr)  /* first year change is allowed */
{
   int i;  /* loop counter */

   for (i = 0; i < firstyr - 1937; i++)
      piaparms -> no_change[i] = 1;
   for (i = firstyr - 1937; i < piaparms -> maxyears; i++)
      piaparms -> no_change[i] = 0;
}
/* Function to set base year
 */
int setbasyr(
PIAPARMS *piaparms,  /* piaparms structure */
int istartnew)  /* new value of base year */
{
   int ierr;  /* error indicator */

   if ((ierr = baseyrchk(istartnew)) > 0)
      return(ierr);
   piaparms -> istart = istartnew;
   piaparms -> cstart = piaparms -> istart + 2;
   return(0);
}
/* Function to check base year
 */
int baseyrchk(
int istartnew)  /* new value of base year */
{
   if (istartnew < 1979 || istartnew > 1999)
      return(259);
   return(0);
}
