/*
 * @(#)piaparms.h	1.9   3/17/94
 * Function and structure declarations for piaparms.C
 */

#ifndef __PIAPARMS_H
#define __PIAPARMS_H

typedef struct {
   int     amend50[3];  /* date of 1950 amendments */
   int     amend52[3];  /* date of 1952 amendments */
   int     amend54[3];  /* date of 1954 amendments */
   int     amend56[3];  /* date of 1956 amendments */
   int     amend58[3];  /* date of 1958 amendments */
   int     amend61[3];  /* date of 1961 amendments */
   int     amend651[3];  /* date of 1965 amendments for benefit increase */
   int     amend652[3];  /* date of 1965 amendments for change to age 60 */
   int     amend653[3];  /* date of 1965 amendments for old start */
   int     amend671[3];  /* date of 1967 amendments for old start */
   int     amend672[3];  /* date of 1967 amendments for benefit increase */
   int     amend69[3];  /* date of 1969 amendments */
   int     amend70[3];  /* date of 1970 amendments */
   int     amend721[3];  /* date of 1972 amendments for benefit increase */
   int     amend722[3];  /* date of 1972 amendments for special minimum */
   int     amend741[3];  /* date of 1974 amendments for partial increase */
   int     amend742[3];  /* date of 1974 amendments for full increase */
   int     amend77[3];  /* date of 1977 amendments */
   int     amend80[3];  /* date of 1980 amendments */
   int     amend81[3];  /* date of birth for age 62 and 1 month in
                         * 1981 amendments */
   int     amend82[3];  /* date of 1982 amendments */
   int     amend83[3];  /* date of 1983 amendments */
   int     amend88[3];  /* date of 1988 amendments */
   int     amend90[3];  /* date of 1990 amendments */
   double *base;     /* wage base under present law, 1937 to 1936+maxyears */
   double *base77;   /* old-law wage bases (ignoring 1979-81 ad hoc
                 increases), 1937 to 1936+maxyears */
   double *basehi;   /* HI wage bases */
   float  *cpiinc;   /* benefit increases, 1951 to 1936+maxyears */
   int    *monben;   /* month of benefit increase, 1951 to 1936+maxyears */
   int     cstart;   /* starting year of catch-up benefit increases */
   double  cachup[10][8];  /* catch-up benefit increases */
   double *fq;       /* annual average earnings, 1937 to 1936+maxyears */
   int    *no_change; /* indicator for no change allowed, 1937 to
                 1936+maxyears */
   double *wagmin;   /* low wage, 1937 to 1936+maxyears */
   float  *fqinc;    /* increase in annual average earnings, 1937
                 to 1936+maxyears */
   float  *pspmin;   /* percentage of old-law wage base required for
                 year of coverage, year 1951 to 1936+maxyears */
   float  *qcamt;    /* amount required for quarter of coverage, 
                 1937 to 1936+maxyears */
   double  percp[3];  /* bend points for wage-indexed PIA formula */
   int     ibenos[3]; /* bend points for old-start PIB formula */
   double  percos[2]; /* old-start PIB formula percentages */
   double  spmnper[2];  /* percentage of old-law wage base required for
                 year of coverage for special minimum (before 1991
                 and after 1990) */
   float  *pibtable;  /* pib-pia conversion table */
   char   *directory;  /* directory with conversion table file */
   int     istart;  /* current year (year after last known benefit increase) */
   int     maxyears;  /* maximum number of years allowed, starting with 1936 */
   double  maxearn;   /* maximum earnings allowed */
   int     maxchr;    /* maximum characters in title or message */
   } PIAPARMS;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int    initparms( PIAPARMS **piaparmsp, int maxyears, double maxearn,
   int maxchr, char *directory );
void   setparms ( PIAPARMS *piaparms );
void   bendpiac ( PIAPARMS *piaparms, int melgyr, double *bendpts );
void   mfbset   ( PIAPARMS *piaparms, int melgyr, double *bendpts,
   double *percm );
double bicchp   ( PIAPARMS *piaparms, int year, double bcatch, int mchhup );
int    cchpexist( PIAPARMS *piaparms, int year, int mcchup);
double round   ( double, int );
void   percpset( PIAPARMS *piaparms, double *percp );
double percw0set( PIAPARMS *piaparms, int melgyr, int *bendate, int spmntot);
void   setnoch  ( PIAPARMS *piaparms, int firstyr );
int    setbasyr ( PIAPARMS *piaparms, int istartnew );
int    baseyrchk( int istartnew );
#else
int    initparms();
void   setparms();
void   bendpiac();
void   mfbset();
double bicchp();
int    cchpexist();
double round();
void   percpset();
double percw0set();
void   setnoch();
int    setbasyr();
int    baseyrchk();
#endif

#endif
