/*
 * @(#)prep.C	1.81   4/1/94
 * Functions to prepare the data for a PIA calculation
 */

#ifndef lint
static char *prepID = " @(#)prep.C	1.81   4/1/94 ";
#endif

#include <stdio.h>
#include <math.h>  /* definition of floor */
#include <stdlib.h>
#include "pia.h"
#include "compdate.h"
#include "ardri.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void wgbase   ( PIAPARMS *piaparms, double *baset, int firstyr,
   int lastyr, int wbind );
static int  ielgyrc1 ( WORKERDATA *workerdata, PIADATA *piadata, int jind7 );
static int  ielgyrc2 ( WORKERDATA *, int );
#else
static void wgbase();
static int  ielgyrc1();
static int  ielgyrc2();
#endif

/* Function to initialize all structures used in pia program
 */
int initpia(
Taxes **taxdatap,  /* taxdata structure */
PIADATA **piadatap,  /* piadata structure */
WORKERDATA **workerdatap,  /* workerdata structure */
PIAPARMS **piaparmsp,  /* piaparms structure */
Lawchg **lawchgdatap,  /* lawchgdata structure */
FOINFO **foinfop,  /* field office address structure */
Pebs **pebsdatap,  /* pebsdata structure */
Config *config,  /* configuration structure */
int maxyears,  /* maximum number of years projected, starting with 1937 */
int maxchr,  /* maximum string length allowed */
double maxearn)  /* maximum wage base or earnings allowed */
{
   int ierr;  /* return value */

   initcat(config -> direct[1]);
   /* initialize tax structure */
   if ((ierr = inittaxes(taxdatap, maxyears)) > 0)
      return(ierr);
   /* set tax rates */
   settxrt(*taxdatap);
   /* set calculation variables */
   if ((ierr = initcal(piadatap, maxyears, maxchr)) > 0)
      return(ierr);
   /* set input variables */
   if ((ierr = initdata(workerdatap, maxyears, maxearn, maxchr)) > 0)
      return(ierr);
   /* set printer initialization string and other printing parameters */
   setprn_init(*piadatap, config -> prn_init);
   (*piadatap) -> iprntr = &config -> iprntr;
   (*piadatap) -> command1 = config -> command1;
   (*piadatap) -> command2 = config -> command2;
   /* set calculation parameters */
   if ((ierr = initparms(piaparmsp, maxyears, maxearn, maxchr,
      config -> direct[1])) > 0)
      return(ierr);
   setparms(*piaparmsp);
   /* get base year */
   if ((ierr = getbasyr(*piaparmsp)) > 0)
      return(ierr);
#ifdef LAWCHG
   /* set law-change array */
   if ((ierr = initlc(lawchgdatap, (*piaparmsp) -> istart, maxyears - 14,
      config -> direct[1])) > 0)
      return(ierr);
#endif
   /* set field office info structure */
   if ((ierr = initfo(foinfop, config -> direct[1])) > 0)
      return(ierr);
   /* set PEBES parameters */
   if ((*pebsdatap = (Pebs *)malloc(sizeof(Pebs))) == (Pebs *)0)
      return(288);
   /* get historical amounts */
   if ((ierr = gethst(*piaparmsp)) > 0)
      return(ierr);
   /* set titles of assumptions */
   if ((ierr = asmtit(*piaparmsp)) > 0)
      return(ierr);
   /* get field office information */
   if ((ierr = getfo(*foinfop)) > 0)
      return(ierr);
#ifdef LAWCHG
   /* get law changes */
   if ((ierr = getlawchg(*lawchgdatap)) > 0)
      return(ierr);
#endif
   return(0);
}
/* Function to project quarter-of-coverage amount
 */
void qcamtc(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int i1; /* loop counter */

   for (i1 = 41; i1 < piaparms -> maxyears; i1++) {
      piaparms -> qcamt[i1] = (float)floor(25. * piaparms -> fq[i1-2] /
         piaparms -> fq[39] + .5);
      piaparms -> qcamt[i1] *= 10.; }
}
/* Function to determine freeze period and last year of allowable earnings
 */
void ernyrcal(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   int year1;  /* year before attainment of normal retirement age */
   int year2;  /* year before assumed attainment of normal
                  retirement age */

   /* determine years of freeze */
   if (workerdata -> valdi == 1) {
      piadata -> frzyr1 = (workerdata -> ionset[0] == (int)JANUARY &&
         workerdata -> ionset[1] == 1) ?
         workerdata -> ionset[2] : workerdata -> ionset[2] + 1;
      year1 = (piadata -> nra[1] + piadata -> kbirth[0] > 12) ?
         piadata -> kbirth[2] + piadata -> nra[0] :
         piadata -> kbirth[2] + piadata -> nra[0] - 1;
      if (workerdata -> ioasdi == DISABILITY) {
         year2 = (piadata -> nra[1] + workerdata -> waitper[0] > 12) ?
            workerdata -> waitper[2] + piadata -> nra[0] - 62 :
            workerdata -> waitper[2] + piadata -> nra[0] - 63;
         piadata -> frzyr2 = (year2 < year1) ? year2 : year1;
         if (workerdata -> bendate[2] - 1 < piadata -> frzyr2)
            piadata -> frzyr2 = workerdata -> bendate[2] - 1;
         }
      else
         piadata -> frzyr2 = (workerdata -> bendate[2] - 1 < year1) ?
         workerdata -> bendate[2] - 1 : year1;
      if (workerdata -> ioasdi == SURVIVOR &&
         piadata -> frzyr2 > workerdata -> ideath[2] - 1)
         piadata -> frzyr2 = workerdata -> ideath[2] - 1;
      }
   /* determine last year of allowable earnings */
   piadata -> iernyr = (workerdata -> ioasdi == SURVIVOR) ?
      workerdata -> ideath[2] : workerdata -> bendate[2] - 1;
}
/* Function to project old and new wage bases
 */
void wgbsst(
PIAPARMS *piaparms,  /* piaparms structure */
int frstyear,  /* first year in base0, base1, and base2 arrays */
int lastyear)  /* last year to project */
{
   /* project present-law OASDI bases */
   wgbase(piaparms, piaparms -> base, frstyear, lastyear, 0);
   /* project HI bases */
   wgbase(piaparms, piaparms -> basehi, frstyear, lastyear, 0);
   /* project old-law OASDI bases */
   wgbase(piaparms, piaparms -> base77, frstyear, lastyear, 2);
}
/* Function to project an old or present law wage base
 */
static void wgbase(
PIAPARMS *piaparms,  /* piaparms structure */
double *baset,  /* bases to be projected */
int firstyr,  /* first year in baset array */
int lastyr,  /* last year to project */
int wbind)  /* indicator for type of projection
          0 = present law,
     1 = prior law (ignore 1990-92 ad hoc increases),
     2 = old law (ignore 1979-81 ad hoc increases) */
{
   double baseun; /* intermediate, unrounded wage base */
   register i1; /* index of year under consideration */
   register i2; /* loop counter */
   int iflag; /* number of bases considered since last increase */
   double factor;  /* factor to apply to previous base */
   static double defcomp = .0149249;  /* increase in average wage due to
      deferred comp in 1990 */

   i1 = piaparms -> istart - firstyr + 1;
   while (i1 < lastyr-firstyr+1)
      { /* project to date of entitlement */
      iflag = 1;
      /* skip over wage bases that have been set */
      if (baset[i1] > .001)
         goto newyear;
      while ((double)piaparms -> cpiinc[i1+iflag-16] < .1)
         { /* if no benefit increase, wage base equals last previously
            * set base */
         baset[i1+iflag-1] = baset[i1-1];
         iflag++;
         if (i1+iflag >= piaparms -> maxyears)
            goto newyear;
         }
      baseun = baset[i1-1];
      for (i2 = 1; i2 <= iflag; i2++)
         {
         if (wbind != 1 && i1+i2 > 1989-firstyr+1 && i1+i2 < 1993-firstyr+1)
            {
            if (i1+i2 == 1990-firstyr+1)
               factor = piaparms -> fq[i1+i2-3] / piaparms -> fq[i1+i2-4]
                  + .02;
            else if (i1+i2 == 1991-firstyr+1)
               factor =
                  (piaparms -> fq[i1+i2-3] + .02 * piaparms -> fq[i1+i2-4]) /
                  (piaparms -> fq[i1+i2-4] + .02 * piaparms -> fq[i1+i2-5]);
            else
               factor = piaparms -> fq[i1+i2-3] * (1. + defcomp) /
                  (piaparms -> fq[i1+i2-4] + .02 * piaparms -> fq[i1+i2-5]);
            }
         else
            factor = 1.0 + (double)piaparms -> fqinc[i1+i2-3] / 100.;
         baseun = (baseun+.001)*factor;
         }
      if (wbind == 2 && i1+iflag > 1978-firstyr+1 &&
         i1+iflag < 1982-firstyr+1)
         {
         if (i1+iflag == 1979-firstyr+1)
            baset[i1+iflag-1] = 22900.;
         else if (i1+iflag == 1980-firstyr+1)
            baset[i1+iflag-1] = 25900.;
         else
            baset[i1+iflag-1] = 29700.;
         }
      else
         baset[i1+iflag-1] = 300.*floor(baseun/300.+.5);
      /* do not allow a decrease in the base */
      if (baset[i1+iflag-1] < baset[i1+iflag-2])
         baset[i1+iflag-1] = baset[i1+iflag-2];
newyear: i1 += iflag;
      } /* end while i1 */
}
/* Function to project minimum wage
 */
void minpro(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int i1;  /* loop counter */

   for (i1 = 0; i1 < piaparms -> maxyears; i1++)
      piaparms -> wagmin[i1] = .45 * piaparms -> fq[i1];
}
/* Function to project steady earnings
 */
int earnpr(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms)  /* piaparms structure */
{
   int i1; /* loop counter */
   int over_max = 0;  /* indicator for earnings over maximum allowed */

   for (i1 = workerdata -> ibegin - 1937;
      i1 <= workerdata -> iend - 1937; i1++) {
      switch (workerdata -> earntype[i1])
         {
         case MAXIMUM:
            workerdata -> earnpebs[i1] = (i1 < 14) ? 3000. :
               workerdata -> maxearn;
            if (piaparms -> base[i1] > workerdata -> maxearn)
               over_max = 1;
            break;
         case AVERAGE:
            if (piaparms -> fq[i1] <= workerdata -> maxearn)
               workerdata -> earnpebs[i1] = piaparms -> fq[i1];
            else {
               workerdata -> earnpebs[i1] = workerdata -> maxearn;
               over_max = 1; }
            break;
         case LOW:
            if (piaparms -> wagmin[i1] <= workerdata -> maxearn)
               workerdata -> earnpebs[i1] = piaparms -> wagmin[i1];
            else {
               workerdata -> earnpebs[i1] = workerdata -> maxearn;
               over_max = 1; }
            break;
         case OLDLAWMAX:
            if (piaparms -> base77[i1] <= workerdata -> maxearn)
               workerdata -> earnpebs[i1] = piaparms -> base77[i1];
            else {
               workerdata -> earnpebs[i1] = workerdata -> maxearn;
               over_max = 1; }
            break;
         case CHILDCARE:
            workerdata -> earnpebs[i1] = 0.;
            break;
         case ENTERED:
            break;
         } /* end switch */
      } /* end for */
   return(over_max);
}
/* Function to project average wages
 */
void avgpro(
PIAPARMS *piaparms)  /* piaparms structure */
{
   register i1; /* loop counter */

   for (i1 = piaparms -> istart - 1938; i1 < piaparms -> maxyears; i1++) {
      piaparms -> fq[i1] = piaparms -> fq[i1-1] *
         ( (double)piaparms -> fqinc[i1] / 100. + 1.);
      /* round to nearest penny */
      piaparms -> fq[i1] = (floor(piaparms -> fq[i1] * 100. + .5))/100.;
      }
}
/* Function to compute year of eligibility
 */
void elgyr(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
#ifdef LAWCHG
   int i1;  /* temporary value */
#endif

   /* determine worker's year of eligibility */
   piadata -> ielgyr[0] = ielgyrc1(workerdata, piadata, 0);
   /* take disability into account */
   piadata -> ielgyr[1] = ielgyrc2(workerdata, piadata -> ielgyr[0]);
#ifdef LAWCHG
   /* account for age-65 computation point if proposed law */
   if (lawchgdata -> jind[7] > 0 &&
      piadata -> ielgyr[0] >= lawchgdata -> jstart[0][7]) {
      i1 = (piadata -> ielgyr[0] + 1 - lawchgdata -> jstart[0][7] > 3) ? 3 :
         piadata -> ielgyr[0] + 1 - lawchgdata -> jstart[0][7];
      lawchgdata -> ielgy1 = ielgyrc1(workerdata, piadata, i1);
      lawchgdata -> ielgy1 = ielgyrc2(workerdata, lawchgdata -> ielgy1);
      }
#endif

   /* determine widow's year of eligibility */

   if (workerdata -> ioasdi == SURVIVOR &&
      (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID))
      {
      if (workerdata -> jsurv == DISAB_WID)
         piadata -> kelgyr = (piadata -> lbirth[2] + 50 <
            workerdata -> jonset[2]) ?
            workerdata -> jonset[2] :
            piadata -> lbirth[2] + 50;
      else
         piadata -> kelgyr = piadata -> lbirth[2] + 60;
      }
}
/* Function to compute year of eligibility before considering disability
 */
static int ielgyrc1(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
int jind7)  /* 0 for present law, 1-3 for change to age-65 comp point */
{
   int rv;  /* return value */

   rv = piadata -> kbirth[2] + 62; /* start with year of age 62 */
#ifdef LAWCHG
   if (jind7 > 0)
      rv += jind7;
#endif
   if (workerdata -> isex == 1 && rv < 1975)
      /* account for age-65 computation point for older workers */
      rv = (1975 < rv + 3) ? 1975 : rv + 3;
   if (workerdata -> ioasdi == SURVIVOR && rv > workerdata -> ideath[2])
      /* for survivors, use year of death, if earlier */
      rv = workerdata -> ideath[2];
   return(rv);
}
/* Function to compute year of eligibility after considering disability
 */
static int ielgyrc2(
WORKERDATA *workerdata,  /* workerdata structure */
int melgyr)  /* year of attainment of age 62, for old-age and disability,
   or year of death, for survivor */
{
   int rv;  /* return value */

   rv = melgyr;
   if (workerdata -> ioasdi != DISABILITY && workerdata -> valdi == 1 &&
      rv > workerdata -> ionset[2])
      /* consider disability onset prior to eligibility */
      rv = workerdata -> ionset[2];
   if (workerdata -> ioasdi == DISABILITY && rv > workerdata -> ionset[2])
      rv = workerdata -> ionset[2];
   return(rv);
}
/* Function to calculate relative earnings position
 */
float repcal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   double rv;  /* return value */
   int i1;  /* loop counter */
   double reptot = 0.;  /* total of annual rep's */
   int temp;  /* temporary index */
   double test;  /* proportioned wage base */
   int qtr;  /* quarter of death */

   /* reset years of earnings, if necessary */
   if (workerdata -> ibegin > piadata -> kbirth[2] + 22) {
      temp = (piadata -> kbirth[2] + 22 < 1937) ?
         1937 : piadata -> kbirth[2] + 22;
      for (i1 = temp - 1937; i1 < workerdata -> ibegin - 1937; i1++)
         piadata -> earnst[0][i1] = 0.;
      workerdata -> ibegin = temp;
      }
   if (workerdata -> iend < piadata -> ielgyr[1]) {
      temp = piadata -> ielgyr[1];
      for (i1 = workerdata -> iend - 1936; i1 < temp - 1936; i1++)
         piadata -> earnst[0][i1] = 0.;
      workerdata -> iend = temp;
      }
   /* calculate relative earnings position */
   for (i1 = workerdata -> ibegin - 1937; i1 < workerdata -> iend - 1936; i1++)
      {
      if (workerdata -> qc[i1] > 0) {
         test = (double)workerdata -> qc[i1] * piaparms -> base[i1] / 4.;
         piadata -> rep[i1] = (float)((piadata -> earnst[0][i1] < test) ?
            piadata -> earnst[0][i1] : test) / piaparms -> fq[i1];
         piadata -> rep[i1] =
            (float)floor(piadata -> rep[i1] * 100000. + .5) / 100000.;
         reptot += piadata -> rep[i1];
         }
      else
         piadata -> rep[i1] = 0.;
      }
   rv = floor(400000. * reptot / (double)piadata -> qctot + .5) / 100000.;
   temp = (workerdata -> ioasdi == SURVIVOR &&
      workerdata -> ideath[2] == piadata -> ielgyr[1]) ?
      piadata -> ielgyr[1] - 1936 : piadata -> ielgyr[1] - 1937;
   for (i1 = workerdata -> ibegin - 1937; i1 < workerdata -> iend - 1936; i1++)
      {
      /* fill in earnings from 22 to eligibility, plus other years with
         at least 1 qc */
      if (((i1 < piadata -> kbirth[2] - 1915 ||
         i1 > temp - 1) && workerdata -> qc[i1] > 0)
         || (i1 > piadata -> kbirth[2] - 1916 && i1 < temp))
         piadata -> earnst[1][i1] = rv * piaparms -> fq[i1];
      /* prorate by quarter in year of death */
      if (i1 == workerdata -> ideath[2] - 1937) {
         qtr = (workerdata -> ideath[0] + 2)/3;
         piadata -> earnst[1][i1] *= qtr/4.;
         }
      piadata -> earnst[1][i1] = floor(100.*piadata -> earnst[1][i1]+.5)/100.;
      }
   return((float)rv);
}
/* Function to determine number of elapsed years, computation years,
 * and dropout years
 */
void ncal(
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
PIAPARMS *piaparms,  /* piaparms structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int ntype)  /* 0 for new-start, 1 for old-start */
{
   int elap0;  /* start year */
   int elap1;  /* first elapsed year */
   int elap2;  /* last elapsed year */
   int *nx;  /* n or nold */
   int *nelapx;  /* nelap or nelapold */
   int *ndropx;  /* ndrop or ndropold */

   if (ntype == 0) {
      nx = &piadata -> n;
      nelapx = &piadata -> nelap;
      ndropx = &piadata -> ndrop;
      }
   else {
      nx = &piadata -> nold;
      nelapx = &piadata -> nelapold;
      ndropx = &piadata -> ndropold;
      }
   elap0 = (ntype > 0) ? 1936 : 1950;
   elap1 = (piadata -> kbirth[2] + 21 > elap0) ?
      piadata -> kbirth[2] + 21 : elap0;

   /* account for 1960 ending year for 1960 or later method, nondisability */
#ifdef LAWCHG
   if (lawchgdata -> jind[7] > 0)
      elap2 = (workerdata -> ient[2] > 1960 &&
         lawchgdata -> ielgy1 < 1961 &&
         workerdata -> valdi == 0) ? 1960 : lawchgdata -> ielgy1 - 1;
   else
#endif
      elap2 = (workerdata -> ient[2] > 1960 &&
         piadata -> ielgyr[1] < 1961 &&
         workerdata -> valdi == 0) ? 1960 : piadata -> ielgyr[1] - 1;
   if (workerdata -> ioasdi == SURVIVOR &&
      elap2 > workerdata -> ideath[2] - 1)
      elap2 = workerdata -> ideath[2] - 1;

   *nelapx = elap2 - elap1;
   if (*nelapx < 2)
      *nelapx = 2;
#ifdef LAWCHG
   if (lawchgdata -> jind[7] > 0) {
      if (*nelapx > 43)
         *nelapx = 43;
      }
   else
#endif
      if (*nelapx > 40)
         *nelapx = 40;

   /* if entitlement in June 1992 or later, use 5 dropout */
   if (compmdy(workerdata -> ient, piaparms -> amend90) >= 0)
      *ndropx = 5;
   else {
      /* if death is in Sept 1954 or later, use 5 dropout */
      if (workerdata -> ioasdi == SURVIVOR) {
         /* if disability freeze, use 5 dropout for disability in Sept 1954
          * or later */
         if (workerdata -> valdi == 1)
            *ndropx =
               (compmdy(workerdata -> ionset, piaparms -> amend54) >= 0) ?
               5 : 0;
         else
            *ndropx =
               (compmdy(workerdata -> ideath, piaparms -> amend54) >= 0) ?
               5 : 0;
         }
      else
      {
         /* if disability freeze, use 5 dropout for disability in Sept 1954
          * or later */
         if (workerdata -> valdi == 1)
            *ndropx =
               (compmdy(workerdata -> ionset, piaparms -> amend54) >= 0) ?
               5 : 0;
         else
            /* if entitlement is in Sept 1954 or later, use 5 dropout */
            *ndropx =
               (compmdy(workerdata -> ient, piaparms -> amend54) >= 0) ?
               5 : 0;
         }
      }
   if ((workerdata -> valdi == 1 && workerdata -> ioasdi == OLD_AGE &&
      compmdy(workerdata -> priorent, piaparms -> amend80) >= 0)
      || (compmdy(workerdata -> ient, piaparms -> amend80) >= 0 &&
      workerdata -> ioasdi == DISABILITY))
      /* 1-for-5 dropout rule for DI, if not survivor */
      *ndropx = (*nelapx/5 < 5) ? *nelapx/5 : *ndropx;
#ifdef LAWCHG
   if (lawchgdata -> jind[14] > 0 &&
      workerdata -> ient[2] >= lawchgdata -> jstart[0][14] &&
      piadata -> ielgyr[1] >= lawchgdata -> jstart[0][14] - 2)
      *ndropx = 5;
#endif

   *nx = *nelapx - *ndropx;
   if (*nx < 2) { /* nx is minimum of 2 */
      *nx = 2;
      *ndropx = *nelapx - *nx;
      }
   if (workerdata -> ioasdi == OLD_AGE && workerdata -> ient[2] < 1958 &&
      ntype == 0)
      { /* old-age modification prior to 1958 */
      *nx = piadata -> ielgyr[1] - 1953;
      if (*nx < 2) {
         *nx = 2;
         *ndropx = *nelapx - *nx;
         }
      }
   return;
}
/* Function to calculate worker age at entitlement
 */
void entage(
int age[2],  /* calculated age (years and months) */
int birth[3],  /* month, day, and year of birth */
int dateage[3])  /* date of desired age (month, day, and year) */
{
   age[0] = dateage[2] - birth[2]; /* set years */
   age[1] = dateage[0] - birth[0]; /* set months */
   if (age[1] < 0) { /* adjust age downward if less than 0 months */
      age[1] += 12;
      age[0]--; }
   if (age[1] > 11) { /* adjust age upward if more than 11 months */
      age[1] -= 12;
      age[0]++; }
   return;
}
/* Function to calculate a date by adding year and month to prior date
 */
void datecal(
int newdate[3],  /* date to be calculated (month, day, and year) */
int olddate[3],  /* prior date (month, day, and year) */
int age[2])  /* age to add to prior date (years and months) */
{
   newdate[0] = olddate[0] + age[1];
   newdate[1] = 0;
   newdate[2] = olddate[2] + age[0];
   if (newdate[0] > 12) {
      newdate[0] -= 12;
      newdate[2]++; }
}
/* Function to project earnings
 */
void ernproj(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   register i1;  /* loop counter */

   for (i1 = workerdata -> ibegin1 - 1937;
      i1 < workerdata -> iend1 - 1936; i1++)
      piadata -> earnst[0][i1] = workerdata -> earnpebs[i1];
   if (workerdata -> projback) {
      for (i1 = workerdata -> ibegin1 - 1938;
         i1 > workerdata -> ibegin - 1938; i1--) {
         if (workerdata -> projback == 2)
            piadata -> earnst[0][i1] = piadata -> earnst[0][i1 + 1] /
               (1. + workerdata -> percback / 100.);
         else
            piadata -> earnst[0][i1] = piadata -> earnst[0][i1 + 1] /
               (1. + (piaparms -> fqinc[i1 + 1] +
               workerdata -> percback) / 100.);
         if (piadata -> earnst[0][i1] > workerdata -> maxearn) {
            piadata -> earnst[0][i1] = workerdata -> maxearn;
            piadata -> over_max = 1; }
         }
      }
   if (workerdata -> projfwrd) {
      for (i1 = workerdata -> iend1 - 1936;
         i1 < workerdata -> iend - 1936; i1++) {
         if (workerdata -> projfwrd == 2)
            piadata -> earnst[0][i1] = piadata -> earnst[0][i1 - 1] *
               (1. + workerdata -> percfwrd / 100.);
         else
            piadata -> earnst[0][i1] = piadata -> earnst[0][i1 - 1] *
               (1. + (piaparms -> fqinc[i1] +
               workerdata -> percfwrd) / 100.);
         if (piadata -> earnst[0][i1] > workerdata -> maxearn) {
            piadata -> earnst[0][i1] = workerdata -> maxearn;
            if (workerdata -> earntype[workerdata -> iend1 - 1937] != MAXIMUM)
               piadata -> over_max = 1;
            }
         }
      }
   /* calculate HI earnings */
   for (i1 = workerdata -> ibegin - 1937;
      i1 < workerdata -> iend - 1936; i1++)
      piadata -> earnst[4][i1] = piadata -> earnst[0][i1] +
         workerdata -> earnhi[i1];
   for (i1 = 0; i1 < workerdata -> ibegin - 1937; i1++) {
      piadata -> earnst[0][i1] = 0.0;
      piadata -> earnst[4][i1] = 0.0;
      }
   for (i1 = workerdata -> iend - 1936; i1 < workerdata -> maxyears; i1++) {
      piadata -> earnst[0][i1] = 0.0;
      piadata -> earnst[4][i1] = 0.0;
      }
   /* limit earnings to wage base */
   ernlimit(piadata -> earnst[2], piadata -> earnst[0], piaparms -> base,
      piaparms -> maxyears);
   ernlimit(piadata -> earnst[5], piadata -> earnst[4], piaparms -> basehi,
      piaparms -> maxyears);
}
/* Function to check data for validity
 */
datacheck(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int ierr;  /* error indicator */

   if (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = monthnchk(workerdata -> monthnow)) > 0)
         return(ierr);
      setpbdata(workerdata);
      setbirth(workerdata -> ibirth, piadata -> kbirth);
      /* ielgyr[1] is not yet calculated for PEBES case; use piadata -> kbirth[2]+62
       * since there is no prior disability in PEBES case */
      nracal(workerdata, lawchgdata, piadata -> nra, piadata -> kbirth[2] + 62);
      datecal(piadata -> nradate, piadata -> kbirth, piadata -> nra);
      if ((ierr = agecheck(workerdata, piadata -> nradate)) > 0)
         return(ierr);
      }
   else
      {
      if ((ierr = ientchk(workerdata -> ient)) > 0)
         return(ierr);
      if (workerdata -> recalc) {
         if ((ierr = bendt2chk(workerdata)) > 0)
            return(ierr);
         }
      else
         setbendt2(workerdata);
      if (workerdata -> ioasdi == DISABILITY)
         workerdata -> valdi = 1;
      if ((ierr = ibegchk(workerdata)) > 0)
         return(ierr);
      if ((ierr = iendcheck(workerdata)) > 0)
         return(ierr);
      setbirth(workerdata -> ibirth, piadata -> kbirth);
      nracal(workerdata, lawchgdata, piadata -> nra, piadata -> kbirth[2] + 62);
      datecal(piadata -> nradate, piadata -> kbirth, piadata -> nra);
      }
   /* calculate early retirement age */
   if (workerdata -> ioasdi == OLD_AGE) /* only for old-age */
      nra1cal(workerdata, piaparms, piadata);
   if (workerdata -> joasdi != PEBS_CALC) {
      /* calculate age at entitlement */
      entage(piadata -> iage, piadata -> kbirth, workerdata -> ient);
      /* calculate age at benefit date */
      entage(piadata -> iage1, piadata -> kbirth, workerdata -> bendate);
      setiagepl(workerdata, 0); }
   qctdchk2(workerdata);
   if ((ierr = qccheck(workerdata)) > 0)
      return(ierr);
   if ((ierr = dthcheck(workerdata)) > 0)
      return(ierr);
   if (workerdata -> joasdi == SURVIVOR)
      if ((ierr = jsurvchk((int)workerdata -> jsurv)) > 0)
         return(ierr);
   if (workerdata -> valdi == 1) {
      if (compmdy(workerdata -> ionset, piadata -> nradate) >= 0)
         /* disability after normal retirement age */
         return(159);
      if ((ierr = discheck(workerdata)) > 0)
         return(ierr);
      if (workerdata -> ioasdi == OLD_AGE) {
         if (compmdy(workerdata -> priorent, piadata -> nradate) >= 0)
            /* prior entitlement after normal retirement age */
            return(162);
         if ((ierr = priorchk(workerdata)) > 0)
            return(ierr);
         }
      }
   if (workerdata -> ioasdi == DISABILITY)
      if ((ierr = waitchk(workerdata)) > 0)
         return(ierr);
   if (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID) {
      setbirth(workerdata -> jbirth, piadata -> lbirth);
      /* calculate widow's age at entitlement */
      entage(piadata -> jage, piadata -> lbirth, workerdata -> ient);
      }
   if (workerdata -> jsurv == DISAB_WID)
      if ((ierr = widcheck(workerdata)) > 0)
         return(ierr);
   /* set PEBS assumptions */
   if (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = pebsasmchk(workerdata)) > 0)
         return(ierr);
      setibasch(workerdata, 1);
      }
   else
      {
      elgyr(workerdata, piadata, lawchgdata);
      if ((ierr = ardri(workerdata, piaparms, piadata, lawchgdata)) > 0)
         return(ierr);
      if (need_bi(workerdata) == 0)
         workerdata -> ialtbi = FLAT;
      if (need_aw(workerdata) == 0)
         workerdata -> ialtaw = FLAT;
      if (workerdata -> anscch != 'Y')
         zerocch(workerdata -> cachup);
      }
   return(0);
}
/* Function to limit earnings to wage base
 */
void ernlimit(
double *earnings1,  /* array of limited earnings */
double *earnings2,  /* array of unlimited earnings */
double *tbase,  /* array of wage bases */
int numyears)  /* number of years to compare */
{
   int i2;  /* loop counter */

   for (i2 = 0; i2 < numyears; i2++)
      earnings1[i2] = (earnings2[i2] > tbase[i2]) ?
         tbase[i2] : earnings2[i2];
}
