/*
 * @(#)prtutils.C	1.50   4/1/94
 * Various functions used in print routines.
 */

#ifndef lint
static char *prtutilsID = " @(#)prtutils.C	1.50   4/1/94 ";
#endif

#include "stdio.h"
#include <stdlib.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#include <stdlib.h>
#if DLC > 0
#include <disp.h>
#endif
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "taxes.h"
#include "piaout.h"
#include "prtutils.h"
#include "utils.h"
#include "setup.h"
#include "comma.h"
#include "mesgcat.h"

/* Function to send print file to printer
 */
printout(
PIADATA *piadata,  /* piadata structure */
char *toutfile) /* name of output file */
{
   char command[100]; /* command string */

   strcpy(command, piadata -> command1);
   strcat(command," ");
   strcat(command,toutfile);
   strcat(command," ");
   strcat(command, piadata -> command2);
   return(system(command));
}
/* Function to print bottom of letter for disability
 */
void bottom3(
FILE *out,  /* print file */
char *retire,  /* type of estimate */
enum assum_type assumption)  /* projection assumption */
{
   fprintf(out,
      "\n      The estimates on this statement are based on your earnings\n");
   fprintf(out,
      "      record and any information you gave us.  We used current\n");
   fprintf(out,
      "      dollar values for these estimates.");
   if (assumption == PEBS_ASSUM) {
      fprintf(out,"  We adjusted all %s\n", retire);
      fprintf(out,
         "      estimates to account for average wage growth in the national\n");
      fprintf(out,
         "      economy by increasing your benefit by 1 percent for each\n");
      fprintf(out, "      year between now and when you turn age 62.\n"); }
   else
      fprintf(out, "\n");
}
/* Function to print out name and SSN
 */
void prtnmssn(
FILE *out,  /* print file */
WORKERDATA *workerdata,  /* workerdata structure */
int cols)  /* number of columns to skip */
{
   fprintf(out, "%sWage earner:  %s\n", stringd(cols,' '),
      workerdata -> nhname);
   fprintf(out, "%sSSN:  %s\n", stringd(cols,' '), workerdata -> ssn);
}
/* Function to print out uninsured message
 */
void nonins(
FILE *out,  /* print file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
int cols)  /* number of columns to skip */
{
   static char form1[] = "%sWarning! %s";  /* format for output */

   if (workerdata -> totalize)
      {
      if (piadata -> qctot < 6)
         fprintf(out, form1, stringd(cols,' '), catstr(190));
      if (piadata -> qctot >= piadata -> qcreq)
         fprintf(out, form1, stringd(cols,' '), catstr(191));
      }
   else
      if (piadata -> qctot < piadata -> qcreq)
         fprintf(out, form1, stringd(cols,' '), catstr(192));
}
/* Function to print out noncovered pension
 */
void nonpenout(
FILE *out,  /* print file */
WORKERDATA *workerdata,  /* workerdata structure */
int cols)  /* number of columns to skip */
{
   fprintf(out, "%sNoncovered monthly pension = %s\n", stringd(cols,' '),
      pdouble((double)workerdata -> pubpen, 3, 2));
}
/* Function to print out disability insured message
 */
void disinsout(
FILE *out,  /* print file */
int cols)  /* number of columns to skip */
{
   fprintf(out, "%s%s\n", stringd(cols,' '), catstr(289));
}
