/*
 * @(#)savdis.C	1.84   4/7/94
 * Functions to read a case from or save a case to disk
 */

#ifndef lint
static char *savdisID = " @(#)savdis.C	1.84   4/7/94 ";
#endif

#include <stdio.h>
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "utils.h"
#include "scanfile.h"
#include "compdate.h"
#include "savdis.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int  ibirthf  ( FILE *in, WORKERDATA *workerdata );
static int  earntypef( FILE *in, WORKERDATA *workerdata );
static int  ionsetf  ( FILE *, WORKERDATA * );
static int  priorf   ( FILE *, WORKERDATA * );
static int  waitperf ( FILE *, WORKERDATA * );
static int  benredf  ( FILE *, WORKERDATA * );
static int  avgredf  ( FILE *, WORKERDATA * );
static int  wagebsf  ( FILE *, WORKERDATA * );
static int  taxf     ( FILE *, WORKERDATA * );
static int  earnfhi  ( FILE *, WORKERDATA * );
static int  qc1f     ( FILE *in, WORKERDATA *workerdata );
static int  qc2f     ( FILE *in, WORKERDATA *workerdata );
#else
static int ibirthf();
static int earntypef();
static int ionsetf();
static int priorf();
static int waitperf();
static int benredf();
static int avgredf();
static int wagebsf();
static int taxf();
static int earnfhi();
static int qc1f();
static int qc2f();
#endif

/* Function to read case from file
 */
readfile(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1; /* loop counter */
   int iend2; /* last year of earnings in file */
   int itemp;  /* temporary integer */
   float ftemp;  /* temporary float */
   int datetemp[3];  /* temporary date */
   int ierr;  /* error indicator */

   do {
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setistart(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setisex(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setjoasdi(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setrecalc(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = settotali(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setmqge(workerdata, itemp)) > 0)
         break;
      if ((ierr = ibirthf(in,workerdata)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setmonthn(workerdata,itemp)) > 0)
         break;
      /* read date of entitlement */
      if (fscanf(in, "%d", datetemp) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setient(workerdata, datetemp)) > 0)
         break;
      /* read date of benefit */
      if (fscanf(in, "%d", datetemp) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setbendt1(workerdata, datetemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setiagepl(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setprojbk(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%f", &ftemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setpercbk(workerdata, ftemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setibegin(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setibegn1(workerdata, itemp)) > 0)
         break;
      if ((ierr = ibegchk(workerdata)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setprojfd(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%f", &ftemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setpercfd(workerdata, ftemp)) > 0)
         break;
      if (fscanf(in, "%d", &iend2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setiend1(workerdata, iend2)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setiend(workerdata, itemp)) > 0)
         break;
      if ((ierr = iendcheck(workerdata)) > 0)
         break;
      if ((ierr = earntypef(in, workerdata)) > 0)
         break;
      if ((ierr = qc1f(in,workerdata)) > 0)
         break;
      if (qcbyyear(workerdata))
         if ((ierr = qc2f(in,workerdata)) > 0)
            break;
      if (fscanf(in, "%d", datetemp) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setideath(workerdata, datetemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setjsurv(workerdata, itemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setvaldi(workerdata, itemp)) > 0)
         break;
      if ((ierr = valdi2chk(workerdata)) > 0)
         break;
      if ((ierr = ionsetf(in,workerdata)) > 0)
         break;
      if ((ierr = priorf(in,workerdata)) > 0)
         break;
      if ((ierr = waitperf(in,workerdata)) > 0)
         break;
      if (fscanf(in, "%d", datetemp) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 1) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setjbirth(workerdata, datetemp)) > 0)
         break;
      if (fscanf(in, "%d", datetemp) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 1) <= 0) {
         ierr = 69;
         break; }
      if (fscanf(in, "%d", datetemp + 2) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setjonset(workerdata, datetemp)) > 0)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setialtbi(workerdata,itemp)) > 0)
         break;
      if (workerdata -> ialtbi == OTHER_ASSUM)
         ierr = benredf(in,workerdata);
      else
         setanscch(workerdata, 'N');
      if (ierr)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setialtaw(workerdata,itemp)) > 0)
         break;
      if (workerdata -> joasdi == PEBS_CALC)
         if ((ierr = pebsasmchk(workerdata)) > 0)
            break;
      if (workerdata -> ialtaw == OTHER_ASSUM)
         ierr = avgredf(in,workerdata);
      if (ierr)
         break;
      if (fscanf(in, "%d", &itemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setibasch(workerdata, itemp)) > 0)
         break;
      if (workerdata -> ibasch == 2)
         if ((ierr = wagebsf(in,workerdata)) > 0)
            break;
      zeroearn(workerdata);
      if ((ierr = earnf(in, workerdata)) > 0)
         break;
      if (workerdata -> mqge)
         if ((ierr = earnfhi(in, workerdata)) > 0)
            break;
      if (workerdata -> joasdi == PEBS_CALC)
         setpbdata(workerdata);
      /* fill out earnings, if necessary */
      for (i1 = iend2 + 1; i1 <= workerdata -> iend1; i1++)
         setearnpb(workerdata, i1, workerdata -> earnpebs[iend2 - 1937]);
      if ((ierr = taxf(in,workerdata)) > 0)
         break;
      if (fscanf(in, "%f", &ftemp) <= 0) {
         ierr = 69;
         break; }
      if ((ierr = setpubpen(workerdata, ftemp)) > 0)
         break;
      if (getitle(workerdata -> nhname, 35, in) < 0) {
         ierr = 69;
         break; }
      if (getitle(workerdata -> nhname, 35, in) < 0) {
         ierr = 69;
         break; }
      for (i1 = 0; i1 < 3; i1++) {
         if (getitle(workerdata -> nhaddr[i1], 35, in) < 0) {
            ierr = 69;
            break; }
         }
      if (getitle(workerdata -> ssn, 12, in) < 0) {
         ierr = 69;
         break; }
      } while (0);
   fclose(in);
   return(ierr);
}
/* Function to read date of birth from file
 */
static int ibirthf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int datetemp[3];  /* temporary date */
   int ierr;  /* error indicator */

   if (fscanf(in, "%d", datetemp) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 1) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 2) <= 0)
      return(69);
   if ((ierr = setibirth(workerdata, datetemp)) > 0)
      return(ierr);
   return(0);
}
/* Function to read type of earnings vector from file
 */
static int earntypef(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int earntypet;  /* earntype as integer */
   int i1;  /* loop counter */
   int ierr;  /* error indicator */

   for (i1 = workerdata -> ibegin1; i1 <= workerdata -> iend1; i1++) {
      if (fscanf(in, "%d", &earntypet) <= 0)
         return(69);
      if ((ierr = setearntp(workerdata, i1, earntypet)) > 0)
         return(ierr);
      }
   return(0);
}
/* Function to read date of disability onset from file
 */
static int ionsetf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int datetemp[3];  /* temporary date */
   int rv;  /* return value */

   if (fscanf(in, "%d", datetemp) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 1) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 2) <= 0)
      return(69);
   if ((rv = setionset(workerdata, datetemp)) > 0)
      return(rv);
   if (workerdata -> valdi == 1)
      if ((rv = discheck(workerdata)) > 0)
         return(rv);
   return(0);
}
/* Function to read date of prior disability entitlement from file
 */
static int priorf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int datetemp[3];  /* temporary date */
   int rv;  /* return value */

   if (fscanf(in, "%d", datetemp) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 2) <= 0)
      return(69);
   if ((rv = setprrent(workerdata, datetemp)) > 0)
      return(rv);
   if (workerdata -> valdi == 1 && workerdata -> joasdi == OLD_AGE)
      if ((rv = priorchk(workerdata)) > 0)
         return(rv);
   return(0);
}
/* Function to read first month of waiting period from file
 */
static int waitperf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int datetemp[3];  /* temporary date */
   int rv;  /* return value */

   if (fscanf(in, "%d", datetemp) <= 0)
      return(69);
   if (fscanf(in, "%d", datetemp + 2) <= 0)
      return(69);
   if ((rv = setwaitpd(workerdata, datetemp)) > 0)
      return(rv);
   if (workerdata -> joasdi == DISABILITY)
      if ((rv = waitchk(workerdata)) > 0)
         return(rv);
   return(0);
}
/* Function to read user-specified benefit increases from file
 */
static benredf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1,i2; /* loop counters */
   char temp[20];  /* temporary string */
   int ierr;  /* error indicator */
   float ftemp;  /* temporary float */
   double dtemp;  /* temporary double */

   workerdata -> jaltbi = 0;
   for (i1 = workerdata -> istart; i1 <= workerdata -> bendate[2]; i1++) {
      if (fscanf(in, "%f", &ftemp) <= 0)
         return(69);
      if ((ierr = setcpiinc(workerdata, i1, ftemp)) > 0)
         return(ierr);
      }
   if (fscanf(in, "%s\n", temp) <= 0)
      return(69);
   if ((ierr = setanscch(workerdata, temp[0])) > 0)
      return(ierr);
   if (workerdata -> anscch == 'Y')
      {
      for (i2 = 0; i2 < 10; i2++) {
         for (i1 = 0; i1 < 8; i1++) {
            if (fscanf(in, "%lf\n", &dtemp) <= 0)
               return(69);
            if ((ierr = setcachup(workerdata, i2, i1, dtemp)) > 0)
               return(ierr);
            } /* end for i1 */
         } /* end for i2 */
      } /* end if */
   if (getitle(workerdata -> titlbi, workerdata -> maxchr, in) < 0)
      return(69);
   return(0);
}
/* Function to read user-specified average wage increases from file
 */
static avgredf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i1; /* loop counter */
   float fqinct;  /* temporary fqinc */
   int ierr;  /* error indicator */

   workerdata -> jaltaw = 0;
   for (i1 = workerdata -> istart - 1; i1 <= workerdata -> bendate[2]; i1++) {
      if (fscanf(in, "%f\n", &fqinct) <= 0)
         return(69);
      if ((ierr = setfqinc(workerdata, i1, fqinct)) > 0)
         return(ierr);
      }
   if (getitle(workerdata -> titlaw, workerdata -> maxchr, in) < 0)
      return(69);
   return(0);
}
/* Function to get specified wage bases from file
 */
static wagebsf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1; /* loop counter */
   double baset;  /* temporary wage base */
   int ierr;  /* error indicator */

   workerdata -> jbasch = 0;
   for (i1 = workerdata -> istart + 1; i1 <= workerdata -> bendate[2]; i1++) {
      if (fscanf(in, "%lf", &baset) <= 0)
         return(69);
      if ((ierr = setbase(workerdata, i1, baset)) > 0)
         return(ierr);
      }
   for (i1 = workerdata -> istart + 1; i1 <= workerdata -> bendate[2]; i1++) {
      if (fscanf(in, "%lf", &baset) <= 0)
         return(69);
      if ((ierr = setbase77(workerdata, i1, baset)) > 0)
         return(ierr);
      }
   return(0);
}
/* Function to get Medicare earnings from file
 */
static int earnfhi(
FILE *infile,  /* input file */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1; /* loop counter */
   double earnhit;  /* temporary Medicare earnings */
   int ierr;  /* error indicator */

   for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++)
      {
      if (fscanf(infile, "%lf", &earnhit) <= 0)
         return(69);
      if ((ierr = setearnhi(workerdata, i1, earnhit)) > 0)
         return(ierr);
      }
   return(0);
}
/* Function to get type of taxes from file
 */
static int taxf(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1;  /* loop counter */
   int taxtypet;  /* temporary taxtype */
   int ierr;  /* error indicator */

   for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++)
      {
      if (fscanf(in, "%d", &taxtypet) <= 0)
         return(69);
      if ((ierr = settaxtyp(workerdata, i1, taxtypet)) > 0)
         return(ierr);
      }
   return(0);
}
/* Function to get summary quarters of coverage
 */
static int qc1f(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int qct;  /* temporary quarters of coverage */
   int ierr;  /* error indicator */

   if (fscanf(in, "%d", &qct) <= 0)
      return(69);
   if ((ierr = setqctd(workerdata, qct)) > 0)
      return(ierr);
   if (fscanf(in, "%d", &qct) <= 0)
      return(69);
   if ((ierr = setqc51td(workerdata, qct)) > 0)
      return(ierr);
   qctdchk2(workerdata);
   return(0);
}
/* Function to get annual quarters of coverage
 */
static int qc2f(
FILE *in,  /* pointer to file with case */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1;  /* loop counter */
   int qct;  /* temporary quarters of coverage */
   int ierr;  /* error indicator */

   for (i1 = workerdata -> ibegin; i1 <= lastqcyr(workerdata); i1++)
      {
      if (fscanf(in, "%d", &qct) <= 0)
         return(69);
      if ((ierr = setqc2(workerdata, i1, qct)) > 0)
         return(ierr);
      }
   setqctd(workerdata, qcsum(workerdata, 1937, lastqcyr(workerdata)));
   setqc51td(workerdata, qcsum(workerdata, 1951, lastqcyr(workerdata)));
   return(0);
}
/* Function to save a case to disk
 */
savdis(
FILE *iout,  /* file pointer to save results */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1,i2; /* loop counters */

   fprintf(iout, "%4d\n", workerdata -> istart);
   fprintf(iout, "%4d\n", workerdata -> isex);
   fprintf(iout, "%4d\n", (int)workerdata -> joasdi);
   fprintf(iout, "%4d\n", workerdata -> recalc);
   fprintf(iout, "%4d\n", workerdata -> totalize);
   fprintf(iout, "%4d\n", workerdata -> mqge);
   for (i1 = 0; i1 < 3; i1++)
      fprintf(iout, "%4d\n", workerdata -> ibirth[i1]);
   fprintf(iout, "%4d\n", workerdata -> monthnow);
   for (i1 = 0; i1 < 3; i1 += 2)
      fprintf(iout, "%4d\n", workerdata -> ient[i1]);
   for (i1 = 0; i1 < 3; i1 += 2)
      fprintf(iout, "%4d\n", workerdata -> bendate[i1]);
   fprintf(iout, "%4d\n", workerdata -> iageplan);
   fprintf(iout, "%4d\n", workerdata -> projback);
   fprintf(iout, "%6.2f\n", workerdata -> percback);
   fprintf(iout, "%4d\n", workerdata -> ibegin);
   fprintf(iout, "%4d\n", workerdata -> ibegin1);
   fprintf(iout, "%4d\n", workerdata -> projfwrd);
   fprintf(iout, "%6.2f\n", workerdata -> percfwrd);
   fprintf(iout, "%4d\n", workerdata -> iend1);
   fprintf(iout, "%4d\n", workerdata -> iend);
   for (i1 = workerdata -> ibegin1 - 1937; i1 < workerdata -> iend1 - 1936;
      i1++)
      fprintf(iout, "%4d\n", (int)workerdata -> earntype[i1]);
   fprintf(iout, "%4d\n", workerdata -> qctottd);
   fprintf(iout, "%4d\n", workerdata -> qctot51td);
   if (qcbyyear(workerdata))
      for (i1 = workerdata -> ibegin; i1 <= lastqcyr(workerdata); i1++)
         fprintf(iout, "%4d\n", workerdata -> qc[i1-1937]);
   fprintf(iout, "%4d\n", workerdata -> ideath[0]);
   fprintf(iout, "%4d\n", workerdata -> ideath[2]);
   fprintf(iout, "%4d\n", workerdata -> jsurv);
   fprintf(iout, "%4d\n", workerdata -> valdi);
   for (i1 = 0; i1 < 3; i1++)
      fprintf(iout, "%4d\n", workerdata -> ionset[i1]);
   for (i1 = 0; i1 < 3; i1 += 2)
      fprintf(iout, "%4d\n", workerdata -> priorent[i1]);
   for (i1 = 0; i1 < 3; i1 += 2)
      fprintf(iout, "%4d\n", workerdata -> waitper[i1]);
   for (i1 = 0; i1 < 3; i1++)
      fprintf(iout, "%4d\n", workerdata -> jbirth[i1]);
   for (i1 = 0; i1 < 3; i1++)
      fprintf(iout, "%4d\n", workerdata -> jonset[i1]);
   fprintf(iout, "%4d\n", (int)workerdata -> ialtbi);
   if (workerdata -> ialtbi == OTHER_ASSUM)
      {
      for (i1 = workerdata -> istart - 1951;
         i1 < workerdata -> bendate[2] - 1950; i1++)
         fprintf(iout, "%6.2f\n", workerdata -> cpiinc[i1]);
         fprintf(iout, "%c\n", workerdata -> anscch);
         if (workerdata -> anscch == 'Y')
            {
            for (i1 = 0; i1 < 8; i1++) {
               for (i2 = 0; i2 < 10; i2++) {
                  fprintf(iout, "%6.2f\n", workerdata -> cachup[i2][i1]);
                  }
               }
            }
         fprintf(iout, "%s\n", workerdata -> titlbi);
         }
   fprintf(iout, "%4d\n", (int)workerdata -> ialtaw);
   if (workerdata -> ialtaw == OTHER_ASSUM)
      {
      for (i1 = workerdata -> istart - 1938;
         i1 < workerdata -> bendate[2] - 1936; i1++)
         fprintf(iout, "%6.2f\n", workerdata -> fqinc[i1]);
         fprintf(iout, "%s\n", workerdata -> titlaw);
         }
   fprintf(iout, "%4d\n", workerdata -> ibasch);
   if (workerdata -> ibasch == 2) /* save user-specified wage bases */
      {
      for (i1 = workerdata -> istart - 1936;
         i1 < workerdata -> bendate[2] - 1936; i1++)
         fprintf(iout, "%10.2lf\n", workerdata -> base[i1]);
      for (i1 = workerdata -> istart - 1936;
         i1 < workerdata -> bendate[2] - 1936; i1++)
         fprintf(iout, "%10.2lf\n", workerdata -> base77[i1]);
      }
   for (i1 = workerdata -> ibegin1 - 1937; i1 < workerdata -> iend1 - 1936;
      i1++) { /* save user-specified earnings */
      if (workerdata -> earntype[i1] == ENTERED)
         fprintf(iout, "%10.2lf\n", workerdata -> earnpebs[i1]);
      }
   if (workerdata -> mqge)  /* save user-specified Medicare earnings */
      {
      for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++)
         fprintf(iout, "%10.2lf\n", workerdata -> earnhi[i1-1937]);
      }
   for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++)
      fprintf(iout, "%4d\n", workerdata -> taxtype[i1-1937]);
   fprintf(iout, "%10.2f\n", workerdata -> pubpen);
   fprintf(iout, "%s\n", workerdata -> nhname);
   for (i1 = 0; i1 < 3; i1++)
      fprintf(iout, "%s\n", workerdata -> nhaddr[i1]);
   fprintf(iout, "%s\n", workerdata -> ssn);
   fclose(iout);
   return(0);
}
