/*
 * @(#)scanfile.C	1.21   3/14/94
 * Various functions to read data from a file
 */

#ifndef lint
static char *scanflID = " @(#)scanfile.C	1.21   3/14/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "scanfile.h"
#include "utils.h"

/* Function to get earnings from file
 */
earnf(
FILE *infile,  /* input file */
WORKERDATA *workerdata)  /* workerdata structure */
{
   register i1; /* loop counter */
   double earnpebst;  /* temporary earnpebs */
   int ierr;  /* error indicator */

   for (i1 = workerdata -> ibegin1; i1 <= workerdata -> iend1; i1++)
      {
      if (workerdata -> earntype[i1 - 1937] == ENTERED) {
         if (fscanf(infile, "%lf", &earnpebst) <= 0)
            return(69);
         if ((ierr = setearnpb(workerdata, i1, earnpebst)) > 0)
            return(ierr);
         }
      }
   return(0);
}
/* Function to get stored average wage increases
 */
int avgmen(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   FILE *inwage; /* input file for average wage increases */
   int i1; /* loop counter */
   int istrt2;  /* starting year for average wage assumptions */
   char *infile;  /* full pathname of file with average wage assumptions */

   infile = getawfl(piaparms, altnum);
   if ((inwage = fopen(infile,"r")) == (FILE *)NULL)
      return(65);
   if (fscanf(inwage,"%d",&istrt2) <= 0) {
      fclose(inwage);
      return(75); }
   if (istrt2 != piaparms -> istart - 1) {
      fclose(inwage);
      return(62); }
   for (i1 = piaparms -> istart - 1938; i1 < piaparms -> maxyears; i1++)
      if (fscanf(inwage, "%f", &piaparms -> fqinc[i1]) <= 0) {
         fclose(inwage);
         return(75); }
   fclose(inwage);
   return(0);
}
/* Function to get stored benefit increases
 */
int benmen(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   FILE *inben; /* input file for benefit increases */
   int i1,i2; /* loop counters */
   int istrt2;  /* starting year for benefit increase assumptions */
   char *infile;  /* full pathname of file with benefit increases */

   infile = getbifl(piaparms, altnum);
   if ((inben = fopen(infile,"r")) == (FILE *)NULL)
      return(63);
   if (fscanf(inben,"%d",&istrt2) <= 0) {
      fclose(inben);
      return(73); }
   if (istrt2 != piaparms -> istart) {
      fclose(inben);
      return(61); }
   for (i1 = piaparms -> istart - 1951; i1 < piaparms -> maxyears - 14; i1++)
      if (fscanf(inben, "%f", &(piaparms -> cpiinc[i1])) <= 0) {
         fclose(inben);
         return(73); }
   fclose(inben);
   infile = getcufl(piaparms, altnum);
   if ((inben = fopen(infile,"r")) == (FILE *)NULL)
      return(64);
   for (i1 = 0; i1 < 8; i1++) {
      for (i2 = 0; i2 < 10; i2++) {
         if (fscanf(inben, "%lf", &(piaparms -> cachup[i2][i1])) <= 0) {
            fclose(inben);
            return(74); }
         } /* end for i2 */
      } /* end for i1 */
   fclose(inben);
   return(0);
}
/* Function to create full pathname for average wage file
 */
char *getawfl(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   char temp[5];  /* temporary string */
   static char awfile[15] = AWDAT;  /* filename with projected average
                 wage increases */
   char *infile;  /* pointer to return */

   sprintf(temp, "%d", piaparms -> istart - 1900);
   strncpy(awfile+2, temp, 2);
   sprintf(temp, "%d", altnum);
   strncpy(awfile+4, temp, 1);
   concat(&infile, piaparms -> directory, awfile);
   return(infile);
}
/* Function to create full pathname for benefit increase file
 */
char *getbifl(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   char temp[5];  /* temporary string */
   static char bifile[15] = BIDAT;  /* filename with projected benefit
                 increases */
   char *infile;  /* pointer to return */

   sprintf(temp, "%d", piaparms -> istart - 1900);
   strncpy(bifile+2, temp, 2);
   sprintf(temp, "%d", altnum);
   strncpy(bifile+4, temp, 1);
   concat(&infile, piaparms -> directory, bifile);
   return(infile);
}
/* Function to create full pathname for catch-up benefit increase file
 */
char *getcufl(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   char temp[5];  /* temporary string */
   static char cufile[15] = CUDAT;  /* filename with projected catch-up
                 benefit increases */
   char *infile;  /* pointer to return */

   sprintf(temp, "%d", piaparms -> istart - 1900);
   strncpy(cufile+2, temp, 2);
   sprintf(temp, "%d", altnum);
   strncpy(cufile+4, temp, 1);
   concat(&infile, piaparms -> directory, cufile);
   return(infile);
}
/* Function to create full pathname for titles file
 */
char *gettitlfl(
PIAPARMS *piaparms)  /* piaparms structure */
{
   char temp[5];  /* temporary string */
   static char titlfile[15] = TITLESDAT;  /* filename with assumptions
                 titles */
   char *infile;  /* pointer to return */

   sprintf(temp, "%d", piaparms -> istart - 1900);
   strncpy(titlfile+6, temp, 2);
   concat(&infile, piaparms -> directory, titlfile);
   return(infile);
}
/* Function to create full pathname for historical data file
 */
char *getawbifl(
PIAPARMS *piaparms)  /* piaparms structure */
{
   char temp[5];  /* temporary string */
   static char awbifile[15] = AWBIDAT;  /* filename with historical
                 average wages and benefit increases */
   char *infile;  /* pointer to return */

   sprintf(temp, "%d", piaparms -> istart - 1900);
   strncpy(awbifile+4, temp, 2);
   concat(&infile, piaparms -> directory, awbifile);
   return(infile);
}
/* Function to save benefit increases
 */
int savebi(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   static char *form1 = "%4.1f\n";  /* benefit increase format */
   register i1,i2;  /* loop counters */
   char *infile;  /* full pathname of file with assumptions */
   FILE *outben;  /* output file for benefit increases */

   infile = getbifl(piaparms, altnum);
   if ((outben = fopen(infile, "w")) == (FILE *)NULL)
      return(82);
   fprintf(outben, "%4d\n", piaparms -> istart);
   for (i1 = piaparms -> istart - 1951; i1 < piaparms -> maxyears - 14; i1++)
      fprintf(outben, form1, piaparms -> cpiinc[i1]);
   fclose(outben);
   /* store catch-up benefit increases */
   infile = getcufl(piaparms, altnum);
   if ((outben = fopen(infile, "w")) == (FILE *)NULL)
      return(83);
   for (i1 = 1; i1 < 8; i1++) {
      for (i2 = 1; i2 < 10; i2++)
         fprintf(outben, form1, piaparms -> cachup[i2][i1]);
      fprintf(outben, form1, 0.0);
      }
   for (i2 = 0; i2 < 10; i2++)
      fprintf(outben, form1, 0.0);
   fclose(outben);
   return(0);
}
/* Function to save average wage increases
 */
int saveaw(
PIAPARMS *piaparms,  /* piaparms structure */
int altnum)  /* alternative number */
{
   static char *form2 = "%9.6f\n";  /* average wage increase format */
   register i1;  /* loop counter */
   char *infile;  /* full pathname of file with assumptions */
   FILE *outben;  /* output file for average wage increases */

   infile = getawfl(piaparms, altnum);
   if ((outben = fopen(infile, "w")) == (FILE *)NULL)
      return(84);
   fprintf(outben, "%4d\n", piaparms -> istart - 1);
   for (i1 = piaparms -> istart - 1938; i1 < piaparms -> maxyears; i1++)
      fprintf(outben, form2, piaparms -> fqinc[i1]);
   fclose(outben);
   return(0);
}
