/*
 * @(#)setup.C	1.47   3/21/94
 * Various functions to set up the PIA program
 */

#ifndef lint
static char *setupID = " @(#)setup.C	1.47   3/21/94 ";
#endif

#include <stdio.h>
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include <stdlib.h>
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "scanfile.h"
#include "utils.h"
#include "setup.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int  scnerrh ( FILE *in );
static int  scnerrf ( FILE *in );
#else
static int  scnerrh();
static int  scnerrf();
#endif

static char *mfbeninc[MAXASM] = /* benefit increase selections */
   { "                                                                ",
     "                                                                ",
     "                                                                ",
     "                                                                ",
     "No increase beginning with xxxx benefit increase (new PEBES)",
     "Old PEBES calculation (no future benefit increases)",
     "Other assumptions (input from keyboard)" };
static char *mfavgwage[MAXASM] = /* average wage selections */
   { "                                                                ",
     "                                                                ",
     "                                                                ",
     "                                                                ",
     "No increase beyond xxxx average wage (new PEBES)",
     "Old PEBES calculation (1-percent real wage increases)",
     "Other assumptions (input from keyboard)" };

/* Function to set titles of assumptions
 */
asmtit(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int   i1; /* loop counter */
   FILE *intit; /* input file with titles */
   char  temp[5]; /* temporary character array */
   char *infile;  /* full pathname of file with assumptions */

   infile = gettitlfl(piaparms);
   if ((intit = fopen(infile,"r")) == (FILE *)NULL)
      return(76);
   for (i1 = 0; i1 < 4; i1++)
      {
      if (getitle(mfavgwage[i1], piaparms -> maxchr, intit) < 0) {
         fclose(intit);
         return(77); }
      strcpy(mfbeninc[i1], mfavgwage[i1]);
      } /* end for */
   sprintf(temp, "%d", piaparms -> istart);
   strncpy(&mfbeninc[4][27], temp, 4);
   sprintf(temp, "%d", piaparms -> istart - 2);
   strncpy(&mfavgwage[4][19], temp, 4);
   fclose(intit);
   return(0);
}
/* Function to save titles of assumptions
 */
int savetitl(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int   i1; /* loop counter */
   FILE *out; /* output file */
   char *infile;  /* full pathname of file with historical data */

   infile = gettitlfl(piaparms);
   if ((out = fopen(infile, "w")) == (FILE *)NULL)
      return(85);
   for (i1 = 0; i1 < 4; i1++)
      fprintf(out, "%s\n", mfavgwage[i1]);
   fclose(out);
   return(0);
}
/* Function to get historical benefit increases and average wages
 */
int gethst(
PIAPARMS *piaparms)  /* piaparms structure */
{
   double *dp;  /* temporary pointer to double */
   float *fp;  /* temporary pointer to float */
   int   i1; /* loop counter */
   FILE *in; /* input file */
   char *infile;  /* full pathname of file with historical data */

   infile = getawbifl(piaparms);
   if ((in = fopen(infile,"r")) == (FILE *)NULL)
      return(71);
   for (i1 = 0, fp = piaparms -> cpiinc; i1 < piaparms -> istart - 1951;
      i1++, fp++)
      if (fscanf(in, "%f", fp) <= 0)
         return(scnerrh(in));
   for (i1 = 0, dp = piaparms -> fq; i1 < piaparms -> istart - 1938;
      i1++, dp++)
      if (fscanf(in, "%lf", dp) <= 0)
         return(scnerrh(in));
   for (i1 = 1; i1 < piaparms -> istart - 1938; i1++, dp++)
      piaparms -> fqinc[i1] = 100. *
         (piaparms -> fq[i1] / piaparms -> fq[i1 - 1] - 1.);
   for (i1 = 0, dp = piaparms -> base; i1 < piaparms -> istart - 1936;
      i1++, dp++)
      if (fscanf(in, "%lf", dp) <= 0)
         return(scnerrh(in));
   for (i1 = 0; i1 < 54 && i1 < piaparms -> maxyears; i1++)
      piaparms -> basehi[i1] = piaparms -> base[i1];
   for (i1 = 54, dp = piaparms -> basehi + 54; i1 < piaparms -> istart - 1936;
      i1++, dp++)
      if (fscanf(in, "%lf", dp) <= 0)
         return(scnerrh(in));
   for (i1 = 0, dp = piaparms -> base77; i1 < piaparms -> istart - 1936;
      i1++, dp++)
      if (fscanf(in, "%lf", dp) <= 0)
         return(scnerrh(in));
   fclose(in);
   return(0);
}
/* Function to save historical benefit increases and average wages
 */
int saveawbi(
PIAPARMS *piaparms)  /* piaparms structure */
{
   int   i1; /* loop counter */
   FILE *out; /* output file */
   char *infile;  /* full pathname of file with historical data */

   infile = getawbifl(piaparms);
   if ((out = fopen(infile, "w")) == (FILE *)NULL)
      return(81);
   for (i1 = 0; i1 < piaparms -> istart - 1951; i1++)
      fprintf(out, "%6.2f\n", piaparms -> cpiinc[i1]);
   for (i1 = 0; i1 < piaparms -> istart - 1938; i1++)
      fprintf(out, "%10.2lf\n", piaparms -> fq[i1]);
   for (i1 = 0; i1 < piaparms -> istart - 1936; i1++)
      fprintf(out, "%10.2lf\n", piaparms -> base[i1]);
   for (i1 = 54; i1 < piaparms -> istart - 1936; i1++)
      fprintf(out, "%10.2lf\n", piaparms -> basehi[i1]);
   for (i1 = 0; i1 < piaparms -> istart - 1936; i1++)
      fprintf(out, "%10.2lf\n", piaparms -> base77[i1]);
   fclose(out);
   return(0);
}
/* Function to handle historical data file error
 */
static int scnerrh(
FILE *in)  /* input file */
{
   fclose(in);
   return(72);
}
#ifdef LAWCHG
/* Function to get law changes from disk
 */
int getlawchg(
Lawchg *lawchgdata)  /* Lawchg structure */
{
   FILE *in;  /* input file */
   char *infile;  /* full pathname of file with law changes */
   int ierr;  /* error indicator */

   concat(&infile, lawchgdata -> directory, LAWCHGDAT);
   if ((in = fopen(infile,"r")) == (FILE *)NULL)
      return(93);
   if ((ierr = lawchgf(in, lawchgdata)) > 0)
      return(ierr);
   fclose(in);
   return(0);
}
#endif
/* Function to get base year
 */
int getbasyr(
PIAPARMS *piaparms)  /* piaparms structure */
{
   FILE *in;  /* input file */
   char *infile;  /* full pathname of file with base year */
   int ierr = 0;  /* error indicator */
   int istartnew;  /* new value of istart */

   concat(&infile, piaparms -> directory, BASEYEARDAT);
   if ((in = fopen(infile,"r")) == (FILE *)NULL)
      return(87);
   if (fscanf(in, "%d", &istartnew) <= 0) {
      fclose(in);
      return(88); }
   fclose(in);
   ierr = setbasyr(piaparms, istartnew);
   return(ierr);
}
/* Function to save base year
 */
int savebasyr(
PIAPARMS *piaparms)  /* piaparms structure */
{
   FILE *out;  /* output file */
   char *infile;  /* full pathname of file with base year */

   concat(&infile, piaparms -> directory, BASEYEARDAT);
   if ((out = fopen(infile, "w")) == (FILE *)NULL)
      return(89);
   fprintf(out, "%5d\n", piaparms -> istart);
   fclose(out);
   return(0);
}
/* Function to initialize configuration structure
 */
Config *initcnf(
int maxchr,  /* maximum string length allowed */
char **mesgptr)  /* pointer to error message */
{
   static char *mesg = "Could not allocate memory for config variables";
   int i1;  /* loop counter */
   Config *config;  /* configuration structure */

   /* allocate memory for structure */
   if ((config = (Config *)malloc(sizeof(Config))) == (Config *)0) {
      *mesgptr = mesg;
      return((Config *)0); }
   if ((config -> command1 = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0) {
      *mesgptr = mesg;
      return((Config *)0); }
   if ((config -> command2 = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0) {
      *mesgptr = mesg;
      return((Config *)0); }
   for (i1 = 0; i1 < 2; i1++) {
      if ((config -> direct[i1] = (char *)calloc((unsigned)maxchr,
         sizeof(char))) == (char *)0) {
         *mesgptr = mesg;
         return((Config *)0); }
      }
   if ((config -> prn_init = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0) {
      *mesgptr = mesg;
      return((Config *)0); }
   config -> maxchr = maxchr;
   *mesgptr = (char *)0;
   return(config);
}
/* Function to initialize field office info structure
 */
int initfo(
FOINFO **foinfop,  /* field office info structure */
char *directory)  /* directory with field office file */
{
   /* allocate memory for structure */
   if ((*foinfop = (FOINFO *)malloc(sizeof(FOINFO))) == (FOINFO *)0)
      return(287);
   (*foinfop) -> directory = directory;
   strcpy((*foinfop) -> foaddr[0], "Social Security Administration");
   return(0);
}
/* Function to get field office information
 */
int getfo(
FOINFO *foinfo)  /* field office info structure */
{
   int i1; /* loop counter */
   FILE *in; /* input file */
   char *infile;  /* full pathname of file with field office info */

   concat(&infile, foinfo -> directory, FODAT);
   if ((in = fopen(infile,"r")) == (FILE *)NULL)
      return(90);
   if (getitle(foinfo -> foname, FOSIZE, in) < 0)
      return(scnerrf(in));
   if (getitle(foinfo -> fotitle, FOSIZE, in) < 0)
      return(scnerrf(in));
   for (i1 = 0; i1 < 4; i1++)
      if (getitle(foinfo -> foaddr[i1], FOSIZE, in) < 0)
         return(scnerrf(in));
   fclose(in);
   return(0);
}
/* Function to save field office information
 */
int savefo(
FOINFO *foinfo)  /* field office info structure */
{
   int i1; /* loop counter */
   FILE *out; /* output file */
   char *infile;  /* full pathname of file with field office info */

   concat(&infile, foinfo -> directory, FODAT);
   if ((out = fopen(infile, "w")) == (FILE *)NULL)
      return(92);
   fprintf(out, "%s\n", foinfo -> foname);
   fprintf(out, "%s\n", foinfo -> fotitle);
   for (i1 = 0; i1 < 4; i1++)
      fprintf(out, "%s\n", foinfo -> foaddr[i1]);
   fclose(out);
   return(0);
}
/* Function to handle field office file error
 */
static int scnerrf(
FILE *in)  /* input file */
{
   fclose(in);
   return(91);
}
/* Function to get the configuration
 */
int getcnf(
Config *config)  /* configuration structure */
{
   FILE *in; /* input file */
   int iprntrt;  /* temporary iprntr */
   int icolort;  /* temporary icolor */
   int ierr;  /* error indicator */

   if ((in = fopen(CONFIGDAT,"r")) == (FILE *)NULL)
      return(66);
   if (fscanf(in,"%d",&iprntrt) == EOF) {
      fclose(in);
      return(67);
      }
   if ((ierr = setiprntr(config, iprntrt)) > 0)
      return(ierr);
   if (fscanf(in,"%d",&icolort) == EOF) {
      fclose(in);
      return(67);
      }
   if ((ierr = seticolor(config, icolort)) > 0)
      return(ierr);
   if (getitle(config -> direct[0], config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   if (getitle(config -> direct[0], config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   if (getitle(config -> direct[1], config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   if (getitle(config -> prn_init, config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   if (getitle(config -> command1, config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   if (getitle(config -> command2, config -> maxchr, in) < 0) {
      fclose(in);
      return(67);
      }
   fclose(in);
   delspcnf(config);
   return(0);
}
/* Function to set type of printing
 */
int setiprntr(
Config *config,  /* configuration structure */
int iprntrt)  /* new value of iprntr */
{
   int ierr;  /* error indicator */

   if ((ierr = iprntrchk(iprntrt)) > 0)
      return(ierr);
   config -> iprntr = iprntrt;
   return(0);
}
/* Function to check value of iprntr
 */
int iprntrchk(
int iprntrt)  /* new value of iprntr */
{
#if defined(MSDOS)
   if (iprntrt < 0 || iprntrt > 1)
      return(260);
#else
   if (iprntrt != 1)
      return(261);
#endif
   return(0);
}
/* Function to set color indicator
 */
int seticolor(
Config *config,  /* configuration structure */
int icolort)  /* new value of icolor */
{
   int ierr;  /* error indicator */

   if ((ierr = icolorchk(icolort)) > 0)
      return(ierr);
   config -> icolor = icolort;
   return(0);
}
/* Function to check value of icolor
 */
int icolorchk(
int icolort)  /* new value of icolor */
{
   if (icolort < 0 || icolort > 1)
      return(262);
   return(0);
}
/* Function to save the configuration
 */
int saveconf(
Config *config)  /* configuration structure */
{
   FILE *out; /* output file */

   if ((out = fopen(CONFIGDAT, "w")) == (FILE *)NULL)
      return(80);
   fprintf(out, "%3d\n", config -> iprntr);
   fprintf(out, "%3d\n", config -> icolor);
   fprintf(out, "%s\n", config -> direct[0]);
   fprintf(out, "%s\n", config -> direct[1]);
   fprintf(out, "%s\n", config -> prn_init);
   fprintf(out, "%s\n", config -> command1);
   fprintf(out, "%s\n", config -> command2);
   fclose(out);
   return(0);
}
/* Function to delete spaces from configuration strings
 */
void delspcnf(
Config *config)  /* configuration structure */
{
   wn_sdelspc(config -> direct[0], 3);
   wn_sdelspc(config -> direct[1], 3);
   wn_sdelspc(config -> prn_init, 3);
   wn_sdelspc(config -> command1, 3);
   wn_sdelspc(config -> command2, 3);
}
/* Function to return an average wage increase assumption title
 */
char *getavgwage(
int altnum)  /* which alternative */
{
   return(mfavgwage[altnum - 1]);
}
/* Function to return a benefit increase assumption title
 */
char *getbeninc(
int altnum)  /* which alternative */
{
   return(mfbeninc[altnum - 1]);
}
/* Function set an average wage increase assumption title
 */
void setavgwage(
int altnum,  /* which alternative */
char *titlet)  /* new title */
{
   strcpy(mfavgwage[altnum - 1], titlet);
}
/* Function set a benefit increase assumption title
 */
void setbeninc(
int altnum,  /* which alternative */
char *titlet)  /* new title */
{
   strcpy(mfbeninc[altnum - 1], titlet);
}
