/*
 * @(#)setup.h	1.26   6/27/94
 * Function declarations for setup.c
 */

#ifndef __SETUP_H
#define __SETUP_H

#define FOSIZE 40

typedef struct {
   char  *command1;  /* first part of command to send output to printer */
   char  *command2;  /* second part of command to send output to printer */
   char  *direct[2];  /* local and central directories with data */
   int    icolor; /* color indicator (0 for monochrome, 1 for color) */
   int    iprntr; /* printer method (0 for direct write to printer,
                 1 for mass storage file) */
   char  *prn_init;  /* printer initialization string, ascii */
   int    maxchr;  /* maximum characters in title or message */
   } Config;

typedef struct {
   char   foaddr[4][FOSIZE];  /* field office address */
   char   foname[FOSIZE];  /* field office manager name */
   char   fotitle[FOSIZE];  /* field office manager title */
   char  *directory;  /* directory with field office file */
   } FOINFO;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int   asmtit   ( PIAPARMS *piaparms );
int   savetitl ( PIAPARMS *piaparms );
int   gethst   ( PIAPARMS *piaparms );
int   saveawbi ( PIAPARMS *piaparms );
int   getlawchg( Lawchg *lawchgdata );
int   getbasyr ( PIAPARMS *piaparms );
int   savebasyr( PIAPARMS *piaparms );
Config *initcnf ( int maxchr, char **mesgptr );
int   initfo   ( FOINFO **foinfop, char *directory );
int   getfo    ( FOINFO *foinfo );
int   savefo   ( FOINFO *foinfo );
int   getcnf   ( Config *config );
int   setiprntr( Config *config, int iprntrt );
int   iprntrchk( int iprntrt );
int   seticolor( Config *config, int icolort );
int   icolorchk( int icolort );
int   saveconf ( Config *config );
void  delspcnf ( Config *config );
char *getavgwage( int altnum );
char *getbeninc( int altnum );
void  setavgwage( int altnum, char *titlet );
void  setbeninc( int altnum, char *titlet );
#else
int   asmtit();
int   savetitl();
int   gethst();
int   saveawbi();
int   getlawchg();
int   getbasyr();
int   savebasyr();
int   initcnf();
int   initfo();
int   getfo();
int   savefo();
int   getcnf();
int   setiprntr();
int   iprntrchk();
int   seticolor();
int   icolorchk();
int   saveconf();
void  delspcnf();
char *getavgwage();
char *getbeninc();
void  setavgwage();
void  setbeninc();
#endif

#if defined(MSDOS) | defined(THINK_C)
#define BASEYEARDAT "BASEYEAR.DAT"
#define FODAT "FO.DAT"
#define CONFIGDAT "CONFIG.DAT"
#define CONFIGPIA "CONFIG.PIA"
#else
#define BASEYEARDAT "baseyear.dat"
#define FODAT "fo.dat"
#define CONFIGDAT "config.dat"
#define CONFIGPIA "config.pia"
#endif

#endif  // __SETUP_H
