/* @(#)taxes.C	1.16   3/17/94
 * Various functions with taxes and tax rates
 */

#ifndef lint
static char *taxesID = " @(#)taxes.C	1.16   3/17/94 ";
#endif

#include <stdlib.h>
#include "taxes.h"

int inittaxes(
Taxes **taxdatap,  /* taxdata structure */
int maxyears)  /* maximum number of years projected, starting with 1937 */
{
   register i,i1;  /* loop counter */

   /* allocate memory for structure */
   if ((*taxdatap = (Taxes *)malloc(sizeof(Taxes))) == (Taxes *)0)
      return(282);
   /* allocate memory for tax arrays */
   for (i = 0; i < 5; i++) {
      if (((*taxdatap) -> taxes[i] = (float *)calloc((unsigned)maxyears,
         sizeof(float))) == (float *)0)
         return(282);
      }
   for (i1 = 0; i1 < 2; i1++) {
      for (i = 0; i < 5; i++) {
         if (((*taxdatap) -> taxrat[i1][i] = (float *)calloc((unsigned)maxyears,
            sizeof(float))) == (float *)0)
            return(282);
         }
      }
   (*taxdatap) -> maxyears = maxyears;
   return(0);
}
/* Function to initialize tax rates
 */
void settxrt(
Taxes *taxdata)  /* taxdata structure */
{
   register i,i1;  /* loop counter */

   /* 1937-49 */
   for (i = 0; i < 13; i++) {
      taxdata -> taxrat[0][0][i] = (float).01;
      taxdata -> taxrat[0][1][i] = (float).00;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).00;
      taxdata -> taxrat[1][1][i] = (float).00;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1950 */
   taxdata -> taxrat[0][0][13] = (float).015;
   taxdata -> taxrat[0][1][13] = (float).00;
   taxdata -> taxrat[0][3][13] = (float).00;
   taxdata -> taxrat[1][0][13] = (float).00;
   taxdata -> taxrat[1][1][13] = (float).00;
   taxdata -> taxrat[1][3][13] = (float).00;
   /* 1951-53 */
   for (i = 14; i < 17; i++) {
      taxdata -> taxrat[0][0][i] = (float).015;
      taxdata -> taxrat[0][1][i] = (float).00;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).0225;
      taxdata -> taxrat[1][1][i] = (float).00;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1954-56 */
   for (i = 17; i < 20; i++) {
      taxdata -> taxrat[0][0][i] = (float).02;
      taxdata -> taxrat[0][1][i] = (float).00;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).03;
      taxdata -> taxrat[1][1][i] = (float).00;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1957-58 */
   for (i = 20; i < 22; i++) {
      taxdata -> taxrat[0][0][i] = (float).02;
      taxdata -> taxrat[0][1][i] = (float).0025;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).03;
      taxdata -> taxrat[1][1][i] = (float).00375;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1959 */
   taxdata -> taxrat[0][0][22] = (float).0225;
   taxdata -> taxrat[0][1][22] = (float).0025;
   taxdata -> taxrat[0][3][22] = (float).00;
   taxdata -> taxrat[1][0][22] = (float).03375;
   taxdata -> taxrat[1][1][22] = (float).00375;
   taxdata -> taxrat[1][3][22] = (float).00;
   /* 1960-61 */
   for (i = 23; i < 25; i++) {
      taxdata -> taxrat[0][0][i] = (float).0275;
      taxdata -> taxrat[0][1][i] = (float).0025;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).04125;
      taxdata -> taxrat[1][1][i] = (float).00375;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1962 */
   taxdata -> taxrat[0][0][25] = (float).02875;
   taxdata -> taxrat[0][1][25] = (float).0025;
   taxdata -> taxrat[0][3][25] = (float).00;
   taxdata -> taxrat[1][0][25] = (float).04325;
   taxdata -> taxrat[1][1][25] = (float).00375;
   taxdata -> taxrat[1][3][25] = (float).00;
   /* 1963-65 */
   for (i = 26; i < 29; i++) {
      taxdata -> taxrat[0][0][i] = (float).03375;
      taxdata -> taxrat[0][1][i] = (float).0025;
      taxdata -> taxrat[0][3][i] = (float).00;
      taxdata -> taxrat[1][0][i] = (float).05025;
      taxdata -> taxrat[1][1][i] = (float).00375;
      taxdata -> taxrat[1][3][i] = (float).00; }
   /* 1966 */
   taxdata -> taxrat[0][0][29] = (float).035;
   taxdata -> taxrat[0][1][29] = (float).0035;
   taxdata -> taxrat[0][3][29] = (float).0035;
   taxdata -> taxrat[1][0][29] = (float).05275;
   taxdata -> taxrat[1][1][29] = (float).00525;
   taxdata -> taxrat[1][3][29] = (float).0035;
   /* 1967 */
   taxdata -> taxrat[0][0][30] = (float).0355;
   taxdata -> taxrat[0][1][30] = (float).0035;
   taxdata -> taxrat[0][3][30] = (float).005;
   taxdata -> taxrat[1][0][30] = (float).05375;
   taxdata -> taxrat[1][1][30] = (float).00525;
   taxdata -> taxrat[1][3][30] = (float).005;
   /* 1968 */
   taxdata -> taxrat[0][0][31] = (float).03325;
   taxdata -> taxrat[0][1][31] = (float).00475;
   taxdata -> taxrat[0][3][31] = (float).006;
   taxdata -> taxrat[1][0][31] = (float).050875;
   taxdata -> taxrat[1][1][31] = (float).007125;
   taxdata -> taxrat[1][3][31] = (float).006;
   /* 1969 */
   taxdata -> taxrat[0][0][32] = (float).03725;
   taxdata -> taxrat[0][1][32] = (float).00475;
   taxdata -> taxrat[0][3][32] = (float).006;
   taxdata -> taxrat[1][0][32] = (float).055875;
   taxdata -> taxrat[1][1][32] = (float).007125;
   taxdata -> taxrat[1][3][32] = (float).006;
   /* 1970 */
   taxdata -> taxrat[0][0][33] = (float).0365;
   taxdata -> taxrat[0][1][33] = (float).0055;
   taxdata -> taxrat[0][3][33] = (float).006;
   taxdata -> taxrat[1][0][33] = (float).05475;
   taxdata -> taxrat[1][1][33] = (float).00825;
   taxdata -> taxrat[1][3][33] = (float).006;
   /* 1971-72 */
   for (i = 34; i < 36; i++) {
      taxdata -> taxrat[0][0][i] = (float).0405;
      taxdata -> taxrat[0][1][i] = (float).0055;
      taxdata -> taxrat[0][3][i] = (float).006;
      taxdata -> taxrat[1][0][i] = (float).06075;
      taxdata -> taxrat[1][1][i] = (float).00825;
      taxdata -> taxrat[1][3][i] = (float).006; }
   /* 1973 */
   taxdata -> taxrat[0][0][36] = (float).043;
   taxdata -> taxrat[0][1][36] = (float).0055;
   taxdata -> taxrat[0][3][36] = (float).01;
   taxdata -> taxrat[1][0][36] = (float).06205;
   taxdata -> taxrat[1][1][36] = (float).00795;
   taxdata -> taxrat[1][3][36] = (float).01;
   /* 1974-77 */
   for (i = 37; i < 41; i++) {
      taxdata -> taxrat[0][0][i] = (float).04375;
      taxdata -> taxrat[0][1][i] = (float).00575;
      taxdata -> taxrat[0][3][i] = (float).009;
      taxdata -> taxrat[1][0][i] = (float).06185;
      taxdata -> taxrat[1][1][i] = (float).00815;
      taxdata -> taxrat[1][3][i] = (float).009; }
   /* 1978 */
   taxdata -> taxrat[0][0][41] = (float).04275;
   taxdata -> taxrat[0][1][41] = (float).00775;
   taxdata -> taxrat[0][3][41] = (float).01;
   taxdata -> taxrat[1][0][41] = (float).0601;
   taxdata -> taxrat[1][1][41] = (float).0109;
   taxdata -> taxrat[1][3][41] = (float).01;
   /* 1979 */
   taxdata -> taxrat[0][0][42] = (float).0433;
   taxdata -> taxrat[0][1][42] = (float).0075;
   taxdata -> taxrat[0][3][42] = (float).0105;
   taxdata -> taxrat[1][0][42] = (float).0601;
   taxdata -> taxrat[1][1][42] = (float).0104;
   taxdata -> taxrat[1][3][42] = (float).0105;
   /* 1980 */
   taxdata -> taxrat[0][0][43] = (float).0452;
   taxdata -> taxrat[0][1][43] = (float).0056;
   taxdata -> taxrat[0][3][43] = (float).0105;
   taxdata -> taxrat[1][0][43] = (float).062725;
   taxdata -> taxrat[1][1][43] = (float).007775;
   taxdata -> taxrat[1][3][43] = (float).0105;
   /* 1981 */
   taxdata -> taxrat[0][0][44] = (float).047;
   taxdata -> taxrat[0][1][44] = (float).0065;
   taxdata -> taxrat[0][3][44] = (float).013;
   taxdata -> taxrat[1][0][44] = (float).07025;
   taxdata -> taxrat[1][1][44] = (float).00975;
   taxdata -> taxrat[1][3][44] = (float).013;
   /* 1982 */
   taxdata -> taxrat[0][0][45] = (float).04575;
   taxdata -> taxrat[0][1][45] = (float).00825;
   taxdata -> taxrat[0][3][45] = (float).013;
   taxdata -> taxrat[1][0][45] = (float).068125;
   taxdata -> taxrat[1][1][45] = (float).012375;
   taxdata -> taxrat[1][3][45] = (float).013;
   /* 1983 */
   taxdata -> taxrat[0][0][46] = (float).04775;
   taxdata -> taxrat[0][1][46] = (float).00625;
   taxdata -> taxrat[0][3][46] = (float).013;
   taxdata -> taxrat[1][0][46] = (float).071125;
   taxdata -> taxrat[1][1][46] = (float).009375;
   taxdata -> taxrat[1][3][46] = (float).013;
   /* 1984 */
   taxdata -> taxrat[0][0][47] = (float).049263158;
   taxdata -> taxrat[0][1][47] = (float).004752842;
   taxdata -> taxrat[0][3][47] = (float).013;
   taxdata -> taxrat[1][0][47] = (float).0839;
   taxdata -> taxrat[1][1][47] = (float).0081;
   taxdata -> taxrat[1][3][47] = (float).021;
   /* 1985 */
   taxdata -> taxrat[0][0][48] = (float).052;
   taxdata -> taxrat[0][1][48] = (float).005;
   taxdata -> taxrat[0][3][48] = (float).0135;
   taxdata -> taxrat[1][0][48] = (float).087;
   taxdata -> taxrat[1][1][48] = (float).0084;
   taxdata -> taxrat[1][3][48] = (float).0226;
   /* 1986-87 */
   for (i = 49; i < 51; i++) {
      taxdata -> taxrat[0][0][i] = (float).052;
      taxdata -> taxrat[0][1][i] = (float).005;
      taxdata -> taxrat[0][3][i] = (float).0145;
      taxdata -> taxrat[1][0][i] = (float).0895;
      taxdata -> taxrat[1][1][i] = (float).0086;
      taxdata -> taxrat[1][3][i] = (float).0249; }
   /* 1988-89 */
   for (i = 51; i < 53; i++) {
      taxdata -> taxrat[0][0][i] = (float).0553;
      taxdata -> taxrat[0][1][i] = (float).0053;
      taxdata -> taxrat[0][3][i] = (float).0145;
      taxdata -> taxrat[1][0][i] = (float).0959;
      taxdata -> taxrat[1][1][i] = (float).0092;
      taxdata -> taxrat[1][3][i] = (float).0251; }
   /* 1990-99 */
   for (i = 53; i < 63; i++) {
      taxdata -> taxrat[0][0][i] = (float).056;
      taxdata -> taxrat[0][1][i] = (float).006;
      taxdata -> taxrat[0][3][i] = (float).0145;
      taxdata -> taxrat[1][0][i] = (float).112;
      taxdata -> taxrat[1][1][i] = (float).012;
      taxdata -> taxrat[1][3][i] = (float).029; }
   /* 2000+ */
   for (i = 63; i < taxdata -> maxyears; i++) {
      taxdata -> taxrat[0][0][i] = (float).0549;
      taxdata -> taxrat[0][1][i] = (float).0071;
      taxdata -> taxrat[0][3][i] = (float).0145;
      taxdata -> taxrat[1][0][i] = (float).1098;
      taxdata -> taxrat[1][1][i] = (float).0142;
      taxdata -> taxrat[1][3][i] = (float).029; }
   /* OASDI and HI */
   for (i1 = 0; i1 < 2; i1++) {
      for (i = 0; i < taxdata -> maxyears; i++) {
         taxdata -> taxrat[i1][2][i] = taxdata -> taxrat[i1][0][i] +
            taxdata -> taxrat[i1][1][i];
         taxdata -> taxrat[i1][4][i] = taxdata -> taxrat[i1][2][i] +
            taxdata -> taxrat[i1][3][i]; }
      }
}
/* Function to calculate taxes paid
 */
int taxcal(
Taxes *taxdata,  /* taxdata structure */
int maxyears,  /* maximum number of years projected, starting with 1937 */
double *ernoasdi,  /* array of OASDI earnings limited to OASDI wage base */
double *ernhi,  /* array of HI earnings limited to HI wage base */
int *taxtypet)  /* array of tax types */
{
   register i,i1;

   /* check tax type */
   for (i = 0; i < maxyears; i++)
      if (taxtypet[i] < 0 || taxtypet[i] > 1)
         return(1);
   /* calculate OASI, DI, and OASDI taxes */
   for (i1 = 0; i1 < 3; i1++)
      {
      for (i = 0; i < maxyears; i++)
         taxdata -> taxes[i1][i] = taxdata -> taxrat[taxtypet[i]][i1][i] *
            ernoasdi[i];
      taxdata -> taxtot[i1][0] = taxdata -> taxtot[i1][1] = 0.0;
      }
   /* calculate HI and OASDHI taxes */
   for (i = 0; i < maxyears; i++)
      {
      taxdata -> taxes[3][i] = taxdata -> taxrat[taxtypet[i]][3][i] *
         ernhi[i];
      taxdata -> taxes[4][i] = taxdata -> taxes[2][i] +
         taxdata -> taxes[3][i];
      }
   /* find total taxes */
   for (i1 = 0; i1 < 5; i1++)
      {
      taxdata -> taxtot[i1][0] = taxdata -> taxtot[i1][1] = 0.0;
      for (i = 0; i < 14; i++) {
         taxdata -> taxtot[i1][0] += taxdata -> taxes[i1][i];
         taxdata -> taxtot[i1][1] += taxdata -> taxes[i1][i];
         }
      for (i = 14; i < maxyears; i++)
         taxdata -> taxtot[i1][1] += taxdata -> taxes[i1][i];
      }
   return(0);
}
