/*
 * @(#)taxes.h	1.14   6/27/94
 * Function declarations for taxes.c
 */

#ifndef __TAXES_H
#define __TAXES_H

typedef struct {
   float *taxes[5];  /* taxes paid: OASI, DI, OASDI, HI, OASDHI */
   float *taxrat[2][5];  /* tax rates, employee and self-employed,
                 OASI, DI, OASDI, HI, OASDHI */
   double taxtot[5][2];  /* total taxes, OASI, DI, OASDI, HI, OASDHI,
                 1937-50 and 1937+ */
   int maxyears;  /* maximum number of years allowed */
   } Taxes;

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int  inittaxes( Taxes **taxdatap, int maxyears );
void settxrt  ( Taxes *taxdata );
int  taxcal   ( Taxes *taxdata, int maxyears, double *ernoasdi,
   double *ernhi, int *taxtypet );
#else
int  inittaxes();
void settxrt();
int  taxcal();
#endif

#endif  // __TAXES_H
