/*
 * @(#)two_page.C	1.76   3/21/94
 * Function to write out two-page summary of results
 */

#ifndef lint
static char *two_pgID = " @(#)two_page.C	1.76   3/21/94 ";
#endif

#include <stdio.h>
#include "pia.h"
#include "coment.h"
#include "prtutils.h"
#include "comma.h"

char *mfwgbase[2] =  /* wage base titles */
   { "automatic provisions followed",
     "ad hoc wage bases (entered by user)" };
char *survivor[3] = /* type of survivor titles */
   { "young survivor (child or parent of child)",
     "disabled widow (aged 50-59)",
     "aged widow (aged 60 or over)" };
char *earnmal[6] = /* earnings selection titles */
   { "entered earnings",
     "maximum earnings",
     "average earnings",
     "low earnings",
     "old-law maximum earnings",
     "childcare year" };

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void  noninp   ( FILE *out, WORKERDATA *workerdata, PIADATA *piadata );
static void  bottom4  ( FILE * );
#else
static void  noninp();
static void  bottom4();
#endif

/* Function to print first page of 2-page summary
 */
void two_pg1(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   register i1;  /* loop counter */
   int cols = 6;  /* left-hand margin */

   fprintf(out, "%20sSummary of results%12s%s\n\n", " ", " ",
      piadata -> dateln);
   fprintf(out,"      %s born on %s\n", fmale(workerdata),
      date(workerdata -> ibirth));
   switch (workerdata -> ioasdi)
   {
   case OLD_AGE:
      fprintf(out, "      Retired in %s %d at age %d and %d months\n",
         month(workerdata -> ient[0] - 1), workerdata -> ient[2],
         piadata -> iage[0], piadata -> iage[1]);
      if (workerdata -> recalc)
         fprintf(out, "      Benefit as of %s %d at age %d and %d months\n",
            month(workerdata -> bendate[0] - 1), workerdata -> bendate[2],
            piadata -> iage1[0], piadata -> iage1[1]);
      if (workerdata -> valdi == 1) {
         fprintf(out, "%s%s%s\n", stringd(cols, ' '), catstr(248),
            date(workerdata -> ionset));
         fprintf(out, "      Previous disability entitlement in %s %d\n",
            month(workerdata -> priorent[0] - 1), workerdata -> priorent[2]);
         }
      fprintf(out,"      Normal retirement age = %d and %d months\n",
         piadata -> nra[0], piadata -> nra[1]);
      fprintf(out,"      Early retirement age = %d and %d months\n",
         piadata -> nra1[0], piadata -> nra1[1]);
      break;
   case SURVIVOR:
      fprintf(out, "      Died in %s %d\n", month(workerdata -> ideath[0]-1),
         workerdata -> ideath[2]);
      fprintf(out, "      Benefits started in %s %d\n",
         month(workerdata -> ient[0] - 1), workerdata -> ient[2]);
      if (workerdata -> recalc)
         fprintf(out, "      Benefit as of %s %d\n",
            month(workerdata -> bendate[0] - 1), workerdata -> bendate[2]);
      if (workerdata -> valdi == 1)
         fprintf(out, "%s%s%s\n", stringd(cols, ' '), catstr(248),
            date(workerdata -> ionset));
      fprintf(out, "      Type of beneficiary:  %s\n",
         survivor[(int)workerdata -> jsurv - 1]);
      if (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID)
         fprintf(out, "%s%s%s\n", stringd(cols, ' '), catstr(249),
            date(workerdata -> jbirth));
      if (workerdata -> jsurv == DISAB_WID)
         fprintf(out, "%s%s%s\n", stringd(cols, ' '), catstr(268),
            date(workerdata -> jonset));
      if (workerdata -> jsurv == AGED_WID)
         fprintf(out,
            "      Widow(er)'s normal retirement age = %d and %d months\n",
            piadata -> nra2[0], piadata -> nra2[1]);
      break;
   case DISABILITY:
      fprintf(out,"      Disabled on %s\n", date(workerdata -> ionset));
      fprintf(out,"      Benefits started in %s %d at age %d ",
         month(workerdata -> ient[0] - 1), workerdata -> ient[2],
         piadata -> iage[0]);
      fprintf(out, "and %d months\n", piadata -> iage[1]);
      if (workerdata -> recalc)
         fprintf(out, "      Benefit as of %s %d at age %d and %d months\n",
            month(workerdata -> bendate[0] - 1), workerdata -> bendate[2],
            piadata -> iage1[0], piadata -> iage1[1]);
      break;
   case PEBS_CALC:
      return;
   } /* end switch */
   if (workerdata -> pubpen > (float)0.)
      nonpenout(out, workerdata, 6);
   for (i1 = 0; i1 < MAXCAL; i1++) {
      fprintf(out, "\n      %s\n", piadata -> title[i1]);
      if (piadata -> iapp[i1]) {
         fprintf(out, "         PIA = %s\n",
            pdouble(piadata -> piaent[i1],9,2));
         fprintf(out, "         MFB = %s\n",
            pdouble(piadata -> mfbent[i1],9,2)); }
      else
         fprintf(out, "         Not applicable\n");
      } /* end for */
   fprintf(out,"\n\n\n\n");
   switch (piadata -> iappn)
      {
      case OLD_START:
      case PIA_TABLE:
      case TRANS_GUAR:
         fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(269),
            pdouble(piadata -> ame[piadata -> iappn],8,0));
         break;
      case WAGE_IND:
      case REIND_WID:
         fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(270),
            pdouble(piadata -> ame[piadata -> iappn],8,0));
         break;
      case SPEC_MIN:
         fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(271),
            pint(piadata -> ispmnt[0], 8));
      }
   fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(272),
      pdouble(piadata -> hipia,8,2));
   /* print support PIA, if applicable */
   if (piadata -> arfapp > 0)
      fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(280),
         pdouble(piadata -> suppia,8,2));
   if (piadata -> arf >= 1.0) {
      fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(273),
         pint(piadata -> mardri, 8));
      fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(274),
         pdouble(piadata -> arf, 8, 3));
      }
   else
      {
      fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(275),
         pint(piadata -> mardri, 8));
      if (workerdata -> ioasdi == SURVIVOR && workerdata -> jsurv == YOUNG_SURV)
         fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(276),
            pdouble(piadata -> arf, 8, 3));
      else
         fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(277),
            pdouble(piadata -> arf, 8, 3));
      }
   fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(278),
      pdouble(piadata -> benfit[0],8,2));
   fprintf(out, "%s%s%s\n", stringd(cols,' '), catstr(281),
      pdouble(piadata -> benfit[1],8,2));
   if (piadata -> arfapp > 0)
      fprintf(out, "%s%s%\n", stringd(cols,' '),
         catstr(245 + piadata -> arfapp));
   fprintf(out, "%s%s%s\n\n\n\n", stringd(cols,' '), catstr(279),
      pdouble(piadata -> himfb,8,2));
#ifdef LAWCHG
   if (lawchgdata -> jindt)
      coment(out,lawchgdata);
#endif
   if (need_bi(workerdata)) /* benefit increase assumptions */
      {
      fprintf(out, "      Benefit increase assumptions:\n");
      if (workerdata -> ialtbi == OTHER_ASSUM)
         fprintf(out, "      %s\n", workerdata -> titlbi);
      else
         fprintf(out, "      %s\n", getbeninc((int)workerdata -> ialtbi));
      }
   if (need_aw(workerdata)) /* average wage assumptions */
      {
      fprintf(out, "      Average wage increase assumptions:\n");
      if (workerdata -> ialtaw == OTHER_ASSUM)
         fprintf(out, "      %s\n", workerdata -> titlaw);
      else
         fprintf(out, "      %s\n", getavgwage((int)workerdata -> ialtaw));
      }
   /* print noninsured paragraph */
   noninp(out, workerdata, piadata);
   if (workerdata -> ioasdi == DISABILITY) {
      fprintf(out,"\n");
      disinsout(out,6); }
   if (pebsasmchk(workerdata) == 0)
      bottom3(out, "future", workerdata -> ialtaw);
   else
      bottom4(out);
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
}
/* Function to print second page of 2-page summary
 */
void two_pg2(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
int curyear)  /* current year (through which qc's are known) */
{
   register i1;  /* loop counter */

   fprintf(out,"          Earnings Used in PIA Calculation%8s%s\n\n",
      " ", piadata -> dateln);
   fprintf(out,"%39sAmount    Quarters"," ");
   if (workerdata -> totalize)
      fprintf(out,"  Relative     Attri-");
   fprintf(out,"\n%16sAnnual      Maximum     per         of"," ");
   if (workerdata -> totalize)
      fprintf(out,"     earnings      buted");
   fprintf(out, "\n      year%5searnings     earnings     QC   ", " ");
   fprintf(out, "   coverage");
   if (workerdata -> totalize)
      fprintf(out,"  position    earnings");
   fprintf(out,"\n\n");
   for (i1 = workerdata -> ibegin; i1 <= workerdata -> iend; i1++) {
      fprintf(out, "      %4d", i1);
      if (workerdata -> ibegin != 1950 || i1 != 1950 ||
         workerdata -> totalize != 0)
         fprintf(out, " %s", pdouble(piadata -> earnst[2][i1-1937], 12, 2));
      else
         fprintf(out, " %s", pdouble(piadata -> stot[0], 12, 2));
      fprintf(out, " %s", pdouble(piaparms -> base[i1-1937], 12, 2));
      if (i1 <= curyear && workerdata -> totalize == 0)
         fprintf(out,"\n");
      else {
         if (i1 > curyear && i1 > 1950)
            fprintf(out, " %s", pdouble(piaparms -> qcamt[i1-1937], 9, 2));
         else
            fprintf(out,"%10s"," ");
         if (i1 > 1950)
            fprintf(out, "     %4d", workerdata -> qc[i1-1937]);
         else {
            if (i1 < 1950)
               fprintf(out,"%10s"," ");
            else
               fprintf(out, "     %4d", piadata -> qctot50);
            }
         if (workerdata -> totalize) {
            fprintf(out, " %10.5f", piadata -> rep[i1-1937]);
            fprintf(out, " %s", pdouble(piadata -> earnst[3][i1-1937], 12, 2));
            }
         fprintf(out,"\n");
         }
      } /* end for */
   fprintf(out, "\n      QC's for %4d and earlier%20s%4d\n\n", curyear, " ",
      workerdata -> qctottd);
   if (workerdata -> totalize)
      fprintf(out, "      Relative earnings position = %7.5f\n",
         piadata -> repavg);
   if (workerdata -> bendate[2] > workerdata -> istart &&
      workerdata -> iend > workerdata -> istart)
      fprintf(out,"      Projected wage bases:  %s\n",
         mfwgbase[workerdata -> ibasch - 1]);
   /* print noninsured message */
   nonins(out, workerdata, piadata, 6);
   if (piadata -> iernyr < workerdata -> iend)  /* print unused earnings message */
      fprintf(out, "\n      Warning! %s\n", catstr(193));
   if (workerdata -> ioasdi == DISABILITY)
      { /* print disability-insured message */
      fprintf(out,"\n");
      disinsout(out,6); }
   if (piadata -> over_max)  /* print truncated earnings message */
      fprintf(out,"\n      Warning! %s\n", catstr(194));
   fprintf(out,"\n");
   prtnmssn(out,workerdata,6);
   FORMFEED;
}
/* Function to print noninsured paragraph
 */
static void noninp(
FILE *out,  /* output file */
WORKERDATA *workerdata,  /* workerdata structure */
PIADATA *piadata)  /* piadata structure */
{
   if (workerdata -> totalize)
      {
      if (piadata -> qctot < 6) {
         fprintf(out,"\n      This estimate is theoretical because 6 ");
         fprintf(out,"quarters are needed to be\n");
         fprintf(out,"      eligible for a totalization benefit; the ");
         fprintf(out, "worker has only %d.\n", piadata -> qctot);
         }
      if (piadata -> qctot >= piadata -> qcreq) {
         fprintf(out,"\n      This estimate is theoretical because the ");
         fprintf(out,"worker is fully insured.\n");
         fprintf(out,"      The worker must have fewer than %d quarters; ",
            piadata -> qcreq);
         if (workerdata -> isex == 1)
            fprintf(out,"he");
         else
            fprintf(out,"she");
         fprintf(out, " has %d.\n", piadata -> qctot);
         }
      }
   else
      if (piadata -> qctot < piadata -> qcreq) {
         fprintf(out,"\n      This estimate is theoretical because the ");
         fprintf(out,"worker is not fully insured.\n");
         fprintf(out, "      A total of %d quarters are needed; ",
            piadata -> qcreq);
         if (workerdata -> isex == 1)
            fprintf(out,"he");
         else
            fprintf(out,"she");
         fprintf(out, " has only %d.\n", piadata -> qctot);
         }
}
/* Function to print generic warning
 */
static void bottom4(
FILE *out)  /* output file */
{
   fprintf(out, "\n      The estimates we gave are based on your ");
   fprintf(out, "earnings record and any infor-\n");
   fprintf(out, "      mation you gave us.  The estimate provided ");
   fprintf(out, "could change--it could\n");
   fprintf(out, "      increase or decrease--depending on your ");
   fprintf(out, "actual future earnings,\n");
   fprintf(out, "      future changes in the average wages of all ");
   fprintf(out, "employed persons, and on\n");
   fprintf(out, "      future rates of inflation.\n");
}
