/*
 * @(#)utils.C	1.56   3/31/94
 * Various utility functions
 */

#ifndef lint
static char *utilsID = " @(#)utils.C	1.56   3/31/94 ";
#endif

#include <stdio.h>
#if defined(M_XENIX) | defined(M_UNIX)
#include "bool.h"
#endif
#include <stdlib.h>
#ifdef BSD
#include <sys/time.h>
#include <strings.h>
#else
#include <time.h>
#include <string.h>
#endif
#include "utils.h"

#if defined(MSDOS) | defined(THINK_C)
#define SLASH "\\"
#else
#define SLASH "/"
#endif

/* Function to create a string with all characters the same
 */
char *stringd(
int nchar,  /* number of characters to create */
int chr)  /* character to use */
{
   static char start[80]; /* string to hold results */
   char *i1; /* loop counter */

   for (i1 = start; i1 < start+nchar; i1++)
      *i1 = (char)chr;
   *(start+nchar) = '\0';
   return(start);
}
/* Function to get current month
 */
curmonth()
{
   time_t clock;  /* time in seconds */
   struct tm *curtime;  /* structure to hold current time */

   time(&clock);  /* get time */
   curtime = localtime(&clock);
   /* convert month from 0-11 to 1-12 */
   return(curtime -> tm_mon + 1);
}
/* Function to get date and time
 */
char *datime()
{
   time_t clock; /* time in seconds */

   time(&clock); /* get time */
   return(ctime(&clock));
}
/* Function to get current date as (month day, year)
 */
char *datenow()
{
   time_t clock;  /* time in seconds */
   struct tm *curtime;  /* structure holding current time */
   int modyyr[3];  /* month, day, and year */

   time(&clock);  /* get time */
   curtime = localtime(&clock);
   modyyr[0] = curtime -> tm_mon + 1;
   modyyr[1] = curtime -> tm_mday;
   modyyr[2] = curtime -> tm_year + 1900;
   return(date(modyyr));
}
/* Function to return a date as (month day, year)
 */
char *date(
int *modyyr)  /* month, day, and year */
{
   static char retdate[20];  /* date string to be returned */

   sprintf(retdate, "%s %d, %d", month(modyyr[0] - 1), modyyr[1], modyyr[2]);
   return(retdate);
}
/* Function to produce full name of month
 */
char *month(
int mnth)  /* number of month (0-11) */
{
   static char *monthnm[12] = { "January","February","March","April",
                 "May","June","July","August","September","October",
                 "November","December" };
                 /* month for output */

   return(monthnm[mnth]);
}
/* Function to get a title from a file, including embedded
 * spaces, and ignoring quote marks
 */
int getitle(
char *str,  /* string to put title into */
unsigned int maxchar,  /* maximum number of characters */
FILE *in)  /* file to read */
{
   unsigned i1; /* loop counter */
   int   i2; /* character returned by fgetc */

   i1 = 0;
   while (((i2 = fgetc(in)) != '\n') && (i2 != EOF) && (i1 < maxchar)) {
      if (i2 != 34) /* do not use quotes */
         str[i1++] = (char)i2;
      } /* end while */
   if (i1 == 0 && i2 == EOF)
      return(-1);
   if (i1 < maxchar-1)
      str[i1] = '\0';
   else
      str[maxchar-1] = '\0'; /* ensure end of string */
   return(i1);
}
/* Function to concatenate directory and file names into pathname
 */
void concat(
char **pathname,  /* pathname of file */
char *directory,  /* directory name */
char *filename)  /* local filename */
{
   static char ernfile[130];  /* pathname, saved in this function */

   if (strlen(directory) > 0) {
      strcpy(ernfile,directory);
      strcat(ernfile,SLASH);
      strcat(ernfile,filename);
      }
   else
      strcpy(ernfile,filename);
   *pathname = ernfile;
}
