/*
 * winboss1.C for WindowBoss
 * Supplemental windows functions
 */

#ifndef lint
static char *winboss1ID = " winboss1.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wnutils.h"
#include "winboss1.h"
#include "getdate.h"
#include "mesgcat.h"

char *employee[2] = { "Employee ", "Self-emp " };
   /* labels for type of taxes */
char *mlstr[6] = { "Entered  ", "Maximum  ", "Average  ", "Low      ",
   "Oldlawmax", "Childcare" };
   /* labels for type of earnings */

/* Function to set colors
 */
void setcolor(
int icolor)  /* color indicator (0 for monochrome, 1 for color) */
{
   int i1;  /* loop counter */

   /* set colors for color monitor */
   init_pair(1,BLUE,BLUE); /* blue on blue (data entry) */
   init_pair(2,GREEN,BLACK); /* green (responses) */
   init_pair(3,RED,BLACK); /* red (errors) */
   init_pair(4,YELLOW,BLACK);  /* yellow (help screens) */
   init_pair(5,CYAN,BLACK); /* cyan (intro screens) */
   init_pair(6,WHITE,BLACK);  /* white (requested actions) */
   init_pair(7,WHITE,WHITE); /* white on white */
   init_pair(8,WHITE,GREEN); /* white on green */
   init_pair(9,YELLOW,BLUE);  /* yellow on blue (titles) */
   init_pair(10,BLUE,BLACK); /* blue (border) */
   if (icolor == 0) {
      for (i1 = 0; i1 < 8; i1++)  /* set monochrome colors */
         color[i1] = 0x07;
      color[8] = 0x70;
      }
}
/* Function to get a year from a window with validation
 */
int wn_gyear(
int fun,  /* SET or XEQ */
WIFORM frm,  /* form pointer or NFRM */
int fld,  /* field number or NFLD */
WINDOW *wn,  /*window to use */
int row,  /* row position of input field */
int col,  /* column position of input field */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill char */
int *value,  /* the integer to be returned */
int fwidth,  /* field width */
int low,  /* low limit */
int high,  /* high limit */
char *ubuff,  /* returns value as a string */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   long lv;  /* temp value */
   int v;  /* temp value */
   char mask[10];  /* single precision */
   int r;  /* sscanf return value */
   int rv;  /* return value */

   if (fun != SET && fun != XEQ)         /* safety check */
      return(FALSE);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      return(FALSE);
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GYEAR;            /* function code */
    frm[fld]->v1.vip = value;           /* &value */
    frm[fld]->v2.vi = fwidth;           /* fwidth */
    frm[fld]->v3.vi = low;              /* lower limit */
    frm[fld]->v4.vi = high;             /* upper limit */
    frm[fld]->v5.vcp = ubuff;           /* &ubuff */
    frm[fld]->v6.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v7.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

   strcpy(mask,"#######");  /* set mask */
   if (fwidth > 6) {  /* don't allow foolishness */
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   mask[fwidth] = NUL;  /* set length */
 begin:
   if (!(rv = wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   if (wni_frmflg) return(TRUE);        /* wn_frmget in progress */
   if (wns_escape) return(rv);          /* escape exit */
   r = sscanf(ubuff, "%ld", &lv);  /* convert to long */
   if (r == EOF || r == 0)
      lv = 0l;  /* no data entered */
   if (lv < (long)INT_MIN || lv > (long)INT_MAX) {  /* range check data type */
      wn_iemsg(errmsg);  /* do error thing */
      goto begin;  /* start over */
      }
   v = (int)lv;  /* convert to int */
   if (v < 100) {
      v += 1900;
      sprintf(ubuff,"%d",v);
      wn_putsa(wn,row,col+(int)strlen(prmpt),ubuff,atrib);
      }
   if (v < low || v > high) {  /* bad int */
      wn_iemsg(errmsg);  /* do error thing */
      goto begin;  /* and start over */
      }
   *value = v;  /* load user value */
   return(rv);  /* all is well ... in gross sense */
}
/* Function to get a E or S from a window with validation
 */
int wn_ges(
int fun,  /* SET or XEQ */
WIFORM frm,  /* form pointer or NFRM */
int fld,  /* field number or NFLD */
WINDOW *wn,  /*window to use */
int row,  /* row position of input field */
int col,  /* column position of input field */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill char */
int *value,  /* 0 = employee, 1 = self-employed */
char *ubuff,  /* returns value as a string */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   char mask[3];  /* single char unput */
   int rv;  /* return value */

   if (fun != SET && fun != XEQ)         /* safety check */
      return(FALSE);
   if (*value < 0 || *value > 1)
      return(FALSE);
   strcpy(ubuff,employee[*value]);

   if (fun == SET) {                     /* set up */
      if (frm[fld]->pself != (char *)frm[fld])
         wns_ierr("wn_ges");             /* die if memory is mangled */
      frm[fld]->wn = wn;                 /* set window */
      frm[fld]->row = row;               /* set row */
      frm[fld]->col = col;               /* set col */
      frm[fld]->prmpt = prmpt;           /* set prompt */
      frm[fld]->atrib = atrib;           /* set attribute */
      frm[fld]->fill = fill;             /* set fill character */
      frm[fld]->fcode = GES;             /* function code */
      frm[fld]->v1.vip = value;          /* value */
      frm[fld]->v2.vcp = ubuff;          /* &ubuff */
      frm[fld]->v3.vcp = hlpmsg;         /* &hlpmsg */
      frm[fld]->v4.vcp = errmsg;         /* &errmsg */
      return(TRUE);
   }

   wn_putsa(wn,row,col+(int)strlen(prmpt),ubuff,atrib);
   strcpy(mask,"u");  /* set mask */
 begin:
   if (!(rv = wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   if (wni_frmflg) return(TRUE);        /* wn_frmget in progress */
   if (wns_escape) return(rv);          /* escape exit */
   if (*ubuff == 'E' || *ubuff == 'S') {
      *value = (*ubuff == 'E') ? 0 : 1;  /* set user value */
      wn_putsa(wn,row,col+(int)strlen(prmpt),employee[*value],atrib);
      return(rv);  /* and return */
      }
   wn_iemsg(errmsg);  /* display error message */
   goto begin;  /* till we get it right */
}
/* Function to get a E, M, A, L, or C from a window with validation
 */
int wn_gmlchr(
int fun,  /* SET or XEQ */
WIFORM frm,  /* form pointer or NFRM */
int fld,  /* field number or NFLD */
WINDOW *wn,  /*window to use */
int row,  /* row position of input field */
int col,  /* column position of input field */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill char */
int *value,  /* 0 = entered, 1 = maximum, 2 = average, 3 = low,
   4 = old-law maximum, 5 = childcare year */
char *ubuff,  /* returns value as a string */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   char mask[3];  /* single char unput */
   int rv;  /* return value */

   if (fun != SET && fun != XEQ)         /* safety check */
      return(FALSE);
   if (*value < 0 || *value > 5)
      return(FALSE);
   strcpy(ubuff,mlstr[*value]);

   if (fun == SET) {                     /* set up */
      if (frm[fld]->pself != (char *)frm[fld])
         wns_ierr("wn_gmlchr");             /* die if memory is mangled */
      frm[fld]->wn = wn;                 /* set window */
      frm[fld]->row = row;               /* set row */
      frm[fld]->col = col;               /* set col */
      frm[fld]->prmpt = prmpt;           /* set prompt */
      frm[fld]->atrib = atrib;           /* set attribute */
      frm[fld]->fill = fill;             /* set fill character */
      frm[fld]->fcode = GMLCHR;          /* function code */
      frm[fld]->v1.vip = value;          /* value */
      frm[fld]->v2.vcp = ubuff;          /* &ubuff */
      frm[fld]->v3.vcp = hlpmsg;         /* &hlpmsg */
      frm[fld]->v4.vcp = errmsg;         /* &errmsg */
      return(TRUE);
   }

   wn_putsa(wn,row,col+(int)strlen(prmpt),ubuff,atrib);
   strcpy(mask,"u");  /* set mask */
 begin:
   if (!(rv = wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   if (wni_frmflg) return(TRUE);        /* wn_frmget in progress */
   if (wns_escape) return(rv);          /* escape exit */
   switch (*ubuff)
      {
      case 'E':
         *value = 0;
         break;
      case 'M':
         *value = 1;
         break;
      case 'A':
         *value = 2;
         break;
      case 'L':
         *value = 3;
         break;
      case 'O':
         *value = 4;
         break;
      case 'C':
         *value = 5;
         break;
      default:
         wn_iemsg(errmsg);  /* display error message */
         goto begin;  /* till we get it right */
      }
   wn_putsa(wn,row,col+(int)strlen(prmpt),mlstr[*value],atrib);
   return(rv);  /* and return */
}
/* Function to get a M or F from a window with validation
 */
int wn_gmf(
int fun,  /* SET or XEQ */
WIFORM frm,  /* form pointer or NFRM */
int fld,  /* field number or NFLD */
WINDOW *wn,  /*window to use */
int row,  /* row position of input field */
int col,  /* column position of input field */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill char */
int *value,  /* 1 = male, 2 = female */
char *ubuff,  /* returns value as a string */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   char mask[3];  /* single char unput */
   int rv;  /* return value */

   if (fun != SET && fun != XEQ)         /* safety check */
      return(FALSE);

   if (fun == SET) {                     /* set up */
      if (frm[fld]->pself != (char *)frm[fld])
         wns_ierr("wn_gmf");             /* die if memory is mangled */
      frm[fld]->wn = wn;                 /* set window */
      frm[fld]->row = row;               /* set row */
      frm[fld]->col = col;               /* set col */
      frm[fld]->prmpt = prmpt;           /* set prompt */
      frm[fld]->atrib = atrib;           /* set attribute */
      frm[fld]->fill = fill;             /* set fill character */
      frm[fld]->fcode = GMF;             /* function code */
      frm[fld]->v1.vip = value;          /* value */
      frm[fld]->v2.vcp = ubuff;          /* &ubuff */
      frm[fld]->v3.vcp = hlpmsg;         /* &hlpmsg */
      frm[fld]->v4.vcp = errmsg;         /* &errmsg */
      return(TRUE);
   }

   if (*value)
      strcpy(ubuff, ((*value == 1) ? "M" : "F"));
   else
      *ubuff = NUL;

   strcpy(mask,"u");  /* set mask */
 begin:
   if (!(rv = wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   if (wni_frmflg) return(TRUE);        /* wn_frmget in progress */
   if (wns_escape) return(rv);          /* escape exit */
   if (*ubuff == 'M') {
      *value = 1;  /* set user value */
      return(rv);  /* and return */
      }
   if (*ubuff == 'F') {
      *value = 2;  /* set user value */
      return(rv);  /* and return */
      }
   wn_iemsg(errmsg);  /* display error message */
   goto begin;  /* till we get it right */
}
/* Function to get a I or L from a window with validation
 */
int wn_gil(
int fun,  /* SET or XEQ */
WIFORM frm,  /* form pointer or NFRM */
int fld,  /* field number or NFLD */
WINDOW *wn,  /*window to use */
int row,  /* row position of input field */
int col,  /* column position of input field */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill char */
int *value,  /* 0 = initial, 1 = recalculation */
char *ubuff,  /* returns value as a string */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   char mask[3];  /* single char unput */
   int rv;  /* return value */

   if (fun != SET && fun != XEQ)         /* safety check */
      return(FALSE);

   if (fun == SET) {                     /* set up */
      if (frm[fld]->pself != (char *)frm[fld])
         wns_ierr("wn_gmf");             /* die if memory is mangled */
      frm[fld]->wn = wn;                 /* set window */
      frm[fld]->row = row;               /* set row */
      frm[fld]->col = col;               /* set col */
      frm[fld]->prmpt = prmpt;           /* set prompt */
      frm[fld]->atrib = atrib;           /* set attribute */
      frm[fld]->fill = fill;             /* set fill character */
      frm[fld]->fcode = GIL;             /* function code */
      frm[fld]->v1.vip = value;          /* value */
      frm[fld]->v2.vcp = ubuff;          /* &ubuff */
      frm[fld]->v3.vcp = hlpmsg;         /* &hlpmsg */
      frm[fld]->v4.vcp = errmsg;         /* &errmsg */
      return(TRUE);
   }

   strcpy(ubuff, ((*value == 0) ? "I" : "L"));
   strcpy(mask,"u");  /* set mask */
 begin:
   if (!(rv = wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
      *ubuff = NUL;  /* indicate error */
      return(FALSE);  /* and return */
      }
   if (wni_frmflg) return(TRUE);        /* wn_frmget in progress */
   if (wns_escape) return(rv);          /* escape exit */
   if (*ubuff == 'I') {
      *value = 0;  /* set user value */
      return(rv);  /* and return */
      }
   if (*ubuff == 'L') {
      *value = 1;  /* set user value */
      return(rv);  /* and return */
      }
   wn_iemsg(errmsg);  /* display error message */
   goto begin;  /* till we get it right */
}
/* Function to get date as mo/dy/year
 */
wn_gmdy(
int fun,  /* function code (SET || XEQ) */
WIFORM frm,  /* form pointer (actual || NFRM) */
int fld,  /* field # in form (actual || NFLD) */
WINDOW *wn, /* window being used */
int row,  /* row in window where data input begins */
int col,  /* col in window where data input begins */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill character */
int *mnth,  /* month */
int *day,  /* day */
int *year,  /* year */
int low,  /* low limit on year */
int high,  /* high limit on year */
char *ubuff,  /* returns "mo/dy/year" */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   int modyyr[3];  /* month, day, and year */
   int r;  /* getmdy return value */
   int rv;  /* return value */
   int eflg;  /* error flag */

   if (fun != SET && fun != XEQ)   /* safety check */
      return(FALSE);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gmdy");              /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GMDY;             /* function code */
    frm[fld]->v1.vip = mnth;            /* &month */
    frm[fld]->v2.vip = day;             /* &day */
    frm[fld]->v3.vip = year;            /* &year */
    frm[fld]->v4.vi = low;              /* lower limit on year */
    frm[fld]->v5.vi = high;             /* upper limit on year */
    frm[fld]->v6.vcp = ubuff;           /* &ubuff */
    frm[fld]->v7.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v8.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

   modyyr[0] = *mnth;
   modyyr[1] = *day;
   modyyr[2] = *year;
   putmdy(ubuff,modyyr);
 begin:
   if (!(rv=wn_input(wn,row,col,prmpt,"##/##/####",fill,atrib,ubuff,hlpmsg)))
      {
      *ubuff = NUL;  /* load ubuff with a bad date */
      return(FALSE);  /* indicate error */
      }
   if (wni_frmflg) return(TRUE);  /* wn_frmget in progress */
   if (wns_escape) return(rv);    /* escape exit */
   eflg = FALSE;
   r = getmdy(ubuff, modyyr);
   if (r == EOF || r == 0) {  /* no data - set to zip */
      wn_iemsg(catstr(250));
      *mnth = *day = *year = 0;
      eflg = TRUE;
      }
   if (modyyr[2] < 100) {  /* adjust for 2-digit year */
      modyyr[2] += 1900;
      sprintf(ubuff+6,"%4d",modyyr[2]);
      wn_putsa(wn,row,col+6+(int)strlen(prmpt),ubuff+6,atrib); }
   if (modyyr[0] < 1 || modyyr[0] > 12) { /* bad month entry */
      wn_iemsg(catstr(251));
      eflg = TRUE; }
   if (modyyr[1] < 1 || modyyr[1] > 31) { /* bad day entry */
      wn_iemsg(catstr(252));
      eflg = TRUE; }
   if (modyyr[2] < low || modyyr[2] > high) { /* bad year entry */
      wn_iemsg(errmsg);
      eflg = TRUE; }
   if (eflg)
      goto begin;  /* start over */
   *mnth = modyyr[0];  /* load user month */
   *day = modyyr[1];  /* and day */
   *year = modyyr[2];  /* and year */
   return(rv);  /* all is well ... in gross sense */
}
/* Function to get date as mo/year
 */
wn_gmy(
int fun,  /* function code (SET || XEQ) */
WIFORM frm,  /* form pointer (actual || NFRM) */
int fld,  /* field # in form (actual || NFLD) */
WINDOW *wn,  /* window being used */
int row,  /* row in window where data input begins */
int col,  /* col in window where data input begins */
char *prmpt,  /* prompt string */
chtype atrib,  /* data entry attribute */
char fill,  /* fill character */
int *mnth,  /* month */
int *year,  /* year */
int low,  /* low limit on year */
int high,  /* high limit on year */
char *ubuff,  /* returns "mo/year" */
char *hlpmsg,  /* help message */
char *errmsg)  /* error message */
{
   int moyear[3];  /* month, day, and year */
   int r;  /* sscanf return value */
   int rv;  /* return value */
   int eflg;  /* error flag */

   if (fun != SET && fun != XEQ)   /* safety check */
      return(FALSE);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gmy");               /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = GMY;              /* function code */
    frm[fld]->v1.vip = mnth;            /* &month */
    frm[fld]->v2.vip = year;            /* &year */
    frm[fld]->v3.vi = low;              /* lower limit on year */
    frm[fld]->v4.vi = high;             /* upper limit on year */
    frm[fld]->v5.vcp = ubuff;           /* &ubuff */
    frm[fld]->v6.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v7.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

   moyear[0] = *mnth;
   moyear[2] = *year;
   putmy(ubuff,moyear);

 begin:
   if (!(rv=wn_input(wn,row,col,prmpt,"##/####",fill,atrib,ubuff,hlpmsg)))
      {
      *ubuff = NUL;  /* load ubuff with a bad date */
      return(FALSE);  /* indicate error */
      }
   if (wni_frmflg) return(TRUE);  /* wn_frmget in progress */
   if (wns_escape) return(rv);    /* escape exit */
   eflg = FALSE;
   r = getmy(ubuff, moyear);
   if (r == EOF || r == 0) {  /* no data - set to zip */
      wn_iemsg(catstr(253));
      *mnth = *year = 0;
      eflg = TRUE;
      }
   if (moyear[2] < 100) {  /* adjust for 2-digit year */
      moyear[2] += 1900;
      sprintf(ubuff+3,"%4d",moyear[2]);
      wn_putsa(wn,row,col+3+(int)strlen(prmpt),ubuff+3,atrib); }
   if (moyear[0] < 1 || moyear[0] > 12) { /* bad month entry */
      wn_iemsg(catstr(251));
      eflg = TRUE; }
   if (moyear[2] < low || moyear[2] > high) { /* bad year entry */
      wn_iemsg(errmsg);
      eflg = TRUE; }
   if (eflg)
      goto begin;  /* start over */
   *mnth = moyear[0];  /* load user month */
   *year = moyear[2];  /* and year */
   return(rv);  /* all is well ... in gross sense */
}
