/*
 * wnutils.C for WindowBoss
 * Various utility functions using windows
 */

#ifndef lint
static char *wnutilsID = " wnutils.C for WindowBoss ";
#endif

#if defined(NO_WINDOW)
#include <stdio.h>
#include "bool.h"
#else
#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include <stdlib.h>
#if DLC > 0
#define SIGNAL(addr) int_intercept(0x23,addr,200)
#else
#define SIGNAL(addr) signal(SIGINT,addr)
#endif
#include <signal.h>
#include <string.h>
#include "utils.h"
#include "wnutils.h"
#include "mesgcat.h"

#if !defined(NO_WINDOW)
WINDOW *win4;  /* subwindow for messages */
WINDOW *win5;  /* main data entry window */
#endif

#define PIAEXT ".PIA"
#define SLASH "\\"

/* Function to get a return from keyboard
 */
void getret()
{
   char ans[2]; /* answer to prompt */

#if defined(NO_WINDOW)
   printf("%-65s","Press RETURN to continue");
   while ((ans[0] = getchar()) != '\n')
      ;
#else
   wattrset(win4,COLOR_PAIR(6));
   wn_dtext(XEQ,NFRM,NFLD,win4,1+FF,6+FF,stringd(65,' '));
   wn_dtext(XEQ,NFRM,NFLD,win4,1+FF,6+FF,"Press RETURN to continue");
   WREFRESH(win4);
   v_hidec();
   while ((ans[0] = (char)wgetch(win4)) != '\n')
      beep();
   wn_sync(win4,TRUE);
   clr_warn();
#endif
}
/* Function to capture break-key input, or usual end-of-program
 */
void done(
int stat)  /* exit status */
{
#if !defined(NO_WINDOW)
   attrset(A_NORMAL);
   erase();
   touchwin(stdscr);
   refresh();
   wn_exit();
   v_border(BLACK);
#endif
   exit(stat);
}
/* Function to print status message
 */
void status(
char *mesg)  /* message to be printed */
{
#if defined(NO_WINDOW)
   printf("%-65s\n",mesg);
#else
   wattrset(win4,COLOR_PAIR(4));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,stringd(65,' '));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,mesg);
   WREFRESH(win4);
#endif
}
/* Function to clear status message
 */
void clr_stat()
{
#if !defined(NO_WINDOW)
   wattrset(win4, COLOR_PAIR(4));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,stringd(65,' '));
   WREFRESH(win4);
#endif
   return;
}
/* Function to print help message
 */
int wn_ihmsg(
char *mesg)  /* message to be printed */
{
   if (!strlen(mesg))
      return(TRUE);
   status(mesg);
   getret();
   clr_stat();
   return(TRUE);
}
/* Function to print accept or edit message
 */
int wn_conmsg()
{
   int value;  /* value of key hit */

#if defined(NO_WINDOW)
   printf("Press ENTER to Accept, any other key to Edit");
   value = getchar();
#else
   wattrset(win4,COLOR_PAIR(6));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,
      "Press ENTER to Accept, any other key to Edit");
   WREFRESH(win4);
   value = wgetch(win4);
#endif
   clr_stat();
   return(value);
}
/* Function to print warning message
 */
int wn_iemsg(
char *mesg)  /* message to be printed */
{
#if defined(NO_WINDOW)
   printf("%-65s\n",mesg);
#else
   wattrset(win4,COLOR_PAIR(3));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,stringd(65,' '));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,mesg);
   beep();
   getret();
   clr_stat();
#endif
   return(TRUE);
}
/* Function to clear warning message
 */
void clr_warn()
{
#if !defined(NO_WINDOW)
   wattrset(win4, COLOR_PAIR(3));
   wn_dtext(XEQ,NFRM,NFLD,win4,1+FF,6+FF,stringd(65,' '));
   WREFRESH(win4);
#endif
   return;
}
/* Function to print header on new screen
 */
void begscrn(
char *center)  /* heading to center */
{
#if defined(NO_WINDOW)
   printf("%s\n",center);
#else
   wn_titla(win4, center, COLOR_PAIR(9));
   wattrset(win5,COLOR_PAIR(2));
   werase(win5);
   WREFRESH(win5);
#endif
}
/* Function to get filename for case to read or save
 */
int opencase(
char **ernfil)  /* name of file */
{
   static char ernfile[45];  /* name of file, saved in this function */
   int i1;  /* temporary counter */
   int rv;  /* return value */

   /* initialize name of file */
   if (strlen(ernfile) == 0)
      strcpy(ernfile, *ernfil);
#if defined(NO_WINDOW)
   printf("Enter name of file for this case (must be a legal pathname)\n");
   scanf("%s",ernfile);
   rv = 0;
#else
   wattrset(win5,COLOR_PAIR(6));
   wn_dtext(XEQ,NFRM,NFLD,win5,16,3,
      "Enter name of file for this case (must be a legal pathname)");
   rv = GETTEXT(XEQ,NFRM,NFLD,win5,17,3,"> ",COLOR_PAIR(2),' ',40,
      ernfile,"%name of file%",NSTR);
   if (rv == ESC)
      return(ESC_CODE);
   wn_sdelspc(ernfile,3);
#endif
   i1 = strlen(ernfile);
   /* add ".pia" extension, if not already there */
   if (strcmp(ernfile+i1-4,PIAEXT))
      strcat(ernfile, PIAEXT);
   *ernfil = ernfile;
   return(rv);
}
#if !defined(NO_WINDOW)
/* Function to initialize windows
 */
WINDOW *initwin(
int icolor)  /* color indicator (0 for monochrome, 1 for color) */
{
   wn_init();
   wn_dmode(FLASH);
   SIGNAL(done); /* capture control-break */
   refresh(); /* clear screen */
   setcolor(icolor);
   if ((win4 = wn_open(0,21,0,COLS-2+2*FF,LINES-23+2*FF,COLOR_PAIR(1),
      COLOR_PAIR(9))) == (WINDOW *)NULL) {
      printf("Could not open win4\n");
      done(1); }
   if ((win5 = wn_open(1000,1,0,COLS,20,A_NORMAL,A_NORMAL)) ==
      (WINDOW *)NULL) {
      printf("Could not open win5\n");
      done(1); }
#ifndef NOKEYPAD
   keypad(win4,TRUE);
   keypad(win5,TRUE);
#endif
   wn_sync(win5,TRUE);
   WREFRESH(win4);
   v_border(COLOR_PAIR(1)); /* initialize border */
   werase(win5);
   return(win5);
}
/* Function to get a return for printer ready
 */
void getrpr()
{
   wattrset(win4,COLOR_PAIR(6));
   wn_dtext(XEQ,NFRM,NFLD,win4,FF,6+FF,
      "Press RETURN when printer is ready                               ");
   WREFRESH(win4);
   v_hidec();
   while ((char)wgetch(win4) != '\n')
      beep();
   wn_sync(win4,TRUE);
   clr_stat();
}
#endif
