/*
 * worker.C for WindowBoss
 * Functions to get basic data about worker
 */

#ifndef lint
static char *workerID = " worker.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "winboss1.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "utils.h"
#include "wnutils.h"
#include "piain.h"
#include "mesgcat.h"

static char qctitle[] = "Quarters of coverage";

/* Function to get basic wage-earner information
 */
int worker1(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   char asex[3];  /* sex as 'M' or 'F' */
   static char joasdist[10];  /* joasdi as a string */
   char totalstr[10];  /* Y or N as a string for totalize */
   char backstr[10];  /* Y or N as a string for projback */
   char fwrdstr[10];  /* Y or N as a string for projfwrd */
   char mqgestr[10];  /* Y or N as a string for mqge */
   char recalcstr[10];  /* I or L as a string for recalc */
   WIFORM frm;  /* form pointer */
   int rv;  /* return value */
   int joasdit;  /* integer version of joasdi */
   int projbackt;  /* temporary projback */
   int projfwrdt;  /* temporary projfwrd */

   begscrn("  Wage-earner info  ");
   frm = wn_frmopn(8);
   wattrset(wn,COLOR_PAIR(6));
   if (!frm) {
      wn_iemsg(catstr(201));
      done(1); }
   /* get sex of worker */
   wn_gmf(SET,frm,0,wn,3,28,
      "Is sex of worker (M)ale or (F)emale? > ",COLOR_PAIR(2),
      ' ', &(workerdata -> isex), asex, "%sex%", catstr(254));
   /* get type of benefit */
   joasdit = (int) workerdata -> joasdi;
   sprintf(joasdist, "%1d", joasdit);
   wn_gint(SET,frm,1,wn,4,8,
      "Type of benefit (1: old-age, 2: surv, 3: disab, 4: PEBES > ",
      COLOR_PAIR(2),' ',&joasdit,1,1,4,joasdist,"%type of benefit%",
      catstr(6));
   wn_gil(SET,frm,2,wn,5,16,
      "Is PIA at (I)nitial entitlement or (L)ater date? > ",
      COLOR_PAIR(2), ' ', &(workerdata -> recalc), recalcstr,
      "%recalculation%", catstr(255));
   if (workerdata -> projback == 0) {
      projbackt = 0;
      strcpy(backstr,"N"); }
   else {
      projbackt = 1;
      strcpy(backstr,"Y"); }
   wn_gbool(SET,frm,3,wn,6,3,
      "Are earnings projected back from first year entered? (Y or N) > ",
      COLOR_PAIR(2), ' ', &projbackt, backstr, "%backward projection%",
      catstr(258));
   if (workerdata -> projfwrd == 0) {
      projfwrdt = 0;
      strcpy(fwrdstr,"N"); }
   else {
      projfwrdt = 1;
      strcpy(fwrdstr,"Y"); }
   wn_gbool(SET,frm,4,wn,7,8,
      "Are earnings projected after last year entered? (Y or N) > ",
      COLOR_PAIR(2), ' ', &projfwrdt, fwrdstr, "%forward projection%",
      catstr(258));
   if (workerdata -> totalize == 0)
      strcpy(totalstr,"N");
   else
      strcpy(totalstr,"Y");
   wn_gbool(SET,frm,5,wn,8,24,
      "Is this a totalization benefit? (Y or N) > ",COLOR_PAIR(2),' ',
      &(workerdata -> totalize), totalstr, "%totalization%", catstr(258));
   if (workerdata -> mqge == 0)
      strcpy(mqgestr,"N");
   else
      strcpy(mqgestr,"Y");
   wn_gbool(SET,frm,6,wn,9,27,
      "Are there Medicare earnings? (Y or N) > ",COLOR_PAIR(2),' ',
      &(workerdata -> mqge), mqgestr, "%hi earnings Y or N%", catstr(258));
   if ((rv = wn_frmget(frm)) == ESC_CODE) {
      wn_frmcls(frm);
      return(rv); }
   setjoasdi(workerdata, joasdit);
   if (projbackt) {
      if (workerdata -> projback == 0)
         workerdata -> projback = 1;
      }
   else
      workerdata -> projback = 0;
   if (projfwrdt) {
      if (workerdata -> projfwrd == 0)
         workerdata -> projfwrd = 1;
      }
   else
      workerdata -> projfwrd = 0;
   if (workerdata -> joasdi == PEBS_CALC)
      setpbdata(workerdata);
   if (workerdata -> joasdi == DISABILITY)
      workerdata -> valdi = 1;
   wn_frmcls(frm);
   return(rv);
}
/* Function to get PEBES information
 */
int worker2a(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   static char iageplst[10];  /* iageplan as a string */
   static char monthnst[10];  /* monthnow as a string */
   static char mdyst[12];  /* date of birth as a string */
   char ibeginst[10];  /* ibegin as a string */
   WIFORM frm;  /* form pointer */
   char *mesg2 = "Month in xxxx that this case is being or was processed > ";
      /* prompt for month of PEBES processing */
   int rv;  /* return value */
   char temp[20];  /* temporary string */
   int ierr;  /* error indicator */
#if defined(EXPANDED_PEBES)
   char ibegin1st[10];  /* ibegin1 as a string */
   char projbstr[10];  /* projback as a string */
   char percbstr[10];  /* percback as a string */
   char projfstr[10];  /* projfwrd as a string */
   char percfstr[10];  /* percfwrd as a string */
#endif

   begscrn("     PEBES info     ");
   wattrset(wn,COLOR_PAIR(6));
#if defined(EXPANDED_PEBES)
   frm = wn_frmopn(10);
#else
   frm = wn_frmopn(5);
#endif
   if (!frm) {
      wn_iemsg(catstr(202));
      done(1); }
   /* get date of birth */
   wn_gmdy(SET, frm, 0, wn, 3, 33, "Date of birth (mo/dy/year) > ",
      COLOR_PAIR(2), ' ', &(workerdata -> ibirth[0]),
      &(workerdata -> ibirth[1]), &(workerdata -> ibirth[2]), 1800,
      workerdata -> istart - 1, mdyst, "%date of birth%", catstr(120));
   /* check month of processing */
   sprintf(temp, "%d", workerdata -> istart);
   strncpy(mesg2+9,temp,4);
   /* get current month */
   if (workerdata -> monthnow == 0)
      workerdata -> monthnow = curmonth();
   sprintf(monthnst, "%2d", workerdata -> monthnow);
   wn_gint(SET, frm, 1, wn, 4, 5, mesg2, COLOR_PAIR(2), ' ',
      &(workerdata -> monthnow), 2, 1, 12, monthnst,
      "%processing month%", catstr(56));
   sprintf(iageplst, "%2d", workerdata -> iageplan);
   wn_gint(SET, frm, 2, wn, 5, 34,
      "Planned age of retirement > ", COLOR_PAIR(2), ' ',
      &(workerdata -> iageplan), 2, 0, 99, iageplst,
      "%retirement age%", catstr(104));
   sprintf(ibeginst, "%d", workerdata -> ibegin);
#if defined(EXPANDED_PEBES)
   if (workerdata -> projback) {
      sprintf(ibegin1st, "%d", workerdata -> ibegin1);
      wn_gyear(SET, frm, 3, wn, 6, 29,
         "First year of entered earnings > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin1), 4, 1937, workerdata -> istart - 1,
         ibegin1st, "%first year bef proj%", catstr(8));
      sprintf(projbstr, "%1d", workerdata -> projback);
      wn_gint(SET, frm, 4, wn, 7, 14,
         "Type of backward earnings projection (1 or 2) > ",
         COLOR_PAIR(2), ' ', &workerdata -> projback, 1, 1, 2, projbstr,
         "%backward proj type%", catstr(105));
      sprintf(percbstr, "%6.2f", workerdata -> percback);
      wn_gfloat(SET, frm, 5, wn, 8, 33, "Backward percentage factor > ",
         COLOR_PAIR(2), ' ', &workerdata -> percback, 6, 2, 0.0, 9.9,
         percbstr, "%backward percentage%", catstr(106));
      wn_gyear(SET, frm, 6, wn, 9, 18,
         "Year to which earnings are projected back > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin), 4, 1937, workerdata -> istart - 1,
         ibeginst, "%first year aft proj%", catstr(8));
      }
   else {
      wn_gyear(SET, frm, 3, wn, 6, 20,
         "First year for which there are earnings > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin), 4, 1937, 1936 + workerdata -> maxyears,
         ibeginst, "%first year of earnings%", catstr(8));
      wn_dtext(SET, frm, 4, wn, 7, 14, stringd(49,' '));
      wn_dtext(SET, frm, 5, wn, 8, 33, stringd(30,' '));
      wn_dtext(SET, frm, 6, wn, 9, 18, stringd(45,' '));
      }
   sprintf(projfstr, "%1d", workerdata -> projfwrd);
   wn_gint(SET, frm, 7, wn, 10, 15,
      "Type of forward earnings projection (1 or 2) > ",
      COLOR_PAIR(2), ' ', &workerdata -> projfwrd, 1, 1, 2, projfstr,
      "%forward proj type%", catstr(107));
   sprintf(percfstr, "%6.2f", workerdata -> percfwrd);
   wn_gfloat(SET, frm, 8, wn, 11, 34, "Forward percentage factor > ",
      COLOR_PAIR(2), ' ', &workerdata -> percfwrd, 6, 2, 0.0, 9.9,
      percfstr, "%forward percentage%", catstr(108));
#else
   wn_gyear(SET, frm, 3, wn, 6, 20,
      "First year for which there are earnings > ",COLOR_PAIR(2),' ',
      &(workerdata -> ibegin), 4, 1937, workerdata -> istart - 1,
      ibeginst, "%first year of earnings%", catstr(121));
#endif
  form2a:
   if ((rv = wn_frmget(frm)) == ESC_CODE) {
      wn_frmcls(frm);
      return(rv); }
   setpbdata(workerdata);
   if ((ierr = ibegchk(workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      goto form2a; }
   wn_frmcls(frm);
   return(rv);
}
/* Function to get non-PEBES information
 */
int worker2b(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   static char mdyst[12];  /* date of birth as a string */
   char ientst[9];  /* date of entitlement as a string */
   char ibeginst[10];  /* ibegin as a string */
   char iendst[10];  /* iend as a string */
   char ibegin1st[10];  /* ibegin1 as a string */
   char iend1st[10];  /* iend1 as a string */
   char answerdi[10];  /* Y or N as a string for valdi */
   char bendatest[10];  /* benefit date as a string */
   char projbstr[10];  /* projback as a string */
   char percbstr[10];  /* percback as a string */
   char projfstr[10];  /* projfwrd as a string */
   char percfstr[10];  /* percfwrd as a string */
   WIFORM frm;  /* form pointer */
   int rv;  /* return value */
   int ierr;  /* error indicator */

   begscrn("   Non-PEBES info   ");
   wattrset(wn,COLOR_PAIR(6));
   frm = wn_frmopn(13);
   if (!frm) {
      wn_iemsg(catstr(203));
      done(1); }
   /* get date of birth */
   wn_gmdy(SET, frm, 0, wn, 3, 33, "Date of birth (mo/dy/year) > ",
      COLOR_PAIR(2), ' ', &(workerdata -> ibirth[0]),
      &(workerdata -> ibirth[1]), &(workerdata -> ibirth[2]), 1800,
      1936 + workerdata -> maxyears, mdyst, "%date of birth%", catstr(55));
   wn_gmy(SET, frm, 1, wn, 4, 22, "Date of initial entitlement (mo/year) > ",
      COLOR_PAIR(2), ' ', workerdata -> ient, workerdata -> ient + 2,
      1940, 1936 + workerdata -> maxyears,
      ientst, "%entitlement%", catstr(103));
   if (workerdata -> recalc)
      wn_gmy(SET, frm, 2, wn, 5, 26, "Date of desired benefit (mo/year) > ",
         COLOR_PAIR(2), ' ', workerdata -> bendate,
         workerdata -> bendate + 2, 1940,
         1936 + workerdata -> maxyears, bendatest, "%benefit date%",
         catstr(119));
   else
      wn_dtext(SET, frm, 2, wn, 5, 26, stringd(37,' '));
   sprintf(ibeginst, "%d", workerdata -> ibegin);
   if (workerdata -> projback) {
      sprintf(ibegin1st, "%d", workerdata -> ibegin1);
      wn_gyear(SET, frm, 3, wn, 6, 29,
         "First year of entered earnings > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin1), 4, 1937, 1936 + workerdata -> maxyears,
         ibegin1st, "%first year bef proj%", catstr(8));
      sprintf(projbstr, "%1d", workerdata -> projback);
      wn_gint(SET, frm, 4, wn, 7, 14,
         "Type of backward earnings projection (1 or 2) > ",
         COLOR_PAIR(2), ' ', &workerdata -> projback, 1, 1, 2, projbstr,
         "%backward proj type%", catstr(105));
      sprintf(percbstr, "%6.2f", workerdata -> percback);
      wn_gfloat(SET, frm, 5, wn, 8, 33, "Backward percentage factor > ",
         COLOR_PAIR(2), ' ', &workerdata -> percback, 6, 2, 0.0, 9.9,
         percbstr, "%backward percentage%", catstr(106));
      wn_gyear(SET, frm, 6, wn, 9, 18,
         "Year to which earnings are projected back > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin), 4, 1937, 1936 + workerdata -> maxyears,
         ibeginst, "%first year aft proj%", catstr(8));
      }
   else {
      wn_gyear(SET, frm, 3, wn, 6, 20,
         "First year for which there are earnings > ", COLOR_PAIR(2), ' ',
         &(workerdata -> ibegin), 4, 1937, 1936 + workerdata -> maxyears,
         ibeginst, "%first year of earnings%", catstr(8));
      wn_dtext(SET, frm, 4, wn, 7, 14, stringd(49,' '));
      wn_dtext(SET, frm, 5, wn, 8, 33, stringd(30,' '));
      wn_dtext(SET, frm, 6, wn, 9, 20, stringd(43,' '));
      }
   sprintf(iendst,"%d",workerdata -> iend);
   if (workerdata -> projfwrd) {
      sprintf(iend1st, "%d", workerdata -> iend1);
      wn_gyear(SET, frm, 7, wn, 10, 30,
         "Last year of entered earnings > ", COLOR_PAIR(2), ' ',
         &(workerdata -> iend1), 4, 1937, 1936 + workerdata -> maxyears,
         iend1st, "%last year bef proj%", catstr(9));
      sprintf(projfstr, "%1d", workerdata -> projfwrd);
      wn_gint(SET, frm, 8, wn, 11, 15,
         "Type of forward earnings projection (1 or 2) > ",
         COLOR_PAIR(2), ' ', &workerdata -> projfwrd, 1, 1, 2, projfstr,
         "%forward proj type%", catstr(107));
      sprintf(percfstr, "%6.2f", workerdata -> percfwrd);
      wn_gfloat(SET, frm, 9, wn, 12, 34, "Forward percentage factor > ",
         COLOR_PAIR(2), ' ', &workerdata -> percfwrd, 6, 2, 0.0, 9.9,
         percfstr, "%forward percentage%", catstr(108));
      wn_gyear(SET, frm, 10, wn, 13, 15,
         "Year to which earnings are projected forward > ", COLOR_PAIR(2), ' ',
         &(workerdata -> iend), 4, 1937, 1936 + workerdata -> maxyears,
         iendst, "%last year aft proj%", catstr(9));
      }
   else {
      wn_gyear(SET, frm, 7, wn, 10, 10,
         "Last year for which there are or will be earnings > ",
         COLOR_PAIR(2), ' ', &(workerdata -> iend), 4, 1937,
         1936 + workerdata -> maxyears, iendst,
         "%last year of earnings%", catstr(9));
      wn_dtext(SET, frm, 8, wn, 11, 15, stringd(48,' '));
      wn_dtext(SET, frm, 9, wn, 12, 34, stringd(29,' '));
      wn_dtext(SET, frm, 10, wn, 13, 21, stringd(42,' '));
      }
   if (workerdata -> joasdi == DISABILITY)
      {  /* must be disabled if disability case */
      workerdata -> valdi = 1;
      wn_dtext(SET, frm, 11, wn, 14, 26, stringd(37,' '));
      }
   else
      {  /* get disability code */
      strcpy(answerdi, (workerdata -> valdi == 0) ? "N" : "Y");
      wn_gbool(SET, frm, 11, wn, 14, 26,
         "Was the worker disabled? (Y or N) > ", COLOR_PAIR(2),' ',
         &workerdata -> valdi, answerdi, "%prior disability%", catstr(258));
      }
  form2b:
   if ((rv = wn_frmget(frm)) == ESC_CODE) {
      wn_frmcls(frm);
      return(rv); }
   if ((ierr = ibegchk(workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      goto form2b; }
   /* check bounds of last year */
   if ((ierr = iendcheck(workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      goto form2b; }
   if (workerdata -> recalc) {
      if ((ierr = bendt2chk(workerdata)) > 0) {
         wn_iemsg(catstr(ierr));
         goto form2b; }
      }
   else
      setbendt2(workerdata);
   wn_frmcls(frm);
   return(rv);
}
/* Function to get name and ssn of wage earner
 */
int namessn(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   WIFORM frm;  /* form pointer */
   int rv;  /* return value */

   begscrn("  Name and address  ");
   frm = wn_frmopn(7);
   if (!frm) {
      wn_iemsg(catstr(204));
      done(1); }
   wn_dtext(SET,frm,0,wn,5,3,
      "Enter wage earner's name, address, and Social Security number:");
   wn_gtext(SET,frm,1,wn,6,3,"    Wage earner's name > ",
      COLOR_PAIR(2), ' ', 33, workerdata -> nhname, "%name and address%",
      NSTR);
   wn_gtext(SET,frm,2,wn,7,3,"        Address line 1 > ",
      COLOR_PAIR(2), ' ', 33, workerdata -> nhaddr[0], "%name and address%",
      NSTR);
   wn_gtext(SET,frm,3,wn,8,3,"        Address line 2 > ",
      COLOR_PAIR(2), ' ', 33, workerdata -> nhaddr[1], "%name and address%",
      NSTR);
   wn_gtext(SET,frm,4,wn,9,3,"        Address line 3 > ",
      COLOR_PAIR(2), ' ', 33, workerdata -> nhaddr[2], "%name and address%",
      NSTR);
   wn_gtext(SET,frm,5,wn,10,3,"Social Security number > ",
      COLOR_PAIR(2), ' ', 11, workerdata -> ssn, "%name and address%", NSTR);
   wattrset(wn,COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_sdelspc(workerdata -> nhname, 3);
   wn_sdelspc(workerdata -> nhaddr[0], 3);
   wn_sdelspc(workerdata -> nhaddr[1], 3);
   wn_sdelspc(workerdata -> nhaddr[2], 3);
   wn_sdelspc(workerdata -> ssn, 3);
   wn_frmcls(frm);
   return(rv);
}
/* Function to get summary qc's only
 */
int getqc1(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   static char qcstr[10];  /* qctottd as a string */
   static char qc14str[10];  /* qctot51td as a string */
   WIFORM frm;  /* form pointer */
   char *mesg6 = "Number of quarters of coverage, 1937-1977 inclusive > ";
      /* prompt for qc's 1937 through 1977 */
   char *mesg7 = "Number of quarters of coverage, 1951-1977 inclusive > ";
      /* prompt for qc's 1951 through 1977 */
   int rv;  /* return value */
   int ierr;  /* error indicator */

   /* no historical qc's if earnings started after 1977 */
   if (workerdata -> ibegin > 1977) {
      setqctd(workerdata, 0);
      setqc51td(workerdata, 0);
      return(0);
      }
   else
      {
      begscrn(qctitle);
      wattrset(wn,COLOR_PAIR(6));
      sprintf(qcstr, "%3d", workerdata -> qctottd);
      frm = wn_frmopn(3);
      wn_gint(SET,frm,0,wn,3,8,mesg6,COLOR_PAIR(2),' ',
         &(workerdata -> qctottd), 3, 0, 999, qcstr, "%quarters 1937-1977%",
         catstr(33));
      if (!frm) {
         wn_iemsg(catstr(205));
         done(1); }
      if (workerdata -> ibegin < 1951 && workerdata -> iend > 1950)
         {
         /* need qc's after 1950 to see if eligible for old-start */
         sprintf(qc14str, "%3d", workerdata -> qctot51td);
         wn_gint(SET, frm, 1, wn, 4, 8, mesg7, COLOR_PAIR(2), ' ',
            &(workerdata -> qctot51td), 3, 0, 999, qc14str,
            "%quarters 1951-1977%", catstr(40));
         }
      else
         wn_dtext(SET,frm,1,wn,4,8,stringd(58,' '));
  form3:
      rv = wn_frmget(frm);
      if (workerdata -> ibegin > 1950)
         workerdata -> qctot51td = workerdata -> qctottd;
      if (rv == ESC_CODE) {
         wn_frmcls(frm);
         return(rv); }
      if ((ierr = qccheck(workerdata)) > 0) {
         wn_iemsg(catstr(ierr));
         goto form3; }
      return(rv);
      }
}
/* Function to get year-by-year quarters of coverage
 */
int getqc2(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][8];  /* prompt for each year of earnings */
   int rv;  /* return value */

   if (workerdata -> ibegin > lastqcyr(workerdata))
      rv = TRUE;
   else {
   begscrn(qctitle);
   frm = wn_frmopn(61);
   if (!frm) {
      wn_iemsg(catstr(206));
      done(1); }
   for (i = 0; (i < 60 && i <= lastqcyr(workerdata) - workerdata -> ibegin);
      i++)
      {
      sprintf(answer[i], "%1d",
         workerdata -> qc[workerdata -> ibegin + i - 1937]);
      sprintf(prmpt[i], "%4d   ", workerdata -> ibegin + i);
      i2 = i / 20;
      i1 = i - i % 20;
      wn_gint(SET,frm,i,wn,i+FF2-i1,8+FF2+i2*(COLS/3),prmpt[i],
         COLOR_PAIR(2), '_', workerdata -> qc + workerdata -> ibegin - 1937 + i,
         1, 0, 4, answer[i], "%annual quarters%", catstr(41));
      }
   WREFRESH(wn);
   wattrset(wn,COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
   }
   setqctd(workerdata, qcsum(workerdata, 1937, lastqcyr(workerdata)));
   setqc51td(workerdata, qcsum(workerdata, 1951, lastqcyr(workerdata)));
   return(rv);
}
