/*
 * @(#)wrkrdata.C	1.53 7/20/94
 * Functions to initialize a workerdata structure and check data
 */

#ifndef lint
static char *workerdataID = " @(#)wrkrdata.C	1.53 7/20/94 ";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "compdate.h"
#include "wrkrdata.h"
#include "getdate.h"

static int maxyear;  /* maximum year allowed */
static int istart;  /* starting year of assumptions */
static double maxearng;  /* maximum earnings allowed */

/* Function to initialize a workerdata structure
 */
int initdata(
WORKERDATA **workerdatap,  /* pointer to new workerdata structure */
int maxyears,  /* maximum number of years projected, starting with 1937 */
double maxearn,  /* maximum earnings allowed */
int maxchr)  /* maximum string length allowed */
{
   /* allocate memory for structure */
   if ((*workerdatap = (WORKERDATA *)malloc(sizeof(WORKERDATA))) ==
      (WORKERDATA *)0)
      return(284);
   /* allocate memory for quarters of coverage */
   if (((*workerdatap) -> qc = (int *)calloc((unsigned)maxyears,
      sizeof(int))) == (int *)0)
      return(284);
   /* allocate memory for type of earnings */
   if (((*workerdatap) -> earntype = (enum earn_type *)calloc((unsigned)maxyears,
      sizeof(int))) == (void *)0)
      return(284);
   /* allocate memory for PEBES earnings array */
   if (((*workerdatap) -> earnpebs = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(284);
   /* allocate memory for HI earnings array */
   if (((*workerdatap) -> earnhi = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(284);
   if (((*workerdatap) -> titlaw = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0)
      return(284);
   if (((*workerdatap) -> titlbi = (char *)calloc((unsigned)maxchr,
      sizeof(char))) == (char *)0)
      return(284);
   /* allocate memory for benefit increases */
   if (((*workerdatap) -> cpiinc = (float *)calloc((unsigned)(maxyears-14),
      sizeof(float))) == (float *)0)
      return(284);
   /* allocate memory for wage base */
   if (((*workerdatap) -> base = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(284);
   /* allocate memory for old-law wage base */
   if (((*workerdatap) -> base77 = (double *)calloc((unsigned)maxyears,
      sizeof(double))) == (double *)0)
      return(284);
   /* allocate memory for wage increases */
   if (((*workerdatap) -> fqinc = (float *)calloc((unsigned)maxyears,
      sizeof(float))) == (float *)0)
      return(284);
   if (((*workerdatap) -> taxtype = (int *)calloc((unsigned)maxyears,
      sizeof(int))) == (int *)0)
      return(284);
   (*workerdatap) -> bendate[1] = 1;
   (*workerdatap) -> ient[1] = 1;
   (*workerdatap) -> ideath[1] = 1;
   (*workerdatap) -> priorent[1] = 1;
   (*workerdatap) -> waitper[1] = 1;
   (*workerdatap) -> maxyears = maxyears;
   maxyear = 1936 + maxyears;
   (*workerdatap) -> maxearn = maxearn;
   maxearng = maxearn;
   (*workerdatap) -> maxchr = maxchr;
   zerojalt(*workerdatap);
   return(0);
}
/* Function to check for first year of earnings within bounds
 */
int ibegchk(
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i1;  /* first possible year of earnings */

   if (workerdata -> projback == 0)
      workerdata -> ibegin1 = workerdata -> ibegin;
   i1 = (workerdata -> ibirth[2] > 1936 && workerdata -> ibirth[2] < 1951) ?
      1951 : workerdata -> ibirth[2];
   if (workerdata -> ibegin < i1)
      return(122);
   if (workerdata -> ibegin1 < workerdata -> ibegin)
      return(101);
   return(0);
}
/* Function to check for last year of earnings within bounds
 */
int iendcheck(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> projfwrd == 0)
      workerdata -> iend1 = workerdata -> iend;
   if (workerdata -> iend1 < workerdata -> ibegin1)
      return(9);
   if (workerdata -> iend1 > workerdata -> iend)
      return(102);
   if (workerdata -> iend > workerdata -> ibegin + MAXYRS - 1)
      return(26);
   return(0);
}
/* Function to set the value of ioasdi
 */
void setioasdi(
WORKERDATA *workerdata,  /* workerdata structure */
enum ben_type ioasdit)  /* new value of ioasdi */
{
   workerdata -> ioasdi = ioasdit;
}
/* Function to check for correct numbers of QC's
 */
int qccheck(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> qctot51td > workerdata -> qctottd)
      return(109);
   return(0);
}
/* Function to set benefit date for initial entitlement case
 */
void setbendt2(
WORKERDATA *workerdata)  /* workerdata structure */
{
   workerdata -> bendate[0] = workerdata -> ient[0];
   workerdata -> bendate[2] = workerdata -> ient[2];
}
/* Function to check for PEBS case too old in initial year
 */
int agecheck(
WORKERDATA *workerdata,  /* workerdata structure */
int nradatet[3])  /* normal retirement age date */
{
   int date1[3];  /* current date */

   date1[0] = workerdata -> monthnow;
   date1[1] = 0;
   date1[2] = workerdata -> istart;
   if (compmdy(nradatet,date1) <= 0)
      return(152);
   return(0);
}
/* Function to sum quarters of coverage over a period of years
 */
int qcsum(
WORKERDATA *workerdata,  /* workerdata structure */
int firstyr,  /* first year to sum */
int lastyr)  /* last year to sum */
{
   int i1;  /* loop counter */
   int rv = 0;  /* sum of qc's */

   for (i1 = firstyr-1937; i1 < lastyr-1936; i1++)
      rv += workerdata -> qc[i1];
   return(rv);
}
/* Function to check that date of death is before entitlement
 */
int dthcheck(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> ioasdi == SURVIVOR)
      {
      if (compmdy(workerdata -> ideath, workerdata -> ient) > 0)
         /* death after entitlement */
         return(112);
      if (compmdy(workerdata -> ideath, workerdata -> ibirth) < 0)
         /* death before birth */
         return(113);
      }
   return(0);
}
/* Function to set type of survivor
 */
int setjsurv(
WORKERDATA *workerdata,  /* workerdata structure */
int jsurvt)  /* type of survivor to use */
{
   int ierr;  /* error indicator */

   if (workerdata -> ioasdi == SURVIVOR) {
      if ((ierr = jsurvchk(jsurvt)) > 0)
         return(ierr);
      workerdata -> jsurv = (enum surv_type)jsurvt;
      }
   else
      workerdata -> jsurv = NO_SURV;
   return(0);
}
/* Function to check for type of survivor in bounds
 */
int jsurvchk(
int jsurvt)  /* type of survivor to use */
{
   if (jsurvt != (int)YOUNG_SURV && jsurvt != (int)DISAB_WID &&
      jsurvt != (int)AGED_WID)
      return(13);
   return(0);
}
/* Function to set first month of waiting period
 */
int setwaitpd(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to check */
{
   int i;  /* loop counter */
   int ierr;  /* error indicator */

   if (workerdata -> ioasdi == DISABILITY) {
      if ((ierr = waitpdchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i += 2)
         workerdata -> waitper[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> waitper);
   return(0);
}
/* Function to check first month of waiting period
 */
int waitpdchk(
int datetemp[3])  /* date to check */
{
   if (mocheck(datetemp[0]))
      return(45);
   if (datetemp[2] < 1940)
      return(46);
   if (datetemp[2] > maxyear)
      return(47);
   return(0);
}
/* Function to check first month of waiting period
 */
int waitchk(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (compmdy(workerdata -> waitper, workerdata -> ionset) < 0)
      /* waiting period before onset */
      return(160);
   if (compmdy(workerdata -> waitper, workerdata -> ient) > 0)
      /* waiting period after entitlement */
      return(161);
   return(0);
}
/* Function to check disabled widow's date of disability
 */
int widcheck(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (compmdy(workerdata -> jonset, workerdata -> jbirth) < 0)
      /* disability before birth */
      return(158);
   if (compmdy(workerdata -> jonset, workerdata -> ient) > 0)
      /* disability after entitlement */
      return(138);
   return(0);
}
/* Function to set date of disability
 */
int setionset(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to check */
{
   int i;  /* loop counter */
   int ierr;  /* error indicator */

   if (workerdata -> valdi == 1) {
      if ((ierr = ionsetchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i++)
         workerdata -> ionset[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> ionset);
   return(0);
}
/* Function to check date of disability
 */
int ionsetchk(
int datetemp[3])  /* date to check */
{
   int ierr;  /* error indicator */

   if ((ierr = modychk(datetemp)) > 0)
      return(13 + ierr);
   if (datetemp[2] < 1940)
      /* disability before 1940 */
      return(32);
   if (datetemp[2] > maxyear)
      /* disability after last possible year */
      return(16);
   return(0);
}
/* Function to check date of disability
 */
int discheck(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> valdi == 1) {
      if (workerdata -> ionset[2] < workerdata -> ibirth[2])
         /* disability before birth */
         return(15);
      if (compmdy(workerdata -> ionset, workerdata -> ient) > 0)
         /* disability after entitlement */
         return(127);
      if (workerdata -> ioasdi == SURVIVOR &&
         compmdy(workerdata -> ionset, workerdata -> ideath) > 0)
         /* disability after death */
         return(157);
      }
   return(0);
}
/* Function to set date of prior entitlement to disability
 */
int setprrent(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to check */
{
   int i;  /* loop counter */
   int ierr;  /* error indicator */

   if (workerdata -> valdi == 1 && workerdata -> ioasdi == OLD_AGE) {
      if ((ierr = prrentchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i += 2)
         workerdata -> priorent[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> priorent);
   return(0);
}
/* Function to check date of prior entitlement to disability
 */
int prrentchk(
int datetemp[3])  /* date to check */
{
   if (mocheck(datetemp[0]))
      return(42);
   if (datetemp[2] < 1940)
      return(43);
   if (datetemp[2] > maxyear)
      return(44);
   return(0);
}
/* Function to check date of prior entitlement to disability
 */
int priorchk(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> valdi == 1 && workerdata -> ioasdi == OLD_AGE) {
      if (compmdy(workerdata -> priorent, workerdata -> ient) >= 0)
         return(164);
      if (compmdy(workerdata -> priorent, workerdata -> ionset) < 0)
         /* prior entitlement to disability before disability onset */
         return(163);
      }
   return(0);
}
/* Function to set day before birth
 */
void setbirth(
int birth1[3],  /* day of birth */
int birth2[3])  /* day before birth */
{
   birth2[0] = birth1[0];
   birth2[1] = birth1[1] - 1;
   birth2[2] = birth1[2];
   /* take care of birth on 1st of month */
   if (birth2[1] < 1) {
      birth2[1] = 30;
      birth2[0]--; }
   /* take care of birth on January 1 */
   if (birth2[0] < 1) {
      birth2[0] = 12;
      birth2[2]--; }
}
/* Function to zero out catchup benefit increases
 */
void zerocch(
double cachup[10][8])  /* catch-up benefit increases */
{
   int i1,i2;  /* loop counters */

   for (i2=0; i2<10; i2++) {
      for (i1=0; i1<8; i1++) {
         cachup[i2][i1] = 0.;
         } /* end for i1 */
      } /* end for i2 */
}
/* Function to set date of benefit to specified date
 */
int setbendt1(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> recalc) {
      if ((ierr = bendt1chk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i++)
         workerdata -> bendate[i] = datetemp[i];
      }
   else
      setbendt2(workerdata);
   return(0);
}
/* Function to check that date of benefit is at or after entitlement
 */
int bendt1chk(
int datetemp[3])  /* date to check */
{
   if (mocheck(datetemp[0]))
      return(117);
   if (datetemp[2] < 1940)
      return(118);
   if (datetemp[2] > maxyear)
      return(119);
   return(0);
}
/* Function to check that date of benefit is at or after entitlement
 */
int bendt2chk(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (compmdy(workerdata -> bendate, workerdata -> ient) < 0)
      /* benefit date before entitlement */
      return(114);
   return(0);
}
/* Function to check for month and day in bounds
 */
int modychk(
int *mody)  /* month and day to check */
{
   if (mocheck(mody[0]))
      return(1);
   if (mody[1] < 1 || mody[1] > 31)
      return(2);
   return(0);
}
/* Function to check for month in bounds
 */
int mocheck(
int month)  /* month to check */
{
   if (month < 1 || month > 12)
      return(1);
   return(0);
}
/* Function to see if quarters of coverage by year are needed
 */
int qcbyyear(
WORKERDATA *workerdata)  /* workerdata structure */
{
   return(workerdata -> totalize || workerdata -> joasdi == PEBS_CALC);
}
/* Function to zero out earnings and quarters of coverage before first
   year and after last year
 */
void zeroearn(
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i1;  /* loop counter */

   for (i1 = 0; i1 < workerdata -> ibegin - 1937; i1++) {
      workerdata -> earnpebs[i1] = 0.;
      workerdata -> earnhi[i1] = 0.;
      workerdata -> qc[i1] = 0;
      }
   for (i1 = workerdata -> iend1 - 1936; i1 < workerdata -> maxyears; i1++) {
      workerdata -> earnpebs[i1] = 0.;
      workerdata -> earnhi[i1] = 0.;
      workerdata -> qc[i1] = 0;
      }
}
/* Function to return output label for sex of worker
 */
char *fmale(
WORKERDATA *workerdata)  /* workerdata structure */
{
   return(workerdata -> isex == 1 ? "Male" : "Female" );
}
/* Function to set date of entitlement
 */
int setient(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> joasdi != PEBS_CALC)
      if ((ierr = ientchk(datetemp)) > 0)
         return(ierr);
   for (i = 0; i < 3; i++)
      workerdata -> ient[i] = datetemp[i];
   return(0);
}
/* Function to check that date of entitlement is within bounds
 */
int ientchk(
int datetemp[3])  /* date to check */
{
   if (mocheck(datetemp[0]))
      return(2);
   if (datetemp[2] < 1940)
      return(3);
   if (datetemp[2] > maxyear)
      return(103);
   return(0);
}
/* Function to check for valid assumption for PEBES
 */
int pebsasmchk(
WORKERDATA *workerdata)  /* workerdata structure */
{
#if defined(EXPANDED_PEBES)
   if (workerdata -> ialtbi < ALTERN_I ||
      workerdata -> ialtbi > MAXASM ||
      workerdata -> ialtaw < ALTERN_I ||
      workerdata -> ialtaw > MAXASM)
      return(12);
#else
   if ((workerdata -> ialtbi != FLAT &&
      workerdata -> ialtbi != PEBS_ASSUM) ||
      (workerdata -> ialtaw != FLAT &&
      workerdata -> ialtaw != PEBS_ASSUM))
      return(12);
#endif
   return(0);
}
/* Function to return last year of annual QCs
 */
int lastqcyr(
WORKERDATA *workerdata)  /* workerdata structure */
{
   return(workerdata -> iend < 1977 ? workerdata -> iend : 1977);
}
/* Function to set some PEBES data
 */
void setpbdata(
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i;  /* loop counter */

   setioasdi(workerdata, OLD_AGE);
   workerdata -> iend1 = workerdata -> iend = 1 + workerdata -> istart;
   workerdata -> valdi = 0;
   zeromdy(workerdata -> ideath);
   workerdata -> jsurv = NO_SURV;
   zeromdy(workerdata -> ionset);
   /* only allow entered earnings historically, unless doing an expanded
    * PEBES */
#if !defined(EXPANDED_PEBES)
   workerdata -> ibegin1 = workerdata -> ibegin;
   workerdata -> projback = 0;
   workerdata -> percback = 0.0;
   workerdata -> projfwrd = 1;
   workerdata -> percfwrd = 0.0;
   for (i = 0; i < workerdata -> iend1 - 1936; i++)
      workerdata -> earntype[i] = ENTERED;
#else
   /* must have a forward projection even in expanded PEBES */
   if (workerdata -> projfwrd == 0)
      workerdata -> projfwrd = 1;
#endif
}
/* Function to check quarters of coverage to 1977
 */
void qctdchk2(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> ibegin > 1950)
      workerdata -> qctot51td = workerdata -> qctottd;
   if (workerdata -> iend < 1951)
      workerdata -> qctot51td = 0;
   if (workerdata -> ibegin > 1977)
      workerdata -> qctottd = workerdata -> qctot51td = 0;
}
/* Function to initialize previous assumptions indicators
 */
void zerojalt(
WORKERDATA *workerdata)  /* workerdata structure */
{
   workerdata -> jaltbi = 0;
   workerdata -> jaltaw = 0;
   workerdata -> jbasch = 0;
}
/* Function to set month of PEBES processing
 */
int setmonthn(
WORKERDATA *workerdata,  /* workerdata structure */
int monthnowt)  /* value to use */
{
   int ierr;  /* error indicator */

   if (workerdata -> joasdi == PEBS_CALC)
      if ((ierr = monthnchk(monthnowt)) > 0)
         return(ierr);
   workerdata -> monthnow = monthnowt;
   return(0);
}
/* Function to check for correct month of PEBES processing
 */
int monthnchk(
int monthnowt)  /* value to check */
{
   if (mocheck(monthnowt))
      return(56);
   return(0);
}
/* Function to set summary quarters of coverage, 1937 to 1977
 */
int setqctd(
WORKERDATA *workerdata,  /* workerdata structure */
int qct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = qctdchk(qct)) > 0)
      return(ierr);
   workerdata -> qctottd = qct;
   return(0);
}
/* Function to check summary quarters of coverage, 1937 to 1977
 */
int qctdchk(
int qct)  /* value to check */
{
   if ( qct < 0 || qct > 164)
      return(33);
   return(0);
}
/* Function to set summary quarters of coverage, 1951 to 1977
 */
int setqc51td(
WORKERDATA *workerdata,  /* workerdata structure */
int qct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = qc51tdchk(qct)) > 0)
      return(ierr);
   workerdata -> qctot51td = qct;
   return(0);
}
/* Function to check summary quarters of coverage, 1951 to 1977
 */
int qc51tdchk(
int qct)  /* value to check */
{
   if ( qct < 0 || qct > 108)
      return(40);
   return(0);
}
/* Function to set annual quarters of coverage for one year
 */
int setqc2(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year to set */
int qct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = qc2check(qct)) > 0)
      return(ierr);
   workerdata -> qc[year - 1937] = qct;
   return(0);
}
/* Function to check annual quarters of coverage for one year
 */
int qc2check(
int qct)  /* value to check */
{
   if (qct > 4 || qct < 0)
      return(41);
   return(0);
}
/* Function to set type of benefit
 */
int setjoasdi(
WORKERDATA *workerdata,  /* workerdata structure */
int joasdit)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = joasdichk(joasdit)) > 0)
      return(ierr);
   workerdata -> joasdi = (enum ben_type)joasdit;
   /* initialize ioasdi with old age if this is PEBES calculation */
   setioasdi(workerdata, (workerdata -> joasdi == PEBS_CALC) ?
      OLD_AGE : workerdata -> joasdi);
   return(0);
}
/* Function to check type of benefit
 */
int joasdichk(
int joasdit)  /* value to check */
{
   if (joasdit < (int)OLD_AGE || joasdit > (int)PEBS_CALC)
      return(6);
   return(0);
}
/* Function to set sex
 */
int setisex(
WORKERDATA *workerdata,  /* workerdata structure */
int isext)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = isexchk(isext)) > 0)
      return(ierr);
   workerdata -> isex = isext;
   return(0);
}
/* Function to check sex
 */
int isexchk(
int isext)  /* value to check */
{
   if (isext < 1 || isext > 2)
      return(1);
   return(0);
}
/* Function to set ialtaw
 */
int setialtaw(
WORKERDATA *workerdata,  /* workerdata structure */
int ialtawt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = ialtawck1(ialtawt)) > 0)
      return(ierr);
   workerdata -> ialtaw = (enum assum_type)ialtawt;
   return(0);
}
/* Function to check ialtaw in general case
 */
int ialtawck1(
int ialtawt)  /* value to check */
{
   if (ialtawt < (int)ALTERN_I || ialtawt > MAXASM)
      return(20);
   return(0);
}
/* Function to check ialtaw in PEBES case
 */
int ialtawck2(
int ialtawt)  /* value to check */
{
   if (ialtawt != (int)FLAT && ialtawt != (int)PEBS_ASSUM)
      return(116);
   return(0);
}
/* Function to set ialtbi
 */
int setialtbi(
WORKERDATA *workerdata,  /* workerdata structure */
int ialtbit)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = ialtbick1(ialtbit)) > 0)
      return(ierr);
   workerdata -> ialtbi = (enum assum_type)ialtbit;
   return(0);
}
/* Function to check ialtbi in general case
 */
int ialtbick1(
int ialtbit)  /* value to check */
{
   if (ialtbit < (int)ALTERN_I || ialtbit > MAXASM)
      return(19);
   return(0);
}
/* Function to check ialtbi in PEBES case
 */
int ialtbick2(
int ialtbit)  /* value to check */
{
   if (ialtbit != FLAT && ialtbit != PEBS_ASSUM)
      return(115);
   return(0);
}
/* Function to set recalc
 */
int setrecalc(
WORKERDATA *workerdata,  /* workerdata structure */
int recalct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = recalcchk(recalct)) > 0)
      return(ierr);
   workerdata -> recalc = recalct;
   return(0);
}
/* Function to check recalc
 */
int recalcchk(
int recalct)  /* value to check */
{
   if (recalct < 0 || recalct > 1)
      return(58);
   return(0);
}
/* Function to set totalize
 */
int settotali(
WORKERDATA *workerdata,  /* workerdata structure */
int totalit)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = totalichk(totalit)) > 0)
      return(ierr);
   workerdata -> totalize = totalit;
   return(0);
}
/* Function to check totalize
 */
int totalichk(
int totalit)  /* value to check */
{
   if (totalit < 0 || totalit > 1)
      return(57);
   return(0);
}
/* Function to set mqge
 */
int setmqge(
WORKERDATA *workerdata,  /* workerdata structure */
int mqget)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = mqgechk(mqget)) > 0)
      return(ierr);
   workerdata -> mqge = mqget;
   return(0);
}
/* Function to check mqge
 */
int mqgechk(
int mqget)  /* value to check */
{
   if (mqget < 0 || mqget > 1)
      return(59);
   return(0);
}
/* Function to set iageplan
 */
int setiagepl(
WORKERDATA *workerdata,  /* workerdata structure */
int iageplant)  /* value to use */
{
   int ierr;  /* error indicator */

   if (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = iageplchk(iageplant)) > 0)
         return(ierr);
      workerdata -> iageplan = iageplant;
      }
   else
      workerdata -> iageplan = 0;
   return(0);
}
/* Function to check iageplan
 */
int iageplchk(
int iageplant)  /* value to check */
{
   if (iageplant < 0 || iageplant > 99)
      return(104);
   return(0);
}
/* Function to set date of birth
 */
int setibirth(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = ibirt1chk(datetemp)) > 0)
         return(ierr);
      }
   else {
      if ((ierr = ibirt2chk(datetemp)) > 0)
         return(ierr);
      }
   for (i = 0; i < 3; i++)
      workerdata -> ibirth[i] = datetemp[i];
   return(0);
}
/* Function to check date of birth in a PEBES case
 */
int ibirt1chk(
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */

   if ((ierr = modychk(datetemp)) > 0)
      return(3 + ierr);
   if (datetemp[2] < 1800)
      return(55);
   if (datetemp[2] > istart - 1)
      return(120);
   return(0);
}
/* Function to check date of birth in a non-PEBES case
 */
int ibirt2chk(
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */

   if ((ierr = modychk(datetemp)) > 0)
      return(3 + ierr);
   if (datetemp[2] < 1800 || datetemp[2] > maxyear)
      return(55);
   return(0);
}
/* Function to set projback
 */
int setprojbk(
WORKERDATA *workerdata,  /* workerdata structure */
int projbackt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = projbkchk1(projbackt)) > 0)
      return(ierr);
   workerdata -> projback = projbackt;
   return(0);
}
/* Function to check projback in general case
 */
int projbkchk1(
int projbackt)  /* value to check */
{
   if (projbackt < 0 || projbackt > 2)
      return(25);
   return(0);
}
/* Function to check projback in backward projection case
 */
int projbkchk2(
int projbackt)  /* value to check */
{
   if (projbackt < 1 || projbackt > 2)
      return(105);
   return(0);
}
/* Function to set percback
 */
int setpercbk(
WORKERDATA *workerdata,  /* workerdata structure */
float percbackt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = percbkchk(percbackt)) > 0)
      return(ierr);
   workerdata -> percback = percbackt;
   return(0);
}
/* Function to check percback
 */
int percbkchk(
float percbackt)  /* value to check */
{
   if (percbackt < 0.0 || percbackt > 9.99)
      return(106);
   return(0);
}
/* Function to set ibegin
 */
int setibegin(
WORKERDATA *workerdata,  /* workerdata structure */
int ibegint)  /* value to use */
{
   int ierr;  /* error indicator */

   if  (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = ibegn1chk(ibegint)) > 0)
         return(ierr);
      }
   else {
      if ((ierr = ibegn2chk(ibegint)) > 0)
         return(ierr);
      }
   workerdata -> ibegin = ibegint;
   return(0);
}
/* Function to check ibegin in a PEBES case
 */
int ibegn1chk(
int ibegint)  /* value to check */
{
   if (ibegint < 1937)
      return(8);
   if (ibegint > istart - 1)
      return(121);
   return(0);
}
/* Function to check ibegin in a non-PEBES case
 */
int ibegn2chk(
int ibegint)  /* value to check */
{
   if (ibegint < 1937 || ibegint > maxyear)
      return(8);
   return(0);
}
/* Function to set ibegin1
 */
int setibegn1(
WORKERDATA *workerdata,  /* workerdata structure */
int ibegint)  /* value to use */
{
   int ierr;  /* error indicator */

   if  (workerdata -> joasdi == PEBS_CALC) {
      if ((ierr = ibegn1chk(ibegint)) > 0)
         return(ierr);
      }
   else {
      if ((ierr = ibegn2chk(ibegint)) > 0)
         return(ierr);
      }
   workerdata -> ibegin1 = ibegint;
   return(0);
}
/* Function to set projfwrd
 */
int setprojfd(
WORKERDATA *workerdata,  /* workerdata structure */
int projfwrdt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = projfdchk1(projfwrdt)) > 0)
      return(ierr);
   workerdata -> projfwrd = projfwrdt;
   return(0);
}
/* Function to check projfwrd in general case
 */
int projfdchk1(
int projfwrdt)  /* value to check */
{
   if (projfwrdt < 0 || projfwrdt > 2)
      return(27);
   return(0);
}
/* Function to check projfwrd in forward projection case
 */
int projfdchk2(
int projfwrdt)  /* value to check */
{
   if (projfwrdt < 1 || projfwrdt > 2)
      return(107);
   return(0);
}
/* Function to set percfwrd
 */
int setpercfd(
WORKERDATA *workerdata,  /* workerdata structure */
float percfwrdt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = percfdchk(percfwrdt)) > 0)
      return(ierr);
   workerdata -> percfwrd = percfwrdt;
   return(0);
}
/* Function to check percfwrd
 */
int percfdchk(
float percfwrdt)  /* value to check */
{
   if (percfwrdt < 0.0 || percfwrdt > 9.99)
      return(108);
   return(0);
}
/* Function to set iend
 */
int setiend(
WORKERDATA *workerdata,  /* workerdata structure */
int iendt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = iendchk(iendt)) > 0)
      return(ierr);
   workerdata -> iend = iendt;
   return(0);
}
/* Function to check iend
 */
int iendchk(
int iendt)  /* value to check */
{
   if (iendt < 1937 || iendt > maxyear)
      return(9);
   return(0);
}
/* Function to set iend1
 */
int setiend1(
WORKERDATA *workerdata,  /* workerdata structure */
int iendt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = iendchk(iendt)) > 0)
      return(ierr);
   workerdata -> iend1 = iendt;
   return(0);
}
/* Function to set istart
 */
int setistart(
WORKERDATA *workerdata,  /* workerdata structure */
int istartt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = istartchk(istartt)) > 0)
      return(ierr);
   workerdata -> istart = istartt;
   istart = istartt;
   return(0);
}
/* Function to check istart
 */
int istartchk(
int istartt)  /* value to check */
{
   if (istartt < 1979 || istartt > maxyear)
      return(9);
   return(0);
}
/* Function to set valdi
 */
int setvaldi(
WORKERDATA *workerdata,  /* workerdata structure */
int valdit)  /* value to use */
{
   int ierr;  /* error indicator */

   if (workerdata -> joasdi == PEBS_CALC && workerdata -> ioasdi != DISABILITY)
      workerdata -> valdi = 0;
   else {
      if ((ierr = valdi1chk(valdit)) > 0)
         return(ierr);
      workerdata -> valdi = valdit;
      }
   return(0);
}
/* Function to check valdi in general case
 */
int valdi1chk(
int valdit)  /* value to check */
{
   if (valdit < 0 || valdit > 1)
      return(23);
   return(0);
}
/* Function to check valdi in disability case
 */
int valdi2chk(
WORKERDATA *workerdata)  /* workerdata structure */
{
   if (workerdata -> ioasdi == DISABILITY && workerdata -> valdi == 0)
      return(24);
   return(0);
}
/* Function to set date of death
 */
int setideath(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> ioasdi == SURVIVOR) {
      if ((ierr = ideathchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i += 2)
         workerdata -> ideath[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> ideath);
   return(0);
}
/* Function to check date of death in survivor case
 */
int ideathchk(
int datetemp[3])  /* date to use */
{
   int date1[3];  /* temporary date */

   if (mocheck(datetemp[0]))
      return(10);
   date1[0] = (int)JANUARY;
   date1[1] = 0;
   date1[2] = 1940;
   if (compmdy(datetemp, date1) < 0)
      /* death before 1940 */
      return(11);
   if (datetemp[2] > maxyear)
      return(11);
   return(0);
}
/* Function to set widow date of birth
 */
int setjbirth(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> jsurv == DISAB_WID || workerdata -> jsurv == AGED_WID) {
      if ((ierr = jbirthchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i++)
         workerdata -> jbirth[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> jbirth);
   return(0);
}
/* Function to check date of widow birth in widow case
 */
int jbirthchk(
int datetemp[3])  /* date to use */
{
   int date1[3];  /* temporary date */
   int ierr;  /* error indicator */

   if ((ierr = modychk(datetemp)) > 0)
      return(16 + ierr);
   date1[0] = (int)JANUARY;
   date1[1] = 0;
   date1[2] = 1800;
   if (compmdy(datetemp, date1) < 0)
      /* death before 1800 */
      return(146);
   if (datetemp[2] > maxyear)
      return(146);
   return(0);
}
/* Function to set widow date of disability onset
 */
int setjonset(
WORKERDATA *workerdata,  /* workerdata structure */
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */
   int i;  /* loop counter */

   if (workerdata -> jsurv == DISAB_WID) {
      if ((ierr = jonsetchk(datetemp)) > 0)
         return(ierr);
      for (i = 0; i < 3; i++)
         workerdata -> jonset[i] = datetemp[i];
      }
   else
      zeromdy(workerdata -> jonset);
   return(0);
}
/* Function to check date of widow disability onset in disabled widow case
 */
int jonsetchk(
int datetemp[3])  /* date to use */
{
   int ierr;  /* error indicator */

   if ((ierr = modychk(datetemp)) > 0)
      return(ierr + 33);
   if (datetemp[2] < 1940)
      return(36);
   if (datetemp[2] > maxyear)
      return(37);
   return(0);
}
/* Function to set anscch
 */
int setanscch(
WORKERDATA *workerdata,  /* workerdata structure */
char ansccht)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = anscchchk(ansccht)) > 0)
      return(ierr);
   if (islower(ansccht))
      ansccht = toupper(ansccht);
   workerdata -> anscch = ansccht;
   return(0);
}
/* Function to check anscch
 */
int anscchchk(
char ansccht)  /* value to check */
{
   if (ansccht != 'Y' && ansccht != 'N' && ansccht != 'y' && ansccht != 'n')
      return(31);
   return(0);
}
/* Function to set ibasch
 */
int setibasch(
WORKERDATA *workerdata,  /* workerdata structure */
int ibascht)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = ibaschchk(ibascht)) > 0)
      return(ierr);
   if (workerdata -> joasdi == PEBS_CALC)
      workerdata -> ibasch = 1;
   else
      workerdata -> ibasch = ibascht;
   return(0);
}
/* Function to check ibasch
 */
int ibaschchk(
int ibascht)  /* value to check */
{
   if (ibascht < 1 || ibascht > 2)
      return(21);
   return(0);
}
/* Function to set pubpen
 */
int setpubpen(
WORKERDATA *workerdata,  /* workerdata structure */
float pubpent)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = pubpenchk(pubpent)) > 0)
      return(ierr);
   workerdata -> pubpen = pubpent;
   return(0);
}
/* Function to check ibasch
 */
int pubpenchk(
float pubpent)  /* value to use */
{
   if (pubpent < (float)0. || pubpent > (float)maxearng)
      return(22);
   return(0);
}
/* Function to set type of earnings
 */
int setearntp(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of earntype */
int earntypet)  /* value to use */
{
   int ierr;  /* error indicator */

   if (workerdata -> joasdi != PEBS_CALC) {
      if ((ierr = earntpchk(earntypet)) > 0)
         return(ierr);
      else
         workerdata -> earntype[year - 1937] = (enum earn_type)earntypet;
      }
   else
      workerdata -> earntype[year - 1937] = ENTERED;
   return(0);
}
/* Function to check earntype
 */
int earntpchk(
int earntypet)  /* value to use */
{
   if (earntypet < (int)ENTERED || earntypet > (int)CHILDCARE)
      return(7);
   return(0);
}
/* Function to set type of taxes
 */
int settaxtyp(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of taxtype */
int taxtypet)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = taxtypchk(taxtypet)) > 0)
      return(ierr);
   workerdata -> taxtype[year - 1937] = taxtypet;
   return(0);
}
/* Function to check taxtype
 */
int taxtypchk(
int taxtypet)  /* value to use */
{
   if (taxtypet > 1 || taxtypet < 0)
      return(48);
   return(0);
}
/* Function to set benefit increase
 */
int setcpiinc(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of cpiinc */
float cpiinct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = cpiincchk(cpiinct)) > 0)
      return(ierr);
   workerdata -> cpiinc[year - 1951] = cpiinct;
   return(0);
}
/* Function to check a benefit increase
 */
int cpiincchk(
float cpiinct)  /* value to use */
{
   if ((double)cpiinct > 99.99 || (double)cpiinct < 0.0)
      return(110);
   return(0);
}
/* Function to set catch-up benefit increase
 */
int setcachup(
WORKERDATA *workerdata,  /* workerdata structure */
int i2,  /* first index of cachup */
int i1,  /* second index of cachup */
double cachupt)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = cachupchk(cachupt)) > 0)
      return(ierr);
   workerdata -> cachup[i2][i1] = cachupt;
   return(0);
}
/* Function to check a catch-up benefit increase
 */
int cachupchk(
double cachupt)  /* value to use */
{
   if (cachupt > 99.99 || cachupt < 0.0)
      return(123);
   return(0);
}
/* Function to set earnings
 */
int setearnpb(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of earnings */
double earnpebst)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = earnpbchk(earnpebst)) > 0)
      return(ierr);
   workerdata -> earnpebs[year - 1937] = earnpebst;
   return(0);
}
/* Function to check earnings
 */
int earnpbchk(
double earnpebst)  /* value to use */
{
   if (earnpebst > maxearng || earnpebst < 0.0)
      return(28);
   return(0);
}
/* Function to set average wage increase
 */
int setfqinc(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of fqinc */
float fqinct)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = fqincchk(fqinct)) > 0)
      return(ierr);
   workerdata -> fqinc[year - 1937] = fqinct;
   return(0);
}
/* Function to check an average wage increase
 */
int fqincchk(
float fqinct)  /* value to use */
{
   if ((double)fqinct > 99.99 || (double)fqinct < -9.99)
      return(111);
   return(0);
}
/* Function to set wage base
 */
int setbase(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of base */
double baset)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = basechk(baset)) > 0)
      return(ierr);
   workerdata -> base[year - 1937] = baset;
   return(0);
}
/* Function to set old-law wage base
 */
int setbase77(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of base */
double baset)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = basechk(baset)) > 0)
      return(ierr);
   workerdata -> base77[year - 1937] = baset;
   return(0);
}
/* Function to check a wage base
 */
int basechk(
double baset)  /* value to use */
{
   if (baset > maxearng || baset < 0.0)
      return(39);
   return(0);
}
/* Function to set Medicare earnings
 */
int setearnhi(
WORKERDATA *workerdata,  /* workerdata structure */
int year,  /* year of earnings */
double earnhit)  /* value to use */
{
   int ierr;  /* error indicator */

   if ((ierr = earnhichk(earnhit)) > 0)
      return(ierr);
   workerdata -> earnhi[year - 1937] = earnhit;
   return(0);
}
/* Function to check Medicare earnings
 */
int earnhichk(
double earnhit)  /* value to use */
{
   if (earnhit > maxearng || earnhit < 0.0)
      return(38);
   return(0);
}
/* Function to see if benefit increase assumptions are needed 
 */
int need_bi(
WORKERDATA *workerdata)  /* workerdata structure */
{
   int tempdate[3];  /* temporary date */

   tempdate[0] = (int)DECEMBER;
   tempdate[1] = 0;
   tempdate[2] = istart;
   return((compmdy(workerdata -> bendate, tempdate) > -1) ? 1 : 0);
}
/* Function to see if average wage increase assumptions are needed 
 */
int need_aw(
WORKERDATA *workerdata)  /* workerdata structure */
{
   int tempdate[3];  /* temporary date */

   tempdate[0] = (int)DECEMBER;
   tempdate[1] = 0;
   tempdate[2] = istart;
   if (workerdata -> earntype[istart - 1937] == AVERAGE ||
      workerdata -> earntype[istart - 1937] == LOW ||
      workerdata -> earntype[istart - 1938] == AVERAGE ||
      workerdata -> earntype[istart - 1938] == LOW ||
      (workerdata -> projfwrd == 1 && workerdata -> iend > istart - 2) ||
      (workerdata -> projback == 1 && workerdata -> ibegin1 > istart - 2))
      tempdate[2] -= 2;
   return((compmdy(workerdata -> bendate, tempdate) > 0) ? 1 : 0);
}
