/*
 *  @(#)wrkrdata.h	1.53   4/1/94
 *  Declarations needed for worker data.
 */

#ifndef __WRKRDATA_H
#define __WRKRDATA_H

#define MAXASM 7 /* number of assumptions */

enum ben_type { OLD_AGE = 1, SURVIVOR, DISABILITY, PEBS_CALC };
enum surv_type { NO_SURV, YOUNG_SURV, DISAB_WID, AGED_WID };
enum assum_type { ALTERN_I = 1, ALTERN_IIB, ALTERN_III, ALTERN_IIA, FLAT,
                 PEBS_ASSUM, OTHER_ASSUM };
enum earn_type { ENTERED, MAXIMUM, AVERAGE, LOW, OLDLAWMAX, CHILDCARE };

typedef struct {
   int     istart;    /* current year (year after last known benefit
                 increase) */
   int     isex;      /* sex of worker (1 for male, 2 for female) */
   enum ben_type  joasdi; /* type of calculation (1 for old-age, 2 for
                 survivor, 3 for disability, 4 for PEBS statement */
   int     recalc;    /* recalculation code (0 for initial benefit, 1 for
                 recalculation) */
   int     totalize;  /* totalization code (0 for no totalization, 1 for
                 totalization) */
   int     mqge;  /* Medicare earnings code (0 for no Medicare earnings,
                 1 for Medicare earnings) */
   int     ibirth[3]; /* month, day, and year of birth of worker */
   int     monthnow;  /* current month (1-12) */
   int     bendate[3];  /* month, day, and year of benefit date (day is 0) */
   int     ient[3];   /* month, day, and year of entitlement (day is 0) */
   int     iageplan;  /* planned retirement age as entered */
   enum earn_type *earntype;  /* type of earnings (0 for earnings read in,
                 1 for maximum earnings, 2 for average earnings, 3 for low
                 earnings, 4 for old-law maximum earnings, 5 for
                 childcare year */
   int     projback;  /* indicator for backward projection
                 0 = no backward projection,
                 1 = backward projection related to average wage increase,
                 2 = backward projection by a constant percentage */
   float   percback;  /* percentage used in backward projection
                 if projback = 1: increment to average wage increase,
                 if projback = 2: constant percentage increase */
   int     ibegin1;   /* first year of earnings before backward projection */
   int     ibegin;    /* first year of earnings after backward projection */
   int     projfwrd;  /* indicator for forward projection
                 0 = no forward projection,
                 1 = forward projection related to average wage increase,
                 2 = forward projection by a constant percentage */
   float   percfwrd;  /* percentage used in forward projection
                 if projfwrd = 1: increment to average wage increase,
                 if projfwrd = 2: constant percentage increase */
   int     iend1;     /* last year of earnings before forward projection */
   int     iend;      /* last year of earnings after forward projection */
   int     qctot51td; /* number of quarters of coverage earned from
                 1951 through 1977 */
   int     qctottd;   /* number of quarters of coverage earned from 1937
                 through 1977 */
   int    *qc;        /* quarters of coverage, 1937 to 1937+maxyears */
   int     ideath[3]; /* month, day, and year of death (day is 0) */
   enum surv_type jsurv;  /* type of survivor (see surv_type) */
   int     valdi;     /* disability code (0 for no disability, 1 for
                 disability before and continuing to retirement) */
   int     ionset[3]; /* month, day, and year of worker's 
                 disability onset */
   int     priorent[3]; /* month, day, and year of prior DIB entitlement
                 (day is 0) */
   int     waitper[3];  /* month, day, and year of beginning of waiting
                 period (day is 0) */
   int     jbirth[3]; /* month, day, and year of birth of widow */
   int     jonset[3]; /* month, day, and year of widow's 
                 disability onset */
   enum assum_type ialtbi;  /* benefit increase assumption */
   float  *cpiinc;    /* benefit increases, 1951 to 1951+maxyears, as
                 read in */
   char    anscch;    /* answer to catch-up benefit increase prompt */
   double  cachup[10][8];  /* catch-up benefit increases */
   char   *titlbi;    /* title of user's benefit increases */
   enum assum_type ialtaw;  /* average wage increase assumption */
   float  *fqinc;     /* increase in annual average earnings, 1937
                 to 1937+maxyears, as read in */
   char   *titlaw;    /* title of user's average wages */
   int     ibasch;    /* ad hoc base change (1=none, 2=change) */
   double *base;      /* wage base under present law, 1937 to 1937+maxyears,
                 as read in */
   double *base77;    /* old-law wage bases (ignoring 1979-81 ad hoc
                 increases), 1937 to 1937+maxyears, as read in */
   double *earnpebs;  /* worker earnings, 1937 to 1937+maxyears, as read in */
   double *earnhi;    /* worker additional Medicare earnings, 1937 to
                 1937+maxyears */
   float   pubpen;    /* monthly noncovered pension */
   int    *taxtype;   /* type of taxes paid (0=employee, 1=self-
                 employed) */
   char    nhname[35];  /* name of wage earner */
   char    nhaddr[3][35];  /* address of wage earner */
   char    ssn[12];   /* social security number of wage earner */
   int     maxyears;  /* maximum number of years allowed */
   double  maxearn;   /* maximum earnings allowed */
   unsigned int maxchr;    /* maximum characters in title or message */
   enum ben_type  ioasdi; /* type of benefit (1 for old-age, 2 for 
                 survivor, 3 for disability), set even if PEBES case */
   int     jaltbi;    /* last benefit increase assumption read in */
   int     jaltaw;    /* last average wage increase assumption read in */
   int     jbasch;    /* last ad hoc base change read in */
   }  WORKERDATA;

#define MAXYRS 60 /* maximum number of years of earnings */

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
int   initdata  ( WORKERDATA **workerdatap, int maxyears, double maxearn,
   int maxchr );
int   ibegchk   ( WORKERDATA * );
int   iendcheck ( WORKERDATA * );
void  setioasdi ( WORKERDATA *workerdata, enum ben_type ioasdit );
int   qccheck   ( WORKERDATA * );
int   setbendt1 ( WORKERDATA *workerdata, int datetemp[3] );
void  setbendt2 ( WORKERDATA *workerdata );
int   agecheck  ( WORKERDATA *workerdata, int nradatet[3] );
int   qcsum     ( WORKERDATA *, int, int );
int   dthcheck  ( WORKERDATA * );
int   setjsurv  ( WORKERDATA *workerdata, int jsurvt );
int   jsurvchk  ( int jsurvt );
int   setionset ( WORKERDATA *workerdata, int datetemp[3] );
int   ionsetchk ( int datetemp[3] );
int   discheck  ( WORKERDATA *workerdata );
int   setwaitpd ( WORKERDATA *workerdata, int datetemp[3] );
int   waitpdchk ( int datetemp[3] );
int   waitchk   ( WORKERDATA *workerdata );
int   setprrent ( WORKERDATA *workerdata, int datetemp[3] );
int   prrentchk ( int datetemp[3] );
int   priorchk  ( WORKERDATA *workerdata );
int   widcheck  ( WORKERDATA * );
void  setbirth  ( int birth1[3], int birth2[3]);
void  zerocch   ( double[10][8] );
int   setient   ( WORKERDATA *workerdata, int datetemp[3] );
int   ientchk   ( int datetemp[3] );
int   bendt1chk ( int datetemp[3] );
int   bendt2chk ( WORKERDATA *workerdata );
int   modychk   ( int *mody );
int   mocheck   ( int month );
int   qcbyyear  ( WORKERDATA *workerdata );
void  zeroearn  ( WORKERDATA *workerdata );
char *fmale     ( WORKERDATA *workerdata );
int   pebsasmchk( WORKERDATA *workerdata );
int   lastqcyr  ( WORKERDATA *workerdata );
void  setpbdata ( WORKERDATA *workerdata );
void  qctdchk2  ( WORKERDATA *workerdata );
void  zerojalt  ( WORKERDATA *workerdata );
int   setmonthn ( WORKERDATA *workerdata, int monthnowt );
int   monthnchk ( int monthnowt );
int   setqctd   ( WORKERDATA *workerdata, int qct );
int   qctdchk   ( int qct );
int   setqc51td ( WORKERDATA *workerdata, int qct );
int   qc51tdchk ( int qct );
int   setqc2    ( WORKERDATA *workerdata, int year, int qct );
int   qc2check  ( int qct );
int   setjoasdi ( WORKERDATA *workerdata, int joasdit );
int   joasdichk ( int joasdit );
int   setisex   ( WORKERDATA *workerdata, int isext );
int   isexchk   ( int isext );
int   setialtaw ( WORKERDATA *workerdata, int ialtawt );
int   ialtawck1 ( int ialtawt );
int   ialtawck2 ( int ialtawt );
int   setialtbi ( WORKERDATA *workerdata, int ialtbit );
int   ialtbick1 ( int ialtbit );
int   ialtbick2 ( int ialtbit );
int   setrecalc ( WORKERDATA *workerdata, int recalct );
int   recalcchk ( int recalct );
int   settotali ( WORKERDATA *workerdata, int totalit );
int   totalichk ( int totalit );
int   setmqge   ( WORKERDATA *workerdata, int mqget );
int   mqgechk   ( int mqget );
int   setiagepl ( WORKERDATA *workerdata, int iageplant );
int   iageplchk ( int iageplant );
int   setibirth ( WORKERDATA *workerdata, int datetemp[3] );
int   ibirt1chk ( int datetemp[3] );
int   ibirt2chk ( int datetemp[3] );
int   setprojbk ( WORKERDATA *workerdata, int projbackt );
int   projbkchk1( int projbackt );
int   projbkchk2( int projbackt );
int   setpercbk ( WORKERDATA *workerdata, float percbackt );
int   percbkchk ( float percbackt );
int   setibegin ( WORKERDATA *workerdata, int ibegint );
int   ibegn1chk ( int ibegint );
int   ibegn2chk ( int ibegint );
int   setibegn1 ( WORKERDATA *workerdata, int ibegint );
int   setprojfd ( WORKERDATA *workerdata, int projfwrdt );
int   projfdchk1( int projfwrdt );
int   projfdchk2( int projfwrdt );
int   setpercfd ( WORKERDATA *workerdata, float percfwrdt );
int   percfdchk ( float percfwrdt );
int   setiend   ( WORKERDATA *workerdata, int iendt );
int   iendchk   ( int iendt );
int   setiend1  ( WORKERDATA *workerdata, int iendt );
int   setistart ( WORKERDATA *workerdata, int istartt );
int   istartchk ( int istartt );
int   setvaldi  ( WORKERDATA *workerdata, int valdit );
int   valdi1chk ( int valdit );
int   valdi2chk ( WORKERDATA *workerdata );
int   setideath ( WORKERDATA *workerdata, int datetemp[3] );
int   ideathchk ( int datetemp[3] );
int   setjbirth ( WORKERDATA *workerdata, int datetemp[3] );
int   jbirthchk ( int datetemp[3] );
int   setjonset ( WORKERDATA *workerdata, int datetemp[3] );
int   jonsetchk ( int datetemp[3] );
int   setanscch ( WORKERDATA *workerdata, char ansccht );
int   anscchchk ( char ansccht );
int   setibasch ( WORKERDATA *workerdata, int ibascht );
int   ibaschchk ( int ibascht );
int   setpubpen ( WORKERDATA *workerdata, float pubpent );
int   pubpenchk ( float pubpent );
int   setearntp ( WORKERDATA *workerdata, int year, int earntypet );
int   earntpchk ( int earntypet );
int   settaxtyp ( WORKERDATA *workerdata, int year, int taxtypet );
int   taxtypchk ( int taxtypet );
int   setcpiinc ( WORKERDATA *workerdata, int year, float cpiinct );
int   cpiincchk ( float cpiinct );
int   setcachup ( WORKERDATA *workerdata, int i2, int i1, double cachupt );
int   cachupchk ( double cachupt );
int   setearnpb ( WORKERDATA *workerdata, int year, double earnpebst );
int   earnpbchk ( double earnpebst );
int   setfqinc  ( WORKERDATA *workerdata, int year, float fqinct );
int   fqincchk  ( float fqinct );
int   setbase   ( WORKERDATA *workerdata, int year, double baset );
int   setbase77 ( WORKERDATA *workerdata, int year, double baset );
int   basechk   ( double baset );
int   setearnhi ( WORKERDATA *workerdata, int year, double earnhit );
int   earnhichk ( double earnhit );
int   need_bi   ( WORKERDATA *workerdata );
int   need_aw   ( WORKERDATA *workerdata );
#else
int   initdata();
int   ibegchk();
int   iendcheck();
void  setioasdi();
int   qccheck();
int   setbendt1();
void  setbendt2();
int   agecheck();
int   qcsum();
int   dthcheck();
int   setjsurv();
int   jsurvchk();
int   setionset();
int   ionsetchk();
int   discheck();
int   setwaitpd();
int   waitpdchk();
int   waitchk();
int   setprrent();
int   prrentchk();
int   priorchk();
int   widcheck();
void  setbirth();
void  zerocch();
int   setient();
int   ientchk();
int   bendt1chk();
int   bendt2chk();
int   modychk();
int   mocheck();
int   qcbyyear();
void  zeroearn();
char *fmale();
int   pebsasmchk();
int   lastqcyr();
void  setpbdata();
void  qctdchk2();
void  zerojalt();
int   setmonthn();
int   monthnchk();
int   setqctd();
int   qctdchk();
int   setqc51td();
int   qc51tdchk();
int   setqc2();
int   qc2check();
int   setjoasdi();
int   joasdichk();
int   setisex();
int   isexchk();
int   setialtaw();
int   ialtawck1();
int   ialtawck2();
int   setialtbi();
int   ialtbick1();
int   ialtbick2();
int   setrecalc();
int   recalcchk();
int   settotali();
int   totalichk();
int   setmqge();
int   mqgechk();
int   setiagepl();
int   iageplchk();
int   setibirth();
int   ibirt1chk();
int   ibirt2chk();
int   setprojbk();
int   projbkchk();
int   setpercbk();
int   percbkchk();
int   setibegin();
int   ibegn1chk();
int   ibegn2chk();
int   setibegn1();
int   setprojfd();
int   projfdchk();
int   setpercfd();
int   percfdchk();
int   setiend();
int   iendchk();
int   setiend1();
int   setistart();
int   istartchk();
int   setvaldi();
int   valdi1chk();
int   valdi2chk();
int   setideath();
int   ideathchk();
int   setjbirth();
int   jbirthchk();
int   setjonset();
int   jonsetchk();
int   setanscch();
int   anscchchk();
int   setibasch();
int   ibaschchk();
int   setpubpen();
int   pubpenchk();
int   setearntp();
int   earntpchk();
int   settaxtyp();
int   taxtypchk();
int   setcpiinc();
int   cpiincchk();
int   setcachup();
int   cachupchk();
int   setearnpb();
int   earnpbchk();
int   setfqinc();
int   fqincchk();
int   setbase();
int   setbase77();
int   basechk();
int   setearnhi();
int   earnhichk();
int   need_bi();
int   need_aw();
#endif

#endif
