PROGRAM Quotes;

uses WinTypes, WinProcs, WObjects, Strings, WinCrt, WinDOS;

{$R WFUND1.RES}

const
  id_Dial  = 201;   id_HangUps = 203;   id_Quit  = 204;     cm_index    = 901;

  numf = 20;

  LineWidth   = 80;  { Width of each line displayed.                 }
  LineHeight  = 60;  { Number of line that are held in memory.       }

    
type
  pString = ^STRING;

  TApp = object(TApplication)
    procedure Idle; virtual;
    procedure InitMainWindow; virtual;
    procedure MessageLoop; virtual;
  end;

  PBuffer = ^TBuffer;
  TBuffer = object(TCollection)
    Pos: Integer;
    constructor Init(AParent: PWindow);
    procedure FreeItem(Item: Pointer); virtual;
    function PutChar(C: Char): Boolean;
  end;

  PCommWindow = ^TCommWindow;
  TCommWindow = object(TWindow)
    Cid: Integer;
    Buffer: PBuffer;
    FontRec: TLogFont;
    CharHeight: Integer;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor Done; virtual;
    procedure Dial(var Message: TMessage); virtual cm_First + id_Dial;
    procedure HangUp(var Message: TMessage); virtual cm_First + id_HangUps;
    procedure Error(E: Integer; C: PChar);
    procedure ReadChar; virtual;
    PROCEDURE ProgramExit(VAR Message: TMessage); virtual cm_First + id_Quit;
    PROCEDURE GetWindowClass(VAR AWndClass: TWndClass); virtual;
    PROCEDURE MyIndex(var Message: TMessage);virtual cm_First + cm_index;
    procedure SetConfigure;       PROCEDURE Timer(TimeSw: BYTE);
    procedure SetHeight;          PROCEDURE ReadF2;
    procedure SetUpWindow; virtual;
    procedure wmChar(var Message: TMessage); virtual wm_Char;
    procedure wmSize(var Message: TMessage); virtual wm_Size;
    procedure WriteChar;
  end;

var
  cCISId, cCISPass : ARRAY [1..20] OF CHAR;
  iCISId, iCISPass : ARRAY [1..20] OF LONGINT;
  PhoneNumber, MyStop : ARRAY [0..40] OF CHAR;
  InitString1, File1 : ARRAY [0..40] OF CHAR;
  pTemp : ARRAY [0..200] OF CHAR;
  Descript, Trade : ARRAY [1..1024] OF pSTRING;
  transmit : BYTE;
  temp, MyCheck, DataSw, period : REAL;
  i, m, iTemp, iTemp1, iTemp2, comm, count, isw, isw1, isw14, minX1, secX1, sec100X1 : INTEGER;
  monitor, count1f, count2f, count3f, bond : LONGINT;
  hour, minute, second, sec100 : WORD;
  InitString, sTemp, sTemp1, sTemp2, Speeds, CISPhone, File2, CISId, CISPass, MyTone, sPeriod
    : STRING;
  pTemp1 : pChar;               cTemp : CHAR;

  Rect: TRect;                  Message: TMessage;
  DC, MyMenu, CRTId : HDC;      MyWind : HWnd;

  ifb, ifc, ifd : TEXT;

                         {******************}
PROCEDURE ClearScreen;

BEGIN

InvalidateRect(MyWind, nil, True);
UpdateWindow(MyWind);
ValidateRect(MyWind, nil);
GetClientRect(MyWind, Rect);

END;


                         {***********************}
PROCEDURE TCommWindow.ReadF2;
label jump1, jump2;
BEGIN

FOR i:= 1 TO 100 DO
  begin
  NEW(Descript[i]);
  NEW(Trade[i]);
  end;
                            
File2:= 'funds.cfg';
ASSIGN (ifb, File2);
RESET (ifb);
READLN (ifb, iTemp, iTemp, DataSw, iTemp, comm, transmit, bond);
                          
FOR m:= 1 TO 14 DO
  READ (ifb, iTemp, iTemp);
READLN (ifb, iTemp, iTemp);
FOR m:= 16 TO 19 DO
  READ (ifb, iTemp, iTemp);
READLN (ifb, iTemp, iTemp);
                            
FOR m:= 1 TO 14 DO
  READ (ifb, iCISPass[m], iCISId[m]);
READLN (ifb, iCISPass[15], iCISId[15]);
FOR m:= 16 TO 19 DO
  READ (ifb, iCISPass[m], iCISId[m]);
READLN (ifb, iCISPass[20], iCISId[20]);
           
READLN (ifb, monitor, count1f, count2f, count3f, MyCheck);
IF ROUND(DataSw) <> 7259 THEN TCommWindow.Done;   

FOR m:= 1 TO numf DO
  begin
  READLN (ifb, sTemp);
  READLN (ifb, sTemp);
  end;

FOR m:= 1 TO 5 DO
  READLN (ifb, sTemp);

READLN (ifb, sTemp);
READLN (ifb, sTemp);
READLN (ifb, sTemp);
FOR i:= 1 TO 9 DO
    READ (ifb, iTemp);
  READLN (ifb, iTemp);
READLN (ifb, sTemp);
READLN (ifb, Speeds);
READLN (ifb, CISphone);    
READLN (ifb, InitString);
READLN (ifb, MyTone);
CLOSE (ifb);

FOR m:= 1 TO 20 DO
  begin
  cCISId[m]:= CHR(iCISId[m] + 36);
  IF (iCISPass[m] = 27) OR (iCISPass[m] = 13) THEN
    cCISPass[m]:= ' '
  ELSE
    cCISPass[m]:= CHR(iCISPass[m] + 36);
  end;
             
CISPass:= '';
CISId:= '';
FOR m:= 1 TO 20 DO
  begin
  IF cCISPass[m] = ' ' THEN GOTO jump1;
  CISPass:= CISPass + cCISPass[m];
  end;
jump1:
FOR m:= 1 TO 20 DO
  begin
  IF cCISId[m] = ' ' THEN GOTO jump2;
  CISId:= CISId + cCISId[m];
  end;
jump2:
  
CISPass:= CISPass + CHR(13);
CISId:= CISId + CHR(13);
STR(comm:1, sTemp);
sTemp:= 'COM' + sTemp;
StrPCopy(File1, sTemp);
                     
count:= 0;
isw1:= 0;                               { for "Issue:" recognition }
isw14:= 0;
StrPCopy(MyStop, 'NO CARRIER');
                         
StrCopy(WindowTitle, 'Fund Investor - CompuServe Quotes');
WindowOrg.X:= 1;
WindowOrg.Y:= 1;
ScreenSize.X:= 80;
ScreenSize.Y:= 700;
InitWinCRT;
CRTId:= GetActiveWindow;

ASSIGN (ifd, 'quote.dat');
REWRITE(ifd);


END;
                        

                                {****************}
PROCEDURE Delay (count: INTEGER; PrintSw: BYTE);

var
hour, minute, second, second1, sec100, sec101 : WORD;
MySecond, MySecond1, MySec100, MySec101, iTemp, iTemp1, iTemp2 : INTEGER;
temp: REAL;

BEGIN
                                    {count of 100 = 1 sec 
                             PrintSw = 1  displays timer's time in Main Window
                                     = 2  displays timer's time in CRT Window }
GetTime(hour, minute, second, sec100);
MySecond:= second;
MySec100:= sec100;
iTemp:= 0;      
WHILE iTemp < count DO
  begin                  
  GetTime(hour, minute, second1, sec101);    
  MySecond1:= second1;
  MySec101:= sec101;
  iTemp1:= MySecond1 - MySecond;                 
  IF iTemp1 < 0 THEN iTemp1:= iTemp1 + 60;
  iTemp1:= iTemp1 * 100;        
  iTemp2:= MySec101 - MySec100;
  iTemp:= iTemp1 + iTemp2;        
  IF iTemp < 0 THEN iTemp:= iTemp + 100; 
  temp:= iTemp;
  temp:= temp / 100.0;
  STR(temp:6:2, sTemp);
  sTemp:= sTemp + ' sec.';
  end;

END;


{ TBuffer }
{ The Buffer is used to hold each line that is displayed in the main    }
{ window.  The constant LineHeight determines the number of lines that }
{ are stored.  The Buffer is prefilled with the LineHeight worth of    }
{ lines.                                                               }
CONSTRUCTOR TBuffer.Init(AParent: PWindow);
var
  P: PChar;
  I: Integer;
BEGIN
  TCollection.Init(LineHeight + 1, 10);
  GetMem(P, LineWidth + 1);
  P[0] := #0;
  Pos := 0;
  Insert(P);
  for I := 1 to LineHeight do
  begin
    GetMem(P, LineWidth + 1);
    P[0] := #0;
    Insert(P);
  end;
END;

PROCEDURE TBuffer.FreeItem(Item: Pointer);
BEGIN
  FreeMem(Item, LineWidth + 1);
END;

{ This procedure processes all incomming information from the com  }
{ port.  This procedure is called by TCommWindow.ReadChar.           }

FUNCTION TBuffer.PutChar(C: Char): Boolean;
var
  Width: Integer;
  P: PChar;
BEGIN         
  PutChar := False;
  Case C of
    #13: Pos := 0;                          { if a Carriage Return.  }
    #10:                                    { if a Line Feed.        }
      begin
        GetMem(P, LineWidth + 1);
        FillChar(P^, LineWidth + 1, ' ');
        P[Pos] := #0;
        Insert(P);
      end;
    #8:
      if Pos > 0 then                       { if a Delete.           }
      begin
        Dec(Pos);
        P := At(Count - 1);
        P[Pos] := ' ';
      end;
   #32..#128:                               { else handle all other  }
    begin                                   { displayable characters.}
      P := At(Count - 1);
      Width := StrLen(P);
      if Width > LineWidth then             { if line is to wide     }
      begin                                 { create a new line.     }
        Pos := 1;
        GetMem(P, LineWidth + 1);
        P[0] := C;
        P[1] := #0;
        Insert(P);
      end
      else                                   { else add character    }
      begin                                  { to current line.      }
        P[Pos] := C;
        Inc(Pos);
        P[Pos] := #0;
      end;
    end;
  end;                    
  if Count > LineHeight then                 { if too many lines }
  begin                                      { have been added delete}
    AtFree(0);                               { current line and let  }
    PutChar := True;                         { the call procedure    }
  end;                                       { know to scroll up.    }
END;

{ TCommWindow }
{ The CommWindow displays the incoming and outgoing text.  There  }
{ should be mention that the text type used is displayed by     }
{ being echoed back to the ReadChar procedure.  So there is no need for }
{ wmChar to write a character to the screen.                          }
CONSTRUCTOR TCommWindow.Init(AParent: PWindowsObject; ATitle: PChar);
BEGIN
  TWindow.Init(AParent, ATitle);
  Attr.Style := Attr.Style or ws_VScroll;
  Attr.Menu := LoadMenu(HInstance, 'Main3');
  Attr.X:= 1;
  Attr.Y:= 1;
  Scroller := New(PScroller, Init(@Self, 1, 1, 100, 100));
  Buffer := New(PBuffer, Init(@Self));
  ReadF2;                
END;

{ Close the Comm port and deallocate the Buffer.                      }
DESTRUCTOR TCommWindow.Done;
begin
  IF isw14 > 0 THEN Error(CloseComm(Cid), 'Close');
  Dispose(Buffer, Done);
  DoneWinCRT;
  TWindow.Done;
END;


PROCEDURE TCommWindow.GetWindowClass(VAR AWndClass: TWndClass);

Begin

  TWindow.GetWindowClass(AWndClass);

End;


                        {***********************}
PROCEDURE TCommWindow.MyIndex (VAR Message: TMessage);

BEGIN

WinHelp(HWindow, 'funds.hlp', Help_Key, LongInt(PChar('d/l from CompuServe')));

END;


PROCEDURE TCommWindow.ProgramExit(VAR Message: TMessage);
begin
  IF isw14 = 1 THEN
    begin
    sTemp:= 'ATZ' + CHR(13);
    StrPCopy(pTemp, sTemp);
    WriteComm(CId, pTemp, 4);
    end;
  WinHelp(HWindow, 'funds.hlp', Help_quit, 0);
  ReleaseDC(HWindow, DC);
  CLOSE(ifd);
  TCommWindow.Done;
end;


                    {*****************}
PROCEDURE TCommWindow.Timer(TimeSw: BYTE);
                     { 0 - starts the timer;   1 - terminates }
var
  iTemp, iTemp1, iTemp2 : INTEGER;
  
BEGIN

GetTime(hour, minute, second, sec100);

IF TimeSw = 0 THEN
  begin
  MinX1:= Minute;
  SecX1:= Second;
  Sec100X1:= Sec100;
  end;

If TimeSw = 1 THEN
  begin
  iTemp:= Minute;
  iTemp1:= MinX1;
  iTemp:= iTemp - iTemp1;
  IF iTemp < 0 THEN
    Minute:= iTemp + 60
  ELSE
    Minute:= iTemp;
  iTemp:= Second;
  iTemp1:= SecX1;
  iTemp2:= iTemp - iTemp1;  
  iTemp:= Sec100;
  iTemp1:= Sec100X1;
  iTemp:= iTemp - iTemp1;
  IF iTemp < 0 THEN
    begin
    iTemp:= iTemp + 100;
    iTemp2:= iTemp2 - 1;
    end;
  IF iTemp2 < 0 THEN
    begin
    iTemp2:= iTemp2 + 60;
    Minute:= Minute - 1;
    end;
  IF iTemp2 < 0 THEN
    begin
    Second:= iTemp2 + 60;
    Minute:= Minute - 1;
    end
  ELSE
    Second:= iTemp2;
  Period:= Minute * 60 + Second + iTemp / 100;
  end;
       
END;




PROCEDURE TCommWindow.Dial(var Message: TMessage);

BEGIN
if CID >= 0 then
  begin
  FlushComm(CID, 0);
  FlushComm(CID, 1);
  isw14:= 1;                
  Error(WriteComm(CID, PhoneNumber, StrLen(PhoneNumber)), 'writing');
  BringWindowToTop(CRTId);
  ClrScr;          
  TCommWindow.Timer(0);
  end;

END;

PROCEDURE TCommWindow.HangUp(var Message: TMessage);
 
BEGIN

IF isw14 > 0 then
  begin
  sTemp:= '+++';
  StrPCopy(PhoneNumber, sTemp);
  StrPCopy(pTemp, sTemp);
  Error(WriteComm(CID, pTemp, LENGTH(sTemp)), 'Writing');
  DELAY (200, 2);
  sTemp:= 'AT H0 ' + CHR(13);
  StrPCopy(pTemp, sTemp);
  Error(WriteComm(CID, pTemp, LENGTH(sTemp)), 'Writing');
  end;

END;


{ Checks for comm errors and writes any errors.                       }
PROCEDURE TCommWindow.Error(E: Integer; C: PChar);
var
  S: array[0..100] of Char;
BEGIN
  if E >= 0 then exit;
  Str(E, S);
  MessageBox(GetFocus, S, C, mb_Ok);
END;

{ Redraw all the lines in the buffer by using ForEach.                }

{ Read a character from the comm port, if there is no error then call }
{ Buffer^.PutChar to add it to the buffer and write it to the screen. }
PROCEDURE TCommWindow.ReadChar;
var
  Stat: TComStat;
  I, Size: Integer;        Ca : ARRAY [0..2] of Char;
  C: Char;
BEGIN
  GetCommError(CID, Stat);
  for I := 1 to Stat.cbInQue do
  begin
    Size := ReadComm(CId, Ca, 1);
    c:= Ca[0];
    Error(Size, 'Read Comm');      
    if C <> #0 then
    begin
      if Buffer^.PutChar(C) then
      begin
        ScrollWindow(HWindow, 0, -CharHeight, Nil, Nil);
        UpDateWindow(HWindow);
      end;
      WriteChar;
    end;
  end;
  
END;

PROCEDURE TCommWindow.SetConfigure;
var
  Config: array[0..20] of Char;
  S: array[0..5] of Char;           pTemp: array[0..5] of Char;
  DCB: TDCB;                    

BEGIN

CISPhone:= MyTone + CISPhone + CHR(13);
StrPCopy(PhoneNumber, CISPhone);

StrPCopy(S, Speeds);
StrCopy(Config, '????:??,?,?,?');  
Config[0] := File1[0];
Config[1] := File1[1];
Config[2] := File1[2];
Config[3] := File1[3];
Config[5] := S[0];
Config[6] := S[1];
IF transmit = 0 THEN
  begin
  Config[8] := 'n';
  Config[10] := '8';
  Config[12] := '1';
  end
ELSE
  begin
  Config[8] := 'e';
  Config[10] := '7';
  Config[12] := '1';
  end;
    
BuildCommDCB(Config, DCB); 
DCB.ID := CID;
Error(SetCommState(DCB), 'Set Comm State');
END;

PROCEDURE TCommWindow.SetUpWindow;
var
  DCB: TDCB;
BEGIN
  TWindow.SetUpWindow;
  SetHeight;
  Cid := OpenComm(File1, 1024, 1024);
  Error(Cid, 'Open');
  SetConfigure;
  sTemp:= 'ATZ&FQ0V0E0M1X0' + CHR(13);                       { Send a reset to Modem. }
  StrPCopy(InitString1, sTemp);
  WriteComm(Cid, InitString1, StrLen(InitString1));
  sTemp:= InitString + CHR(13);
  StrPCopy(InitString1, sTemp);
  WriteComm(Cid, InitString1, StrLen(InitString1));

END;

{ Call back function used only to get record structure for fixed   }
{ width font.                                                         }
FUNCTION GetFont(LogFont: PLogFont; TM: PTextMetric; FontType: Word;
  P: PCommWindow): Integer; export;
BEGIN
  if P^.CharHeight = 0 then
  begin
    P^.FontRec := LogFont^;
    P^.CharHeight := P^.FontRec.lfHeight;
  end;
END;

{ Get the a fix width font to use in the TCommWindow.  Use EnumFonts  }
{ to save work of create the FontRec by hand.                         }
{ The TScroller of the main window is also updated know that the font }
{ height is known.                                                    }
PROCEDURE TCommWindow.SetHeight;
var
  DC: HDC;
  ProcInst: Pointer;
BEGIN
  DC := GetDC(HWindow);
  CharHeight := 0;
  ProcInst := MakeProcInstance(@GetFont, HInstance);
  EnumFonts(DC, 'Arial', ProcInst, @Self);
  FreeProcInstance(ProcInst);
  ReleaseDC(HWindow, DC);

  Scroller^.SetUnits(CharHeight, CharHeight);
  Scroller^.SetRange(LineWidth, LineHeight);
  Scroller^.ScrollTo(0, LineHeight);
END;


{ Write the character from the pressed key to the Comunication Port.   }
PROCEDURE TCommWindow.wmChar(var Message: TMessage);
BEGIN
  if CID >= 0 then
    Error(WriteComm(CId, @Message.wParam, 1), 'Writing');
END;

PROCEDURE TCommWindow.wmSize(var Message: TMessage);
BEGIN
  TWindow.wmSize(Message);
  Scroller^.SetRange(LineWidth, LineHeight - (Message.lParamhi div CharHeight));
END;



PROCEDURE TCommWindow.WriteChar;
label jump1, EndJob;
var
  Font: HFont;                   S: PChar;
  APos : Integer;         sTemp : STRING;

BEGIN

  MyMenu:= GetActiveWindow;
  MyWind:= HWindow;
  sTemp:= '';
  APos := Buffer^.Count - 1;
  S := Buffer^.AT(APos);
  sTemp:= StrPas(s);       
  iTemp:= LENGTH(sTemp);
  sTemp1:= COPY(sTemp, iTemp, 1);
  sTemp2:= COPY(sTemp, 1, 6);
  APos := (APos - Scroller^.YPos) * CharHeight;
  if APos < 0 then GOTO EndJob;
        
EndJob:

IF (count = 0) AND (isw14 = 1) OR (isw1 = 0) AND (isw14 = 1)THEN
  begin
  TCommWindow.Timer(1);  
  IF (period > 40) AND (count = 0) OR (period > 100) AND (isw1 = 0) THEN
    begin              
    TCommWindow.HangUp(Message);
    ClrScr;
    GoToXY(5, 10);
    WRITELN('Failed to connect with Host Computer');
    Delay(300, 2);
    TCommWindow.ProgramExit(Message);
    end;
  end;             
IF sTemp2 = 'Issue:' THEN isw1:= 1;
IF (iTemp = isw) AND (count < 10) AND (count > 3) OR (iTemp = isw) AND
        (count < 1) THEN WRITELN(s);
IF (iTemp = isw) AND (isw1 = 1) THEN WRITELN(ifd, s);
IF (count = 0) AND (sTemp = 'CONNECT') THEN
  begin
  count:= count + 1;
  WriteComm(CId, CHR(13), 1);
  end;
IF (count = 1) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;      
  sTemp:= 'CIS' + CHR(13);
  StrPCopy(pTemp, sTemp);
  WriteComm(CId, pTemp, 4);
  sTemp1:= '';
  sTemp:= '';
  end;

IF (count = 2) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;     
  StrPCopy(pTemp, CISId);   
  WriteComm(CId, pTemp, LENGTH(CISId));
  sTemp1:= '';
  end;
IF (count = 3) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;     
  StrPCopy(pTemp, CISPass);   
  Delay(200, 0);
  WriteComm(CId, pTemp, LENGTH(CISPass));
  sTemp1:= '';
  end;
IF (count = 4) AND (sTemp1 = '!') OR (count = 4) AND (sTemp1 = 'K')THEN
  begin
  count:= count + 1;     
  sTemp:= 'Go BasicQuotes' + CHR(13);
  StrPCopy(pTemp, sTemp);   
  WriteComm(CId, pTemp, LENGTH(sTemp));
  sTemp1:= '';
  sTemp:= '';
  end;
IF (count = 5) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;
  ASSIGN (ifc, 'quote.log');
  RESET (ifc);
  i:= 0;
  WHILE NOT EOF(ifc) DO
    begin
    i:= i + 1;
    READLN (ifc, Descript[i]^);
    READLN (ifc, Trade[i]^);     
    IF Trade[i]^ = '' THEN i:= i - 1;
    end;
  CLOSE(ifc);
  sTemp:= '';
  FOR m:= 1 TO i DO
    sTemp:= sTemp + Trade[m]^ + ',';
  sTemp:= COPY(sTemp, 1, LENGTH(sTemp) - 1) + CHR(13);
  IF LENGTH(sTemp) > 1000 THEN
    begin
    sTemp:= 'Too many investments listed, max. no of characters is 800';
    StrPCopy(pTemp, sTemp);
    TextOut (Dc, 20, 40, pTemp, LENGTH(sTemp));
    Delay (500, 1);
    GOTO jump1;
    end;
  StrPCopy(pTemp, sTemp);
  WriteComm(CId, pTemp, LENGTH(sTemp));
jump1:
  sTemp1:= '';
  sTemp:= '';
  end;
IF (count = 6) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;     
  IF Speeds = '19' THEN
    iTemp:= 192
  ELSE
    VAL(Speeds, iTemp, iTemp1);        
  iTemp:= ROUND(i * 100.0 * 192.0 / iTemp);
  Delay(iTemp, 0);
  WriteComm(CId, CHR(3), 1);
  sTemp1:= '';
  end;
IF (count = 7) AND (sTemp1 = '!') THEN
  begin
  count:= count + 1;     
  sTemp:= 'OFF' + CHR(13);
  StrPCopy(pTemp, sTemp);   
  WriteComm(CId, pTemp, LENGTH(sTemp));
  sTemp1:= '';
  end;
IF (count = 8) AND (sTemp1 = ':') THEN
  begin
  count:= count + 1;     
  isw1:= 0;
  sTemp:= 'BYE' + CHR(13);
  StrPCopy(pTemp, sTemp);   
  WriteComm(CId, pTemp, LENGTH(sTemp));
  sTemp1:= '';
  end;                  
IF (count = 9) AND (s[9] = MyStop[9]) AND (s[8] = MyStop[8]) THEN
  begin
  WRITELN (Output, #7);
  WRITELN ('Press  <ENTER>  to exit');
  cTemp:= READKEY;
  TCommWindow.ProgramExit(Message);
  end;
        
isw:= iTemp;

END;

{ TApp }
PROCEDURE TApp.Idle;
var
  Stat: TComStat;
  I, Size: Integer;
  C: Char;
BEGIN
  if MainWindow <> Nil then
    if MainWindow^.HWindow <> 0 then
      PCommWindow(MainWindow)^.ReadChar;
  
END;

PROCEDURE TApp.InitMainWindow;
BEGIN
  MainWindow := New(PCommWindow, Init(Nil, 'Fund Investor - CompuServe Module'));
END;

{ Add Idle loop to main message loop.                                 }
PROCEDURE TApp.MessageLoop;
var
  Message: TMsg;
BEGIN
  while True do
  begin
    if PeekMessage(Message, 0, 0, 0, pm_Remove) then
    begin
      if Message.Message = wm_Quit then
      begin
        Status := Message.WParam;
        Exit;
      end;
      if not ProcessAppMsg(Message) then
      begin
        TranslateMessage(Message);
        DispatchMessage(Message);
      end;
    end
    else
      Idle;
  end;
END;

var
  App: TApp;
begin
  App.Init('Comm');
  App.Run;
  App.Done;
END.
