/*
	 KARAOKE

	 Copyright (c) 1993 94 JP COCATRIX . All rights reserved.
*/
/*  This is the interface module used in karados
		given as an explaination of how the resident code like Ultramid
		is used.
		These primitives are called only if the output mode is s (-po=s)
		I Hope it is self documented.
		If loading a patches is no meaning for you, just ignore in the TSR
		The APP_START and APP_END is only a protection for multiple users
		to avoid the remove of the TSR if a program is still using it.
		The key for detection for an other TSR than ULTRAMID
		is "KARADOS".
*/
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "ultramid.h"

#define MK_LONG   (long)((void _seg *)(_DX) + (void near *)(_AX))

#define control_change    	      0xB0
#define after_touch								0xD0

#define TRUE	1			/* Define some handy constants	*/
#define FALSE	0			/* Define some handy constants	*/

extern enum HARD {RIEN,SB,GUS,MPU401,COM1,COM2,COM3,COM4} hardware;
extern void SaySo(char *texte,int multiple);
extern short inrange(unsigned char,unsigned char min,unsigned char max);
extern const char *getInstrument(unsigned char);
extern void info_system(char *txt,short x);
extern volatile	unsigned int tempo;
extern void check_buffers(void);
void	sbFmSound3(int,int,int );
//*******************************************************************
//                 code Synth. output
//*******************************************************************

int (far *um_hook)(void) = 0L;


void	um_parameter( int channel, int control, int value )
{
	sbFmSound3( (control_change+channel),control,value );
}

int	loadpatch( int patch )
{
	char strg[80];
  unsigned i;
	if (um_hook)
	{
    check_buffers(); // for wave see karawav
		if (patch <128)
		sprintf(strg,"Loading %s",getInstrument(patch));
		else
		{
			if (!inrange(patch,128+27,128+87)) return (TRUE);
			sprintf(strg,"Loading drum %d",patch-128);
		}
		SaySo(strg,6);
    i=0;
    if (um_hook)
    do
    {
		  _AX = TSR_LOAD_PATCH;
		  _CX = patch;
      i++;
		}while (((*um_hook)()!=0)&&(i<2));

    if (i==2)
    {
      SaySo("TSR Loading Error",7);
      return (FALSE);
    }
    return (TRUE);
	} return (FALSE);
}


int	reset_um( )
{
	int i;

	_AX = TSR_UNLOAD_ALL_PATCHES;
	if (um_hook)(*um_hook)();
	_AX = TSR_ALL_NOTES_OFF;
	if (um_hook) (*um_hook)();
	for (i=0; i < 16; i++) {
		um_parameter(i, 0x78, 0); /* all sounds off */
		um_parameter(i, 0x79, 0); /* reset all controllers */
		um_parameter(i, 100, 0); /* RPN MSB 0 */
		um_parameter(i, 101, 0); /* RPN LSB 0 */
		um_parameter(i, 6, 2); /* Pitch Bend Sensitivity MSB */
		um_parameter(i, 38, 0); /* Pitch Bend Sensitivity LSB */
	}
	return(1);
}

void	um_cleanup( void )
{
	if (um_hook)
	{
		SaySo("Unload Patches",6);
		_AX = TSR_UNLOAD_ALL_PATCHES;
		if (um_hook)(*um_hook)();
		reset_um();
		_AX = TSR_APP_END;
		if (um_hook)(*um_hook)();
	}
}


//***********************************************************************
//                code commun   common code
//***********************************************************************
// name with FM are for historical reasons !!
#pragma warn -par
int	initfm()
{
	int vector, i;
	char far *stamp;
	switch (hardware)
	{
	case GUS:
	case SB:
  case MPU401:
  case COM1:
  case COM2:
  case COM3:
  case COM4:
		for (vector=0x78; vector <= 0x7f; vector++)
		{
			um_hook = (int (far *)())getvect(vector);
			stamp = (char far *)MK_FP( FP_SEG(um_hook), 0x103 );
			if ((strncmp(stamp, "ULTRAMID", 8) == 0)||(strncmp(stamp, "KARADOS", 7) == 0))
				 break;
			stamp = (char far *)MK_FP( FP_SEG(um_hook), FP_OFF(um_hook)+0x04 );
			if ((strncmp(stamp, "ULTRAMID", 8) == 0)||(strncmp(stamp, "KARADOS", 7) == 0))
				 break;
		}
		if (vector <= 0x7f) {
			if (um_hook)
			{
				_AX = TSR_APP_START;
				(*um_hook)();
				reset_um();
			}
		} else
		{
			um_hook = 0L;
      tempo =0x3F;
      info_system(" No synth found.",20);
			return(1);
		}
		return(0);
	case RIEN :
	default:
      tempo =0x3F;
      info_system(" No hard. Sorry.",20);
		return (1);
	}
}
#pragma warn .par


void	sbFmSound2(int car1, int car2)
{
	if (um_hook)
	{
			_AX = TSR_MIDI_OUT;
			_CX = car1;
			(*um_hook)();
			_AX = TSR_MIDI_OUT;
			_CX = car2;
			(*um_hook)();
  }
}

void	sbFmSound3(int car1, int car2, int car3)
{
	if (um_hook)
	{
			_AX = TSR_MIDI_OUT;
			_CX = car1;
			(*um_hook)();
			_AX = TSR_MIDI_OUT;
			_CX = car2;
			(*um_hook)();
			_AX = TSR_MIDI_OUT;
			_CX = car3;
			(*um_hook)();
  }
}

int um_start_digital(struct um_sound_struct *umss)
{
	if (um_hook)
	{
        _ES = FP_SEG(umss);
        _DI = FP_OFF(umss);
        _AX = TSR_START_DIGITAL;
        (*um_hook)();
        return(_AX);
  }
  return 0;
}

void um_stop_digital(int voice)
{
	if (um_hook)
	{
        _CX = voice;
        _AX = TSR_STOP_DIGITAL;
        (*um_hook)();
  }
}

void um_restart_digital(int voice)
{
	if (um_hook)
	{
        _CX = voice;
        _AX = TSR_RESTART_DIGITAL;
        (*um_hook)();
  }
}

void um_pause_digital(int voice)
{
	if (um_hook)
	{
        _CX = voice;
        _AX = TSR_PAUSE_DIGITAL;
        (*um_hook)();
  }
}

void um_set_pan(int voice, int pan)
{
	if (um_hook)
	{
        _CX = voice;
        _BX = pan;
        _AX = TSR_SET_PAN;
        (*um_hook)();
  }
}

void um_set_volume(int voice, int volume)
{
	if (um_hook)
	{
        _CX = voice;
        _BX = volume;
        _AX = TSR_SET_VOLUME;
        (*um_hook)();
  }
}

long um_allocate_memory(long mem)
{
	if (um_hook)
	{
        asm mov dx, word ptr mem;
        asm mov bx, word ptr mem+2;
        _AX = TSR_ALLOCATE_MEMORY;
        (*um_hook)();
        mem = MK_LONG;
        return(mem);
  }
  return (0);
}

void um_free_memory(long mem)
{
	if (um_hook)
	{
        asm mov bx, word ptr mem+2;
        asm mov dx, word ptr mem;
        _AX = TSR_FREE_MEMORY;
        (*um_hook)();
  }
}

