Program Vegas_Cards;


Uses CRT,PROGRPHX;


Const
 Hearts   = 1;
 Spades   = 2;
 Clubs    = 3;
 Diamonds = 4;
 Crown_Up = 5;
 Crown_Dn = 6;


Type
 Scrap_Type   = Record   { Format of File on Disk with paint .SCR picture }
                  Hz   : Integer;
                  Vt   : Integer;
                  Data : Array [1..4000] of Byte;
                End;

 Suit_Type    = Array [1..13] of Boolean;
 Playing_Card = Array [1..2] of Integer;  { 1 Suit, 2 Value }


Var
 Pix  : Icon_Group;
 Card : Scrap_Type;
 Taste: Scrap_Type;
 msg1,msg2,msg3,msg4,msg5 : Scrap_Type;
 ch   : char;
 i,j  : Integer;
 Deck : Array [1..4] of Suit_Type;
 Hold : Array [1..5] of Boolean;
 Hand : Array [1..5] of Playing_Card;

Procedure Load_Pix;
Var
 In_File : File of Icon_Group;

Begin
 Assign(In_File,'CARDS.PIC');
 Reset (In_File);
 Read  (In_File,Pix);
 Close (In_File);
End;



{==== Load_Scrap ======
 Read picture from file
 ======================}
Procedure Load_Scrap(Var Scrap_Variable:Scrap_Type; File_Name:String);
Var
 In_Block:File;
 Result  :Integer;
Begin
 Assign(In_Block,File_Name);
 Reset (In_Block);
 BlockRead(In_Block,Scrap_Variable,500,Result);
 Close (In_Block);
 Scrap_Variable.Hz:=(Scrap_Variable.Hz+7) shr 3;
End;

Procedure Put_Card(c:Integer);
Begin
 Color(LtWhite);
 BPut_Scrap(Card.Data,(c-1)*14+3,200,Card.Hz,Card.Vt);
End;

Procedure Put_Suit(suit,value,c:Integer);
Begin
 BPut_Icon(Pix.Images[suit],(c-1)*14+3,205);
 BPut_Icon(Pix.Images[suit],(c-1)*14+11,320);
 If (Suit=1) or (Suit=4) then Color(Red)
  Else Color(Black);
 Case value of
  01 : PrintS(' A',((c-1)*14+12)*8,205);
  02 : PrintS(' 2',((c-1)*14+12)*8,205);
  03 : PrintS(' 3',((c-1)*14+12)*8,205);
  04 : PrintS(' 4',((c-1)*14+12)*8,205);
  05 : PrintS(' 5',((c-1)*14+12)*8,205);
  06 : PrintS(' 6',((c-1)*14+12)*8,205);
  07 : PrintS(' 7',((c-1)*14+12)*8,205);
  08 : PrintS(' 8',((c-1)*14+12)*8,205);
  09 : PrintS(' 9',((c-1)*14+12)*8,205);
  10 : PrintS('10',((c-1)*14+12)*8,205);
  11 : PrintS(' J',((c-1)*14+12)*8,205);
  12 : PrintS(' Q',((c-1)*14+12)*8,205);
  13 : PrintS(' K',((c-1)*14+12)*8,205);
 End;

 Case value of
  01 : PrintS(' A',((c-1)*14+4)*8,320);
  02 : PrintS(' 2',((c-1)*14+4)*8,320);
  03 : PrintS(' 3',((c-1)*14+4)*8,320);
  04 : PrintS(' 4',((c-1)*14+4)*8,320);
  05 : PrintS(' 5',((c-1)*14+4)*8,320);
  06 : PrintS(' 6',((c-1)*14+4)*8,320);
  07 : PrintS(' 7',((c-1)*14+4)*8,320);
  08 : PrintS(' 8',((c-1)*14+4)*8,320);
  09 : PrintS(' 9',((c-1)*14+4)*8,320);
  10 : PrintS('10',((c-1)*14+4)*8,320);
  11 : PrintS(' J',((c-1)*14+4)*8,320);
  12 : PrintS(' Q',((c-1)*14+4)*8,320);
  13 : PrintS(' K',((c-1)*14+4)*8,320);
 End;


End;

Procedure Do_Hold(i:Integer);
Begin
 If Hold[i]=False then
  Begin
   Hold[i]:=True;
   Color(LtBlue);
   PrintS('HELD',((i-1)*14+7)*8,180);
  End
  Else
   Begin
    Color(Black);
    Filled_Box(((i-1)*14+7)*8,180,((i-1)*14+7)*8+40,195);
    Hold[i]:=False;
   End;

End;


Procedure Generate_Card(c:Integer);
Var
 value,suit : Integer;
Begin
   Repeat
    value := Random(13)+1;
    suit  := Random(4)+1;
   Until Deck[suit,value]=False;
   Deck[Suit,Value]:=True;
   Hand[c,1]:=Suit;
   Hand[c,2]:=Value;
End;


Procedure Generate_Hand;
Var
 c : Integer;
Begin
 For c:=1 to 5 do
  Generate_Card(c);
End;


Begin
 Load_Pix;
 Load_Scrap(Card,'CARD.SCR');

 Load_Scrap(Taste,'TASTE.SCR');
 Load_Scrap(msg1,'msg1.SCR');
 Load_Scrap(msg2,'msg2.SCR');
 Load_Scrap(msg3,'msg3.SCR');
 Load_Scrap(msg4,'msg4.SCR');
 Load_Scrap(msg5,'msg5.SCR');

 Color(Yellow);
 BPut_Scrap(Taste.Data,16,60,Taste.Hz,Taste.Vt);
 Color(LtBlue);
 BPut_Scrap(msg5.Data,8,1,msg5.Hz,msg5.Vt);
 Box(0,0,639,55);
 Box(1,1,638,56);

REPEAT
 Color(Black);
 Filled_Box(0,100,639,180);
 Color(LtRed);
 BPut_Scrap(msg1.Data,17,100,msg1.Hz,msg1.Vt);


 Repeat


  Color(Black);
  Filled_Box(0,180,639,195);

  For i:=1 to 4 do
   For j:=1 to 13 do
    Deck[i,j]:=False;
  Generate_Hand;

  For i:=1 to 5 do
   Begin
    Put_Card(i);
    Put_Suit(Hand[i,1],Hand[i,2],i);
   End;
 Until Keypressed;
 ch:=readkey;

 Color(Black);
 Filled_Box(0,100,639,180);

 For i:=1 to 5 do Hold[i]:=False;

 Color(LtRed);
 BPut_Scrap(msg2.Data,17,100,msg2.Hz,msg2.Vt);
 BPut_Scrap(msg3.Data,18,140,msg3.Hz,msg3.Vt);


 Repeat
  ch:=readkey;
  Case ch of
   '1' : Do_Hold(1);
   '2' : Do_Hold(2);
   '3' : Do_Hold(3);
   '4' : Do_Hold(4);
   '5' : Do_Hold(5);
  End;
 Until ch=#13;


 Color(Black);
 Filled_Box(0,100,639,180);



 For i:=1 to 5 do
   If (not Hold[i]) then
    Begin
     Generate_Card(i);
     Put_Card(i);
     Put_Suit(Hand[i,1],Hand[i,2],i);
    End;

 Color(LtRed);
 BPut_Scrap(msg4.Data,17,100,msg4.Hz,msg4.Vt);


 ch:=readkey;
UNTIL (ch='Q')  or (ch='q');

End.