*
* PROGRAM: TTL ( WORK ARROUND FOR TOTAL COMMAND - FULL IMPLIMENTATION )
*
*  AUTHOR: KELLY MC TIERNAN
*
*    DATE: 09/06/85
*
*   NOTES: USAGE -
*
*          ERR = .F.
*          USE FILE INDEX <KEYINDEX>
*          DO TTL WITH "TO <TTLFILE> ON <KEY> [FIELDS <FIELD,FIELD..>] 
*          [FOR / WHILE <CONDITION>]",ERR
*
*          ERR = .T. IF PARSING ERROR, OTHERWISE <TTLFILE> HAS TOTALS
*          - SAME AS DBASE III TOTAL COMMAND.
*       
PROCEDURE TTL
PARAM CMDSTR,ERR
*
PRIVATE FNAME,KEY,CONDITION,CNT,CTR,VARTMP,FLDTMP,FLDLST,C,FLDSTR,POS2
PRIVATE WILEFLG,FORFLG
*
* INITIALIZATIONS
*
STORE "" TO FNAME,KEY,FLDLST,VARLST,CONDITION 
POSIT = 0
CMDSTR = UPPER(CMDSTR)
CNT = 0
*
* GET TOTAL FILE NAME
*
IF AT("TO ",CMDSTR) = 0
   ERR = .T.
   RETURN
ELSE
   POSIT = AT("TO ",CMDSTR) + 3
   DO NEXTWORD WITH CMDSTR,POSIT,FNAME
ENDIF
*
* GET KEY FIELD NAME
*
IF AT(" ON ",CMDSTR) = 0
   ERR = .T.
   RETURN
ELSE
   POSIT = AT(" ON ",CMDSTR) + 4
   DO NEXTWORD WITH CMDSTR,POSIT,KEY
ENDIF
*
* GENERATE TOTAL FILE, USE FIELD LIST IF PRESENT
* OTHERWISE GET ALL NUMERIC FIELD TYPES
*
VARTMP = ""
FLDTMP = ""
FLDLST = ""
C = ""
COPY STRUCTURE EXTENDED TO FLDS
SELECT 2
USE FLDS
GO TOP
IF AT(" FIELDS ",CMDSTR) = 0
   DO WHILE .NOT. EOF()
      DO CASE
      *
      * SAVE KEY FIELD IN STRUCTURE FILE
      * 
      CASE FIELD_NAME = "&KEY"
        SKIP
        LOOP
      *
      * GENERATE VARIABLE AND FIELD NAME'S FOR TOTAL PROCESS.
      * COUNT NUMBER OF NUMERIC FIELDS.
      * 
      CASE FIELD_TYPE = "N"
        CNT = CNT + 1
        VARTMP = "VAR"
        FLDTMP = "FLD"
        DO CASE
        CASE CNT > 99 .AND. CNT < 999
            VARTMP = VARTMP + STR(CNT,3)
            FLDTMP = FLDTMP + STR(CNT,3)
            &VARTMP = 0
            &FLDTMP = FIELD_NAME
        CASE CNT > 9 .AND. CNT < 99
            VARTMP = VARTMP + STR(CNT,2)
            FLDTMP = FLDTMP + STR(CNT,2)
            &VARTMP = 0
            &FLDTMP = FIELD_NAME
        CASE CNT < 10
            VARTMP = VARTMP + STR(CNT,1)
            FLDTMP = FLDTMP + STR(CNT,1)
            &VARTMP = 0
            &FLDTMP = FIELD_NAME
        OTHERWISE
            ERR = .T.
            RETURN
        ENDCASE
      *
      * IF NOT NUMERIC OR KEY FIELD, THEN DELETE FROM STRUCTURE FILE.
      *
      OTHERWISE
        DELETE
      ENDCASE
      SKIP
   ENDDO
ELSE
   FLDSTR = ""
   *
   * PARSE FOR FIELDS LIST.
   *
   POSIT = AT(" FIELDS ",CMDSTR) + 8
   DO NEXTWORD WITH CMDSTR,POSIT,FLDLST
   POS2 = 1
   *
   * PARSE INDIVIDUAL FIELD NAMES.
   *
   DO WHILE POS2 <= LEN(FLDLST)
      C = SUBSTR(FLDLST,POS2,1)
      IF C = ',' .OR. POS2 = LEN(FLDLST)
        IF POS2 = LEN(FLDLST)
            FLDSTR = FLDSTR + C
        ENDIF
        CNT = CNT + 1
        VARTMP = "VAR"
        FLDTMP = "FLD"
        DO CASE
        CASE CNT > 99 .AND. CNT < 999
            VARTMP = VARTMP + STR(CNT,3)
            FLDTMP = FLDTMP + STR(CNT,3)
            &VARTMP = 0
            &FLDTMP = FLDSTR
        CASE CNT > 9 .AND. CNT < 99
            VARTMP = VARTMP + STR(CNT,2)
            FLDTMP = FLDTMP + STR(CNT,2)
            &VARTMP = 0
            &FLDTMP = FLDSTR
        CASE CNT < 10
            VARTMP = VARTMP + STR(CNT,1)
            FLDTMP = FLDTMP + STR(CNT,1)
            &VARTMP = 0
            &FLDTMP = FLDSTR
        OTHERWISE
            ERR = .T.
            RETURN
        ENDCASE         
        POS2 = POS2 + 1
        FLDSTR = ""
      ELSE
        FLDSTR = FLDSTR + C
        POS2 = POS2 + 1
      ENDIF
   ENDDO
   GO TOP
   *
   * STRUCTURE FILE - USE FIELDS LIST HERE.
   *
   DO WHILE .NOT. EOF()
      DO CASE
      CASE FIELD_NAME = "&KEY"
        SKIP
        LOOP
      CASE FIELD_TYPE <> "N"
        DELETE
        SKIP
        LOOP
      OTHERWISE
        CTR = 1
        FOUND = .F.
        DO WHILE CTR <= CNT
            FLDTMP = "FLD"
            DO CASE
            CASE CTR > 99 .AND. CTR < 999
                FLDTMP = FLDTMP + STR(CTR,3)
            CASE CTR > 9 .AND. CTR < 99
                FLDTMP = FLDTMP + STR(CTR,2)
            CASE CTR < 10
                FLDTMP = FLDTMP + STR(CTR,1)
            OTHERWISE
                ERR = .T.
                RETURN
            ENDCASE
            IF FIELD_NAME = &FLDTMP
                FOUND = .T.
                EXIT
            ELSE
                CTR = CTR + 1
            ENDIF
        ENDDO
        IF .NOT. FOUND
            DELETE
        ENDIF
        SKIP
    ENDCASE
  ENDDO
ENDIF
PACK
USE
*
* CREATE TOTAL FILE FROM STRUCTURE FILE.
*
CREATE &FNAME FROM FLDS
DELETE FILE FLDS.DBF
USE
USE &FNAME
GO TOP
SELECT 1
GO TOP
*
* DO TOTAL WITH / WITHOUT CONDITION
*
WILEFLG = .F.
FORFLG = .F.
DO CASE
CASE AT(" FOR ",CMDSTR) <> 0
   POSIT = AT(" FOR ",CMDSTR) + 5
   CONDITION = SUBSTR(CMDSTR,POSIT)
   *
   * SET UP CONDITION FLAGS - FOR
   * 
   FORFLG = .T.
CASE AT(" WHILE ",CMDSTR) <> 0
   POSIT = AT(" WHILE ",CMDSTR) + 7
   CONDITION = SUBSTR(CMDSTR,POSIT)
   *
   * SET UP CONDITION FLAGS - WHILE
   *
   WILEFLG = .T.
ENDCASE
*
* DO ACTUAL TOTALING PROCESS  
*
DO WHILE .NOT. EOF()
    IF WILEFLG
        IF .NOT. &CONDITION
            EXIT
        ENDIF
    ENDIF
    IF FORFLG
        IF .NOT. &CONDITION
            SKIP
            LOOP
        ENDIF
    ENDIF
    MKEY = &KEY
    FKEY = &KEY
    SELECT 2
    APPEND BLANK
    REPLACE &KEY WITH MKEY
    SELECT 1
    CTR = 1
    * 
    * INITIALIZE TOTAL ARRAY
    *
    DO WHILE CTR <= CNT
        VARTMP = "VAR"
        DO CASE
        CASE CTR > 99 .AND. CTR < 999
            VARTMP = VARTMP + STR(CTR,3)
        CASE CTR > 9 .AND. CTR < 99
            VARTMP = VARTMP + STR(CTR,2)
        CASE CTR < 10
            VARTMP = VARTMP + STR(CTR,1)
        OTHERWISE
            ERR = .T.
            RETURN
        ENDCASE
        &VARTMP = 0
        CTR = CTR + 1
    ENDDO
    DO WHILE FKEY = MKEY .AND. .NOT. EOF()
        CTR = 1
        DO WHILE CTR <= CNT
            VARTMP = "VAR"
            FLDTMP = "FLD"
            DO CASE
            CASE CTR > 99 .AND. CTR < 999
                VARTMP = VARTMP + STR(CTR,3)
                FLDTMP = FLDTMP + STR(CTR,3)
            CASE CTR > 9 .AND. CTR < 99
                VARTMP = VARTMP + STR(CTR,2)
                FLDTMP = FLDTMP + STR(CTR,2)
            CASE CTR < 10
                VARTMP = VARTMP + STR(CTR,1)
                FLDTMP = FLDTMP + STR(CTR,1)
            OTHERWISE
                ERR = .T.
                RETURN
            ENDCASE
            FLDSTR = &FLDTMP
            &VARTMP = &VARTMP + &FLDSTR
            CTR = CTR + 1
        ENDDO
        * 
        * DO ACTUAL REPLACEMENTS IN TOTAL FILE
        *
        CTR = 1
        DO WHILE CTR <= CNT
            VARTMP = "VAR"
            FLDTMP = "FLD"
            DO CASE
            CASE CTR > 99 .AND. CTR < 999
                VARTMP = VARTMP + STR(CTR,3)
                FLDTMP = FLDTMP + STR(CTR,3)
            CASE CTR > 9 .AND. CTR < 99
                VARTMP = VARTMP + STR(CTR,2)
                FLDTMP = FLDTMP + STR(CTR,2)
            CASE CTR < 10
                VARTMP = VARTMP + STR(CTR,1)
                FLDTMP = FLDTMP + STR(CTR,1)
            OTHERWISE
                ERR = .T.
                RETURN
            ENDCASE
            FLDSTR = &FLDTMP
            SELECT 2
            REPLACE &FLDSTR WITH &VARTMP
            SELECT 1
            CTR = CTR + 1
        ENDDO
        SKIP
        FKEY = &KEY
    ENDDO
ENDDO
SELECT 2
USE
SELECT 1
RETURN

PROCEDURE NEXTWORD
PARAM STRG,POS,DEST
*
* RETURN NEXT WORD FROM A STRING.
*
PRIVATE BEGN,L
*
BEGN = 0
L = 0
DO WHILE SUBSTR(STRG,POS,1) = " "
   POS = POS + 1
ENDDO
BEGN = POS
DO WHILE SUBSTR(STRG,POS,1) <> " " .AND. POS < LEN(STRG)
   POS = POS + 1
ENDDO
IF POS = LEN(STRG)
   L = POS - BEGN + 1
ELSE
   L = POS - BEGN
ENDIF
DEST = SUBSTR(STRG,BEGN,L)
RETURN

