;
;                               qdisplay.inc
;
;       if CX = 0 (null string), then force one blank into string.
;
;       This is because we want to avoid col. 1 for the reverse video box
;       display.  If this program looses control (by control-break or
;       critical error, for example) while the reverse video prompt box is
;       in col. 1, then BIOS scroll procedures will propagate the reverse
;       video attribute to the new line each time the screen is scrolled
;       by DOS.
;
                MOV     AH,2                    ;DOS fn call, 1 char display
                OR      CL,CL                   ;is byte count of string zero?
                JNE     DISPLAY_LINE            ;jump if not
                INC     CL                      ;incr count to 1
                MOV     BYTE PTR [SI+1],BLANK_CHAR  ;put 1 blank char in string
                MOV     BX,1                    ;point BX to this char
;
;       display line.  Use one-character DOS call, because the "display
;       string" call won't display "$"
;
DISPLAY_LINE:   MOV     DL,[SI][BX]             ;next char into DL
                INT     21H                     ;call DOS
                INC     BX                      ;point to next char
                LOOP    DISPLAY_LINE            ;and loop on char count
;
;               --------        end of qdisplay.inc             --------
;
