;                       QGETKEY.INC
;
;
;
;
;       display a reverse video box by calling BIOS VIDEO procedures
;
DISPLAY_BOX:    MOV     AH,15           ;"get current video page" call
                INT     10H             ;call BIOS, returns with BH=page
;
;       get present attribute at cursor position.
;
;       In case user has "customized" his DOS display colors,
;       explicitly reverse the color foreground/background fields in the
;       attribute, instead of just assuming black/white
;
;       BH =  current page
;
                MOV     AH,8            ;"get attribute" call
                INT     10H             ;call BIOS
;
;       AH now contains attribute code.  swap fore/back nibbles, leaving
;       blink and intensity unchanged.
;
;       BH = current page
;
                MOV     BL,AH           ;copy attribute into BL
                MOV     USERS_ATTRIB,AH ;also save attrib in RAM
                MOV     CL,4            ;nibble bit-count for shifting
                ROL     BL,CL           ;swap nibbles in BL
                AND     BL,77H          ;mask out B and I in BL
                AND     AH,88H          ;save B and I in AH
                OR      BL,AH           ;BL now contains swapped fore/back
                                        ; nibbles, with B and I unchanged.
                MOV     CX,1            ;display one character position
                MOV     AL,BLANK_CHAR   ;ascii blank character ...
                MOV     AH,9            ;"write attribute & char" call
                INT     10H             ;call BIOS
;
;       Get one keystroke from user.  Don't echo because we want cursor
;       to point to box so that we can easily "unreverse" it while we echo
;       the character.
;
GET_KEY:        MOV     AH,8            ;"get char-no echo" fn call code
                                        ;(DOS 2.0 Manual, p. D-19)
                INT     21H             ;call DOS and get key code
;
;       now restore character attribute ("unreverse") and echo the
;       user's keystroke at the same time
;
;       BH = current page
;       AL = user's keystroke code
;
                MOV     BL,USERS_ATTRIB ;get original users attribute
                MOV     CX,1            ;display one character
                MOV     AH,9            ;"display attribute" BIOS VIDEO fn
                INT     10H             ;call BIOS
;
;       display a new line  through DOS
;
                MOV     DX,OFFSET NEW_LINE       ;CR, LF string offset
                MOV     AH,9            ;DOS fn code to display string
                                        ;(DOS Manual, p. D-19)
                PUSH    AX              ;DOS trashes AL, so save it
                INT     21H             ;call DOS
                POP     AX              ;restore keycode in AL
;
;               --------        END OF QGETKEY.INC      --------
;
