               PAGE 60,132
TITLE  QUERY.COM  VER.2.1  7-AUG-83  21:05
comment *

                        QUERY.COM


        VERSION 2.1     6-AUG-83

        Written by      Warren Craycroft
                        6236 Oakdale Ave.
                        Oakland, CA  94605


        (C)  1983  by Warren Craycroft.  Permission is granted to copy and
        distribute this program, including source code, provided that no
        charge shall be made except for a reasonable charge for the media
        and handling, and that this notice shall remain intact in all copies.


*
comment *
        This program is a utility that can be used with DOS 2.0
        to allow a yes/no interaction by the user during
        execution of a batch file.  The program does this by
        testing the user's one key response and returning to DOS an
        "errorlevel" code corresponding to that keycode response.
        This errorlevel code can then be tested by the
        batch file program using the IF ERRORLEVEL n  statement.

        When QUERY is run in a batch file, an appropriate question
        has been posed to the user via a REM or ECHO statement, or
        the QUERY statment itself.  A reverse video box then prompts.
        The user may answer with a single keystroke denoting
        a yes, no , or escape response.  The errorlevel code is set
        as follows:

                errorlevel = 2          if user typed ESC key

                errorlevel = 1          if user typed Y or y

                errorlevel = 0          if user typed N or n

        If any other key is typed, the console is beeped,a message is
        displayed, and this program waits for another keystroke.

        Remember that the subsequent IF clauses are "greater than or equal
        to"  and  "less than", so the order of the IF tests is important.

                IF ERRORLEVEL N         means   if errorlevel >= n

                IF NOT ERRORLEVEL N     means   if errorlevel < n


                INCLUDE THESE FILES WHEN ASSEMBLING:

                        PARSER.INC
                        QDISPLAY.INC
                        QGETKEY.INC
                        Q_CMDS.INC



*
;
;               constant equates
;
ESC_CHAR        EQU     1BH             ;ascii ESC keycode
BEL_CHAR        EQU     07              ;ascii BEL keycode
CR              EQU     0DH             ;ascii carriage return
LF              EQU     0AH             ;ascii line feed
BLANK_CHAR      EQU     20H             ;ascii blank character
;
;       equate the return codes to symbols so that this program can be
;       easily modified to a different choice of returned errorlevel codes.
;
ESC_RET_CODE    EQU     2
Y_RET_CODE      EQU     1
N_RET_CODE      EQU     0
;
;       declare a relocatable segment.  Follow the .COM file requirements
;       of entry point at 100H and making all seg register references relative
;       to CS (no relocatable values MOV'ed into segment registers).
;
;
COM_CODE      SEGMENT
;
                ORG     80H             ;PSP offset 80:  user's command line
PSP_CMD_LINE    LABEL   BYTE            ;define a label for address refs
;
                ORG     100H            ;for COM file
;
;
                ASSUME  CS:COM_CODE,DS:COM_CODE    ;tell assembler value of CS
                                                   ; and DS
;
;       parse command line in PSP for commands inside slashes
;
;       leave CX pointing to first character after leading delimiters if no
;       slashes, or first char after second slash
;
START           PROC            FAR     ;FAR is meaningless; no RETS
;
;       address of PSP's command line into SI
;
                MOV     SI,OFFSET PSP_CMD_LINE
;
INCLUDE         PARSER.INC              ;bring in parser include file
INCLUDE         QDISPLAY.INC            ;bring in cmd line string display
INCLUDE         QGETKEY.INC             ;bring in reverse prompt
;
;       AL = user's answering keystroke.  Test it for extended code
;
                OR      AL,AL           ;is the keycode zero?
                JNZ     TEST_ESC        ;jump if not, test for ESC
                MOV     AH,1            ;else extended code was typed
                INT     21H             ;get rest of code, then declare
                                        ;an error
;
;       keycode was not one of the allowed codes.  BEEP the console,
;       display a message, and wait for another keycode from keyboard
;
ERROR:          MOV     DX,OFFSET ERROR_MESSAGE ;display message string
                MOV     AH,9            ;DOS fun code to display string
                INT     21H             ;beep the console
                JMP     DISPLAY_BOX     ;and wait for another key
;
;       test for ESC key, Y, y, N, n. Then exit (through DOS function 4CH)
;       with appropriate exit code:
;
;               exit code 2            if key was ESC
;
;               exit code 0            if key was N or n
;
;               exit code 1            if key was Y or y
;
TEST_ESC:       MOV     DL,AL           ;move keycode to DL
                MOV     AL,ESC_RET_CODE ;return code for ESC
                MOV     AH,4CH          ;DOS fn call for exit
                                        ;(DOS Manual, p. D-49)
;
                CMP     DL,ESC_CHAR     ;is keycode ESC?
                JNE     TEST_N          ;jump if not, test for N
;
;       Exit the program, returning to DOS via DOS 2.0 function call 4EH.
;       This function call terminates execution of QUERY and sets the DOS
;       "errorlevel" to the value found in AL.
;
EXIT:           INT     21H             ;exit with return code in AL
TEST_N:         MOV     AL,N_RET_CODE   ;return code for N, n into AL
                CMP     DL,'N'          ;is it 'N'?
                JE      EXIT            ;jump if yes
                CMP     DL,'n'          ;is it 'n'?
                JE      EXIT            ;jump if yes and exit
TEST_Y:         MOV     AL,Y_RET_CODE   ;return code for Y, y into AL
                CMP     DL,'Y'          ;is keycode 'Y'?
                JE      EXIT            ;jump if yes and exit
                CMP     DL,'y'          ;else is keycode 'y'?
                JE      EXIT            ;jump if yes and exit
                JMP     ERROR           ;else beep the console and
                                        ;get another keycode
START           ENDP
PAGE
INCLUDE         Q_CMDS.INC              ;bring in slash command tables and code
PAGE
;
;               variable data area of the COM segment
;
USERS_ATTRIB    DB      1 DUP(?)        ;temp storage of character attrib
;
;               constant data area of the COM segment
;
ERROR_MESSAGE   DB      CR,LF,BEL_CHAR
                DB      '        *** Please press one of these keys only:'
                DB      '  Y   N   Esc    $'
COM_CODE        ENDS
                END     START
